/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import kgd.card.player.gui.DlgHelp;
import kgd.card.player.gui.DlgMessage;
import kgd.card.player.gui.DlgScore;
import kgd.card.player.gui.FrmMain;
import kgd.card.player.gui.GameScore;
import kgd.card.player.gui.Stat;
import kgd.card.player.gui.StatTableModel;
import kgd.card.player.gui.Tools;
import kgd.card.player.io.ScoreCodec;
import kgd.card.player.io.StatCodec;

public final class DlgStat
extends JDialog {
    private JButton ivBttScore;
    private JButton ivBttReset;
    private JButton ivBttCancel;
    private JButton ivBttHelp;
    private JButton ivBttOK;
    private StatCodec ivStatCodec;
    private StatTableModel ivStatTableModel;
    JTable ivStatTable;
    private ScoreCodec ivScoreCodec;

    public DlgStat() {
        this.ivStatCodec = new StatCodec();
        try {
            this.ivStatCodec.decode();
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.dispose();
        }
        this.initialize();
    }

    public DlgStat(Frame frame, StatCodec statCodec, ScoreCodec scoreCodec) {
        super(frame, true);
        this.ivStatCodec = statCodec;
        this.ivScoreCodec = scoreCodec;
        this.initialize();
    }

    private void eventButtonClicked(ActionEvent actionEvent) {
        Object object;
        String string;
        if (actionEvent.getSource() == this.ivBttOK) {
            this.dispose();
        }
        if (actionEvent.getSource() == this.ivBttCancel) {
            this.dispose();
        }
        if (actionEvent.getSource() == this.ivBttHelp) {
            DlgHelp dlgHelp = new DlgHelp(this);
            dlgHelp.showPage("Stat.htm");
        }
        if (actionEvent.getSource() == this.ivBttScore) {
            int n = this.ivStatTable.getSelectionModel().getMaxSelectionIndex();
            if (n == -1) {
                return;
            }
            string = (String)this.ivStatTableModel.getValueAt(n, 0);
            Stat stat = (Stat)this.ivStatCodec.getStats().get(string);
            object = (GameScore)this.ivScoreCodec.getGameScores().get(string);
            if (object == null) {
                return;
            }
            DlgScore dlgScore = new DlgScore((Dialog)this, (GameScore)object, -1, stat);
        }
        if (actionEvent.getSource() == this.ivBttReset) {
            int n = this.ivStatTable.getSelectionModel().getMaxSelectionIndex();
            if (n == -1) {
                return;
            }
            string = Tools.translate("Stat-ConfirmReset");
            int n2 = DlgMessage.display(this, 3, string);
            if (n2 != 1) {
                return;
            }
            object = (String)this.ivStatTableModel.getValueAt(n, 0);
            this.ivStatCodec.getStats().remove(object);
            try {
                this.ivStatCodec.encode();
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
            this.ivScoreCodec.getGameScores().remove(object);
            try {
                this.ivScoreCodec.encode();
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
            this.ivStatTableModel.deleteRow(n);
        }
    }

    private void eventTableHeaderClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        TableColumnModel tableColumnModel = this.ivStatTable.getColumnModel();
        int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        int n2 = this.ivStatTable.convertColumnIndexToModel(n);
        boolean bl = mouseEvent.isShiftDown();
        this.ivStatTableModel.sort(n2, bl);
        this.ivStatTable.getSelectionModel().clearSelection();
    }

    private void handleException(Throwable throwable) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        throwable.printStackTrace(System.out);
    }

    private void initialize() {
        this.setTitle(Tools.translate("Stat-Title"));
        this.setName("DlgStat");
        this.getContentPane().setLayout(new FlowLayout(1, 4, 4));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DlgStat.this.dispose();
            }
        });
        this.initializeTable();
        this.initializeToolbar();
        int n = 574 + FrmMain.getFrameInsetsDimension().width;
        int n2 = 408 + FrmMain.getFrameInsetsDimension().height;
        int n3 = (Toolkit.getDefaultToolkit().getScreenSize().width - n) / 2;
        int n4 = (Toolkit.getDefaultToolkit().getScreenSize().height - n2) / 2;
        if (this.getParent() != null) {
            n3 = this.getParent().getX() + (this.getParent().getWidth() - n) / 2;
            n4 = this.getParent().getY() + (this.getParent().getHeight() - n2) / 2;
        }
        ((Component)this).setBounds(n3, n4, n, n2);
        ((Component)this).setVisible(true);
    }

    private void initializeTable() {
        this.ivStatTableModel = new StatTableModel(this.ivStatCodec.getStats().values());
        this.ivStatTable = new JTable(this.ivStatTableModel);
        this.ivStatTable.setSelectionMode(0);
        this.ivStatTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DlgStat.this.eventTableHeaderClicked(mouseEvent);
            }
        });
        this.ivStatTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DlgStat.this.ivBttScore.doClick();
                }
            }
        });
        TableColumn tableColumn = this.ivStatTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(100);
        tableColumn = this.ivStatTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(20);
        tableColumn = this.ivStatTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(20);
        tableColumn = this.ivStatTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(20);
        tableColumn = this.ivStatTable.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(20);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(520, 400));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setViewportView(this.ivStatTable);
        this.getContentPane().add(jScrollPane);
    }

    private void initializeToolbar() {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.setPreferredSize(new Dimension(42, 400));
        this.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 1, 1), false);
        jPanel2.setPreferredSize(new Dimension(42, 79));
        jPanel2.setBorder(new EtchedBorder());
        jPanel.add((Component)jPanel2, "North");
        this.ivBttScore = new JButton();
        this.ivBttScore.setPreferredSize(new Dimension(36, 36));
        this.ivBttScore.setIcon(Tools.getIcon("StatScore.gif"));
        this.ivBttScore.setPressedIcon(Tools.getIcon("StatScoreOver.gif"));
        this.ivBttScore.setRolloverIcon(Tools.getIcon("StatScoreOver.gif"));
        this.ivBttScore.setToolTipText(Tools.translate("Stat-Score"));
        this.ivBttScore.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgStat.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel2.add(this.ivBttScore);
        this.ivBttReset = new JButton();
        this.ivBttReset.setPreferredSize(new Dimension(36, 36));
        this.ivBttReset.setIcon(Tools.getIcon("StatReset.gif"));
        this.ivBttReset.setPressedIcon(Tools.getIcon("StatResetOver.gif"));
        this.ivBttReset.setRolloverIcon(Tools.getIcon("StatResetOver.gif"));
        this.ivBttReset.setToolTipText(Tools.translate("Stat-Reset"));
        this.ivBttReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgStat.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel2.add(this.ivBttReset);
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 1, 1), false);
        jPanel3.setPreferredSize(new Dimension(42, 116));
        jPanel3.setBorder(new EtchedBorder());
        jPanel.add((Component)jPanel3, "South");
        this.ivBttOK = new JButton();
        this.ivBttOK.setPreferredSize(new Dimension(36, 36));
        this.ivBttOK.setIcon(Tools.getIcon("OK.gif"));
        this.ivBttOK.setRolloverIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttOK.setPressedIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttOK.setToolTipText(Tools.translate("Stat-OK"));
        this.ivBttOK.setFocusPainted(false);
        this.ivBttOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgStat.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel3.add(this.ivBttOK);
        this.ivBttHelp = new JButton();
        this.ivBttHelp.setPreferredSize(new Dimension(36, 36));
        this.ivBttHelp.setIcon(Tools.getIcon("Help.gif"));
        this.ivBttHelp.setRolloverIcon(Tools.getIcon("HelpSelected.gif"));
        this.ivBttHelp.setPressedIcon(Tools.getIcon("HelpSelected.gif"));
        this.ivBttHelp.setToolTipText(Tools.translate("Stat-Help"));
        this.ivBttHelp.setFocusPainted(false);
        this.ivBttHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgStat.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel3.add(this.ivBttHelp);
        this.ivBttCancel = new JButton();
        this.ivBttCancel.setPreferredSize(new Dimension(36, 36));
        this.ivBttCancel.setIcon(Tools.getIcon("Cancel.gif"));
        this.ivBttCancel.setRolloverIcon(Tools.getIcon("CancelSelected.gif"));
        this.ivBttCancel.setPressedIcon(Tools.getIcon("CancelSelected.gif"));
        this.ivBttCancel.setToolTipText(Tools.translate("Stat-Cancel"));
        this.ivBttCancel.setFocusPainted(false);
        this.ivBttCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgStat.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel3.add(this.ivBttCancel);
    }

    public static void main(String[] stringArray) {
        try {
            DlgStat dlgStat = new DlgStat();
            dlgStat.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            ((Component)dlgStat).setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            throwable.printStackTrace(System.out);
        }
    }
}

