/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import kgd.card.player.gui.FrmMain;
import kgd.card.player.gui.Tools;

public final class DlgMessage
extends JDialog {
    public static final int MSG_ERROR = 1;
    public static final int MSG_WARNING = 2;
    public static final int MSG_QUESTION = 3;
    public static final int MSG_INFORMATION = 4;
    public static final int MSG_YES = 1;
    public static final int MSG_NO = -1;
    private JLabel ivLblMessage;
    private JButton ivBttOK;
    private JButton ivBttCancel;
    private int ivAnswer;

    private DlgMessage() {
        this(new Frame(), 3, "What a question ?\n Please answer quickly");
    }

    private DlgMessage(Dialog dialog, int n, String string) {
        super(dialog, true);
        this.initialize(n, string);
    }

    private DlgMessage(Frame frame, int n, String string) {
        super(frame, true);
        this.initialize(n, string);
    }

    public static int display(Window window, int n, String string) {
        DlgMessage dlgMessage = window instanceof Frame ? new DlgMessage((Frame)window, n, string) : new DlgMessage((Dialog)window, n, string);
        return dlgMessage.getAnswer();
    }

    private void eventButtonClicked(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ivBttOK) {
            this.ivAnswer = 1;
            this.dispose();
        }
        if (actionEvent.getSource() == this.ivBttCancel) {
            this.ivAnswer = -1;
            this.dispose();
        }
    }

    private int getAnswer() {
        return this.ivAnswer;
    }

    private void initialize(int n, String string) {
        String string2;
        switch (n) {
            case 1: {
                string2 = Tools.translate("Message-Error");
                break;
            }
            case 2: {
                string2 = Tools.translate("Message-Warning");
                break;
            }
            case 3: {
                string2 = Tools.translate("Message-Question");
                break;
            }
            default: {
                string2 = Tools.translate("Message-Information");
            }
        }
        this.setTitle(string2);
        this.setName("DlgMessage");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new FlowLayout(1, 4, 16));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DlgMessage.this.ivBttCancel.doClick();
            }
        });
        this.initializeMessage(string);
        this.initializeToolbar(n);
        int n2 = Math.min(this.ivLblMessage.getPreferredSize().width, 600);
        int n3 = n2 + 20 + FrmMain.getFrameInsetsDimension().width;
        int n4 = 98 + FrmMain.getFrameInsetsDimension().height;
        int n5 = (Toolkit.getDefaultToolkit().getScreenSize().width - n3) / 2;
        int n6 = (Toolkit.getDefaultToolkit().getScreenSize().height - n4) / 2;
        if (this.getParent() != null) {
            n5 = this.getParent().getX() + (this.getParent().getWidth() - n3) / 2;
            n6 = this.getParent().getY() + (this.getParent().getHeight() - n4) / 2;
        }
        ((Component)this).setBounds(n5, n6, n3, n4);
        ((Component)this).setVisible(true);
    }

    private void initializeMessage(String string) {
        this.ivLblMessage = new JLabel();
        this.ivLblMessage.setFont(new Font("dialog.bold", 1, 12));
        this.ivLblMessage.setOpaque(false);
        this.ivLblMessage.setHorizontalAlignment(0);
        this.ivLblMessage.setText(string);
        this.getContentPane().add(this.ivLblMessage);
        int n = Math.max(this.ivLblMessage.getPreferredSize().width, 200);
        int n2 = Math.max(this.ivLblMessage.getPreferredSize().height, 18);
        this.ivLblMessage.setPreferredSize(new Dimension(n, n2));
    }

    private void initializeToolbar(int n) {
        this.ivBttOK = new JButton();
        this.ivBttOK.setPreferredSize(new Dimension(98, 32));
        this.ivBttOK.setIcon(Tools.getIcon("OK.gif"));
        this.ivBttOK.setRolloverIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttOK.setPressedIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttOK.setToolTipText(Tools.translate("Message-YES"));
        this.ivBttOK.setFocusPainted(false);
        this.ivBttOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgMessage.this.eventButtonClicked(actionEvent);
            }
        });
        this.getContentPane().add(this.ivBttOK);
        this.ivBttCancel = new JButton();
        this.ivBttCancel.setPreferredSize(new Dimension(98, 32));
        this.ivBttCancel.setIcon(Tools.getIcon("Cancel.gif"));
        this.ivBttCancel.setRolloverIcon(Tools.getIcon("CancelSelected.gif"));
        this.ivBttCancel.setPressedIcon(Tools.getIcon("CancelSelected.gif"));
        this.ivBttCancel.setToolTipText(Tools.translate("Message-NO"));
        this.ivBttCancel.setFocusPainted(false);
        this.ivBttCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgMessage.this.eventButtonClicked(actionEvent);
            }
        });
        this.getContentPane().add(this.ivBttCancel);
        if (n != 3) {
            this.ivBttCancel.setVisible(false);
            this.ivBttOK.setToolTipText(Tools.translate("Message-Continue"));
        }
    }

    public static void main(String[] stringArray) {
        try {
            DlgMessage dlgMessage = new DlgMessage();
            dlgMessage.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            throwable.printStackTrace(System.out);
        }
    }
}

