/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import kgd.card.player.gui.DlgHelp;
import kgd.card.player.gui.DlgShareware;
import kgd.card.player.gui.FrmMain;
import kgd.card.player.gui.HeaderTableModel;
import kgd.card.player.gui.Tools;
import kgd.card.player.io.Shareware;

public final class DlgFile
extends JDialog {
    private JToggleButton ivBttGameClassic;
    private JToggleButton ivBttGameFreecell;
    private JToggleButton ivBttGameSpider;
    private JToggleButton ivBttGameCanfield;
    private JToggleButton ivBttGameFan;
    private JToggleButton ivBttGamePyramid;
    private JToggleButton ivBttGameFavorite;
    private JButton ivBttCancel;
    private JButton ivBttHelp;
    private JButton ivBttOK;
    private HeaderTableModel ivHeaderTableModel;
    JTable ivHeaderTable;
    private File ivFile = null;
    private Shareware ivShareware = null;

    public DlgFile() {
        this.initialize();
    }

    public DlgFile(Frame frame, Shareware shareware) {
        super(frame, true);
        this.ivShareware = shareware;
        this.initialize();
    }

    private void eventButtonClicked(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ivBttOK && this.ivHeaderTable.getSelectedRow() > -1) {
            this.exit(this.ivHeaderTable.getSelectedRow());
        }
        if (actionEvent.getSource() == this.ivBttHelp) {
            DlgHelp dlgHelp = new DlgHelp(this);
            dlgHelp.showPage("SelectGame.htm");
        }
        if (actionEvent.getSource() == this.ivBttCancel) {
            this.exit(-1);
        }
        if (actionEvent.getSource() == this.ivBttGameClassic) {
            this.filterHeaders();
        }
        if (actionEvent.getSource() == this.ivBttGameFreecell) {
            this.filterHeaders();
        }
        if (actionEvent.getSource() == this.ivBttGameSpider) {
            this.filterHeaders();
        }
        if (actionEvent.getSource() == this.ivBttGameCanfield) {
            this.filterHeaders();
        }
        if (actionEvent.getSource() == this.ivBttGameFan) {
            this.filterHeaders();
        }
        if (actionEvent.getSource() == this.ivBttGamePyramid) {
            this.filterHeaders();
        }
        if (actionEvent.getSource() == this.ivBttGameFavorite) {
            this.filterHeaders();
        }
    }

    private void eventTableHeaderClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() != 2) {
            return;
        }
        TableColumnModel tableColumnModel = this.ivHeaderTable.getColumnModel();
        int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        int n2 = this.ivHeaderTable.convertColumnIndexToModel(n);
        boolean bl = mouseEvent.isShiftDown();
        this.ivHeaderTableModel.sort(n2, bl);
        this.ivHeaderTable.getSelectionModel().clearSelection();
    }

    private void exit(int n) {
        if (n > -1) {
            String string = (String)this.ivHeaderTableModel.getValueAt(n, 0);
            if (this.ivShareware.getGameLeftPlay(string) < 1) {
                DlgShareware dlgShareware = new DlgShareware((Dialog)this, this.ivShareware);
                if (!this.ivShareware.isRegistered()) {
                    return;
                }
            }
            this.ivShareware.useGame(string);
            this.ivFile = (File)this.ivHeaderTableModel.getValueAt(n, 6);
        }
        this.dispose();
    }

    private void filterHeaders() {
        ArrayList<String> arrayList = new ArrayList<String>(6);
        if (this.ivBttGameClassic.isSelected()) {
            arrayList.add("Klondike");
        }
        if (this.ivBttGameFreecell.isSelected()) {
            arrayList.add("Freecell");
        }
        if (this.ivBttGameSpider.isSelected()) {
            arrayList.add("Spider");
        }
        if (this.ivBttGameCanfield.isSelected()) {
            arrayList.add("Canfield");
        }
        if (this.ivBttGameFan.isSelected()) {
            arrayList.add("Fan");
        }
        if (this.ivBttGamePyramid.isSelected()) {
            arrayList.add("Pyramid");
        }
        this.ivHeaderTableModel.filter(arrayList, this.ivBttGameFavorite.isSelected());
        this.ivHeaderTable.getSelectionModel().clearSelection();
    }

    public File getFile() {
        return this.ivFile;
    }

    private void initialize() {
        this.setTitle(Tools.translate("File-Title"));
        this.setName("DlgFile");
        this.getContentPane().setLayout(new FlowLayout(1, 4, 4));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DlgFile.this.exit(-1);
            }
        });
        this.initializeTable();
        this.initializeToolbar();
        int n = 574 + FrmMain.getFrameInsetsDimension().width;
        int n2 = 448 + FrmMain.getFrameInsetsDimension().height;
        int n3 = (Toolkit.getDefaultToolkit().getScreenSize().width - n) / 2;
        int n4 = (Toolkit.getDefaultToolkit().getScreenSize().height - n2) / 2;
        if (this.getParent() != null) {
            n3 = this.getParent().getX() + (this.getParent().getWidth() - n) / 2;
            n4 = this.getParent().getY() + (this.getParent().getHeight() - n2) / 2;
        }
        ((Component)this).setBounds(n3, n4, n, n2);
        ((Component)this).setVisible(true);
    }

    private void initializeTable() {
        this.ivHeaderTableModel = new HeaderTableModel();
        this.ivHeaderTable = new JTable(this.ivHeaderTableModel);
        this.ivHeaderTable.setSelectionMode(0);
        this.ivHeaderTable.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                DlgFile.this.eventTableHeaderClicked(mouseEvent);
            }
        });
        this.ivHeaderTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DlgFile.this.ivBttOK.doClick();
                }
            }
        });
        TableColumn tableColumn = this.ivHeaderTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(100);
        tableColumn = this.ivHeaderTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(50);
        tableColumn = this.ivHeaderTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(10);
        tableColumn = this.ivHeaderTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(10);
        tableColumn = this.ivHeaderTable.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(10);
        tableColumn = this.ivHeaderTable.getColumnModel().getColumn(5);
        tableColumn.setPreferredWidth(10);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(502, 440));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setViewportView(this.ivHeaderTable);
        this.getContentPane().add(jScrollPane);
    }

    private void initializeToolbar() {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.setPreferredSize(new Dimension(60, 440));
        this.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 1, 1), false);
        jPanel2.setPreferredSize(new Dimension(60, 264));
        jPanel2.setBorder(new EtchedBorder());
        jPanel.add((Component)jPanel2, "North");
        this.ivBttGameClassic = new JToggleButton();
        this.ivBttGameClassic.setPreferredSize(new Dimension(54, 36));
        this.ivBttGameClassic.setIcon(Tools.getIcon("GameClassic.gif"));
        this.ivBttGameClassic.setSelectedIcon(Tools.getIcon("GameClassicSelected.gif"));
        this.ivBttGameClassic.setToolTipText(Tools.translate("File-Klondike"));
        this.ivBttGameClassic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgFile.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel2.add(this.ivBttGameClassic);
        this.ivBttGameFreecell = new JToggleButton();
        this.ivBttGameFreecell.setPreferredSize(new Dimension(54, 36));
        this.ivBttGameFreecell.setIcon(Tools.getIcon("GameFreecell.gif"));
        this.ivBttGameFreecell.setSelectedIcon(Tools.getIcon("GameFreecellSelected.gif"));
        this.ivBttGameFreecell.setToolTipText(Tools.translate("File-Freecell"));
        this.ivBttGameFreecell.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgFile.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel2.add(this.ivBttGameFreecell);
        this.ivBttGameSpider = new JToggleButton();
        this.ivBttGameSpider.setPreferredSize(new Dimension(54, 36));
        this.ivBttGameSpider.setIcon(Tools.getIcon("GameSpider.gif"));
        this.ivBttGameSpider.setSelectedIcon(Tools.getIcon("GameSpiderSelected.gif"));
        this.ivBttGameSpider.setToolTipText(Tools.translate("File-Spider"));
        this.ivBttGameSpider.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgFile.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel2.add(this.ivBttGameSpider);
        this.ivBttGameCanfield = new JToggleButton();
        this.ivBttGameCanfield.setPreferredSize(new Dimension(54, 36));
        this.ivBttGameCanfield.setIcon(Tools.getIcon("GameCanfield.gif"));
        this.ivBttGameCanfield.setSelectedIcon(Tools.getIcon("GameCanfieldSelected.gif"));
        this.ivBttGameCanfield.setToolTipText(Tools.translate("File-Canfield"));
        this.ivBttGameCanfield.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgFile.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel2.add(this.ivBttGameCanfield);
        this.ivBttGameFan = new JToggleButton();
        this.ivBttGameFan.setPreferredSize(new Dimension(54, 36));
        this.ivBttGameFan.setIcon(Tools.getIcon("GameFan.gif"));
        this.ivBttGameFan.setSelectedIcon(Tools.getIcon("GameFanSelected.gif"));
        this.ivBttGameFan.setToolTipText(Tools.translate("File-Fan"));
        this.ivBttGameFan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgFile.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel2.add(this.ivBttGameFan);
        this.ivBttGamePyramid = new JToggleButton();
        this.ivBttGamePyramid.setPreferredSize(new Dimension(54, 36));
        this.ivBttGamePyramid.setIcon(Tools.getIcon("GamePyramid.gif"));
        this.ivBttGamePyramid.setSelectedIcon(Tools.getIcon("GamePyramidSelected.gif"));
        this.ivBttGamePyramid.setToolTipText(Tools.translate("File-Pyramid"));
        this.ivBttGamePyramid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgFile.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel2.add(this.ivBttGamePyramid);
        this.ivBttGameFavorite = new JToggleButton();
        this.ivBttGameFavorite.setPreferredSize(new Dimension(54, 36));
        this.ivBttGameFavorite.setIcon(Tools.getIcon("GameFavorite.gif"));
        this.ivBttGameFavorite.setSelectedIcon(Tools.getIcon("GameFavoriteSelected.gif"));
        this.ivBttGameFavorite.setToolTipText(Tools.translate("File-Favorite"));
        this.ivBttGameFavorite.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgFile.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel2.add(this.ivBttGameFavorite);
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 1, 1), false);
        jPanel3.setPreferredSize(new Dimension(60, 116));
        jPanel3.setBorder(new EtchedBorder());
        jPanel.add((Component)jPanel3, "South");
        this.ivBttOK = new JButton();
        this.ivBttOK.setPreferredSize(new Dimension(54, 36));
        this.ivBttOK.setIcon(Tools.getIcon("OK.gif"));
        this.ivBttOK.setRolloverIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttOK.setPressedIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttOK.setToolTipText(Tools.translate("File-OK"));
        this.ivBttOK.setFocusPainted(false);
        this.ivBttOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgFile.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel3.add(this.ivBttOK);
        this.ivBttHelp = new JButton();
        this.ivBttHelp.setPreferredSize(new Dimension(54, 36));
        this.ivBttHelp.setIcon(Tools.getIcon("Help.gif"));
        this.ivBttHelp.setRolloverIcon(Tools.getIcon("HelpSelected.gif"));
        this.ivBttHelp.setPressedIcon(Tools.getIcon("HelpSelected.gif"));
        this.ivBttHelp.setToolTipText(Tools.translate("File-Help"));
        this.ivBttHelp.setFocusPainted(false);
        this.ivBttHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgFile.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel3.add(this.ivBttHelp);
        this.ivBttCancel = new JButton();
        this.ivBttCancel.setPreferredSize(new Dimension(54, 36));
        this.ivBttCancel.setIcon(Tools.getIcon("Cancel.gif"));
        this.ivBttCancel.setRolloverIcon(Tools.getIcon("CancelSelected.gif"));
        this.ivBttCancel.setPressedIcon(Tools.getIcon("CancelSelected.gif"));
        this.ivBttCancel.setToolTipText(Tools.translate("File-Cancel"));
        this.ivBttCancel.setFocusPainted(false);
        this.ivBttCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgFile.this.eventButtonClicked(actionEvent);
            }
        });
        jPanel3.add(this.ivBttCancel);
    }

    public static void main(String[] stringArray) {
        try {
            DlgFile dlgFile = new DlgFile();
            dlgFile.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            ((Component)dlgFile).setVisible(true);
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            throwable.printStackTrace(System.out);
        }
    }
}

