/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import kgd.card.player.gui.FrmMain;
import kgd.card.player.gui.Tools;

public final class DlgAutoMove
extends JDialog {
    private int ivStatus;
    private JButton ivBttCancel;
    private JButton ivBttOK;
    private int ivResult;

    public DlgAutoMove() {
        this.ivStatus = 5;
        this.initialize();
    }

    public DlgAutoMove(Frame frame, int n) {
        super(frame, true);
        this.ivStatus = n;
        this.initialize();
    }

    private void eventButtonClicked(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ivBttCancel) {
            this.exit(-1);
        }
        if (actionEvent.getSource() == this.ivBttOK) {
            this.exit(0);
        }
    }

    private void exit(int n) {
        this.ivResult = n;
        this.dispose();
    }

    public int getResult() {
        return this.ivResult;
    }

    private void initialize() {
        this.setTitle(Tools.translate("AutoMove-Title"));
        this.setName("DlgAutoMove");
        this.getContentPane().setLayout(new FlowLayout(1, 4, 4));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DlgAutoMove.this.exit(-1);
            }
        });
        this.initializeInfo();
        this.initializeToolbar();
        int n = 348 + FrmMain.getFrameInsetsDimension().width;
        int n2 = 116 + FrmMain.getFrameInsetsDimension().height;
        int n3 = (Toolkit.getDefaultToolkit().getScreenSize().width - n) / 2;
        int n4 = (Toolkit.getDefaultToolkit().getScreenSize().height - n2) / 2;
        if (this.getParent() != null) {
            n3 = this.getParent().getX() + (this.getParent().getWidth() - n) / 2;
            n4 = this.getParent().getY() + (this.getParent().getHeight() - n2) / 2;
        }
        ((Component)this).setBounds(n3, n4, n, n2);
        ((Component)this).setVisible(true);
    }

    private void initializeInfo() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 4, 4), false);
        jPanel.setPreferredSize(new Dimension(340, 72));
        jPanel.setBorder(new EtchedBorder());
        this.getContentPane().add(jPanel);
        JLabel jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(44, 60));
        jLabel.setIcon(Tools.getIcon("ToolAuto.gif"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setVerticalAlignment(1);
        jPanel.add(jLabel);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setPreferredSize(new Dimension(280, 60));
        jTextArea.setBackground(jLabel.getBackground());
        jTextArea.setFont(jLabel.getFont());
        jTextArea.setEditable(false);
        jPanel.add(jTextArea);
        if (this.ivStatus == 1) {
            jTextArea.setText(Tools.translate("AutoMove-1"));
        } else if (this.ivStatus == 2) {
            jTextArea.setText(Tools.translate("AutoMove-2"));
        } else if (this.ivStatus == 3) {
            jTextArea.setText(Tools.translate("AutoMove-3"));
        } else if (this.ivStatus == 4) {
            jTextArea.setText(Tools.translate("AutoMove-4"));
        } else if (this.ivStatus == 5) {
            jTextArea.setText(Tools.translate("AutoMove-5"));
        }
    }

    private void initializeToolbar() {
        this.ivBttOK = new JButton();
        this.ivBttOK.setPreferredSize(new Dimension(168, 32));
        this.ivBttOK.setIcon(Tools.getIcon("OK.gif"));
        this.ivBttOK.setRolloverIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttOK.setPressedIcon(Tools.getIcon("OKSelected.gif"));
        this.ivBttOK.setToolTipText(Tools.translate("AutoMove-OK"));
        this.ivBttOK.setFocusPainted(false);
        this.ivBttOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgAutoMove.this.eventButtonClicked(actionEvent);
            }
        });
        this.getContentPane().add(this.ivBttOK);
        if (this.ivStatus != 5) {
            this.ivBttOK.setVisible(false);
        }
        this.ivBttCancel = new JButton();
        this.ivBttCancel.setPreferredSize(new Dimension(168, 32));
        this.ivBttCancel.setIcon(Tools.getIcon("Cancel.gif"));
        this.ivBttCancel.setRolloverIcon(Tools.getIcon("CancelSelected.gif"));
        this.ivBttCancel.setPressedIcon(Tools.getIcon("CancelSelected.gif"));
        this.ivBttCancel.setToolTipText(Tools.translate("AutoMove-Cancel"));
        this.ivBttCancel.setFocusPainted(false);
        this.ivBttCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DlgAutoMove.this.eventButtonClicked(actionEvent);
            }
        });
        this.getContentPane().add(this.ivBttCancel);
        if (this.ivStatus != 5) {
            this.ivBttCancel.setPreferredSize(new Dimension(340, 32));
        }
    }

    public static void main(String[] stringArray) {
        try {
            DlgAutoMove dlgAutoMove = new DlgAutoMove();
            dlgAutoMove.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
        catch (Throwable throwable) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            throwable.printStackTrace(System.out);
        }
    }
}

