/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.data;

public final class Score {
    public static final String DEFAULT_PLAYER = "Quid";
    private String ivPlayer = "Quid";
    private int ivDecks = 1;
    private int ivFoundation = 0;
    private int ivTableau = 0;
    private int ivUndo = 0;
    private int ivAutoMove = 0;
    private int ivRedeal = 0;
    private int ivTime = 0;

    public Score() {
    }

    public Score(int n) {
        this.ivDecks = n;
    }

    public int getAutoMove() {
        return this.ivAutoMove;
    }

    public int getBonus() {
        return Math.max(0, 5200 - this.ivTime * (4 / this.ivDecks));
    }

    public int getBuilding() {
        return this.ivTableau + this.ivFoundation;
    }

    public int getDecks() {
        return this.ivDecks;
    }

    public int getFoundation() {
        return this.ivFoundation;
    }

    public String getPlayer() {
        return this.ivPlayer;
    }

    public int getRedeal() {
        return this.ivRedeal;
    }

    public int getTableau() {
        return this.ivTableau;
    }

    public int getTime() {
        return this.ivTime;
    }

    public int getTotal() {
        int n = this.ivFoundation + this.ivTableau + this.ivUndo + this.ivAutoMove + this.ivRedeal;
        if (this.isComplete()) {
            n += this.getBonus();
        }
        return n;
    }

    public int getUndo() {
        return this.ivUndo;
    }

    public boolean isComplete() {
        return this.ivFoundation + this.ivTableau == 5200;
    }

    public void setAutoMove(int n) {
        this.ivAutoMove = n;
    }

    public void setDecks(int n) {
        this.ivDecks = n;
    }

    public void setFoundation(int n) {
        this.ivFoundation = n;
    }

    public void setPlayer(String string) {
        this.ivPlayer = string;
    }

    public void setRedeal(int n) {
        this.ivRedeal = n;
    }

    public void setTableau(int n) {
        this.ivTableau = n;
    }

    public void setTime(int n) {
        this.ivTime = n;
    }

    public void setUndo(int n) {
        this.ivUndo = n;
    }
}

