/*
 * Decompiled with CFR 0.152.
 */
package kgd.card.player.data;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.Timer;
import kgd.card.player.data.Card;
import kgd.card.player.data.Discard;
import kgd.card.player.data.Drag;
import kgd.card.player.data.Foundation;
import kgd.card.player.data.GameListener;
import kgd.card.player.data.Pile;
import kgd.card.player.data.Reserve;
import kgd.card.player.data.Score;
import kgd.card.player.data.Stock;
import kgd.card.player.data.Suit;
import kgd.card.player.data.Tableau;
import kgd.card.player.data.Undo;
import kgd.card.player.data.UndoMove;
import kgd.card.player.data.UndoState;
import kgd.card.player.data.Waste;
import kgd.card.player.data.Widget;

public final class Game {
    public static final int MOVE_SETUP = 0;
    public static final int MOVE_DEAL = 1;
    public static final int MOVE_REDEAL = 2;
    public static final int MOVE_FILL = 3;
    public static final int MOVE_DRAG = 4;
    public static final int MOVE_UNDO = 5;
    public static final int MOVE_ABORT = 6;
    public static final int MOVE_FAST = 7;
    private String ivName = null;
    private String ivLockCards;
    private boolean ivFan;
    private int ivDecks;
    private boolean ivFreecell = false;
    private boolean ivSynchronizedFoundations = false;
    private List ivCards = new ArrayList(104);
    private List ivPiles = new ArrayList(40);
    private List ivOrderedSourcePiles;
    private List ivOrderedTargetPiles;
    private Stock ivStock = null;
    private Waste ivWaste = null;
    private List ivFoundations = new ArrayList(8);
    private List ivTableaux = new ArrayList(30);
    private List ivReserves = new ArrayList(8);
    private List ivDiscards = new ArrayList(4);
    private GameListener ivListener = null;
    private boolean ivRunning = false;
    private static boolean cvAIControlled = false;
    private List ivUndos;
    private boolean ivUndosRunning;
    private List ivUndoMarkers;
    private int ivUndoRecordMarker;
    private Score ivScore;
    private int ivDoneUndos;
    private int ivDoneFalseAutoMoves;
    private boolean ivWon = false;
    private Timer ivTimer;
    private long ivTimerStartTime = 0L;
    private long ivTimerPauseTime = 0L;
    private long ivTimerPauseTotalTime = 0L;

    public Game() {
        this.initialize("NULL", "X", false, false);
        this.ivTimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Game.this.updateScore();
                Game.this.fireStateChanged();
            }
        });
        this.ivTimer.setCoalesce(true);
        this.ivTimer.setInitialDelay(0);
    }

    public Game(Game game) {
        cvAIControlled = true;
        this.ivFan = game.isFan();
        this.ivDecks = game.getDecks();
        this.ivFreecell = game.isFreecell();
        this.ivSynchronizedFoundations = game.isSynchronizedFoundations();
        this.ivWon = game.isWon();
        this.ivUndos = new ArrayList(1000);
        this.ivUndoMarkers = new ArrayList(100);
        this.ivDoneUndos = 0;
        this.ivRunning = true;
        this.ivUndosRunning = true;
        if (game.getStock() != null) {
            this.ivStock = new Stock(game.getStock(), true);
            this.ivPiles.add(this.ivStock);
        }
        if (game.getWaste() != null) {
            this.ivWaste = new Waste(game.getWaste(), true);
            this.ivPiles.add(this.ivWaste);
        }
        this.ivFoundations = new ArrayList(game.getFoundations().size());
        int n = 0;
        while (n < game.getFoundations().size()) {
            Foundation foundation = new Foundation((Foundation)game.getFoundations().get(n), true);
            this.ivFoundations.add(foundation);
            this.ivPiles.add(foundation);
            ++n;
        }
        this.ivTableaux = new ArrayList(game.getTableaux().size());
        int n2 = 0;
        while (n2 < game.getTableaux().size()) {
            Tableau tableau = new Tableau((Tableau)game.getTableaux().get(n2), true);
            this.ivTableaux.add(tableau);
            this.ivPiles.add(tableau);
            ++n2;
        }
        this.ivReserves = new ArrayList(game.getReserves().size());
        int n3 = 0;
        while (n3 < game.getReserves().size()) {
            Reserve reserve = new Reserve((Reserve)game.getReserves().get(n3), true);
            this.ivReserves.add(reserve);
            this.ivPiles.add(reserve);
            ++n3;
        }
        this.ivDiscards = new ArrayList(game.getDiscards().size());
        int n4 = 0;
        while (n4 < game.getDiscards().size()) {
            Discard discard = new Discard((Discard)game.getDiscards().get(n4), true);
            this.ivDiscards.add(discard);
            this.ivPiles.add(discard);
            ++n4;
        }
        this.orderPiles();
    }

    public void addWidget(Widget widget) {
        if (widget instanceof Pile) {
            this.ivPiles.add(widget);
            if (widget instanceof Stock) {
                this.ivStock = (Stock)widget;
            } else if (widget instanceof Waste) {
                this.ivWaste = (Waste)widget;
            } else if (widget instanceof Foundation) {
                this.ivFoundations.add(widget);
            } else if (widget instanceof Tableau) {
                this.ivTableaux.add(widget);
            } else if (widget instanceof Reserve) {
                this.ivReserves.add(widget);
            } else if (widget instanceof Discard) {
                this.ivDiscards.add(widget);
            }
        }
        if (widget instanceof Card) {
            this.ivCards.add(widget);
        }
    }

    private void checkAutoFill(Pile pile) {
        if (!this.ivUndosRunning) {
            return;
        }
        if (pile.getCards().size() > 0) {
            return;
        }
        if (pile.getFillPile().equals("X")) {
            return;
        }
        Pile pile2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(pile.getFillPile(), "|");
        String string = stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        if (string.equals("Stock")) {
            pile2 = this.ivStock;
        } else if (string.equals("Waste")) {
            pile2 = this.ivWaste;
        } else if (string.equals("Reserve")) {
            pile2 = (Pile)this.ivReserves.get(0);
        }
        if (pile2 == null) {
            return;
        }
        int n = Math.min(pile2.getCards().size(), string2.length());
        if (n == 0) {
            return;
        }
        int n2 = 3;
        if (pile2 instanceof Stock && pile instanceof Waste) {
            n2 = 1;
        }
        this.moveBegin(n2, n, null);
        Card card = null;
        int n3 = 0;
        while (n3 < n) {
            card = (Card)pile2.getCards().get(pile2.getCards().size() - 1);
            this.moveCard(card, pile2, pile);
            this.flipCard(card, string2.substring(n3, n3 + 1).equals("V"));
            ++n3;
        }
        this.moveEnd(n2, n, pile2);
    }

    private boolean checkFreecell(List list) {
        if (!this.ivFreecell) {
            return true;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.ivDiscards.size()) {
            if (((Discard)this.ivDiscards.get(n2)).getCards().isEmpty()) {
                ++n;
            }
            ++n2;
        }
        return list.size() <= n + 1;
    }

    private void checkSynchronizedFoundations() {
        Foundation foundation;
        int n;
        if (!this.ivSynchronizedFoundations) {
            return;
        }
        if (this.ivFoundations.isEmpty()) {
            return;
        }
        int n2 = n = 0;
        while (n2 < this.ivFoundations.size()) {
            foundation = (Foundation)this.ivFoundations.get(n2);
            foundation.setActive(true);
            ++n;
            if (foundation.getCards().size() < foundation.getStackMax()) break;
            ++n2;
        }
        int n3 = n;
        while (n3 < this.ivFoundations.size()) {
            foundation = (Foundation)this.ivFoundations.get(n3);
            foundation.setActive(false);
            ++n3;
        }
    }

    private void checkVictory() {
        if (!this.ivRunning) {
            return;
        }
        this.ivWon = this.ivFan ? this.checkVictoryWithTableaux() : this.checkVictoryWithFoundations();
        if (!cvAIControlled && this.ivWon) {
            this.eventStop();
            this.fireWon();
        }
    }

    private boolean checkVictoryWithFoundations() {
        int n = this.ivDecks * 52;
        int n2 = 0;
        Iterator iterator = this.ivFoundations.iterator();
        while (iterator.hasNext()) {
            n2 += ((Foundation)iterator.next()).getCards().size();
        }
        return n2 == n;
    }

    private boolean checkVictoryWithTableaux() {
        boolean bl = true;
        Iterator iterator = this.ivTableaux.iterator();
        while (iterator.hasNext()) {
            Tableau tableau = (Tableau)iterator.next();
            if (tableau.getCards().isEmpty() || tableau.isComplete()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean eventAutoMove(Card card) {
        Drag drag = this.eventStartMove(card);
        if (drag == null) {
            ++this.ivDoneFalseAutoMoves;
            return false;
        }
        if (drag.getTargetWidgets().isEmpty()) {
            ++this.ivDoneFalseAutoMoves;
            return false;
        }
        Pile pile = card.getPile();
        ArrayList<Pile> arrayList = new ArrayList<Pile>(8);
        ArrayList<Pile> arrayList2 = new ArrayList<Pile>(8);
        ArrayList<Pile> arrayList3 = new ArrayList<Pile>(8);
        Iterator iterator = drag.getTargetWidgets().iterator();
        while (iterator.hasNext()) {
            Widget widget = (Widget)iterator.next();
            Pile pile2 = widget instanceof Pile ? (Pile)widget : ((Card)widget).getPile();
            if (pile2 instanceof Foundation) {
                arrayList.add(pile2);
                continue;
            }
            if (pile2 instanceof Tableau) {
                arrayList2.add(pile2);
                continue;
            }
            if (!(pile2 instanceof Discard)) continue;
            arrayList3.add(pile2);
        }
        ArrayList<Pile> arrayList4 = null;
        if (!arrayList.isEmpty()) {
            arrayList4 = arrayList;
        } else if (!arrayList2.isEmpty()) {
            arrayList4 = arrayList2;
        } else if (!arrayList3.isEmpty()) {
            arrayList4 = arrayList3;
        }
        if (arrayList4 == null) {
            ++this.ivDoneFalseAutoMoves;
            return false;
        }
        Pile pile3 = null;
        int n = 0;
        while (n < arrayList4.size()) {
            if (((Pile)arrayList4.get(n)).getCards().size() > 0) {
                pile3 = (Pile)arrayList4.get(n);
                break;
            }
            ++n;
        }
        if (pile3 == null) {
            pile3 = (Pile)arrayList4.get(0);
        }
        this.moveBegin(7, 1, pile3);
        this.moveCards(drag.getSourceCards(), pile, pile3);
        this.moveEnd(7, 1, pile);
        return true;
    }

    public boolean eventDealStock() {
        if (!this.ivRunning) {
            return false;
        }
        if (this.ivStock.getMode() == -1) {
            return false;
        }
        if (this.ivStock.getMode() == 0) {
            if (this.ivStock.getCards().isEmpty()) {
                return this.stockRedeal();
            }
            return this.stockDeal();
        }
        return this.stockShuffle();
    }

    public void eventPause() {
        if (!this.ivTimer.isRunning()) {
            return;
        }
        this.ivTimerPauseTime = System.currentTimeMillis();
        this.ivTimer.stop();
    }

    public void eventRecordUndo() {
        if (!this.ivRunning) {
            return;
        }
        this.ivUndoRecordMarker = this.ivUndoMarkers.isEmpty() ? -2 : (Integer)this.ivUndoMarkers.get(this.ivUndoMarkers.size() - 1);
    }

    public void eventRestart() {
        if (!this.ivRunning) {
            return;
        }
        if (this.ivTimer.isRunning()) {
            return;
        }
        this.ivTimerPauseTotalTime += System.currentTimeMillis() - this.ivTimerPauseTime;
        this.ivTimer.start();
    }

    public void eventStart() {
        Object object;
        Object object2;
        HashMap<Object, Object> hashMap;
        this.orderPiles();
        this.ivDecks = this.ivCards.size() > 52 ? 2 : 1;
        this.ivWon = false;
        this.ivUndos = new ArrayList(1000);
        this.ivUndoMarkers = new ArrayList(100);
        this.ivUndoRecordMarker = -9;
        this.ivScore = new Score(this.ivDecks);
        this.ivDoneUndos = 0;
        this.ivDoneFalseAutoMoves = 0;
        this.ivFan = this.ivFoundations.isEmpty();
        if (this.ivLockCards.equals("X")) {
            hashMap = new HashMap<Object, Object>(0);
        } else {
            object2 = new StringTokenizer(this.ivLockCards, "|");
            hashMap = new HashMap(((StringTokenizer)object2).countTokens());
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                hashMap.put(object, object);
            }
        }
        object = new HashMap(hashMap.size(), 1.0f);
        object2 = new ArrayList(this.ivCards.size());
        Iterator iterator = this.ivCards.iterator();
        while (iterator.hasNext()) {
            Card card = (Card)iterator.next();
            if (hashMap.containsKey(card.getId())) {
                object.put(card.getId(), card);
                hashMap.remove(card.getId());
                continue;
            }
            object2.add(card);
        }
        Collections.shuffle(object2);
        Iterator iterator2 = object2.iterator();
        this.moveBegin(0, this.ivCards.size(), null);
        Iterator iterator3 = this.ivPiles.iterator();
        while (iterator3.hasNext()) {
            Pile pile = (Pile)iterator3.next();
            if (pile.getSetup().equals("X")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(pile.getSetup(), "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                String string2 = string.substring(0, string.length() - 1);
                String string3 = string.substring(string.length() - 1);
                Card card = string2.equals("*-*") ? (Card)iterator2.next() : (Card)object.get(string2);
                this.moveCard(card, null, pile);
                this.flipCard(card, string3.equals("V"));
            }
        }
        this.moveEnd(0, this.ivCards.size(), null);
        this.ivTimerPauseTime = 0L;
        this.ivTimerPauseTotalTime = 0L;
        this.ivTimerStartTime = System.currentTimeMillis();
        this.ivTimer.start();
        this.ivRunning = true;
    }

    public Drag eventStartMove(Card card) {
        if (!this.ivRunning) {
            return null;
        }
        if (!card.isFlipped()) {
            return null;
        }
        Pile pile = card.getPile();
        Suit suit = pile.getSuitForDragging(card);
        if (suit == null) {
            return null;
        }
        if (!this.checkFreecell(suit.getCards())) {
            return null;
        }
        List list = this.searchSuitTargets(suit, pile);
        return new Drag(suit.getCards(), list);
    }

    public void eventStop() {
        if (!this.ivRunning) {
            return;
        }
        this.ivRunning = false;
        this.ivTimer.stop();
        this.updateScore();
    }

    public void eventStopMove(Drag drag) {
        if (!this.ivRunning) {
            return;
        }
        Pile pile = ((Card)drag.getSourceCards().get(0)).getPile();
        if (drag.getTargetIndex() == -1) {
            this.moveBegin(6, 1, null);
            this.moveCards(drag.getSourceCards(), pile, pile);
            this.moveEnd(6, 1, null);
            return;
        }
        Widget widget = (Widget)drag.getTargetWidgets().get(drag.getTargetIndex());
        Pile pile2 = widget instanceof Pile ? (Pile)widget : ((Card)widget).getPile();
        this.moveBegin(4, 1, pile2);
        this.moveCards(drag.getSourceCards(), pile, pile2);
        this.moveEnd(4, 1, pile);
    }

    public void eventUndo() {
        if (!this.ivRunning) {
            return;
        }
        if (this.ivUndoMarkers.isEmpty()) {
            return;
        }
        int n = (Integer)this.ivUndoMarkers.get(this.ivUndoMarkers.size() - 1);
        this.fireMoveBegin(5, 1);
        int n2 = this.ivUndos.size() - 1;
        while (n2 > n) {
            Undo undo = (Undo)this.ivUndos.get(n2);
            if (undo instanceof UndoMove) {
                this.undoMove((UndoMove)undo);
            } else {
                this.undoState((UndoState)undo);
            }
            this.ivUndos.remove(n2);
            --n2;
        }
        this.fireMoveEnd(5, 1);
        this.ivUndoMarkers.remove(this.ivUndoMarkers.size() - 1);
        if (!cvAIControlled) {
            ++this.ivDoneUndos;
        }
    }

    public void eventUndoRecord() {
        if (!this.ivRunning) {
            return;
        }
        if (this.ivUndoRecordMarker == -9) {
            return;
        }
        boolean bl = false;
        if (this.ivUndoRecordMarker > -2) {
            int n = this.ivUndoMarkers.size();
            int n2 = this.ivUndoMarkers.size() - 1;
            while (n2 > -1) {
                if ((Integer)this.ivUndoMarkers.get(n2) == this.ivUndoRecordMarker) {
                    n = n2 + 1;
                    break;
                }
                --n2;
            }
            int n3 = this.ivUndoMarkers.size() - 1;
            while (n3 > n) {
                this.ivUndoMarkers.remove(n3);
                bl = true;
                --n3;
            }
        } else if (this.ivUndoMarkers.size() > 0) {
            int n = this.ivUndoMarkers.size() - 1;
            while (n > 0) {
                this.ivUndoMarkers.remove(n);
                --n;
            }
            bl = true;
        }
        this.ivUndoRecordMarker = -9;
        if (!bl) {
            return;
        }
        this.eventUndo();
    }

    private void fireMoveBegin(int n, int n2) {
        if (!cvAIControlled && this.ivListener != null) {
            this.ivListener.gameMoveBegin(n, n2);
        }
    }

    private void fireMoveCards(List list, Pile pile, Pile pile2) {
        if (!cvAIControlled && this.ivListener != null) {
            this.ivListener.gameMoveCards(list, pile, pile2);
        }
    }

    private void fireMoveEnd(int n, int n2) {
        if (!cvAIControlled && this.ivListener != null) {
            this.ivListener.gameMoveEnd(n, n2);
        }
    }

    private void fireStateChanged() {
        if (!cvAIControlled && this.ivListener != null) {
            this.ivListener.gameStateChanged();
        }
    }

    private void fireWon() {
        if (!cvAIControlled && this.ivListener != null) {
            this.ivListener.gameWon();
        }
    }

    private void flipCard(Card card, boolean bl) {
        if (card.isFlipped() == bl) {
            return;
        }
        card.setFlipped(bl);
        this.markUndo(new UndoState(card, "Flipped", String.valueOf(bl ^ true), String.valueOf(bl)));
    }

    public List getCards() {
        return this.ivCards;
    }

    public String getCondensedName() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.ivName.length()) {
            if (!this.ivName.substring(n, n + 1).equals(" ")) {
                stringBuffer.append(this.ivName.substring(n, n + 1));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int getDecks() {
        return this.ivDecks;
    }

    public List getDiscards() {
        return this.ivDiscards;
    }

    public List getFoundations() {
        return this.ivFoundations;
    }

    public String getId() {
        int n;
        int n2;
        ArrayList<String> arrayList;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ivStock != null) {
            stringBuffer.append(this.ivStock.getId());
        }
        if (this.ivWaste != null) {
            stringBuffer.append(this.ivWaste.getId());
        }
        if (this.ivFoundations.size() > 0) {
            arrayList = new ArrayList<String>(this.ivFoundations.size());
            n2 = 0;
            while (n2 < this.ivFoundations.size()) {
                arrayList.add(((Foundation)this.ivFoundations.get(n2)).getId());
                ++n2;
            }
            Collections.sort(arrayList);
            n = 0;
            while (n < arrayList.size()) {
                stringBuffer.append((String)arrayList.get(n));
                ++n;
            }
        }
        if (this.ivTableaux.size() > 0) {
            arrayList = new ArrayList(this.ivTableaux.size());
            n2 = 0;
            while (n2 < this.ivTableaux.size()) {
                arrayList.add(((Tableau)this.ivTableaux.get(n2)).getId());
                ++n2;
            }
            Collections.sort(arrayList);
            n = 0;
            while (n < arrayList.size()) {
                stringBuffer.append((String)arrayList.get(n));
                ++n;
            }
        }
        if (this.ivReserves.size() > 0) {
            arrayList = new ArrayList(this.ivReserves.size());
            n2 = 0;
            while (n2 < this.ivReserves.size()) {
                arrayList.add(((Reserve)this.ivReserves.get(n2)).getId());
                ++n2;
            }
            Collections.sort(arrayList);
            n = 0;
            while (n < arrayList.size()) {
                stringBuffer.append((String)arrayList.get(n));
                ++n;
            }
        }
        if (this.ivDiscards.size() > 0) {
            arrayList = new ArrayList(this.ivDiscards.size());
            n2 = 0;
            while (n2 < this.ivDiscards.size()) {
                arrayList.add(((Discard)this.ivDiscards.get(n2)).getId());
                ++n2;
            }
            Collections.sort(arrayList);
            n = 0;
            while (n < arrayList.size()) {
                stringBuffer.append((String)arrayList.get(n));
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public String getIdOld() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.ivPiles.size()) {
            stringBuffer.append(String.valueOf(n) + ((Pile)this.ivPiles.get(n)).getId());
            ++n;
        }
        return stringBuffer.toString();
    }

    public GameListener getListener() {
        return this.ivListener;
    }

    public String getLockCards() {
        return this.ivLockCards;
    }

    public String getName() {
        return this.ivName;
    }

    public List getOrderedSourcePiles() {
        return this.ivOrderedSourcePiles;
    }

    public List getOrderedTargetPiles() {
        return this.ivOrderedTargetPiles;
    }

    public List getPiles() {
        return this.ivPiles;
    }

    public List getReserves() {
        return this.ivReserves;
    }

    public Score getScore() {
        return this.ivScore;
    }

    public Stock getStock() {
        return this.ivStock;
    }

    public List getTableaux() {
        return this.ivTableaux;
    }

    public Waste getWaste() {
        return this.ivWaste;
    }

    public void initialize(String string, String string2, boolean bl, boolean bl2) {
        this.eventStop();
        this.ivName = string;
        this.ivLockCards = string2;
        this.ivFreecell = bl;
        this.ivSynchronizedFoundations = bl2;
        int n = 0;
        while (n < this.ivCards.size()) {
            ((Card)this.ivCards.get(n)).setListener(null);
            ((Card)this.ivCards.get(n)).move(null);
            ++n;
        }
        this.ivCards = new ArrayList(104);
        this.ivPiles = new ArrayList(40);
        this.ivStock = null;
        this.ivWaste = null;
        this.ivFoundations = new ArrayList(8);
        this.ivTableaux = new ArrayList(30);
        this.ivReserves = new ArrayList(8);
        this.ivDiscards = new ArrayList(4);
    }

    public static boolean isAIControlled() {
        return cvAIControlled;
    }

    public boolean isFan() {
        return this.ivFan;
    }

    public boolean isFreecell() {
        return this.ivFreecell;
    }

    public boolean isPaused() {
        return this.ivTimer.isRunning() ^ true;
    }

    public boolean isPlayed() {
        return this.ivUndos.size() > 0;
    }

    public boolean isRunning() {
        return this.ivRunning;
    }

    public boolean isSynchronizedFoundations() {
        return this.ivSynchronizedFoundations;
    }

    public boolean isWon() {
        return this.ivWon;
    }

    private void markUndo(Undo undo) {
        if (this.ivUndosRunning) {
            this.ivUndos.add(undo);
        }
    }

    private void moveBegin(int n, int n2, Pile pile) {
        if (n == 1 || n == 2 || n == 4 || n == 7) {
            this.ivUndoMarkers.add(new Integer(this.ivUndos.size() - 1));
        }
        this.ivUndosRunning = n != 0 && n != 5 && n != 6;
        if (this.ivUndosRunning && pile != null && pile.getCards().size() > 0 && pile.getVisibility() != 1) {
            this.flipCard(pile.getLastCard(), false);
        }
        this.fireMoveBegin(n, n2);
    }

    private void moveCard(Card card, Pile pile, Pile pile2) {
        ArrayList<Card> arrayList = new ArrayList<Card>(1);
        arrayList.add(card);
        this.moveCards(arrayList, pile, pile2);
    }

    private void moveCards(List list, Pile pile, Pile pile2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((Card)iterator.next()).move(pile2);
        }
        this.fireMoveCards(list, pile, pile2);
        this.markUndo(new UndoMove(list, pile, pile2));
    }

    private void moveEnd(int n, int n2, Pile pile) {
        this.fireMoveEnd(n, n2);
        if (this.ivUndosRunning && pile != null && pile.getCards().size() > 0 && pile.getVisibility() != 0) {
            this.flipCard(pile.getLastCard(), true);
        }
        if (pile != null) {
            this.checkAutoFill(pile);
        }
        this.checkSynchronizedFoundations();
        this.checkVictory();
    }

    private void orderPiles() {
        this.ivOrderedSourcePiles = new ArrayList(this.ivPiles.size());
        int n = 0;
        while (n < this.ivDiscards.size()) {
            this.ivOrderedSourcePiles.add(this.ivDiscards.get(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.ivReserves.size()) {
            this.ivOrderedSourcePiles.add(this.ivReserves.get(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.ivTableaux.size()) {
            this.ivOrderedSourcePiles.add(this.ivTableaux.get(n3));
            ++n3;
        }
        if (this.ivWaste != null) {
            this.ivOrderedSourcePiles.add(this.ivWaste);
        }
        if (this.ivStock != null) {
            this.ivOrderedSourcePiles.add(this.ivStock);
        }
        int n4 = 0;
        while (n4 < this.ivFoundations.size()) {
            this.ivOrderedSourcePiles.add(this.ivFoundations.get(n4));
            ++n4;
        }
        this.ivOrderedTargetPiles = new ArrayList(this.ivPiles.size());
        int n5 = 0;
        while (n5 < this.ivFoundations.size()) {
            this.ivOrderedTargetPiles.add(this.ivFoundations.get(n5));
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.ivTableaux.size()) {
            this.ivOrderedTargetPiles.add(this.ivTableaux.get(n6));
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.ivReserves.size()) {
            this.ivOrderedTargetPiles.add(this.ivReserves.get(n7));
            ++n7;
        }
        int n8 = 0;
        while (n8 < this.ivDiscards.size()) {
            this.ivOrderedTargetPiles.add(this.ivDiscards.get(n8));
            ++n8;
        }
        if (this.ivWaste != null) {
            this.ivOrderedTargetPiles.add(this.ivWaste);
        }
        if (this.ivStock != null) {
            this.ivOrderedTargetPiles.add(this.ivStock);
        }
    }

    private List searchSuitTargets(Suit suit, Pile pile) {
        ArrayList<Widget> arrayList = new ArrayList<Widget>(10);
        Iterator iterator = this.ivOrderedTargetPiles.iterator();
        while (iterator.hasNext()) {
            Widget widget;
            Pile pile2 = (Pile)iterator.next();
            if (pile2 == pile || (widget = pile2.getWidgetForStacking(suit)) == null) continue;
            arrayList.add(widget);
        }
        return arrayList;
    }

    public void setAIControlled(boolean bl) {
        if (bl == cvAIControlled) {
            return;
        }
        cvAIControlled = bl;
        if (cvAIControlled) {
            this.eventPause();
        } else {
            this.eventRestart();
        }
    }

    public void setListener(GameListener gameListener) {
        this.ivListener = gameListener;
    }

    private boolean stockDeal() {
        List list;
        ArrayList<Waste> arrayList = new ArrayList<Waste>(12);
        StringTokenizer stringTokenizer = new StringTokenizer(this.ivStock.getPilesToDeal(), "|");
        String string = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "+");
            String string3 = stringTokenizer2.nextToken();
            string = stringTokenizer2.nextToken();
            if (string3.equals("Waste")) {
                arrayList.add(this.ivWaste);
            } else if (string3.equals("Tableau")) {
                arrayList.addAll(this.ivTableaux);
            } else if (string3.equals("Discard")) {
                arrayList.addAll(this.ivDiscards);
            } else if (string3.equals("Reserve")) {
                arrayList.addAll(this.ivReserves);
            } else if (string3.equals("Foundation")) {
                arrayList.addAll(this.ivFoundations);
            }
            if (arrayList.size() * string.length() <= this.ivStock.getCards().size() || !stringTokenizer.hasMoreTokens()) break;
            arrayList.clear();
        }
        if ((list = this.ivStock.deal(arrayList.size() * string.length())) == null) {
            return false;
        }
        this.moveBegin(1, list.size(), null);
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = 0;
            while (n3 < arrayList.size()) {
                if (n == list.size()) {
                    bl = true;
                    break;
                }
                Card card = (Card)list.get(n);
                Pile pile = (Pile)arrayList.get(n3);
                this.moveCard(card, this.ivStock, pile);
                this.flipCard(card, string.substring(n2, n2 + 1).equals("V"));
                ++n;
                ++n3;
            }
            if (bl) break;
            ++n2;
        }
        this.moveEnd(1, list.size(), this.ivStock);
        return true;
    }

    private boolean stockRedeal() {
        if (this.ivWaste == null) {
            return false;
        }
        if (this.ivStock.getRedealsCount() >= this.ivStock.getMaxRedeals()) {
            return false;
        }
        if (this.ivWaste.getCards().isEmpty()) {
            return false;
        }
        int n = this.ivWaste.getCards().size();
        this.moveBegin(2, n, null);
        int n2 = n - 1;
        while (n2 > -1) {
            Card card = (Card)this.ivWaste.getCards().get(n2);
            this.moveCard(card, this.ivWaste, this.ivStock);
            this.flipCard(card, this.ivStock.getVisibility() == 1);
            --n2;
        }
        this.moveEnd(2, n, null);
        this.ivStock.setRedealsCount(this.ivStock.getRedealsCount() + 1);
        this.markUndo(new UndoState(this.ivStock, "Redeal", String.valueOf(this.ivStock.getRedealsCount() - 1), String.valueOf(this.ivStock.getRedealsCount())));
        return true;
    }

    private boolean stockShuffle() {
        return true;
    }

    private void undoMove(UndoMove undoMove) {
        this.moveBegin(5, -1, undoMove.getFromPile());
        this.moveCards(undoMove.getCards(), undoMove.getToPile(), undoMove.getFromPile());
        this.moveEnd(5, -1, undoMove.getToPile());
    }

    private void undoState(UndoState undoState) {
        Widget widget = undoState.getWidget();
        if (widget instanceof Card) {
            Card card = (Card)widget;
            if (undoState.getProperty().equals("Flipped")) {
                card.setFlipped(new Boolean(undoState.getOldValue()));
            }
        } else {
            Pile pile = (Pile)widget;
            if (undoState.getProperty().equals("Active")) {
                pile.setActive(new Boolean(undoState.getOldValue()));
            }
            if (undoState.getProperty().equals("Redeal")) {
                this.ivStock.setRedealsCount(new Integer(undoState.getOldValue()));
            }
        }
    }

    private void updateScore() {
        int n = (int)((System.currentTimeMillis() - this.ivTimerStartTime - this.ivTimerPauseTotalTime) / 1000L);
        int n2 = 0;
        Iterator iterator = this.ivFoundations.iterator();
        while (iterator.hasNext()) {
            n2 += ((Foundation)iterator.next()).getCards().size();
        }
        int n3 = n2 * 100 / this.ivDecks;
        int n4 = 0;
        Iterator iterator2 = this.ivTableaux.iterator();
        while (iterator2.hasNext()) {
            Tableau tableau = (Tableau)iterator2.next();
            if (tableau.getCards().isEmpty() || !tableau.isComplete()) continue;
            n4 += tableau.getCards().size();
        }
        int n5 = n4 * 100 / this.ivDecks;
        int n6 = this.ivDoneUndos * -40;
        int n7 = this.ivDoneFalseAutoMoves * -20;
        int n8 = 0;
        if (this.ivStock != null) {
            n8 = this.ivStock.getRedealsCount() * -20;
        }
        this.ivScore.setTime(n);
        this.ivScore.setFoundation(n3);
        this.ivScore.setTableau(n5);
        this.ivScore.setUndo(n6);
        this.ivScore.setAutoMove(n7);
        this.ivScore.setRedeal(n8);
    }
}

