/*
 * Decompiled with CFR 0.152.
 */
package silmar.util;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.List;
import silmar.tiles.TileSize;
import silmar.util.FloatPoint;

public class PointUtil
implements TileSize {
    public static float getSlope(Point from, Point to) {
        if (from.equals(to)) {
            return 0.0f;
        }
        if (to.x == from.x) {
            return to.y > from.y ? 1000.0f : -1000.0f;
        }
        return (float)(to.y - from.y) / (float)(to.x - from.x);
    }

    public static float getXSlope(Point from, Point to) {
        if (from.equals(to)) {
            return 0.0f;
        }
        if (to.y == from.y) {
            return to.x > from.x ? 1000.0f : -1000.0f;
        }
        return (float)(to.x - from.x) / (float)(to.y - from.y);
    }

    public static float getDistance(Point from, Point to) {
        float a = to.y - from.y;
        float b = to.x - from.x;
        return (float)Math.sqrt(a * a + b * b);
    }

    public static Point set(Point p, int x, int y) {
        p.setLocation(x, y);
        return p;
    }

    public static Point getDifference(Point from, Point to) {
        return new Point(to.x - from.x, to.y - from.y);
    }

    public static FloatPoint getUnitVector(Point from, Point to) {
        return PointUtil.getUnitVector(from, to, new FloatPoint());
    }

    public static FloatPoint getUnitVector(Point from, Point to, FloatPoint use) {
        Point vector = PointUtil.getDifference(from, to);
        float distance = PointUtil.getDistance(from, to);
        use.setLocation((float)vector.x / distance, (float)vector.y / distance);
        return use;
    }

    public static boolean isLocationInDirection(Point from, Point to, Point2D.Float direction) {
        return (double)PointUtil.getAngleBetween(PointUtil.getUnitVector(from, to), direction) <= 1.0471975511965976;
    }

    public static float getAngleBetween(Point2D.Float vector1, Point2D.Float vector2) {
        float magnitude1 = PointUtil.getMagnitude(vector1);
        float magnitude2 = PointUtil.getMagnitude(vector2);
        if (magnitude1 == 0.0f || magnitude2 == 0.0f) {
            return 0.0f;
        }
        float cosine = PointUtil.getDotProduct(vector1, vector2) / (magnitude1 * magnitude2);
        if (cosine > 1.0f) {
            cosine = 1.0f;
        }
        if (cosine < -1.0f) {
            cosine = -1.0f;
        }
        return (float)Math.acos(cosine);
    }

    public static float getMagnitude(Point2D.Float vector) {
        return (float)Math.sqrt(vector.x * vector.x + vector.y * vector.y);
    }

    public static float getDotProduct(Point2D.Float vector1, Point2D.Float vector2) {
        return vector1.x * vector2.x + vector1.y * vector2.y;
    }

    public static int getIndexOfNearestPoint(Point location, List points) {
        float minDistance = Float.MAX_VALUE;
        int nearestIndex = 0;
        int numPoints = points.size();
        for (int i = 0; i < numPoints; ++i) {
            Point point = (Point)points.get(i);
            float distance = PointUtil.getDistance(location, point);
            if (!(distance < minDistance)) continue;
            nearestIndex = i;
            minDistance = distance;
        }
        return nearestIndex;
    }

    public static String getDirectionString(Point from, Point to) {
        FloatPoint vector = PointUtil.getUnitVector(from, to);
        String direction = "";
        if (Math.abs(vector.x) <= Math.abs(vector.y)) {
            if (vector.y < 0.0f) {
                direction = direction + "north";
            }
            if (vector.y > 0.0f) {
                direction = direction + "south";
            }
        }
        if (Math.abs(vector.x) >= Math.abs(vector.y)) {
            if (vector.x < 0.0f) {
                direction = direction + "west";
            }
            if (vector.x > 0.0f) {
                direction = direction + "east";
            }
        }
        return direction;
    }
}

