/*
 * Decompiled with CFR 0.152.
 */
package silmar.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static BufferedImage doLoadImage(String fileName) {
        return ImageUtil.doLoadImage(fileName, true);
    }

    public static BufferedImage doLoadImage(String fileName, boolean useDefaultPath) {
        BufferedImage image = null;
        String path = (useDefaultPath ? "pics/" : "") + fileName + ".gif";
        File file = new File(path);
        if (file.exists()) {
            try {
                image = ImageIO.read(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (image == null) {
            URL url = ClassLoader.getSystemClassLoader().getResource(path);
            try {
                image = ImageIO.read(url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        BufferedImage compatibleImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(image.getWidth(), image.getHeight(), 2);
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        return compatibleImage;
    }

    public static Dimension getSizeWithoutLoading(String fileName) {
        byte[] header = null;
        try {
            InputStream in = ClassLoader.getSystemClassLoader().getResourceAsStream("pics/" + fileName + ".gif");
            header = new byte[13];
            in.read(header);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Dimension size = new Dimension();
        size.width = header[7] << 8 | header[6];
        size.height = header[9] << 8 | header[8];
        return size;
    }

    public static Image doEnlargeImageToSize(Image image, Dimension size, Component imageCreator) {
        int oldWidth = image.getWidth(null);
        int oldHeight = image.getHeight(null);
        int[] pixels = new int[size.width * size.height];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, oldWidth, oldHeight, pixels, (size.width - oldWidth) / 2 + (size.height - oldHeight) / 2 * size.width, size.width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int centerx = size.width / 2;
        int centery = size.height / 2;
        for (int i = -3; i <= 3; ++i) {
            ImageUtil.doMakePixelWhite(centerx + i, centery, pixels, size.width);
            ImageUtil.doMakePixelWhite(centerx, centery + i, pixels, size.width);
        }
        return imageCreator.createImage(new MemoryImageSource(size.width, size.height, pixels, 0, size.width));
    }

    private static void doMakePixelWhite(int x, int y, int[] pixels, int imageWidth) {
        pixels[x + y * imageWidth] = Color.white.getRGB();
    }
}

