/*
 * Decompiled with CFR 0.152.
 */
package silmar.util;

import java.awt.Color;

public class HtmlUtil {
    public static final String labelHeader = "<html><p style='color:white;text-align:center'>";
    public static final String tooltipHeader = "<html><p style='color:black;font:11pt sansserif;text-align:left'>";
    public static final String tooltipEnder = "</font></body></html>";

    public static void doIndent(StringBuffer text) {
        text.append("&nbsp;&nbsp;&nbsp;");
    }

    public static void doBreak(StringBuffer text) {
        text.append("<br>");
    }

    public static void doBreakIndent(StringBuffer text) {
        HtmlUtil.doBreak(text);
        HtmlUtil.doIndent(text);
    }

    public static String getHexString(Color color) {
        return Integer.toHexString(color.getRGB() & 0xFFFFFF);
    }

    public static String doBreakText(String text, int maxLineLength) {
        return HtmlUtil.doBreakText(text, maxLineLength, null);
    }

    public static String doBreakText(String text, int maxLineLength, String linePrefix) {
        int index;
        StringBuffer buffer = new StringBuffer();
        int length = text.length();
        int breakLength = 4;
        for (int start = 0; start < length; start += index) {
            if (start + maxLineLength < length) {
                String line = text.substring(start, Math.min(length, start + maxLineLength));
                boolean addBreak = true;
                index = line.indexOf("<br>");
                if (index >= 0) {
                    index += 4;
                    addBreak = false;
                } else {
                    index = line.lastIndexOf(32);
                    if (index < 0) {
                        index = Math.min(line.length(), maxLineLength);
                    }
                }
                line = line.substring(0, index);
                buffer.append(line);
                if (addBreak) {
                    buffer.append("<br>");
                }
                if (linePrefix == null) continue;
                buffer.append(linePrefix);
                continue;
            }
            buffer.append(text.substring(start, length));
            break;
        }
        return buffer.toString();
    }
}

