/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.loading;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import silmar.Sound;
import silmar.entities.MapEntity;
import silmar.entities.beings.monsters.Monster;
import silmar.entities.beings.monsters.MonsterFactory;
import silmar.entities.beings.monsters.MonsterType;
import silmar.entities.beings.player.Player;
import silmar.entities.beings.talkerBeings.TalkerBeing;
import silmar.entities.beings.talkerBeings.TalkerBeingFactory;
import silmar.entities.beings.talkerBeings.TalkerBeingType;
import silmar.entities.items.Item;
import silmar.entities.items.ItemFactory;
import silmar.entities.items.types.ItemType;
import silmar.entities.terrains.Terrain;
import silmar.entities.terrains.TerrainFactory;
import silmar.entities.terrains.TerrainType;
import silmar.entities.terrains.Terrains;
import silmar.entities.types.EntityType;
import silmar.map.Map;
import silmar.map.MapPixelLocation;
import silmar.map.MapTileLocation;
import silmar.map.stocking.MapStocker;
import silmar.tiles.Tile;
import silmar.tiles.TileSize;
import silmar.tiles.TileSizeUtil;
import silmar.util.Random;

public abstract class MapTranslator
implements TileSize {
    private HashMap colorToResult = new HashMap();
    protected Map map;

    public MapTranslator() {
        ColorMapping[] mappings = new ColorMapping[]{new ColorMapping(new Color(255, 255, 255), new MappingResult(Tile.wall)), new ColorMapping(new Color(0, 0, 0), new MappingResult(Tile.floor)), new ColorMapping(new Color(192, 192, 192), new MappingResult(Tile.roomWall)), new ColorMapping(new Color(64, 64, 64), new MappingResult(Tile.roomFloor)), new ColorMapping(new Color(200, 140, 60), new MappingResult(Tile.door)), new ColorMapping(new Color(255, 0, 255), new MappingResult(Tile.secretDoor)), new ColorMapping(new Color(255, 0, 128), new MappingResult(Tile.roomSecretDoor)), new ColorMapping(new Color(0, 0, 255), new MappingResult(Tile.water)), new ColorMapping(new Color(0, 254, 255), new MappingResult(Tile.waterNW)), new ColorMapping(new Color(0, 253, 255), new MappingResult(Tile.waterNE)), new ColorMapping(new Color(0, 252, 255), new MappingResult(Tile.waterSW)), new ColorMapping(new Color(0, 251, 255), new MappingResult(Tile.waterSE)), new ColorMapping(new Color(140, 100, 60), new MappingResult(Tile.slow)), new ColorMapping(new Color(100, 100, 100), new MappingResult(Tile.roomWindow)), new ColorMapping(new Color(153, 102, 0), new MappingResult(Tile.road)), new ColorMapping(new Color(0, 128, 0), new MappingResult(null, TerrainType.upExit)), new ColorMapping(new Color(0, 255, 0), new MappingResult(null, TerrainType.downExit)), new ColorMapping(new Color(255, 255, 204), new MappingResult(Tile.floor, TerrainType.rocks)), new ColorMapping(new Color(0, 140, 0), new MappingResult(Tile.floor, TerrainType.bush)), new ColorMapping(new Color(0, 141, 0), new MappingResult(Tile.roomFloor, TerrainType.bush)), new ColorMapping(new Color(165, 136, 50), new MappingResult(Tile.roomFloor, TerrainType.table)), new ColorMapping(new Color(255, 255, 200), new MappingResult(Tile.roomFloor, TerrainType.crate)), new ColorMapping(new Color(220, 110, 90), new MappingResult(Tile.roomFloor, TerrainType.kiln)), new ColorMapping(new Color(221, 0, 0), new MappingResult(Tile.roomFloor, TerrainType.fire)), new ColorMapping(new Color(250, 250, 250), new MappingResult(Tile.roomFloor, TerrainType.bones))};
        this.doAddMappings(mappings);
    }

    public void doAddMappings(ColorMapping[] mappings) {
        for (int i = 0; i < mappings.length; ++i) {
            ColorMapping mapping = mappings[i];
            this.colorToResult.put(mapping.color, mapping.result);
        }
    }

    public void setMap(Map map_) {
        this.map = map_;
    }

    public void onMapTranslated() {
    }

    public void doTranslate(Color color, MapTileLocation location) {
        MappingResult result = (MappingResult)this.colorToResult.get(color);
        Tile tile = result.tile != null ? result.tile : this.map.getTile(new MapTileLocation(location.x - 1, location.y));
        this.map.setTile(location, tile);
        EntityType entityType = result.entityType;
        MapEntity entityCreated = null;
        if (entityType != null) {
            if (entityType instanceof MonsterType) {
                MonsterType monsterType = (MonsterType)entityType;
                Monster monster = MonsterFactory.doCreateMonster(monsterType);
                this.map.doAddEntity((MapEntity)monster, location);
                entityCreated = monster;
            } else if (entityType instanceof ItemType) {
                ItemType itemType = (ItemType)entityType;
                Item item = ItemFactory.doCreateItem(itemType);
                this.map.doAddEntity((MapEntity)item, location);
                entityCreated = item;
            } else if (entityType instanceof TerrainType) {
                TerrainType terrainType = (TerrainType)entityType;
                Terrain terrain = TerrainFactory.doCreateTerrain(terrainType);
                this.map.doAddEntity((MapEntity)terrain, location);
                entityCreated = terrain;
            } else if (entityType instanceof TalkerBeingType) {
                TalkerBeingType talkerBeingType = (TalkerBeingType)entityType;
                TalkerBeing being = TalkerBeingFactory.doCreateTalkerBeing(talkerBeingType);
                this.map.doAddEntity((MapEntity)being, location);
                entityCreated = being;
            }
        }
        this.onColorTranslated(color, entityCreated, location);
    }

    protected void onColorTranslated(Color color, MapEntity entity, MapTileLocation location) {
    }

    public static class MoonEndTranslator
    extends MapTranslator {
        public MoonEndTranslator() {
            ColorMapping[] mappings = new ColorMapping[]{new ColorMapping(new Color(255, 0, 0), new MappingResult(Tile.roomFloor, MonsterType.sentryborg)), new ColorMapping(new Color(230, 0, 0), new MappingResult(Tile.roomFloor, MonsterType.robotGenerator)), new ColorMapping(new Color(0, 0, 166), new MappingResult(Tile.roomFloor, TerrainType.machinery1)), new ColorMapping(new Color(0, 0, 226), new MappingResult(Tile.roomFloor, TerrainType.machinery2))};
            this.doAddMappings(mappings);
        }
    }

    public static class DaveDungeonEndTranslator
    extends MapTranslator {
        public DaveDungeonEndTranslator() {
            ColorMapping[] mappings = new ColorMapping[]{new ColorMapping(new Color(255, 0, 0), new MappingResult(Tile.floor, MonsterType.ferrousGolem)), new ColorMapping(new Color(0, 254, 254), new MappingResult(Tile.floor, TerrainType.fogPlacer)), new ColorMapping(new Color(249, 249, 249), new MappingResult(Tile.floor, TerrainType.pillar)), new ColorMapping(new Color(0, 230, 230), new MappingResult(Tile.floor, TerrainType.crusher))};
            this.doAddMappings(mappings);
        }

        public void onMapTranslated() {
            Terrain fogPlacer = this.map.getTerrainOfType(TerrainType.fogPlacer);
            fogPlacer.doAct();
        }
    }

    public static class DungeonCEndTranslator
    extends MapTranslator {
        private MapPixelLocation throneLocation;
        private Terrains.Summoner wizardSummoner;
        private EventMarkersActivator activator = new EventMarkersActivator();
        private static final Color wizardSummonerColor = new Color(255, 0, 0);
        private static final Color stalkinSummonerColor = new Color(252, 0, 0);
        private static final Color warpDemonSummonerColor = new Color(253, 0, 0);
        private static final Color vampireSummonerColor = new Color(254, 0, 0);
        protected static StartCriterion startCriterion = new StartCriterion();
        private static DoorAppearsEvent doorAppearsEvent = new DoorAppearsEvent();

        public DungeonCEndTranslator() {
            ColorMapping[] mappings = new ColorMapping[]{new ColorMapping(new Color(0, 255, 255), new MappingResult(Tile.roomFloor, TerrainType.throne)), new ColorMapping(new Color(200, 160, 90), new MappingResult(Tile.roomFloor, TerrainType.eventMarker)), new ColorMapping(wizardSummonerColor, new MappingResult(Tile.roomFloor, TerrainType.summoner)), new ColorMapping(stalkinSummonerColor, new MappingResult(Tile.roomFloor, TerrainType.summoner)), new ColorMapping(warpDemonSummonerColor, new MappingResult(Tile.roomFloor, TerrainType.summoner)), new ColorMapping(vampireSummonerColor, new MappingResult(Tile.roomFloor, TerrainType.summoner))};
            this.doAddMappings(mappings);
        }

        protected void onColorTranslated(Color color, MapEntity entity, MapTileLocation location) {
            if (color.equals(wizardSummonerColor)) {
                this.wizardSummoner = (Terrains.Summoner)entity;
                if (this.throneLocation != null) {
                    this.doPointSummonerToThrone();
                }
            } else if (color.equals(stalkinSummonerColor)) {
                ((Terrains.Summoner)entity).setSummoningParameters(MonsterType.stalkin, null, 3, 2, startCriterion, this.activator);
            } else if (color.equals(warpDemonSummonerColor)) {
                ((Terrains.Summoner)entity).setSummoningParameters(MonsterType.warpDemon, null, 3, 1, startCriterion, this.activator);
            } else if (color.equals(vampireSummonerColor)) {
                ((Terrains.Summoner)entity).setSummoningParameters(MonsterType.vampire, null, 3, 3, startCriterion, this.activator);
            } else if (entity != null && entity.isTerrain()) {
                Terrain terrain = (Terrain)entity;
                if (terrain.isOfType(TerrainType.throne)) {
                    this.throneLocation = TileSizeUtil.getPixelLocation(location);
                    if (this.wizardSummoner != null) {
                        this.doPointSummonerToThrone();
                    }
                } else if (terrain.isOfType(TerrainType.eventMarker)) {
                    ((Terrains.EventMarker)terrain).setEvent(doorAppearsEvent);
                }
            }
        }

        private void doPointSummonerToThrone() {
            this.wizardSummoner.setSummoningParameters(MonsterType.livingDeadWizard, this.throneLocation, 1, 1, startCriterion, null);
        }

        private static class DoorAppearsEvent
        implements Terrains.EventMarker.Event {
            private DoorAppearsEvent() {
            }

            public void doOccur(Terrains.EventMarker marker) {
                Map map = marker.getMap();
                MapPixelLocation location = marker.getLocation();
                MapPixelLocation spot = new MapPixelLocation();
                for (int i = 0; i < 4; ++i) {
                    spot.setLocation(location);
                    switch (i) {
                        case 0: {
                            spot.x -= TileSize.tileSize.width;
                            break;
                        }
                        case 1: {
                            spot.x += TileSize.tileSize.width;
                            break;
                        }
                        case 2: {
                            spot.y -= TileSize.tileSize.height;
                            break;
                        }
                        case 3: {
                            spot.y += TileSize.tileSize.height;
                        }
                    }
                    Tile tile = map.getTile(spot);
                    if (!tile.getBlocksLOS()) continue;
                    map.onSoundIssued(Sound.doorAppears, spot);
                    map.setTile(spot, Tile.door);
                    break;
                }
            }
        }

        private static class StartCriterion
        implements Terrains.Summoner.StartCriterion {
            private StartCriterion() {
            }

            public boolean getCanStart(Terrain summoner, Player player) {
                return player.getLocation().y <= summoner.getLocation().y;
            }
        }
    }

    public static class EventMarkersActivator
    implements Terrains.Summoner.DoneListener,
    Serializable {
        public void onDone(Terrain summoner) {
            Map map = summoner.getMap();
            List terrains = map.getTerrainsInLOS(summoner.getLocation(), null);
            int numTerrains = terrains.size();
            for (int i = 0; i < numTerrains; ++i) {
                Terrain terrain = (Terrain)terrains.get(i);
                if (!terrain.isOfType(TerrainType.eventMarker)) continue;
                ((Terrains.EventMarker)terrain).onTriggered();
            }
        }
    }

    public static class BaseEndTranslator
    extends MapTranslator {
        private List trapLocations = new ArrayList();
        private List itemLocations = new ArrayList();

        public BaseEndTranslator() {
            ColorMapping[] mappings = new ColorMapping[]{new ColorMapping(new Color(255, 0, 0), new MappingResult(Tile.floor)), new ColorMapping(new Color(0, 236, 236), new MappingResult(Tile.floor, TerrainType.repairMachine))};
            this.doAddMappings(mappings);
        }

        protected void onColorTranslated(Color color, MapEntity entity, MapTileLocation location) {
            if (color.getRed() == 255 && color.getGreen() == 0 && color.getBlue() == 0) {
                int roll = Random.getInt(1, 12);
                if (roll <= 9) {
                    this.trapLocations.add(TileSizeUtil.getPixelLocation(location));
                }
                if (roll >= 9 && roll <= 10) {
                    this.itemLocations.add(TileSizeUtil.getPixelLocation(location));
                }
            }
        }

        public void onMapTranslated() {
            MapStocker stocker = new MapStocker();
            stocker.doStockLocations(this.map, this.trapLocations, TerrainType.trapTypes);
            this.trapLocations.clear();
            stocker.doStockLocations(this.map, this.itemLocations, ItemType.types);
            this.itemLocations.clear();
        }
    }

    public static class RuinsEndTranslator
    extends MapTranslator {
        public RuinsEndTranslator() {
            ColorMapping[] mappings = new ColorMapping[]{new ColorMapping(new Color(255, 0, 0), new MappingResult(Tile.roomFloor, MonsterType.acidDragon)), new ColorMapping(new Color(0, 254, 254), new MappingResult(Tile.floor, TerrainType.vacuumHole)), new ColorMapping(new Color(0, 231, 232), new MappingResult(Tile.roomFloor, TerrainType.library)), new ColorMapping(new Color(0, 236, 236), new MappingResult(Tile.roomFloor, TalkerBeingType.demonicWizard))};
            this.doAddMappings(mappings);
        }
    }

    public static class DungeonBEndTranslator
    extends MapTranslator {
        private List itemLocations = new ArrayList();
        private static final Color dragonColor = new Color(255, 0, 0);
        private static final Color goldColor = new Color(255, 255, 0);
        private static final Color itemColor = new Color(200, 200, 0);

        public DungeonBEndTranslator() {
            ColorMapping[] mappings = new ColorMapping[]{new ColorMapping(dragonColor, new MappingResult(Tile.floor, MonsterType.redDragon)), new ColorMapping(goldColor, new MappingResult(Tile.floor)), new ColorMapping(itemColor, new MappingResult(Tile.floor))};
            this.doAddMappings(mappings);
        }

        protected void onColorTranslated(Color color, MapEntity entity, MapTileLocation location) {
            if (color.equals(itemColor) || color.equals(goldColor) || color.equals(dragonColor)) {
                if (Random.getInt(1, 3) <= 2) {
                    this.map.doAddEntity((MapEntity)ItemFactory.doCreateItem(ItemType.gold), location);
                } else {
                    this.itemLocations.add(TileSizeUtil.getPixelLocation(location));
                }
            }
        }

        public void onMapTranslated() {
            MapStocker stocker = new MapStocker();
            stocker.doStockLocations(this.map, this.itemLocations, ItemType.types);
            this.itemLocations.clear();
        }
    }

    public static class CityEndTranslator
    extends MapTranslator {
        public CityEndTranslator() {
            ColorMapping[] mappings = new ColorMapping[]{new ColorMapping(new Color(255, 0, 0), new MappingResult(Tile.roomFloor, MonsterType.grenadier)), new ColorMapping(new Color(200, 0, 0), new MappingResult(Tile.roomFloor, MonsterType.mercenary)), new ColorMapping(new Color(150, 0, 0), new MappingResult(Tile.roomFloor, MonsterType.berzerker)), new ColorMapping(new Color(0, 0, 151), new MappingResult(Tile.floor, TerrainType.landMine))};
            this.doAddMappings(mappings);
        }

        protected void onColorTranslated(Color color, MapEntity entity, MapTileLocation location) {
            Monster monster;
            if (entity != null && entity.isMonster() && ((monster = (Monster)entity).isOfType(MonsterType.grenadier) || monster.isOfType(MonsterType.mercenary))) {
                monster.setStationary(true);
            }
        }
    }

    public static class SwampEndTranslator
    extends MapTranslator {
        public SwampEndTranslator() {
            ColorMapping[] mappings = new ColorMapping[]{new ColorMapping(new Color(0, 180, 0), new MappingResult(Tile.slow, TerrainType.tallTree)), new ColorMapping(new Color(0, 140, 0), new MappingResult(Tile.roomFloor, TerrainType.bush)), new ColorMapping(new Color(255, 0, 0), new MappingResult(Tile.roomFloor, MonsterType.hydra))};
            this.doAddMappings(mappings);
        }
    }

    public static class DungeonAEndTranslator
    extends MapTranslator {
        public DungeonAEndTranslator() {
            ColorMapping[] mappings = new ColorMapping[]{new ColorMapping(new Color(255, 0, 0), new MappingResult(Tile.roomFloor, MonsterType.gargoyle)), new ColorMapping(new Color(0, 236, 236), new MappingResult(Tile.roomFloor, TalkerBeingType.nightdwarf))};
            this.doAddMappings(mappings);
        }
    }

    public static class TopsideTranslator
    extends MapTranslator {
        public TopsideTranslator() {
            ColorMapping[] mappings = new ColorMapping[]{new ColorMapping(new Color(128, 128, 128), new MappingResult(Tile.floor, TerrainType.mapEdgeBarrier)), new ColorMapping(new Color(128, 128, 127), new MappingResult(Tile.road, TerrainType.mapEdgeBarrier)), new ColorMapping(new Color(128, 128, 126), new MappingResult(Tile.water, TerrainType.mapEdgeBarrier)), new ColorMapping(new Color(213, 146, 0), new MappingResult(Tile.roadNW)), new ColorMapping(new Color(213, 145, 0), new MappingResult(Tile.roadNE)), new ColorMapping(new Color(213, 144, 0), new MappingResult(Tile.roadSW)), new ColorMapping(new Color(213, 143, 0), new MappingResult(Tile.roadSE)), new ColorMapping(new Color(255, 255, 150), new MappingResult(Tile.roomFloor, TerrainType.rocks)), new ColorMapping(new Color(0, 150, 0), new MappingResult(Tile.roomFloor, TalkerBeingType.topsideStorekeeper)), new ColorMapping(new Color(0, 149, 0), new MappingResult(Tile.roomFloor, TalkerBeingType.topsidePriest)), new ColorMapping(new Color(0, 148, 0), new MappingResult(Tile.roomFloor, TalkerBeingType.topsideBlacksmith)), new ColorMapping(new Color(0, 147, 0), new MappingResult(Tile.road, TalkerBeingType.dwarvenConsort)), new ColorMapping(new Color(0, 146, 0), new MappingResult(Tile.road, TalkerBeingType.goldPorter)), new ColorMapping(new Color(0, 145, 0), new MappingResult(Tile.roomFloor, TalkerBeingType.sage)), new ColorMapping(new Color(204, 204, 204), new MappingResult(Tile.roomFloor, TerrainType.altar))};
            this.doAddMappings(mappings);
        }
    }

    private class MappingResult {
        public Tile tile;
        public EntityType entityType;

        public MappingResult(Tile tile) {
            this(tile, null);
        }

        public MappingResult(Tile tile, EntityType entityType) {
            this.tile = tile;
            this.entityType = entityType;
        }
    }

    private class ColorMapping {
        public Color color;
        public MappingResult result;

        public ColorMapping(Color color_, MappingResult result_) {
            this.color = color_;
            this.result = result_;
        }
    }
}

