/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.effects;

import silmar.Sound;
import silmar.entities.MapEntity;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapTileDistance;
import silmar.map.effects.LightSourceVisualEffect;
import silmar.map.effects.VisualEffect;
import silmar.util.ThreadUtil;

public class Teleport {
    public static VisualEffect doTeleport(Map map, MapPixelLocation location, boolean out, boolean leaveFinalFrame) {
        map.onSoundIssued(out ? Sound.teleportOut : Sound.teleportIn, location);
        LightSourceVisualEffect effect = new LightSourceVisualEffect(null, new MapPixelDistance(new MapTileDistance(6)));
        map.doAddEntity((MapEntity)effect, location);
        for (int i = 1; i <= 5; ++i) {
            effect.setImageName("teleport" + (out ? i : 6 - i));
            ThreadUtil.doSleep(200L);
        }
        if (leaveFinalFrame) {
            return effect;
        }
        map.doRemoveEntity(effect);
        return null;
    }
}

