/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.effects;

import java.util.List;
import silmar.Sound;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.entities.beings.MovementType;
import silmar.entities.beings.attacks.AttackType;
import silmar.entities.items.Item;
import silmar.entities.terrains.Terrain;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.MapTileDistance;
import silmar.map.effects.Attack;
import silmar.map.effects.LightSourceVisualEffect;
import silmar.tiles.TileSize;
import silmar.util.ThreadUtil;

public class Fireball
implements TileSize {
    public static void doFireball(Map map, MapPixelLocation from, MapPixelLocation to, int strength) {
        if (from != null) {
            Attack.doAttack(map, from, to, AttackType.fireball);
        }
        LightSourceVisualEffect effect = new LightSourceVisualEffect(null, new MapPixelDistance(new MapTileDistance(15)));
        map.doAddEntity((MapEntity)effect, to);
        map.onSoundIssued(Sound.fireballBlast, to);
        for (int i = 1; i <= 2; ++i) {
            effect.setImageName("fireball" + i);
            ThreadUtil.doSleep(400L);
        }
        map.doRemoveEntity(effect);
        List items = map.getItemsInRange(to, new MapPixelDistance(3 * TileSize.tileSize.width / 2), null);
        int numItems = items.size();
        for (int i = 0; i < numItems; ++i) {
            Item item = (Item)items.get(i);
            item.onHitByFireball(strength);
        }
        List terrains = map.getTerrainsInRange(to, new MapPixelDistance(3 * TileSize.tileSize.width / 2), null);
        int numTerrains = terrains.size();
        for (int i = 0; i < numTerrains; ++i) {
            Terrain terrain = (Terrain)terrains.get(i);
            terrain.onHitByFireball(strength);
        }
        List beings = map.getBeingsInRange(to, new MapPixelDistance(3 * TileSize.tileSize.width / 2), null);
        int numBeings = beings.size();
        for (int i = 0; i < numBeings; ++i) {
            Being being = (Being)beings.get(i);
            being.onHitByFireball(strength);
        }
    }

    public static MapPixelLocation getSkeweredTargetLocation(Map map, MapPixelLocation from, MapPixelLocation target, MapPixelDistance maxSkewer) {
        MapPixelDistance range = MapPixelLocationUtil.getDistance(from, target);
        if (maxSkewer.distance > range.distance) {
            maxSkewer = range;
        }
        for (int i = 0; i < 5; ++i) {
            MapPixelLocation skewered = map.getRandomPassibleRectangleLocationInLOSAndRange(target, TileSize.tileSize, maxSkewer, 50, MovementType.flyingNoHands, false);
            if (skewered == null || !map.getCanSee(from, skewered, TileSize.tileSize.width, false, false, null, null)) continue;
            target = skewered;
            break;
        }
        return target;
    }
}

