/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.effects;

import java.awt.Point;
import java.util.List;
import silmar.Sound;
import silmar.entities.beings.Being;
import silmar.entities.beings.attacks.AttackType;
import silmar.entities.beings.attacks.RangedAttackUtil;
import silmar.entities.terrains.Terrain;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.effects.Attack;
import silmar.tiles.TileSize;
import silmar.util.PointUtil;
import silmar.util.Random;

public class BoulderThrow
implements TileSize {
    public static void doThrow(Map map, Terrain boulder, MapPixelLocation from, MapPixelLocation to, int strength, int accuracy) {
        MapPixelLocation bounce;
        Attack.doAttack(map, from, to, AttackType.boulder);
        MapPixelDistance range = MapPixelLocationUtil.getDistance(from, to);
        int rangePenalty = RangedAttackUtil.getPenaltyForRange(range, new MapPixelDistance(strength / 2 * TileSize.tileSize.width));
        MapPixelDistance bounceDistance = new MapPixelDistance(range.distance / 3 + TileSize.tileSize.width);
        List line = MapPixelLocationUtil.getLineLocations(from, to, TileSize.tileSize.width / 2, new MapPixelDistance(range.distance + bounceDistance.distance), 0);
        int toIndex = PointUtil.getIndexOfNearestPoint(to, line);
        MapPixelLocation finalLocation = new MapPixelLocation((Point)line.get(toIndex));
        int numBounces = line.size();
        for (int i = toIndex; i < numBounces && !map.getTile(bounce = new MapPixelLocation((Point)line.get(i))).getBlocksLOS(); ++i) {
            finalLocation.setLocation(bounce);
            map.doMoveEntity(boulder, finalLocation);
            map.onSoundIssued(Sound.damage, finalLocation);
            List beings = map.getEntitiesInRectangle(bounce, boulder.getSize(), map.getBeings(), null, null, null, null);
            int numBeings = beings.size();
            for (int j = 0; j < numBeings; ++j) {
                Being being = (Being)beings.get(j);
                int roll = Random.getInt(1, 20);
                if (roll > accuracy + rangePenalty) continue;
                int damage = Random.getBellCurveInt(1, 10, 4);
                being.onHitByBoulder(strength, damage);
            }
        }
    }
}

