/*
 * Decompiled with CFR 0.152.
 */
package silmar.map.effects;

import java.util.List;
import silmar.entities.MapEntity;
import silmar.entities.beings.attacks.AttackType;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.MapTileDistance;
import silmar.map.effects.LightSourceVisualEffect;
import silmar.map.effects.VisualEffect;
import silmar.tiles.TileSize;
import silmar.util.ThreadUtil;

public class Attack
implements TileSize {
    public static void doAttack(Map map, MapPixelLocation from, MapPixelLocation to, AttackType attackType) {
        if (from.equals(to)) {
            return;
        }
        List locations = MapPixelLocationUtil.getLineLocations(from, to, TileSize.tileSize.width / 4, null, 0);
        map.onSoundIssued(attackType.sound, from);
        VisualEffect effect = attackType.lightTileRadius > 0 ? new LightSourceVisualEffect(attackType.imageName, new MapPixelDistance(new MapTileDistance(attackType.lightTileRadius))) : new VisualEffect(attackType.imageName);
        map.doAddEntity((MapEntity)effect, from);
        int numLocations = locations.size();
        for (int i = 0; i < numLocations; ++i) {
            MapPixelLocation location = (MapPixelLocation)locations.get(i);
            long startTime = System.currentTimeMillis();
            map.doMoveEntity(effect, location);
            long timeTaken = System.currentTimeMillis() - startTime;
            int minimumMovementStepTime = 15;
            if (timeTaken >= 15L) continue;
            ThreadUtil.doSleep(15L - timeTaken);
        }
        map.doRemoveEntity(effect);
    }
}

