/*
 * Decompiled with CFR 0.152.
 */
package silmar.map;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.entities.beings.MovementType;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.MapTileDistance;
import silmar.tiles.TileSize;
import silmar.tiles.TileSizeUtil;

public final class PathFinder
implements TileSize {
    private LocationPool locationPool = new LocationPool();
    private static final MapTileDistance defaultEnclosureDistance = new MapTileDistance(15);
    private PassibleCriterion passibleCriterion = new PassibleCriterion();
    private static Integer[] stepIntegers = new Integer[100];
    private static final Integer cannotUseAsStep;
    private static final List emptyPath;
    private List bestPath;
    private GetPassiblePathResult getPassiblePath_result = new GetPassiblePathResult();
    private GetPassiblePathGoalCriterion getPassiblePath_goalCriterion = new GetPassiblePathGoalCriterion();
    private final MapPixelDistance getPath_squaredDistance = new MapPixelDistance();
    private final MapPixelDistance getPath_maxLength = new MapPixelDistance();
    private final HashMap getPath_steps = new HashMap();
    private final Point[] getPath_directions = new Point[4];
    private final MapPixelLocation getPath_current = new MapPixelLocation();
    private final Dimension getPath_mapPixelSize = new Dimension();
    private final MapPixelDistance getPath_bestSquaredDistance = new MapPixelDistance();
    private final MapPixelLocation getPath_bestPathEnd = new MapPixelLocation();
    private final MapPixelLocation getPathFromStepsMap_current = new MapPixelLocation();
    private final MapPixelLocation getPathFromStepsMap_test = new MapPixelLocation();

    public PathFinder() {
        for (int i = 0; i < this.getPath_directions.length; ++i) {
            this.getPath_directions[i] = new Point();
        }
    }

    public List getNonLosBlockedPath(final Map map, MapPixelLocation from, MapPixelLocation to, MapTileDistance maxLength, boolean pathNeeded) {
        from = TileSizeUtil.getPixelLocation(TileSizeUtil.getTileLocation(from));
        to = TileSizeUtil.getPixelLocation(TileSizeUtil.getTileLocation(to));
        PathCriterion pathCriterion = new PathCriterion(){

            public boolean getCanUseRectangleLocation(MapPixelLocation location) {
                return !map.getTile(location).getBlocksLOS();
            }
        };
        return this.getPath(map, from, to, maxLength, pathCriterion, null, false, pathNeeded, false);
    }

    public GetPassiblePathResult getPassiblePath(Map map, MapPixelLocation from, MapPixelLocation to, MapEntity movingEntity, MapEntity goalEntity, MapTileDistance maxLength, MovementType movementType, boolean detmBestPath, boolean checkForHarmfulTerrains) {
        GetPassiblePathResult result = this.getPassiblePath_result;
        result.doInit();
        from = map.getNearbyPassibleQuarterTileLocation(from, movingEntity.getSize(), movementType, movingEntity, goalEntity);
        if (from == null) {
            return result;
        }
        MapPixelLocation penultimateTo = map.getNearbyPassibleQuarterTileLocation(to, movingEntity.getSize(), movementType, movingEntity, goalEntity);
        if (penultimateTo == null) {
            penultimateTo = to;
        }
        if (from.equals(penultimateTo)) {
            ArrayList<MapPixelLocation> path = new ArrayList<MapPixelLocation>();
            path.add(from);
            path.add(to);
            result.path = path;
            return result;
        }
        this.passibleCriterion.map = map;
        this.passibleCriterion.movingEntity = movingEntity;
        this.passibleCriterion.movementType = movementType;
        this.passibleCriterion.goalEntity = goalEntity;
        this.passibleCriterion.checkForHarmfulTerrains = checkForHarmfulTerrains;
        this.passibleCriterion.harmfulTerrainFound = false;
        this.getPassiblePath_goalCriterion.movingEntity = movingEntity;
        this.getPassiblePath_goalCriterion.goalEntity = goalEntity;
        this.getPassiblePath_goalCriterion.penultimateTo = penultimateTo;
        List path = this.getPath(map, from, penultimateTo, maxLength, this.passibleCriterion, this.getPassiblePath_goalCriterion, true, true, detmBestPath);
        if (checkForHarmfulTerrains) {
            result.foundHarm = this.passibleCriterion.harmfulTerrainFound;
        }
        if (path != null) {
            if (this.passibleCriterion.getCanUseRectangleLocation(to)) {
                path.add(to);
            }
        } else if (detmBestPath) {
            path = this.bestPath;
            result.bestPathReturned = true;
        }
        result.path = path;
        return result;
    }

    public List getBeingsInEnclosure(Map map, MapPixelLocation inEnclosureLocation) {
        return this.getBeingsInEnclosure(map, inEnclosureLocation, map.getBeings());
    }

    public List getBeingsInEnclosure(Map map, MapPixelLocation inEnclosureLocation, List beings) {
        return this.getBeingsInEnclosure(map, inEnclosureLocation, beings, defaultEnclosureDistance);
    }

    public List getBeingsInEnclosure(Map map, MapPixelLocation inEnclosureLocation, List beings, MapTileDistance maxPathLength) {
        List found = map.getEntitiesInRange(inEnclosureLocation, new MapPixelDistance(maxPathLength.distance * TileSize.tileSize.width), beings, null);
        int numFound = found.size();
        for (int i = 0; i < numFound; ++i) {
            Being being = (Being)found.get(i);
            if (map.getCanSee(inEnclosureLocation, being.getLocation(), TileSize.tileSize.width, false, false, null, null) || this.getNonLosBlockedPath(map, inEnclosureLocation, being.getLocation(), maxPathLength, false) != null) continue;
            found.remove(i--);
            --numFound;
        }
        return found;
    }

    public List getMonstersInEnclosure(Map map, MapPixelLocation inEnclosureLocation) {
        return this.getMonstersInEnclosure(map, inEnclosureLocation, map.getMonsters());
    }

    public List getMonstersInEnclosure(Map map, MapPixelLocation inEnclosureLocation, List monsters) {
        return this.getMonstersInEnclosure(map, inEnclosureLocation, monsters, defaultEnclosureDistance);
    }

    public List getMonstersInEnclosure(Map map, MapPixelLocation inEnclosureLocation, List monsters, MapTileDistance maxPathLength) {
        return this.getBeingsInEnclosure(map, inEnclosureLocation, monsters, maxPathLength);
    }

    public List getPath(Map map, MapPixelLocation from, MapPixelLocation to, MapTileDistance maxLength, PathCriterion pathCriterion, GoalCriterion goalCriterion, boolean useDoubleResolution, boolean pathNeeded, boolean detmBestPath) {
        this.bestPath = null;
        this.getPath_maxLength.distance = maxLength.distance * TileSize.tileSize.width;
        if (!detmBestPath && !MapPixelLocationUtil.isDistanceAtMost(from, to, this.getPath_maxLength)) {
            return null;
        }
        int stepsPerTile = useDoubleResolution ? 2 : 1;
        int maxSteps = maxLength.distance * stepsPerTile;
        HashMap steps = this.getPath_steps;
        steps.clear();
        steps.put(from, stepIntegers[0]);
        int widthPerStep = TileSize.tileSize.width / stepsPerTile;
        int heightPerStep = TileSize.tileSize.height / stepsPerTile;
        Point[] directions = this.getPath_directions;
        directions[0].move(0, -heightPerStep);
        directions[1].move(0, heightPerStep);
        directions[2].move(-widthPerStep, 0);
        directions[3].move(widthPerStep, 0);
        MapPixelLocation current = this.getPath_current;
        Dimension mapPixelSize = this.getPath_mapPixelSize;
        mapPixelSize.setSize(map.getSize());
        mapPixelSize.width *= TileSize.tileSize.width;
        mapPixelSize.height *= TileSize.tileSize.height;
        MapPixelDistance bestSquaredDistance = this.getPath_bestSquaredDistance;
        bestSquaredDistance.distance = Integer.MAX_VALUE;
        MapPixelLocation bestPathEnd = this.getPath_bestPathEnd;
        boolean bestPathEndSet = false;
        for (int step = 1; step <= maxSteps; step = (int)((byte)(step + 1))) {
            Integer stepNumber = stepIntegers[step];
            for (int i = Math.max(0, from.x - step * widthPerStep); i <= Math.min(from.x + step * widthPerStep, mapPixelSize.width - 1); i += widthPerStep) {
                for (int j = Math.max(0, from.y - step * heightPerStep); j <= Math.min(from.y + step * heightPerStep, mapPixelSize.height - 1); j += heightPerStep) {
                    current.move(i, j);
                    Integer number = (Integer)steps.get(current);
                    if (number == null || number != stepNumber - 1) continue;
                    for (int k = 0; k < directions.length; ++k) {
                        Point direction = directions[k];
                        current.move(i + direction.x, j + direction.y);
                        if (steps.get(current) != null) continue;
                        if (current.equals(to) || goalCriterion != null && goalCriterion.isAGoal(current)) {
                            steps.put(this.locationPool.getAvailableInstance(current), stepNumber);
                            List path = pathNeeded ? this.getPathFromStepsMap(steps, current) : emptyPath;
                            return path;
                        }
                        boolean canUse = pathCriterion.getCanUseRectangleLocation(current);
                        steps.put(this.locationPool.getAvailableInstance(current), canUse ? stepNumber : cannotUseAsStep);
                        if (!canUse || !detmBestPath) continue;
                        MapPixelDistance squaredDistance = this.getPath_squaredDistance;
                        MapPixelLocationUtil.getSquaredDistance(current, to, squaredDistance);
                        if (squaredDistance.distance >= bestSquaredDistance.distance) continue;
                        bestSquaredDistance.distance = squaredDistance.distance;
                        bestPathEnd.setLocation(current);
                        bestPathEndSet = true;
                    }
                }
            }
        }
        if (detmBestPath && bestPathEndSet) {
            this.bestPath = this.getPathFromStepsMap(steps, bestPathEnd);
        }
        if (pathNeeded) {
            // empty if block
        }
        return null;
    }

    private List getPathFromStepsMap(HashMap steps, MapPixelLocation goal) {
        LinkedList<MapPixelLocation> path = new LinkedList<MapPixelLocation>();
        path.add(goal);
        int step = (Integer)steps.get(goal);
        Point[] directions = this.getPath_directions;
        MapPixelLocation current = this.getPathFromStepsMap_current;
        current.setLocation(goal);
        MapPixelLocation test = this.getPathFromStepsMap_test;
        block0: while (true) {
            int k = 0;
            while (true) {
                if (k >= directions.length) continue block0;
                Point direction = directions[k];
                test.setLocation(current.x + direction.x, current.y + direction.y);
                Integer testStepNum = (Integer)steps.get(test);
                if (testStepNum != null && testStepNum == step - 1) {
                    path.add(0, this.locationPool.getAvailableInstance(test));
                    if (step == 1) {
                        Object[] locations = steps.keySet().toArray();
                        for (int i = 0; i < locations.length; ++i) {
                            this.locationPool.doPlaceInPool((MapPixelLocation)locations[i]);
                        }
                        return path;
                    }
                    current.setLocation(test);
                    --step;
                    continue block0;
                }
                ++k;
            }
            break;
        }
    }

    static {
        for (int i = 0; i < stepIntegers.length; ++i) {
            PathFinder.stepIntegers[i] = new Integer(i);
        }
        cannotUseAsStep = new Integer(-2);
        emptyPath = new LinkedList();
    }

    private class LocationPool {
        private List locations = new LinkedList();

        private LocationPool() {
        }

        public MapPixelLocation getAvailableInstance(MapPixelLocation setTo) {
            MapPixelLocation instance = !this.locations.isEmpty() ? (MapPixelLocation)this.locations.remove(0) : new MapPixelLocation();
            if (setTo != null) {
                instance.setLocation(setTo);
            }
            return instance;
        }

        public void doPlaceInPool(MapPixelLocation location) {
            this.locations.add(location);
        }
    }

    private class GetPassiblePathGoalCriterion
    implements GoalCriterion {
        public MapEntity movingEntity;
        public MapEntity goalEntity;
        public MapPixelLocation penultimateTo;
        private Rectangle isAGoal_rect1 = new Rectangle();
        private Rectangle isAGoal_rect2 = new Rectangle();

        private GetPassiblePathGoalCriterion() {
        }

        public boolean isAGoal(Point location) {
            Rectangle rectangle = this.isAGoal_rect1;
            rectangle.setLocation(this.movingEntity.getLocation());
            Dimension size = this.movingEntity.getSize();
            rectangle.x -= size.width / 2;
            rectangle.y -= size.height / 2;
            rectangle.setSize(size);
            Rectangle goal = null;
            if (this.goalEntity != null) {
                goal = this.goalEntity.getBounds();
            } else {
                goal = this.isAGoal_rect2;
                goal.setLocation(this.penultimateTo);
                goal.setSize(TileSize.tileSize);
                goal.x -= TileSize.tileSize.width / 2;
                goal.y -= TileSize.tileSize.height / 2;
            }
            return rectangle.intersects(goal);
        }
    }

    public static class GetPassiblePathResult {
        public List path;
        public boolean foundHarm;
        public boolean bestPathReturned;

        public void doInit() {
            this.path = null;
            this.foundHarm = false;
            this.bestPathReturned = false;
        }
    }

    private class PassibleCriterion
    implements PathCriterion {
        public Map map;
        public MapEntity movingEntity;
        public MovementType movementType;
        public MapEntity goalEntity;
        public boolean checkForHarmfulTerrains;
        public boolean harmfulTerrainFound;

        private PassibleCriterion() {
        }

        public boolean getCanUseRectangleLocation(MapPixelLocation location) {
            Dimension spotSize = this.movingEntity.getSize();
            Map.IsRectanglePassibleResult result = this.map.isRectanglePassible(location, spotSize, this.movementType, true, this.movingEntity, this.goalEntity, this.checkForHarmfulTerrains);
            this.harmfulTerrainFound |= result.harmful;
            return result.passible && (!this.checkForHarmfulTerrains || !result.harmful);
        }
    }

    public static interface GoalCriterion {
        public boolean isAGoal(Point var1);
    }

    public static interface PathCriterion {
        public boolean getCanUseRectangleLocation(MapPixelLocation var1);
    }
}

