/*
 * Decompiled with CFR 0.152.
 */
package silmar.map;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.util.FloatPoint;
import silmar.util.PointUtil;

public class MapPixelLocationUtil {
    private static MapPixelDistance isDistanceAtMost_squaredDistance = new MapPixelDistance();

    public static boolean isDistanceAtMost(MapPixelLocation from, MapPixelLocation to, MapPixelDistance atMost) {
        if (!MapPixelLocationUtil.areOrthogonalDistancesAtMost(from, to, atMost)) {
            return false;
        }
        int atMostSquared = atMost.distance * atMost.distance;
        MapPixelDistance squaredDistance = isDistanceAtMost_squaredDistance;
        MapPixelLocationUtil.getSquaredDistance(from, to, squaredDistance);
        return squaredDistance.distance <= atMostSquared;
    }

    public static boolean areOrthogonalDistancesAtMost(MapPixelLocation from, MapPixelLocation to, MapPixelDistance distance) {
        if (Math.abs(from.x - to.x) > distance.distance) {
            return false;
        }
        return Math.abs(from.y - to.y) <= distance.distance;
    }

    public static MapPixelDistance getDistance(MapPixelLocation from, MapPixelLocation to) {
        MapPixelDistance use = new MapPixelDistance();
        MapPixelLocationUtil.getDistance(from, to, use);
        return use;
    }

    public static MapPixelDistance getDistance(MapPixelLocation from, MapPixelLocation to, MapPixelDistance use) {
        float a = to.y - from.y;
        float b = to.x - from.x;
        use.distance = Math.round((float)Math.sqrt(a * a + b * b));
        return use;
    }

    public static MapPixelDistance getSquaredDistance(MapPixelLocation from, MapPixelLocation to, MapPixelDistance use) {
        float a = to.y - from.y;
        float b = to.x - from.x;
        use.distance = Math.round(a * a + b * b);
        return use;
    }

    public static List getLineLocations(MapPixelLocation from, MapPixelLocation to, int spacing, MapPixelDistance maxDistance, int maxLocations) {
        FloatPoint direction = PointUtil.getUnitVector(from, to);
        direction.x *= (float)spacing;
        direction.y *= (float)spacing;
        if (maxDistance == null) {
            maxDistance = MapPixelLocationUtil.getDistance(from, to);
        }
        float numMoves = maxDistance.distance / spacing;
        if (maxLocations != 0) {
            numMoves = Math.max(numMoves, (float)maxLocations);
        }
        Point2D.Float current = new Point2D.Float(from.x, from.y);
        Point rounded = new Point(from);
        ArrayList<MapPixelLocation> locations = new ArrayList<MapPixelLocation>();
        int i = 0;
        while ((float)i < numMoves) {
            current.x += direction.x;
            current.y += direction.y;
            rounded.move((int)current.x, (int)current.y);
            locations.add(new MapPixelLocation(rounded));
            ++i;
        }
        return locations;
    }
}

