/*
 * Decompiled with CFR 0.152.
 */
package silmar.gui.dialogs;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import silmar.gui.Fonts;
import silmar.gui.widgets.Button;
import silmar.gui.widgets.Label;
import silmar.util.WindowUtil;

public class InputIntDialog
extends JDialog {
    private Result result = new Result();
    private JLabel messageLabel;
    private SpinnerNumberModel spinnerModel;
    private static HashMap doShow_instances = new HashMap();

    public InputIntDialog(JFrame parent) {
        super(parent);
        this.doBuild();
    }

    public InputIntDialog(JDialog parent) {
        super(parent);
        this.doBuild();
    }

    private void doBuild() {
        this.setModal(true);
        this.setResizable(false);
        Container pane = this.getContentPane();
        JPanel panel = new JPanel();
        pane.add(panel);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel.setBackground(Color.black);
        this.messageLabel = new Label("message", Fonts.medium);
        Label label = this.messageLabel;
        panel.add(label);
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel panel1 = new JPanel();
        panel1.setOpaque(false);
        panel1.setLayout(new BoxLayout(panel1, 0));
        panel.add(panel1);
        final SpinnerNumberModel model = this.spinnerModel = new SpinnerNumberModel();
        Button button = new Button(" Min ");
        panel1.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                model.setValue(model.getMinimum());
            }
        });
        panel1.add(Box.createRigidArea(new Dimension(5, 0)));
        final Spinner spinner = new Spinner(model);
        spinner.setFont(Fonts.medium);
        panel1.add(spinner);
        panel1.add(Box.createRigidArea(new Dimension(5, 0)));
        button = new Button(" Max ");
        panel1.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                model.setValue(model.getMaximum());
            }
        });
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel panel2 = new JPanel();
        panel2.setOpaque(false);
        panel.add(panel2);
        button = new Button(" Ok ");
        panel2.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((InputIntDialog)InputIntDialog.this).result.valueEntered = (Integer)spinner.getValue();
                InputIntDialog.this.setVisible(false);
            }
        });
        button = new Button(" Cancel ");
        panel2.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((InputIntDialog)InputIntDialog.this).result.cancelled = true;
                InputIntDialog.this.setVisible(false);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ((InputIntDialog)InputIntDialog.this).result.cancelled = true;
            }
        });
    }

    private void doInit(String message, int min, int max, int defaultValue) {
        this.result.doInit();
        this.messageLabel.setText(message);
        this.spinnerModel.setMaximum(new Integer(max));
        this.spinnerModel.setMinimum(new Integer(min));
        this.spinnerModel.setValue(new Integer(defaultValue));
        this.spinnerModel.setStepSize(new Integer(max - min <= 30 ? 1 : (max - min) / 10));
        this.pack();
        WindowUtil.doCenterWindow(this);
    }

    public Result getResult() {
        return this.result;
    }

    public static Result doShow(Window parent, String message, int min, int max, int defaultValue) {
        InputIntDialog dialog = InputIntDialog.getInstance(parent);
        dialog.doInit(message, min, max, defaultValue);
        dialog.setVisible(true);
        return dialog.getResult();
    }

    private static InputIntDialog getInstance(Window parent) {
        InputIntDialog dialog = (InputIntDialog)doShow_instances.get(parent);
        if (dialog == null) {
            dialog = parent instanceof JFrame ? new InputIntDialog((JFrame)parent) : new InputIntDialog((JDialog)parent);
            doShow_instances.put(parent, dialog);
        }
        return dialog;
    }

    private class Spinner
    extends JSpinner {
        public Spinner(SpinnerModel model) {
            super(model);
        }

        public Dimension getMaximumSize() {
            Dimension size = this.getPreferredSize();
            return new Dimension(size.width + 20, size.height);
        }

        public Dimension getMinimumSize() {
            return this.getMaximumSize();
        }
    }

    public static class Result {
        public boolean cancelled;
        public int valueEntered;

        public void doInit() {
            this.cancelled = false;
            this.valueEntered = 0;
        }
    }
}

