/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.types;

import java.awt.Dimension;
import java.awt.Image;
import java.util.HashMap;
import silmar.map.Map;
import silmar.map.MapPixelLocation;
import silmar.map.stocking.Stockable;
import silmar.tiles.TileSize;
import silmar.util.ImageUtil;
import silmar.util.PointUtil;

public abstract class EntityType
implements Cloneable,
Stockable,
TileSize {
    protected String name;
    protected String imageName;
    protected Image image;
    protected Dimension size;
    protected int frequency;
    public static final HashMap typesMap = new HashMap();

    public EntityType(String name, String imageName) {
        this.name = name;
        this.imageName = imageName;
        if (imageName != null) {
            this.image = ImageUtil.doLoadImage(this.getImagePath() + imageName);
        }
        typesMap.put(name, this);
    }

    public boolean isPlacementLocationValid(Map map, MapPixelLocation location) {
        int x1 = location.x - this.size.width / 2;
        int x2 = location.x + this.size.width / 2 - 1;
        int y1 = location.y - this.size.height / 2;
        int y2 = location.y + this.size.height / 2 - 1;
        MapPixelLocation test = new MapPixelLocation();
        return this.isPresenceLocationValid(map, (MapPixelLocation)PointUtil.set(test, x1, y1)) && this.isPresenceLocationValid(map, (MapPixelLocation)PointUtil.set(test, x2, y2)) && this.isPresenceLocationValid(map, (MapPixelLocation)PointUtil.set(test, x2, y1)) && this.isPresenceLocationValid(map, (MapPixelLocation)PointUtil.set(test, x1, y2));
    }

    protected abstract boolean isPresenceLocationValid(Map var1, MapPixelLocation var2);

    protected void doDetmSize() {
        this.size = this.imageName != null ? ImageUtil.getSizeWithoutLoading(this.getImagePath() + this.imageName) : TileSize.tileSize;
    }

    protected abstract String getImagePath();

    public final int getFrequency() {
        return this.frequency;
    }

    public final String getImageName() {
        return this.imageName;
    }

    public final String getName() {
        return this.name;
    }

    public final Dimension getSize() {
        return this.size;
    }

    public final Image getImage() {
        return this.image;
    }
}

