/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.terrains;

import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import silmar.Sound;
import silmar.entities.LightSource;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.entities.beings.MovementType;
import silmar.entities.beings.monsters.Monster;
import silmar.entities.beings.monsters.MonsterFactory;
import silmar.entities.beings.monsters.MonsterType;
import silmar.entities.beings.monsters.MonsterUtil;
import silmar.entities.beings.player.Player;
import silmar.entities.items.Item;
import silmar.entities.items.ItemFactory;
import silmar.entities.items.ItemValueContext;
import silmar.entities.items.types.ItemType;
import silmar.entities.talkers.ItemFixer;
import silmar.entities.talkers.ItemSeller;
import silmar.entities.talkers.ItemSellerUtil;
import silmar.entities.talkers.Talker;
import silmar.entities.terrains.Terrain;
import silmar.entities.terrains.TerrainFactory;
import silmar.entities.terrains.TerrainType;
import silmar.entities.terrains.traps.Trap;
import silmar.entities.types.EntityType;
import silmar.game.Game;
import silmar.map.Map;
import silmar.map.MapLevel;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.MapTileDistance;
import silmar.map.MapTileLocation;
import silmar.map.effects.Fireball;
import silmar.map.effects.Moat;
import silmar.map.effects.PowerDischarge;
import silmar.map.effects.Teleport;
import silmar.tiles.Tile;
import silmar.tiles.TileSize;
import silmar.tiles.TileSizeUtil;
import silmar.util.FloatPoint;
import silmar.util.ListUtil;
import silmar.util.Random;
import silmar.util.ThreadUtil;

public class Terrains {

    public static class TempLightSource
    extends Terrain
    implements LightSource {
        private MapPixelDistance lightRadius;

        public void setLightRadius(MapPixelDistance lightRadius) {
            this.lightRadius = lightRadius;
        }

        public boolean isEmittingLight() {
            return true;
        }

        public MapPixelDistance getLightRadius() {
            return this.lightRadius;
        }

        public boolean isLightSource() {
            return true;
        }
    }

    public static class Chest
    extends Terrain {
        private Item item;
        private Trap trap;

        public Item getItem() {
            return this.item;
        }

        public void setItem(Item item) {
            this.item = item;
        }

        public Trap getTrap() {
            return this.trap;
        }

        public void doCheckForBeingTrapped() {
            float chanceOfTrap;
            float f = chanceOfTrap = this.item != null ? (float)this.item.getValue(ItemValueContext.placement) / ((float)this.map.getLevel().getMaxItemPlacementValue() / 4.0f) : 0.5f;
            if (Random.getFloat() < chanceOfTrap) {
                while (this.trap == null) {
                    TerrainType trapType = (TerrainType)ListUtil.getRandomElement(TerrainType.trapTypes);
                    if (trapType.equals(TerrainType.gustOfWindTrap) || !trapType.isValidForMap(this.map)) continue;
                    this.trap = (Trap)TerrainFactory.doCreateTerrain(trapType);
                    this.trap.setChest(this);
                    this.map.doAddEntity((MapEntity)this.trap, this.getLocation());
                }
            }
        }

        public void doOpen(Player player) {
            this.map.onSoundIssued(Sound.chestOpens, this.location);
            Map map = this.getMap();
            if (this.trap != null) {
                this.trap.setMap(map);
                this.trap.setLocation(this.location);
                this.trap.doAttemptToSpring(player);
                this.trap = null;
            }
            map.doRemoveEntity(this);
            if (this.item != null) {
                map.doAddEntity((MapEntity)this.item, this.location);
                this.item = null;
            }
        }

        protected void onDestroyed(int avoidanceFailedBy) {
            if (this.item != null) {
                this.map.doAddEntity((MapEntity)this.item, this.location);
                this.item.onContainngChestDestroyed(avoidanceFailedBy);
                this.item = null;
            }
        }
    }

    public static class FogPlacer
    extends Terrain {
        private MapPixelLocation doProcessFogSpot_pixelSpot = new MapPixelLocation();
        private List doProcessFogSpot_terrains = new ArrayList();

        public void doAct() {
            this.map.onGroupOfChangesToOccur();
            MapTileLocation placerTileLocation = TileSizeUtil.getTileLocation(this.getLocation());
            MapTileLocation spot = new MapTileLocation(placerTileLocation);
            while (!this.map.getTile(spot).getBlocksLOS()) {
                --spot.y;
                while (!this.map.getTile(spot).getBlocksLOS()) {
                    this.doProcessFogSpot(spot);
                    --spot.y;
                }
                spot.y = placerTileLocation.y;
                while (!this.map.getTile(spot).getBlocksLOS()) {
                    this.doProcessFogSpot(spot);
                    ++spot.y;
                }
                ++spot.x;
                spot.y = placerTileLocation.y;
            }
            this.map.onGroupOfChangesOccurred();
        }

        private void doProcessFogSpot(MapTileLocation spot) {
            MapPixelLocation pixelSpot = this.doProcessFogSpot_pixelSpot;
            TileSizeUtil.getPixelLocation(spot, pixelSpot);
            List terrains = this.doProcessFogSpot_terrains;
            this.map.getEntitiesAt(pixelSpot, this.map.getTerrains(), terrains);
            boolean fogRemoved = false;
            int numTerrains = terrains.size();
            for (int i = 0; i < numTerrains; ++i) {
                Terrain terrain = (Terrain)terrains.get(i);
                if (!terrain.isOfType(TerrainType.deathFog) || Random.getInt(1, 2) != 1) continue;
                this.map.doRemoveEntity(terrain);
                fogRemoved = true;
                break;
            }
            if (!fogRemoved && Random.getInt(1, 2) == 1) {
                DeathFog fog = (DeathFog)TerrainFactory.doCreateTerrain(TerrainType.deathFog);
                fog.setStrength(MonsterType.ferrousGolem.getPowerRating() / 5);
                this.map.doAddEntity((MapEntity)fog, pixelSpot);
                if (Random.getInt(1, 50) == 1) {
                    this.map.onSoundIssued(Sound.deathFog, pixelSpot);
                }
            }
        }
    }

    public static class Crusher
    extends Terrain {
        private boolean activated = false;

        public void doAct() {
            if (!this.activated) {
                if (!this.map.getPlayersInLOS(this.location, null).isEmpty()) {
                    this.activated = true;
                } else {
                    return;
                }
            }
            MapTileLocation tileLocation = TileSizeUtil.getTileLocation(this.location);
            int crushTileHeight = 7;
            int crushTileWidth = 4;
            MapPixelLocation leftSoundLocation = TileSizeUtil.getPixelLocation(new MapTileLocation(tileLocation.x - 1, tileLocation.y + 7));
            MapPixelLocation rightSoundLocation = TileSizeUtil.getPixelLocation(new MapTileLocation(tileLocation.x + 4, tileLocation.y + 7));
            this.map.onSoundIssued(Sound.wallsClosing, leftSoundLocation);
            this.map.onSoundIssued(Sound.wallsClosing, rightSoundLocation);
            MapTileLocation wall = new MapTileLocation();
            for (int j = 0; j < 7; ++j) {
                for (int i = 0; i < 4; ++i) {
                    wall.setLocation(tileLocation.x + i, tileLocation.y + j);
                    this.putWall(wall);
                    wall.setLocation(tileLocation.x + i, tileLocation.y + 14 - j - 1);
                    this.putWall(wall);
                }
                if (j >= 6) continue;
                this.pauseForUsersToSee(100);
            }
            this.map.onSoundIssued(Sound.wallsShut, leftSoundLocation);
            this.map.onSoundIssued(Sound.wallsShut, rightSoundLocation);
            this.pauseForUsersToSee(1000);
            this.map.onSoundIssued(Sound.wallsOpening, leftSoundLocation);
            this.map.onSoundIssued(Sound.wallsOpening, rightSoundLocation);
            MapTileLocation floor = wall;
            for (int j = 0; j < 7; ++j) {
                for (int i = 0; i < 4; ++i) {
                    floor.setLocation(tileLocation.x + i, tileLocation.y + 7 - j);
                    this.map.setTile(floor, Tile.floor);
                    floor.setLocation(tileLocation.x + i, tileLocation.y + 7 + j);
                    this.map.setTile(floor, Tile.floor);
                }
                this.pauseForUsersToSee(250);
            }
        }

        protected void pauseForUsersToSee(int length) {
            ThreadUtil.doSleep(length);
        }

        protected void putWall(MapTileLocation location) {
            this.map.setTile(location, Tile.roomWall);
            List beings = this.map.getEntitiesInRectangle(TileSizeUtil.getPixelLocation(location), TileSize.tileSize, this.map.getBeings(), null, null, null, null);
            int numBeings = beings.size();
            for (int i = 0; i < numBeings; ++i) {
                Being being = (Being)beings.get(i);
                being.onHitByCrusher();
            }
        }
    }

    public static class Radiation
    extends Terrain {
        public void doAct() {
            if (Random.getInt(1, 15) == 1) {
                silmar.map.effects.Radiation.doRadiation(this.getMap(), this.getLocation());
            }
        }
    }

    public static class DeathFog
    extends Terrain {
        private int strength;
        private int startTurn;
        private FloatPoint driftDirection;

        public void setStrength(int strength) {
            this.strength = strength;
        }

        public void setDriftDirection(FloatPoint driftDirection) {
            this.driftDirection = driftDirection;
        }

        public boolean onBeingArrival(Being being) {
            this.onBeingHere(being);
            return false;
        }

        public void onBeingHere(Being being) {
            being.onInDeathFog(this.strength);
        }

        public void doAct() {
            Game game = Game.getCurrentGame();
            if (this.startTurn == 0) {
                this.startTurn = game.getTurn();
            }
            if (game.getTurn() - this.startTurn > 7 && Random.getInt(0, 3) == 0) {
                this.getMap().doRemoveEntity(this);
                return;
            }
            if (this.driftDirection != null && Random.getInt(0, 1) == 1) {
                int driftMagnitude = 4;
                MapPixelLocation driftTo = new MapPixelLocation(this.location);
                driftTo.x = (int)((float)driftTo.x + 4.0f * this.driftDirection.x);
                driftTo.y = (int)((float)driftTo.y + 4.0f * this.driftDirection.y);
                if (this.map.isRectanglePassible((MapPixelLocation)driftTo, (Dimension)this.getSize(), (MovementType)MovementType.flying, (boolean)false, null, null, (boolean)false).passible) {
                    this.map.doMoveEntity(this, driftTo);
                }
            }
        }

        public boolean getShouldDrawOnTop() {
            return true;
        }

        public boolean isHarmfulTo(Monster monster) {
            return monster.isAffectedByDeathFog();
        }
    }

    public static class VengefulSymbol
    extends Terrain {
        private int strength;

        public void setStrength(int strength) {
            this.strength = strength;
        }

        public boolean onBeingArrival(Being being) {
            if (being.isMonster() && ((Monster)being).onTouchedVengefulSymbol(this.strength)) {
                this.strength /= 2;
                if (this.strength == 0) {
                    this.getMap().doRemoveEntity(this);
                }
                return true;
            }
            return false;
        }
    }

    public static class Summoner
    extends Terrain {
        private transient EntityType summonType;
        private String summonTypeName;
        private MapPixelLocation summonLocation;
        private int summonQuantity;
        private int summonInterval;
        private StartCriterion startCriterion;
        private boolean started;
        private int numSummoned = 0;
        private DoneListener doneListener;

        public void setSummoningParameters(EntityType summonType, int summonQuantity, int summonInterval, StartCriterion startCriterion, DoneListener doneListener) {
            this.setSummoningParameters(summonType, null, summonQuantity, summonInterval, startCriterion, doneListener);
        }

        public void setSummoningParameters(EntityType summonType, MapPixelLocation summonLocation, int summonQuantity, int summonInterval, StartCriterion startCriterion, DoneListener doneListener) {
            this.summonTypeName = summonType.getName();
            this.summonLocation = summonLocation;
            this.summonQuantity = summonQuantity;
            this.summonInterval = summonInterval;
            this.startCriterion = startCriterion;
            this.doneListener = doneListener;
        }

        public void doAct() {
            if (!this.started) {
                List players = this.map.getPlayersInLOS(this.location, null);
                int numPlayers = players.size();
                for (int i = 0; i < numPlayers; ++i) {
                    Player player = (Player)players.get(i);
                    if (!this.startCriterion.getCanStart(this, player)) continue;
                    this.started = true;
                    break;
                }
            }
            Game game = Game.getCurrentGame();
            if (this.started && game.getTurn() % this.summonInterval == 0) {
                if (this.summonType == null) {
                    this.summonType = (EntityType)EntityType.typesMap.get(this.summonTypeName);
                }
                MapEntity entity = this.summonType.doCreateStockInstance();
                MapPixelLocation nearby = this.summonLocation != null ? this.map.getNearbyPassibleRectangleLocation(this.summonLocation, entity.getSize(), entity.getMovementType()) : this.map.getRandomPassibleRectangleLocationInLOSAndRange(this.location, entity.getSize(), new MapPixelDistance(10 * TileSize.tileSize.width), 50, MovementType.walkingNoHands, true);
                Teleport.doTeleport(this.map, nearby, true, false);
                this.map.doAddEntity(entity, nearby);
                Teleport.doTeleport(this.map, nearby, false, false);
                ++this.numSummoned;
                if (this.numSummoned >= this.summonQuantity) {
                    if (this.doneListener != null) {
                        this.doneListener.onDone(this);
                    }
                    this.map.doRemoveEntity(this);
                }
            }
        }

        public static interface DoneListener {
            public void onDone(Terrain var1);
        }

        public static interface StartCriterion
        extends Serializable {
            public boolean getCanStart(Terrain var1, Player var2);
        }
    }

    public static class EventMarker
    extends Terrain {
        private Event event;

        public void setEvent(Event event) {
            this.event = event;
        }

        public void onTriggered() {
            this.event.doOccur(this);
            this.getMap().doRemoveEntity(this);
        }

        public static interface Event
        extends Serializable {
            public void doOccur(EventMarker var1);
        }
    }

    public static class VacuumHole
    extends Terrain {
        public void doAct() {
            PowerDischarge.doDischarge(this);
            this.map.onSoundIssued(Sound.vacuumHole, this.location, true);
            List beings = this.map.getBeingsInLOS(this.location, null);
            int numBeings = beings.size();
            block0: for (int i = 0; i < numBeings; ++i) {
                Being being = (Being)beings.get(i);
                MapPixelDistance suckDistance = being.getVacuumHoleSuckDistance();
                MapPixelLocation beingLocation = new MapPixelLocation(being.getLocation());
                MapPixelDistance range = MapPixelLocationUtil.getDistance(beingLocation, this.location);
                float maxRange = 25 * TileSize.tileSize.width;
                suckDistance.distance = (int)((float)suckDistance.distance * Math.max(0.0f, (maxRange - (float)range.distance) / maxRange));
                suckDistance.distance = Math.min(suckDistance.distance, range.distance);
                if (suckDistance.distance <= 0 || beingLocation.equals(this.location)) continue;
                if (being.isPlayer()) {
                    Player player = (Player)being;
                    player.onMessage("A vacuum hole sucks you towards it!");
                }
                List locations = MapPixelLocationUtil.getLineLocations(beingLocation, this.location, 2, suckDistance, 0);
                int numLocations = locations.size();
                for (int j = 0; j < numLocations; ++j) {
                    MapPixelLocation spot = (MapPixelLocation)locations.get(j);
                    Dimension beingSize = being.getSize();
                    if (!this.map.isRectanglePassible((MapPixelLocation)spot, (Dimension)beingSize, (MovementType)MovementType.walking, (boolean)true, (MapEntity)being, null, (boolean)false).passible) continue block0;
                    this.map.doMoveEntity(being, spot);
                }
            }
        }
    }

    public static class MonsterActivator
    extends Terrain {
        public boolean onBeingArrival(Being being) {
            MonsterUtil.doActivateMonstersInRange(this.map, this.location, new MapTileDistance(50));
            this.map.doRemoveEntity(this);
            return false;
        }
    }

    public static class MoatLever
    extends Terrain {
        private boolean turnedOn = false;
        private List moat;

        public boolean onInteractionWithPlayer(Player player) {
            if (!this.turnedOn) {
                this.turnedOn = true;
                player.onMessage("Working this lever causes a moat to appear!");
                this.moat = Moat.doForm(this.map, TileSizeUtil.getTileLocation(this.location), new MapTileDistance(2));
            } else {
                this.turnedOn = false;
                Moat.remove(this.map, this.moat);
            }
            return true;
        }
    }

    public static class HolographicTrainer
    extends Terrain {
        private boolean functioned = false;

        public boolean onBeingArrival(Being being) {
            if (!being.isPlayer()) {
                return false;
            }
            Player player = (Player)being;
            if (!this.functioned) {
                if (Random.getInt(1, 3) == 1) {
                    player.onUsedHolographicTrainer();
                    this.functioned = true;
                } else {
                    player.onMessage("This holographic trainer overloads!");
                    Fireball.doFireball(this.map, null, this.location, 12);
                    this.map.doRemoveEntity(this);
                }
                return true;
            }
            player.onMessage("This holographic trainer is burnt out.");
            return false;
        }
    }

    public static class RobotCommandInterface
    extends Terrain {
        private boolean getCanPlayerUseThis(Player player) {
            return player.getIntelligence() >= 15;
        }

        public boolean onBeingArrival(Being being) {
            if (!being.isPlayer()) {
                return false;
            }
            Player player = (Player)being;
            if (this.getCanPlayerUseThis(player)) {
                player.onMessage("With your high intelligence, you are able understand this command interface just enough to temporarily shut down nearby robots!", Player.MessageType.important);
                this.onBeingHere(player);
            } else {
                player.onMessage("Whatever this device is, it seems beyond your limited understanding...", Player.MessageType.important);
            }
            return true;
        }

        public void onBeingHere(Being being) {
            if (!being.isPlayer()) {
                return;
            }
            Player player = (Player)being;
            if (this.getCanPlayerUseThis(player)) {
                List monsters = this.map.getMonstersInLOS(this.location, null);
                int numMonsters = monsters.size();
                for (int i = 0; i < numMonsters; ++i) {
                    Monster monster = (Monster)monsters.get(i);
                    monster.onAffectedByRobotCommandInterface();
                }
            }
        }
    }

    public static class LandMine
    extends Terrain {
        public boolean onBeingArrival(Being being) {
            Fireball.doFireball(this.map, null, this.location, 7);
            this.map.doRemoveEntity(this);
            return true;
        }
    }

    public static class Fire
    extends Terrain
    implements LightSource {
        private static final MapPixelDistance lightRadius = new MapPixelDistance(new MapTileDistance(7));

        public boolean onBeingArrival(Being being) {
            being.onInFire();
            return false;
        }

        public void onBeingHere(Being being) {
            this.onBeingArrival(being);
        }

        public MapPixelDistance getLightRadius() {
            return lightRadius;
        }

        public boolean isEmittingLight() {
            return true;
        }

        public boolean isHarmfulTo(Monster monster) {
            return monster.isAffectedByFire();
        }

        public boolean isLightSource() {
            return true;
        }
    }

    public static class VendingMachine
    extends Terrain
    implements ItemSeller {
        private static final ItemType[] fireArmItemTypesForSale = new ItemType[]{ItemType.pistolBullet, ItemType.shotgunShell, ItemType.assaultRifleBullet, ItemType.landMine};
        private static final ItemType[] laserItemTypesForSale = new ItemType[]{ItemType.laserPistolCell, ItemType.laserAssaultRifleCell};

        public String getGreeting() {
            return "This machine lights up, and then speaks: \"Please use correct change when purchasing items.  Thank you.\"";
        }

        public void onGreetingHeardByPlayer(Player player) {
        }

        public void onTalkedTo() {
            if (Random.getInt(1, 10) <= 7) {
                this.map.doRemoveEntity(this);
                this.map.doAddEntity((MapEntity)TerrainFactory.doCreateTerrain(TerrainType.brokenVendingMachine), this.location);
            }
        }

        public Item[] getItemsForSale() {
            return ItemSellerUtil.doCreateItemsForSaleFromTypes(this.getMap().getLevel().getIndex() < MapLevel.moon.getIndex() ? fireArmItemTypesForSale : laserItemTypesForSale);
        }

        public int getAdjustedItemPrice(Item item, int normalPrice) {
            return normalPrice;
        }
    }

    public static class BrokenVendingMachine
    extends Terrain
    implements Talker {
        public String getGreeting() {
            return "This machine appears to be broken.";
        }

        public void onGreetingHeardByPlayer(Player player) {
        }

        public void onTalkedTo() {
        }
    }

    public static class Mine
    extends Terrain {
        private static final ItemType[] gemstoneTypes = new ItemType[]{ItemType.emerald, ItemType.sapphire, ItemType.ruby, ItemType.diamond, ItemType.jacinthGemstone, ItemType.largeEmerald, ItemType.largeSapphire, ItemType.largeRuby, ItemType.largeDiamond, ItemType.largeJacinthGemstone};
        private boolean visited = false;

        public void onPlayerEnters(Player player) {
            if (this.visited) {
                player.onMessage("This mine is empty.");
                return;
            }
            this.visited = true;
            int random = Random.getInt(1, 10);
            if (random <= 4) {
                player.onMessage("This mine is empty.");
            } else if (random <= 7) {
                player.onMessage("You find a precious gemstone!", Player.MessageType.important);
                Item item = ItemFactory.doCreateItem(gemstoneTypes[Random.getInt(0, gemstoneTypes.length - 1)]);
                MapPixelLocation nearby = this.map.getNearbyPassibleRectangleLocation(this.location, item.getSize(), MovementType.walkingNoHands);
                this.map.doAddEntity((MapEntity)item, nearby);
            } else {
                player.onMessage("This mine is the lair of a powerful creature!", Player.MessageType.important);
                MonsterType type = Random.getBoolean() ? MonsterType.giantWorm : MonsterType.acidDragon;
                Monster monster = MonsterFactory.doCreateMonster(type);
                MapPixelLocation nearby = this.map.getNearbyPassibleRectangleLocation(this.location, monster.getSize(), monster.getMovementType());
                this.map.doAddEntity((MapEntity)monster, nearby);
            }
        }
    }

    public static class MirroredBall
    extends Terrain {
        private boolean visited = false;

        public boolean onInteractionWithPlayer(Player player) {
            if (this.visited) {
                player.onMessage("You see nothing but your own reflection in this mirrored ball.", Player.MessageType.important);
                return false;
            }
            PowerDischarge.doDischarge(this);
            this.visited = true;
            player.onLookedIntoMirroredBall();
            return true;
        }
    }

    public static class Sphinx
    extends Terrain {
        private boolean visited = false;

        public boolean onBeingArrival(Being being) {
            if (!being.isPlayer()) {
                return false;
            }
            Player player = (Player)being;
            if (this.visited) {
                player.onMessage("This sphinx is silent.");
                return false;
            }
            this.visited = true;
            PowerDischarge.doDischarge(this);
            if (player.getJudgement() > 10) {
                List items = this.map.getItems();
                if (items.isEmpty()) {
                    player.onMessage("This sphinx is silent.");
                    return false;
                }
                Item mostValuable = null;
                int numItems = items.size();
                for (int i = 0; i < numItems; ++i) {
                    Item item = (Item)items.get(i);
                    if (mostValuable != null && item.getValue(ItemValueContext.sell) <= mostValuable.getValue(ItemValueContext.sell)) continue;
                    mostValuable = item;
                }
                player.onMessage("The sphinx bellows, \"You have shown good judgement.  Reap thy reward!\"", Player.MessageType.important);
                Teleport.doTeleport(this.map, player.getLocation(), true, false);
                MapPixelLocation nearby = this.map.getNearbyPassibleRectangleLocation(mostValuable.getLocation(), player.getSize(), player.getMovementType());
                this.map.doMoveEntity(player, nearby);
                Teleport.doTeleport(this.map, nearby, false, false);
                return true;
            }
            List monsters = this.map.getMonsters();
            if (monsters.isEmpty()) {
                player.onMessage("This sphinx is silent.");
                return false;
            }
            Monster mostPowerful = null;
            int numMonsters = monsters.size();
            for (int i = 0; i < numMonsters; ++i) {
                Monster monster = (Monster)monsters.get(i);
                if (mostPowerful != null && !monster.isMorePowerfulThan(mostPowerful)) continue;
                mostPowerful = monster;
            }
            player.onMessage("The sphinx bellows, \"I have found you lacking in judgement.  Face thy enemy!\"", Player.MessageType.important);
            Teleport.doTeleport(this.map, player.getLocation(), true, false);
            MapPixelLocation nearby = this.map.getNearbyPassibleRectangleLocation(mostPowerful.getLocation(), player.getSize(), player.getMovementType());
            this.map.doMoveEntity(player, nearby);
            Teleport.doTeleport(this.map, nearby, false, false);
            return true;
        }
    }

    public static class Library
    extends Terrain {
        private boolean visited = false;

        public boolean onBeingArrival(Being being) {
            if (!being.isPlayer()) {
                return false;
            }
            Player player = (Player)being;
            if (this.visited) {
                player.onMessage("There's a lot of valuable knowledge in these books, but who has time to read them?", Player.MessageType.important);
                return false;
            }
            PowerDischarge.doDischarge(this);
            this.visited = true;
            player.onReadFromLibrary();
            return true;
        }
    }

    public static class Garden
    extends Terrain {
        private static final ItemType[] itemTypes = new ItemType[]{ItemType.potionOfStrength, ItemType.potionOfIntelligence, ItemType.potionOfJudgement, ItemType.potionOfAgility, ItemType.potionOfEndurance, ItemType.pearl, ItemType.aquamarineGemstone, ItemType.peridotGemstone, ItemType.opalGemstone};
        private boolean visited = false;

        public boolean onBeingArrival(Being being) {
            if (!being.isPlayer() || this.visited) {
                return false;
            }
            Player player = (Player)being;
            this.visited = true;
            int random = Random.getInt(1, 5);
            if (random <= 3) {
                Item item = ItemFactory.doCreateItem(ItemType.ration);
                MapPixelLocation nearby = this.map.getNearbyPassibleRectangleLocation(this.location, item.getSize(), MovementType.walkingNoHands);
                this.map.doAddEntity((MapEntity)item, nearby);
                player.onMessage("You glean some food from this garden!", Player.MessageType.important);
            } else if (random == 4) {
                Item item = ItemFactory.doCreateItem(itemTypes[Random.getInt(0, itemTypes.length - 1)]);
                MapPixelLocation nearby = this.map.getNearbyPassibleRectangleLocation(this.location, item.getSize(), MovementType.walkingNoHands);
                this.map.doAddEntity((MapEntity)item, nearby);
                player.onMessage("You find an item buried in this garden!", Player.MessageType.important);
            } else {
                Monster monster = MonsterFactory.doCreateMonster(MonsterType.scumShamble);
                MapPixelLocation nearby = this.map.getNearbyPassibleRectangleLocation(this.location, monster.getSize(), monster.getMovementType());
                this.map.doAddEntity((MapEntity)monster, nearby);
                player.onMessage("Hidden within this garden is a scum shamble!", Player.MessageType.important);
            }
            return true;
        }
    }

    public static class Statue
    extends Terrain {
        private boolean used = false;

        public void onGoldInserted(int gold) {
            this.used = true;
            Item item = null;
            while (item == null) {
                ItemType type = ItemType.getRandomType();
                if (type.getPlacementValue() > 50 * gold) continue;
                item = ItemFactory.doCreateItem(type);
            }
            MapPixelLocation location = this.map.getNearbyPassibleRectangleLocation(this.getLocation(), item.getSize(), MovementType.walkingNoHands);
            PowerDischarge.doDischarge(this.map, this.getLocation());
            this.map.doAddEntity((MapEntity)item, location);
        }

        public boolean isUsed() {
            return this.used;
        }
    }

    public static class Fountain
    extends Terrain {
        private List drinkers = new ArrayList();
        private boolean beneficial;
        private boolean beneficialDetermined = false;

        public void onPlayerDrinks(Player player) {
            if (this.drinkers.contains(player)) {
                player.onMessage("Nothing happens.");
                return;
            }
            this.drinkers.add(player);
            if (!this.beneficialDetermined) {
                this.beneficial = Random.getBoolean();
                this.beneficialDetermined = true;
            }
            PowerDischarge.doDischarge(this);
            if (this.beneficial) {
                player.onBeneficialDrinkFromFountain();
            } else {
                player.onDetrimentalDrinkFromFountain();
            }
        }
    }

    public static class RepairMachine
    extends Terrain
    implements ItemFixer {
        public String getGreeting() {
            return "This machine whirs to life: \"What may I fix for you?\"";
        }

        public int getAdjustedItemPrice(Item item, int normalPrice) {
            return normalPrice;
        }

        public boolean getCanFixItem(Item item) {
            return item.getType().isTech() && !item.getType().isGroupable();
        }

        public void onTalkedTo() {
        }

        public void onGreetingHeardByPlayer(Player player) {
        }
    }

    public static class Web
    extends Terrain {
        private Being spinner;
        private int turnBeingFirstStuck = 0;

        public boolean onBeingArrival(Being being) {
            if (being.equals(this.spinner)) {
                return false;
            }
            if (being.getMovementType().equals(MovementType.ethereal)) {
                return false;
            }
            this.getMap().onSoundIssued(Sound.inWeb, this.getLocation());
            being.onStuckInWeb(this, 0);
            return true;
        }

        public void onBeingHere(Being being) {
            if (being.equals(this.spinner)) {
                return;
            }
            if (being.getMovementType().equals(MovementType.ethereal)) {
                return;
            }
            Game game = Game.getCurrentGame();
            if (this.turnBeingFirstStuck == 0) {
                this.turnBeingFirstStuck = game.getTurn();
            }
            int turnsStuck = game.getTurn() - this.turnBeingFirstStuck;
            being.onStuckInWeb(this, turnsStuck);
        }

        public void setSpinner(Being spinner) {
            this.spinner = spinner;
        }

        public boolean isHarmfulTo(Monster monster) {
            return !monster.getMovementType().equals(MovementType.ethereal);
        }
    }

    public static class TrollCarcass
    extends Terrain {
        private Monster troll;
        private int turnCreated = 0;
        private int duration;

        public void setTroll(Monster troll) {
            this.troll = troll;
            this.duration = (1 - troll.getHitPoints()) / 3 + 1;
        }

        public void doAct() {
            Game game = Game.getCurrentGame();
            if (this.turnCreated == 0) {
                this.turnCreated = game.getTurn();
            }
            if (game.getTurn() - this.turnCreated > this.duration && this.troll.onBroughtBackToLife(this.map, this.location)) {
                this.map.doRemoveEntity(this);
            }
        }
    }
}

