/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.terrains;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.entities.beings.MovementType;
import silmar.entities.beings.monsters.Monster;
import silmar.entities.beings.player.Player;
import silmar.entities.terrains.TerrainType;
import silmar.events.Listener;
import silmar.events.Reporter;
import silmar.map.effects.Poof;
import silmar.util.Random;

public class Terrain
extends MapEntity
implements Serializable {
    private transient TerrainType type;
    private String typeName;
    private final Rectangle impassibleBounds = new Rectangle();
    private final Reporter reporter = new Reporter();

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.typeName = this.type.getName();
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.type = (TerrainType)TerrainType.typesMap.get(this.typeName);
    }

    public void doAddListener(Listener listener) {
        this.reporter.doAddListener(listener);
    }

    public void onBeingHere(Being being) {
    }

    public boolean onBeingArrival(Being being) {
        return false;
    }

    public String getImageName() {
        return this.type.getImageName() != null ? "terrain/" + this.type.getImageName() : null;
    }

    public void onCreated(TerrainType type) {
        this.type = type;
    }

    public final boolean isOfType(TerrainType type) {
        return type.equals(this.type);
    }

    public boolean isPassible(MovementType movementType) {
        return this.type.isPassible() || movementType.equals(MovementType.earthing) || movementType.equals(MovementType.ethereal);
    }

    public Dimension getSize() {
        return this.type.getSize();
    }

    public final TerrainType getType() {
        return this.type;
    }

    public boolean onInteractionWithPlayer(Player player) {
        return false;
    }

    protected void onBoundsChanged() {
        Rectangle bounds = this.getBounds();
        this.impassibleBounds.setRect(bounds);
        Dimension size = bounds.getSize();
        this.impassibleBounds.translate(size.width / 4, size.height / 4);
        this.impassibleBounds.width /= 2;
        this.impassibleBounds.height /= 2;
    }

    public final Rectangle getImpassibleBounds() {
        return this.impassibleBounds;
    }

    public void onHitByFireball(int strength) {
        AvoidsResult result = this.getAvoids(-strength * 2);
        if (!result.success) {
            this.onDestroyed(result.failedBy);
            Poof.doPoof(this.map, this.location, this.getSize());
            this.map.doRemoveEntity(this);
        }
    }

    protected void onDestroyed(int avoidanceFailedBy) {
    }

    private AvoidsResult getAvoids(int modifier) {
        int roll = Random.getInt(1, 20);
        AvoidsResult result = new AvoidsResult();
        result.failedBy = -roll + (this.type.getAvoidance() - modifier);
        result.success = result.failedBy <= 0;
        return result;
    }

    public final boolean isTerrain() {
        return true;
    }

    public boolean isHarmfulTo(Monster monster) {
        return false;
    }

    public boolean isVisible() {
        return this.type.getImageName() != null;
    }

    private class AvoidsResult {
        boolean success;
        int failedBy;

        private AvoidsResult() {
        }
    }
}

