/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.items.weapons;

import silmar.entities.beings.Being;
import silmar.entities.beings.BeingUtil;
import silmar.entities.items.weapons.Weapon;
import silmar.util.Random;

public class Weapons {

    protected static class MaceOfPurity
    extends Weapon {
        protected MaceOfPurity() {
        }

        public void onHitVictim(Being victim, Being wielder, int damage) {
            victim.onHitByMaceOfPurity();
        }
    }

    protected static class StaffOfHarming
    extends Weapon {
        protected StaffOfHarming() {
        }

        public void onHitVictim(Being victim, Being wielder, int damage) {
            victim.onHitByStaffOfHarming();
            if (Random.getInt(1, 10) == 1) {
                this.doDegrade();
            }
        }
    }

    protected static class StunWhip
    extends Weapon {
        protected StunWhip() {
        }

        public void onHitVictim(Being victim, Being wielder, int damage) {
            victim.onHitByStunWhip();
            if (Random.getInt(1, 10) == 1) {
                this.doDegrade();
            }
        }
    }

    protected static class EnergySaber
    extends Weapon {
        protected EnergySaber() {
        }

        public void onHitVictim(Being victim, Being wielder, int damage) {
            if (Random.getInt(1, 10) == 1) {
                this.doDegrade();
            }
        }
    }

    protected static class ClubOfImpact
    extends Weapon {
        protected ClubOfImpact() {
        }

        public void onHitVictim(Being victim, Being wielder, int damage) {
            if (victim.isDead()) {
                return;
            }
            BeingUtil.doKnockBeingBack(victim, wielder.getLocation(), damage, wielder.getDamageModifierForStrength());
        }
    }
}

