/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.items.types;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import silmar.entities.MapEntity;
import silmar.entities.beings.player.PlayerAttribute;
import silmar.entities.items.EquipLocation;
import silmar.entities.items.Item;
import silmar.entities.items.ItemFactory;
import silmar.entities.types.EntityType;
import silmar.map.Map;
import silmar.map.MapLevel;
import silmar.map.MapPixelLocation;
import silmar.tiles.Tile;
import silmar.util.ListUtil;
import silmar.util.MathUtil;

public class ItemType
extends EntityType {
    protected boolean hallwayOk = false;
    protected String unidentifiedName;
    protected String pluralName;
    protected float encumbrance = 0.0f;
    protected boolean groupable = false;
    protected boolean mustEquip = true;
    protected EquipLocation equipLocation;
    protected boolean takesTwoHands = false;
    protected ItemType ancestorType;
    protected float chanceOfInChest = 0.0f;
    protected int avoidance;
    protected int[] defenseModifiers = noDefenseModifiers;
    protected int avoidanceModifier;
    protected boolean metal = false;
    protected boolean noisy = false;
    protected int quantityToCreate = 1;
    protected int strengthRequired;
    protected int[] attributeModifiers = noAttributeModifiers;
    protected boolean cursed = false;
    protected boolean magical = false;
    protected boolean tech = false;
    protected String info;
    protected boolean armor;
    protected boolean shield;
    protected int placementValue;
    protected boolean individuallyIdentified = false;
    public static final List types = new ArrayList();
    public static final HashMap typesByName = new HashMap();
    public static final List ammoTypes = new ArrayList();
    public static final List armorTypes = new ArrayList();
    public static final List shieldTypes = new ArrayList();
    public static final List nongroupableTypes = new ArrayList();
    public static final List treasureTypes = new ArrayList();
    private static final int[] noDefenseModifiers = new int[]{0, 0, 0};
    private static final int[] noAttributeModifiers = new int[]{0, 0, 0, 0, 0};
    protected static final String degradesInfo = "May degrade with each use.";
    private static final String futureAmmoName = "strange ammo";
    private static final String futureArmorName = "strange armor";
    private static final String futureShieldName = "strange shield";
    public static ItemType ration = ItemType.doCreateGroupableType(10, true, "ration", null, null, "ration", 1.0f, 0.0f, 10, 1, false, false, 15);
    public static ItemType gold = ItemType.doCreateGroupableType(10, false, "gold", "gold", null, "gold", 0.05f, 0.5f, 0, 1, false, false, 10);
    public static ItemType slingStone = ItemType.doCreateGroupableType(10, true, "sling stone", null, null, "slingStones", 0.3f, 0.0f, 10, 0, false, true, 1);
    public static ItemType pistolBullet = ItemType.doCreateGroupableType(5, true, "pistol bullet", null, "strange ammo", "pistolBullet", 0.1f, 0.7f, 10, 5, true, true, 8);
    public static ItemType arrow = ItemType.doCreateGroupableType(10, true, "arrow", null, null, "arrow", 0.5f, 0.0f, 10, 1, false, true, 15);
    public static ItemType quarrel = ItemType.doCreateGroupableType(10, true, "quarrel", null, null, "quarrel", 1.0f, 0.0f, 10, 1, false, true, 12);
    public static ItemType shotgunShell = ItemType.doCreateGroupableType(3, true, "shotgun shell", null, "strange ammo", "shotgunShell", 0.3f, 0.7f, 10, 10, true, true, 10);
    public static ItemType assaultRifleBullet = ItemType.doCreateGroupableType(3, true, "assault rifle bullet", null, "strange ammo", "assaultRifleBullet", 0.2f, 0.7f, 10, 10, true, true, 8);
    public static ItemType laserPistolCell = ItemType.doCreateGroupableType(1, true, "laser pistol cell", null, "strange ammo", "laserPistolCell", 0.1f, 0.7f, 10, 15, true, true, 8);
    public static ItemType laserAssaultRifleCell = ItemType.doCreateGroupableType(1, true, "laser assault rifle cell", null, "strange ammo", "laserAssaultRifleCell", 0.2f, 0.07f, 10, 20, true, true, 8);
    public static ItemType clothArmor = ItemType.doCreateArmorType("cloth armor", null, null, 0.0f, 0, 0, 0, 0, 0, false, false, 0, 0, false, false);
    public static ItemType leatherArmor = ItemType.doCreateArmorType("leather armor", null, "leatherArmor", 15.0f, 9, 2, 0, 0, 0, false, false, 6, 20, false, false);
    public static ItemType leatherArmorM3 = ItemType.doCreateMagicalArmorType(leatherArmor, -3);
    public static ItemType leatherArmorM2 = ItemType.doCreateMagicalArmorType(leatherArmor, -2);
    public static ItemType leatherArmorM1 = ItemType.doCreateMagicalArmorType(leatherArmor, -1);
    public static ItemType leatherArmorP1 = ItemType.doCreateMagicalArmorType(leatherArmor, 1);
    public static ItemType leatherArmorP2 = ItemType.doCreateMagicalArmorType(leatherArmor, 2);
    public static ItemType leatherArmorP3 = ItemType.doCreateMagicalArmorType(leatherArmor, 3);
    public static ItemType chainMail = ItemType.doCreateArmorType("chain mail", null, "chainMail", 30.0f, 7, 5, 1, 1, 0, true, true, 10, 200, false, false);
    public static ItemType chainMailM5 = ItemType.doCreateMagicalArmorType(chainMail, -5);
    public static ItemType chainMailM4 = ItemType.doCreateMagicalArmorType(chainMail, -4);
    public static ItemType chainMailM3 = ItemType.doCreateMagicalArmorType(chainMail, -3);
    public static ItemType chainMailM2 = ItemType.doCreateMagicalArmorType(chainMail, -2);
    public static ItemType chainMailM1 = ItemType.doCreateMagicalArmorType(chainMail, -1);
    public static ItemType chainMailP1 = ItemType.doCreateMagicalArmorType(chainMail, 1);
    public static ItemType chainMailP2 = ItemType.doCreateMagicalArmorType(chainMail, 2);
    public static ItemType chainMailP3 = ItemType.doCreateMagicalArmorType(chainMail, 3);
    public static ItemType chainMailP4 = ItemType.doCreateMagicalArmorType(chainMail, 4);
    public static ItemType chainMailP5 = ItemType.doCreateMagicalArmorType(chainMail, 5);
    public static ItemType plateMail = ItemType.doCreateArmorType("plate mail", null, "plateMail", 45.0f, 6, 7, 1, 1, 0, true, true, 13, 1000, false, false);
    public static ItemType plateMailM5 = ItemType.doCreateMagicalArmorType(plateMail, -5);
    public static ItemType plateMailM4 = ItemType.doCreateMagicalArmorType(plateMail, -4);
    public static ItemType plateMailM3 = ItemType.doCreateMagicalArmorType(plateMail, -3);
    public static ItemType plateMailM2 = ItemType.doCreateMagicalArmorType(plateMail, -2);
    public static ItemType plateMailM1 = ItemType.doCreateMagicalArmorType(plateMail, -1);
    public static ItemType plateMailP1 = ItemType.doCreateMagicalArmorType(plateMail, 1);
    public static ItemType plateMailP2 = ItemType.doCreateMagicalArmorType(plateMail, 2);
    public static ItemType plateMailP3 = ItemType.doCreateMagicalArmorType(plateMail, 3);
    public static ItemType plateMailP4 = ItemType.doCreateMagicalArmorType(plateMail, 4);
    public static ItemType plateMailP5 = ItemType.doCreateMagicalArmorType(plateMail, 5);
    public static ItemType plasticArmor = ItemType.doCreateArmorType("plastic armor", "strange armor", "plasticArmor", 20.0f, 6, 7, 1, 1, 1, false, true, 7, 3000, true, false);
    public static ItemType kevlarArmor = ItemType.doCreateArmorType("kevlar armor", "strange armor", "kevlarArmor", 20.0f, 7, 5, 5, 1, 1, false, false, 7, 3500, true, false);
    public static ItemType heavyKevlarArmor = ItemType.doCreateArmorType("heavy kevlar armor", "strange armor", "heavyKevlarArmor", 35.0f, 6, 7, 7, 1, 2, false, false, 11, 5000, true, false);
    public static ItemType reflecArmor = ItemType.doCreateArmorType("reflec armor", "strange armor", "reflecArmor", 25.0f, 6, 6, 6, 6, 2, false, false, 8, 7500, true, false);
    public static ItemType heavyReflecArmor = ItemType.doCreateArmorType("heavy reflec armor", "strange armor", "heavyReflecArmor", 40.0f, 5, 9, 9, 9, 3, false, false, 12, 15000, true, false);
    public static ItemType poweredReflecArmor = ItemType.doCreateArmorType("powered reflec armor", "strange armor", "poweredReflecArmor", 20.0f, 4, 11, 11, 11, 4, true, true, 7, 26000, true, false);
    public static ItemType smallShield;
    public static ItemType smallShieldM3;
    public static ItemType smallShieldM2;
    public static ItemType smallShieldM1;
    public static ItemType smallShieldP1;
    public static ItemType smallShieldP2;
    public static ItemType smallShieldP3;
    public static ItemType largeShield;
    public static ItemType largeShieldM3;
    public static ItemType largeShieldM2;
    public static ItemType largeShieldM1;
    public static ItemType largeShieldP1;
    public static ItemType largeShieldP2;
    public static ItemType largeShieldP3;
    public static ItemType greatShield;
    public static ItemType greatShieldM3;
    public static ItemType greatShieldM2;
    public static ItemType greatShieldM1;
    public static ItemType greatShieldP1;
    public static ItemType greatShieldP2;
    public static ItemType greatShieldP3;
    public static ItemType kevlarShield;
    public static ItemType largeKevlarShield;
    public static ItemType riotShield;
    public static ItemType reflecShield;
    public static ItemType largeReflecShield;
    public static ItemType torch;
    public static ItemType bootsOfQuickness;
    public static ItemType bootsOfLethargy;
    public static ItemType capeOfGoodLuck;
    public static ItemType capeOfDisplacement;
    public static ItemType leadLinedCloak;
    public static ItemType blessedFigurine;
    public static ItemType cursedFigurine;
    public static ItemType helmOfCombatMastery;
    public static ItemType skullcapOfReasoning;
    public static ItemType necklaceOfOgreStrength;
    public static ItemType necklaceOfEssence;
    public static ItemType necklaceOfGoodLuck;
    public static ItemType necklaceOfChoking;
    public static ItemType landMine;
    public static ItemType phylacteryOfResurrection;
    public static ItemType potionOfHealing;
    public static ItemType potionOfPoison;
    public static ItemType potionOfStrength;
    public static ItemType potionOfIntelligence;
    public static ItemType potionOfJudgement;
    public static ItemType potionOfAgility;
    public static ItemType potionOfEndurance;
    public static ItemType ringOfPowerStorage;
    public static ItemType ringOfStrength;
    public static ItemType ringOfStrengthSapping;
    public static ItemType robeOfMagicalEnergy;
    public static ItemType turquoiseGemstone;
    public static ItemType obsidianGemstone;
    public static ItemType carnelianGemstone;
    public static ItemType sardonyxGemstone;
    public static ItemType amberGemstone;
    public static ItemType jadeGemstone;
    public static ItemType pearl;
    public static ItemType aquamarineGemstone;
    public static ItemType peridotGemstone;
    public static ItemType opalGemstone;
    public static ItemType sapphire;
    public static ItemType ruby;
    public static ItemType emerald;
    public static ItemType jacinthGemstone;
    public static ItemType diamond;
    public static ItemType largeSapphire;
    public static ItemType largeRuby;
    public static ItemType largeEmerald;
    public static ItemType largeJacinthGemstone;
    public static ItemType largeDiamond;
    public static ItemType silverBar;
    public static ItemType goldBar;
    public static ItemType platinumBar;
    public static ItemType ivoryNecklace;
    public static ItemType silverNecklace;
    public static ItemType goldNecklace;
    public static ItemType coralNecklace;
    public static ItemType jadeNecklace;
    public static ItemType platinumNecklace;
    public static ItemType silverNecklaceWithGems;
    public static ItemType goldNecklaceWithGems;
    public static ItemType platinumNecklaceWithGems;
    public static ItemType silverMedallion;
    public static ItemType goldMedallion;
    public static ItemType platinumMedallion;
    public static ItemType silverChalice;
    public static ItemType goldChalice;
    public static ItemType platinumChalice;
    public static ItemType silverChaliceWithGems;
    public static ItemType goldChaliceWithGems;
    public static ItemType platinumChaliceWithGems;
    public static ItemType silverSceptre;
    public static ItemType goldSceptre;
    public static ItemType platinumSceptre;
    public static ItemType silverSceptreWithGems;
    public static ItemType goldSceptreWithGems;
    public static ItemType platinumSceptreWithGems;
    public static ItemType silverCrown;
    public static ItemType goldCrown;
    public static ItemType platinumCrown;
    public static ItemType silverCrownWithGems;
    public static ItemType goldCrownWithGems;
    public static ItemType platinumCrownWithGems;

    public ItemType(String name, String imageName) {
        super(name, imageName);
        this.doDetmSize();
        types.add(this);
        typesByName.put(name, this);
    }

    public static ItemType getRandomType() {
        return (ItemType)ListUtil.getRandomElement(types);
    }

    public static final ItemType getType(String name) {
        return (ItemType)typesByName.get(name);
    }

    public boolean equals(ItemType type) {
        return type == this || type.name.equals(this.name);
    }

    protected ItemType doMakeClone(String name) {
        ItemType clone;
        try {
            clone = (ItemType)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        clone.name = name;
        clone.defenseModifiers = (int[])this.defenseModifiers.clone();
        types.add(clone);
        typesByName.put(name, clone);
        return clone;
    }

    protected static ItemType doCreateGroupableType(int frequency, boolean hallwayOk, String name, String pluralName, String unidentifiedName, String imageName, float encumbrance, float chanceOfInChest, int quantityToCreate, int placementValue, boolean tech, boolean isAmmo, int avoidance) {
        ItemType type = new ItemType(name, imageName);
        if (pluralName == null) {
            pluralName = name + "s";
        }
        type.frequency = frequency;
        type.hallwayOk = hallwayOk;
        type.pluralName = pluralName;
        type.unidentifiedName = unidentifiedName;
        type.imageName = imageName;
        type.encumbrance = encumbrance;
        type.chanceOfInChest = chanceOfInChest;
        type.quantityToCreate = quantityToCreate;
        type.placementValue = placementValue;
        type.tech = tech;
        type.avoidance = avoidance;
        type.groupable = true;
        type.mustEquip = false;
        type.armor = false;
        if (isAmmo) {
            ammoTypes.add(type);
        }
        return type;
    }

    protected static int getFrequencyForValue(int value) {
        int frequency = (int)(10.0f - 4.0f * Math.max(0.0f, MathUtil.log10(value) - 2.0f));
        return Math.max(1, frequency);
    }

    protected static float getChanceOfInChest(int value) {
        return Math.min(1.0f, 0.1f + 0.2f * MathUtil.log10(value));
    }

    protected static ItemType doCreateArmorType(String name, String unidentifiedName, String imageName, float encumbrance, int avoidance, int defenseBonusNormal, int defenseBonusFirearm, int defenseBonusLaser, int avoidanceModifier, boolean metal, boolean noisy, int strengthRequired, int placementValue, boolean tech, boolean isShield) {
        ItemType type = new ItemType(name, imageName);
        type.armor = true;
        type.unidentifiedName = unidentifiedName;
        type.imageName = imageName;
        type.encumbrance = encumbrance;
        type.avoidance = avoidance;
        type.defenseModifiers = new int[]{defenseBonusNormal, defenseBonusFirearm, defenseBonusLaser};
        type.avoidanceModifier = avoidanceModifier;
        type.metal = metal;
        type.noisy = noisy;
        type.strengthRequired = strengthRequired;
        type.placementValue = placementValue;
        type.tech = tech;
        type.frequency = ItemType.getFrequencyForValue(placementValue);
        type.chanceOfInChest = ItemType.getChanceOfInChest(placementValue);
        type.shield = isShield;
        if (isShield) {
            type.armor = false;
            shieldTypes.add(type);
            type.equipLocation = EquipLocation.rightHand;
        } else {
            armorTypes.add(type);
            type.equipLocation = EquipLocation.body;
        }
        return type;
    }

    protected static ItemType doCreateMagicalArmorType(ItemType normalType, int plus) {
        ItemType type = ItemType.doCreateMagicalItemType(normalType, plus);
        type.avoidanceModifier += plus;
        type.cursed = plus < 0;
        int i = 0;
        while (i < type.defenseModifiers.length) {
            int n = i++;
            type.defenseModifiers[n] = type.defenseModifiers[n] + plus;
        }
        if (armorTypes.contains(normalType)) {
            armorTypes.add(type);
        } else {
            shieldTypes.add(type);
        }
        return type;
    }

    protected static ItemType doCreateMagicalItemType(ItemType normalType, int plus, String name, int addedValue) {
        ItemType type = ItemType.doCreateMagicalItemType(normalType, plus);
        type.name = name;
        type.placementValue += addedValue;
        return type;
    }

    protected static ItemType doCreateMagicalItemType(ItemType normalType, int plus) {
        ItemType type = normalType.doMakeClone(ItemType.doAlterNameForPlus(normalType.name, plus));
        type.individuallyIdentified = true;
        ItemType.doModifyTypeForPlus(type, normalType, plus);
        return type;
    }

    protected static String doAlterNameForPlus(String name, int plus) {
        return name + " " + (plus >= 0 ? "+" : "") + plus;
    }

    protected static void doModifyTypeForPlus(ItemType type, ItemType normalType, int plus) {
        type.pluralName = type.pluralName + " " + (plus >= 0 ? "+" : "") + plus;
        type.ancestorType = normalType;
        type.chanceOfInChest = 1.0f - (1.0f - type.chanceOfInChest) / (float)Math.pow(2.0, Math.max(0, plus));
        type.cursed = plus < 0;
        type.placementValue = (int)Math.rint((float)Math.max(0, type.placementValue + Math.abs(plus) * (int)(1000.0f + MathUtil.log10(type.placementValue) * 1000.0f)) / 1000.0f) * 1000;
        type.frequency = Math.round((float)ItemType.getFrequencyForValue(type.placementValue) * (type.cursed ? 0.5f : 1.0f));
        type.magical = true;
        type.avoidance -= plus;
        type.encumbrance *= 1.0f - (float)Math.abs(plus) * 0.1f;
        type.strengthRequired -= Math.max(0, Math.abs(plus));
        String quality = null;
        int absPlus = Math.abs(plus);
        if (absPlus >= 5) {
            quality = "magnificent";
        } else if (absPlus >= 3) {
            quality = "remarkable";
        } else if (absPlus >= 1) {
            quality = "fine";
        }
        type.unidentifiedName = (quality != null ? quality + " " : "") + normalType.name;
    }

    public static ItemType doCreateNonGroupableItemType(String name, String unidentifiedName, String imageName, float encumbrance, boolean mustEquip, EquipLocation equipLocation, int avoidance, boolean metal, int placementValue, boolean cursed, String info) {
        ItemType type = new ItemType(name, imageName);
        type.unidentifiedName = unidentifiedName;
        type.imageName = imageName;
        type.encumbrance = encumbrance;
        type.mustEquip = mustEquip;
        type.equipLocation = equipLocation;
        type.avoidance = avoidance;
        type.metal = metal;
        type.placementValue = placementValue;
        type.cursed = cursed;
        type.info = info;
        type.frequency = placementValue > 10 ? ItemType.getFrequencyForValue(placementValue) : 0;
        type.chanceOfInChest = ItemType.getChanceOfInChest(placementValue);
        type.magical = true;
        type.individuallyIdentified = true;
        nongroupableTypes.add(type);
        return type;
    }

    public static ItemType doCreateTreasureType(String name, String imageName, float encumbrance, int placementValue) {
        ItemType type = new ItemType(name, imageName);
        type.imageName = imageName;
        type.encumbrance = encumbrance;
        type.placementValue = placementValue;
        type.avoidance = 15;
        type.frequency = ItemType.getFrequencyForValue(placementValue);
        type.chanceOfInChest = ItemType.getChanceOfInChest(placementValue);
        type.mustEquip = false;
        treasureTypes.add(type);
        return type;
    }

    public boolean isDescendedFromType(ItemType other) {
        ItemType ancestor = this;
        while (ancestor != null) {
            if (ancestor.equals(other)) {
                return true;
            }
            ancestor = ancestor.ancestorType;
        }
        return false;
    }

    public int getAttributeRequirement(PlayerAttribute attribute) {
        if (attribute.equals(PlayerAttribute.strength)) {
            return this.strengthRequired;
        }
        return 0;
    }

    protected boolean isPresenceLocationValid(Map map, MapPixelLocation location) {
        Tile tile = map.getTile(location);
        return tile.equals(Tile.roomFloor) || this.hallwayOk && tile.equals(Tile.floor);
    }

    public boolean isValidForMap(Map map) {
        if (this.tech) {
            if (!map.getMotif().isTech()) {
                return false;
            }
            if ((this.equals(kevlarArmor) || this.equals(heavyKevlarArmor) || this.equals(kevlarShield) || this.equals(kevlarShield) || this.equals(largeKevlarShield) || this.equals(riotShield) || this.equals(shotgunShell) || this.equals(assaultRifleBullet)) && map.getLevel().getIndex() < MapLevel.base.getIndex()) {
                return false;
            }
            if ((this.equals(reflecArmor) || this.equals(heavyReflecArmor) || this.equals(poweredReflecArmor) || this.equals(reflecShield) || this.equals(largeReflecShield) || this.equals(laserPistolCell) || this.equals(laserAssaultRifleCell)) && map.getLevel().getIndex() < MapLevel.moon.getIndex()) {
                return false;
            }
        }
        if (this.magical && map.getMotif().isTech()) {
            return false;
        }
        return this.placementValue <= map.getLevel().getMaxItemPlacementValue();
    }

    public MapEntity doCreateStockInstance() {
        return ItemFactory.doCreateItem(this);
    }

    public Item doCreateInstance() {
        return (Item)this.doCreateStockInstance();
    }

    public final boolean isHallwayOk() {
        return this.hallwayOk;
    }

    public final String getUnidentifiedName() {
        return this.unidentifiedName;
    }

    public final String getPluralName() {
        return this.pluralName;
    }

    public final float getEncumbrance() {
        return this.encumbrance;
    }

    public final boolean isGroupable() {
        return this.groupable;
    }

    public final boolean isMustEquip() {
        return this.mustEquip;
    }

    public final EquipLocation getEquipLocation() {
        return this.equipLocation;
    }

    public final ItemType getAncestorType() {
        return this.ancestorType;
    }

    public final boolean getTakesTwoHands() {
        return this.takesTwoHands;
    }

    public final float getChanceOfInChest() {
        return this.chanceOfInChest;
    }

    public final int getAvoidance() {
        return this.avoidance;
    }

    public final int[] getDefenseModifiers() {
        return this.defenseModifiers;
    }

    public final int getAvoidanceModifier() {
        return this.avoidanceModifier;
    }

    public final boolean isMetal() {
        return this.metal;
    }

    public final boolean isNoisy() {
        return this.noisy;
    }

    public final int getQuantityToCreate() {
        return this.quantityToCreate;
    }

    public final int[] getAttributeModifiers() {
        return this.attributeModifiers;
    }

    public final boolean isCursed() {
        return this.cursed;
    }

    public final boolean isMagical() {
        return this.magical;
    }

    public final boolean isTech() {
        return this.tech;
    }

    public String getInfo() {
        return this.info;
    }

    public final boolean isArmor() {
        return this.armor;
    }

    public final boolean isShield() {
        return this.shield;
    }

    public final int getPlacementValue() {
        return this.placementValue;
    }

    public final boolean isIndividuallyIdentified() {
        return this.individuallyIdentified;
    }

    protected String getImagePath() {
        return "items/";
    }

    static {
        ItemType.clothArmor.frequency = 0;
        smallShield = ItemType.doCreateArmorType("small shield", null, "shield", 5.0f, 6, 1, 0, 0, 1, true, false, 8, 10, false, true);
        smallShieldM3 = ItemType.doCreateMagicalArmorType(smallShield, -3);
        smallShieldM2 = ItemType.doCreateMagicalArmorType(smallShield, -2);
        smallShieldM1 = ItemType.doCreateMagicalArmorType(smallShield, -1);
        smallShieldP1 = ItemType.doCreateMagicalArmorType(smallShield, 1);
        smallShieldP2 = ItemType.doCreateMagicalArmorType(smallShield, 2);
        smallShieldP3 = ItemType.doCreateMagicalArmorType(smallShield, 3);
        largeShield = ItemType.doCreateArmorType("large shield", null, "largeShield", 10.0f, 5, 2, 0, 0, 2, true, false, 12, 40, false, true);
        largeShieldM3 = ItemType.doCreateMagicalArmorType(largeShield, -3);
        largeShieldM2 = ItemType.doCreateMagicalArmorType(largeShield, -2);
        largeShieldM1 = ItemType.doCreateMagicalArmorType(largeShield, -1);
        largeShieldP1 = ItemType.doCreateMagicalArmorType(largeShield, 1);
        largeShieldP2 = ItemType.doCreateMagicalArmorType(largeShield, 2);
        largeShieldP3 = ItemType.doCreateMagicalArmorType(largeShield, 3);
        greatShield = ItemType.doCreateArmorType("great shield", null, "greatShield", 20.0f, 4, 3, 1, 1, 3, true, false, 17, 80, false, true);
        greatShieldM3 = ItemType.doCreateMagicalArmorType(greatShield, -3);
        greatShieldM2 = ItemType.doCreateMagicalArmorType(greatShield, -2);
        greatShieldM1 = ItemType.doCreateMagicalArmorType(greatShield, -1);
        greatShieldP1 = ItemType.doCreateMagicalArmorType(greatShield, 1);
        greatShieldP2 = ItemType.doCreateMagicalArmorType(greatShield, 2);
        greatShieldP3 = ItemType.doCreateMagicalArmorType(greatShield, 3);
        kevlarShield = ItemType.doCreateArmorType("kevlar shield", futureShieldName, "kevlarShield", 5.0f, 6, 1, 1, 0, 1, false, false, 8, 500, true, true);
        largeKevlarShield = ItemType.doCreateArmorType("large kevlar shield", futureShieldName, "largeKevlarShield", 10.0f, 5, 2, 2, 0, 2, false, false, 12, 1000, true, true);
        riotShield = ItemType.doCreateArmorType("riot shield", futureShieldName, "riotShield", 25.0f, 4, 5, 5, 1, 5, true, false, 12, 2500, true, true);
        reflecShield = ItemType.doCreateArmorType("reflec shield", futureShieldName, "reflecShield", 5.0f, 6, 1, 1, 1, 1, false, false, 8, 1500, true, true);
        largeReflecShield = ItemType.doCreateArmorType("large reflec shield", futureShieldName, "largeReflecShield", 10.0f, 5, 2, 2, 2, 2, false, false, 12, 3000, true, true);
        ItemType.riotShield.takesTwoHands = true;
        torch = ItemType.doCreateNonGroupableItemType("torch", null, "torch", 1.0f, false, null, 10, false, 1, false, null);
        bootsOfQuickness = ItemType.doCreateNonGroupableItemType("pair of boots of quickness", "pair of boots", "boots", 5.0f, true, EquipLocation.feet, 10, false, 5000, false, "Speeds movement.");
        bootsOfLethargy = ItemType.doCreateNonGroupableItemType("pair of boots of lethargy", "pair of boots", "boots", 5.0f, true, EquipLocation.feet, 10, false, 5000, true, "Slows movement.");
        capeOfGoodLuck = ItemType.doCreateNonGroupableItemType("cape of good luck", "cape", "cape", 3.0f, true, EquipLocation.back, 15, false, 3000, false, "Adds a +2 bonus to avoidance checks.");
        capeOfDisplacement = ItemType.doCreateNonGroupableItemType("cape of displacement", "cape", "cape", 3.0f, true, EquipLocation.back, 15, false, 4000, false, "Makes wearer appear to be a few feet from actual position, adding a bonus to defense.");
        leadLinedCloak = ItemType.doCreateNonGroupableItemType("lead-lined cloak", "cloak", "cape", 10.0f, true, EquipLocation.back, 14, true, 2000, false, "Shields from radiation.");
        blessedFigurine = ItemType.doCreateNonGroupableItemType("blessed figurine", "figurine", "figurine", 1.0f, true, EquipLocation.neck, 17, false, 1500, false, "Provides a +1 bonus to hit.");
        cursedFigurine = ItemType.doCreateNonGroupableItemType("cursed figurine", "figurine", "figurine", 1.0f, true, EquipLocation.neck, 17, false, 1500, true, "Imposes a -1 penalty to hit.");
        helmOfCombatMastery = ItemType.doCreateNonGroupableItemType("helm of combat mastery", "helm", "helm", 5.0f, true, EquipLocation.head, 8, true, 3000, false, "Grants an extra melee attack per turn.");
        skullcapOfReasoning = ItemType.doCreateNonGroupableItemType("skullcap of reasoning", "skullcap", "skullcap", 2.0f, true, EquipLocation.head, 10, true, 6000, false, "Increases intelligence.");
        necklaceOfOgreStrength = ItemType.doCreateNonGroupableItemType("necklace of ogre strength", "necklace", "magicNecklace", 1.0f, true, EquipLocation.neck, 12, false, 12000, false, "Grants a 19 strength.");
        necklaceOfEssence = ItemType.doCreateNonGroupableItemType("necklace of essence", "necklace", "magicNecklace", 1.0f, true, EquipLocation.neck, 12, false, 9000, false, "Absorbs level drains.  Degrades once per drain.");
        necklaceOfGoodLuck = ItemType.doCreateNonGroupableItemType("necklace of good luck", "necklace", "magicNecklace", 1.0f, true, EquipLocation.neck, 12, true, 3000, false, "Adds a +2 bonus to avoidance checks.");
        necklaceOfChoking = ItemType.doCreateNonGroupableItemType("necklace of choking", "necklace", "magicNecklace", 1.0f, true, EquipLocation.neck, 12, true, 3000, true, "Chokes the wearer to death.");
        landMine = ItemType.doCreateNonGroupableItemType("land mine", "strange device", "landMine", 3.0f, false, null, 9, true, 600, false, "Becomes an invisible part of its location.  Is set off the first time a being walks over it.");
        phylacteryOfResurrection = ItemType.doCreateNonGroupableItemType("phylactery of resurrection", "phylactery", "phylactery", 1.0f, false, null, 17, false, 5000, false, "At the moment of death, heals the possessor back to full health.");
        potionOfHealing = ItemType.doCreateNonGroupableItemType("potion of healing", "potion", "potion", 1.0f, false, null, 18, false, 400, false, null);
        potionOfPoison = ItemType.doCreateNonGroupableItemType("potion of poison", "potion", "potion", 1.0f, false, null, 18, false, 3500, false, "Acts as a super-strength poison.");
        potionOfStrength = ItemType.doCreateNonGroupableItemType("potion of strength", "potion", "potion", 1.0f, false, null, 18, false, 3500, false, null);
        potionOfIntelligence = ItemType.doCreateNonGroupableItemType("potion of intelligence", "potion", "potion", 1.0f, false, null, 18, false, 3500, false, null);
        potionOfJudgement = ItemType.doCreateNonGroupableItemType("potion of judgement", "potion", "potion", 1.0f, false, null, 18, false, 3500, false, null);
        potionOfAgility = ItemType.doCreateNonGroupableItemType("potion of agility", "potion", "potion", 1.0f, false, null, 18, false, 3500, false, null);
        potionOfEndurance = ItemType.doCreateNonGroupableItemType("potion of endurance", "potion", "potion", 1.0f, false, null, 18, false, 3500, false, null);
        ringOfPowerStorage = ItemType.doCreateNonGroupableItemType("ring of power storage", "ring", "ring", 0.1f, true, EquipLocation.rightRing, 11, true, 5000, false, "Absorbs the magic- and clerical- point cost of powers used. Is degraded with each usage with a probability determined by the amount of points that would have been spent.");
        ringOfStrength = ItemType.doCreateNonGroupableItemType("ring of strength", "ring", "ring", 0.1f, true, EquipLocation.rightRing, 11, true, 5500, false, "Increases strength.");
        ringOfStrengthSapping = ItemType.doCreateNonGroupableItemType("ring of strength sapping", "ring", "ring", 0.1f, true, EquipLocation.rightRing, 11, true, 5500, true, "Decreases strength.");
        robeOfMagicalEnergy = ItemType.doCreateNonGroupableItemType("robe of magical energy", "robe", "robe", 4.0f, true, EquipLocation.back, 16, false, 13000, false, "Lessens magic- and clerical- point cost of powers used by one-third.");
        ItemType.capeOfGoodLuck.avoidanceModifier = 2;
        ItemType.capeOfDisplacement.defenseModifiers = new int[]{2, 2, 2};
        ItemType.skullcapOfReasoning.attributeModifiers = new int[]{0, 4, 0, 0, 0};
        ItemType.necklaceOfGoodLuck.avoidanceModifier = 2;
        ItemType.landMine.magical = false;
        ItemType.landMine.tech = true;
        ItemType.landMine.individuallyIdentified = false;
        ItemType.potionOfPoison.frequency *= 3;
        ItemType.ringOfStrength.attributeModifiers = new int[]{2, 0, 0, 0, 0};
        ItemType.ringOfStrengthSapping.attributeModifiers = new int[]{-4, 0, 0, 0, 0};
        turquoiseGemstone = ItemType.doCreateTreasureType("turquoise gemstone", "turquoise", 0.1f, 10);
        obsidianGemstone = ItemType.doCreateTreasureType("obsidian gemstone", "obsidian", 0.1f, 30);
        carnelianGemstone = ItemType.doCreateTreasureType("carnelian gemstone", "carnelian", 0.1f, 50);
        sardonyxGemstone = ItemType.doCreateTreasureType("sardonyx gemstone", "sardonyx", 0.1f, 75);
        amberGemstone = ItemType.doCreateTreasureType("amber gemstone", "amber", 0.1f, 100);
        jadeGemstone = ItemType.doCreateTreasureType("jade gemstone", "jade", 0.1f, 250);
        pearl = ItemType.doCreateTreasureType("pearl", "pearl", 0.1f, 500);
        aquamarineGemstone = ItemType.doCreateTreasureType("aquamarine gemstone", "aquamarine", 0.1f, 700);
        peridotGemstone = ItemType.doCreateTreasureType("peridot gemstone", "peridot", 0.1f, 800);
        opalGemstone = ItemType.doCreateTreasureType("opal gemstone", "opal", 0.1f, 1000);
        sapphire = ItemType.doCreateTreasureType("sapphire", "sapphire", 0.1f, 2000);
        ruby = ItemType.doCreateTreasureType("ruby", "ruby", 0.1f, 3000);
        emerald = ItemType.doCreateTreasureType("emerald", "emerald", 0.1f, 5000);
        jacinthGemstone = ItemType.doCreateTreasureType("jacinth gemstone", "jacinth", 0.1f, 7500);
        diamond = ItemType.doCreateTreasureType("diamond", "diamond", 0.1f, 10000);
        largeSapphire = ItemType.doCreateTreasureType("large sapphire", "largeSapphire", 0.2f, 15000);
        largeRuby = ItemType.doCreateTreasureType("large ruby", "largeRuby", 0.2f, 17500);
        largeEmerald = ItemType.doCreateTreasureType("large emerald", "largeEmerald", 0.2f, 20000);
        largeJacinthGemstone = ItemType.doCreateTreasureType("large jacinth gemstone", "largeJacinth", 0.2f, 22500);
        largeDiamond = ItemType.doCreateTreasureType("large diamond", "largeDiamond", 0.2f, 25000);
        silverBar = ItemType.doCreateTreasureType("silver bar", "silverBar", 10.0f, 250);
        goldBar = ItemType.doCreateTreasureType("gold bar", "goldBar", 10.0f, 1000);
        platinumBar = ItemType.doCreateTreasureType("platinum bar", "platinumBar", 10.0f, 4000);
        ivoryNecklace = ItemType.doCreateTreasureType("ivory necklace", "ivoryNecklace", 0.5f, 100);
        silverNecklace = ItemType.doCreateTreasureType("silver necklace", "silverNecklace", 0.5f, 500);
        goldNecklace = ItemType.doCreateTreasureType("gold necklace", "goldNecklace", 0.5f, 1000);
        coralNecklace = ItemType.doCreateTreasureType("coral necklace", "coralNecklace", 0.5f, 2000);
        jadeNecklace = ItemType.doCreateTreasureType("jade necklace", "jadeNecklace", 0.5f, 3000);
        platinumNecklace = ItemType.doCreateTreasureType("platinum necklace", "platinumNecklace", 0.5f, 4000);
        silverNecklaceWithGems = ItemType.doCreateTreasureType("silver necklace with gems", "silverNecklaceWithGems", 0.5f, 5000);
        goldNecklaceWithGems = ItemType.doCreateTreasureType("gold necklace with gems", "goldNecklaceWithGems", 0.5f, 8000);
        platinumNecklaceWithGems = ItemType.doCreateTreasureType("platinum necklace with gems", "platinumNecklaceWithGems", 0.5f, 11000);
        silverMedallion = ItemType.doCreateTreasureType("silver medallion", "silverMedallion", 1.0f, 1000);
        goldMedallion = ItemType.doCreateTreasureType("gold medallion", "goldMedallion", 1.0f, 2000);
        platinumMedallion = ItemType.doCreateTreasureType("platinum medallion", "platinumMedallion", 1.0f, 5000);
        silverChalice = ItemType.doCreateTreasureType("silver chalice", "silverChalice", 2.0f, 2000);
        goldChalice = ItemType.doCreateTreasureType("gold chalice", "goldChalice", 2.0f, 4000);
        platinumChalice = ItemType.doCreateTreasureType("platinum chalice", "platinumChalice", 2.0f, 6000);
        silverChaliceWithGems = ItemType.doCreateTreasureType("silver chalice with gems", "silverChaliceWithGems", 3.0f, 7000);
        goldChaliceWithGems = ItemType.doCreateTreasureType("gold chalice with gems", "goldChaliceWithGems", 3.0f, 9000);
        platinumChaliceWithGems = ItemType.doCreateTreasureType("platinum chalice with gems", "platinumChaliceWithGems", 3.0f, 14000);
        silverSceptre = ItemType.doCreateTreasureType("silver sceptre", "silverSceptre", 4.0f, 3000);
        goldSceptre = ItemType.doCreateTreasureType("gold sceptre", "goldSceptre", 4.0f, 5000);
        platinumSceptre = ItemType.doCreateTreasureType("platinum sceptre", "platinumSceptre", 4.0f, 7000);
        silverSceptreWithGems = ItemType.doCreateTreasureType("silver sceptre with gems", "silverSceptreWithGems", 5.0f, 9000);
        goldSceptreWithGems = ItemType.doCreateTreasureType("gold sceptre with gems", "goldSceptreWithGems", 5.0f, 12000);
        platinumSceptreWithGems = ItemType.doCreateTreasureType("platinum sceptre with gems", "platinumSceptreWithGems", 5.0f, 16000);
        silverCrown = ItemType.doCreateTreasureType("silver crown", "silverCrown", 5.0f, 4000);
        goldCrown = ItemType.doCreateTreasureType("gold crown", "goldCrown", 5.0f, 6000);
        platinumCrown = ItemType.doCreateTreasureType("platinum crown", "platinumCrown", 5.0f, 8000);
        silverCrownWithGems = ItemType.doCreateTreasureType("silver crown with gems", "silverCrownWithGems", 8.0f, 10000);
        goldCrownWithGems = ItemType.doCreateTreasureType("gold crown with gems", "goldCrownWithGems", 8.0f, 18000);
        platinumCrownWithGems = ItemType.doCreateTreasureType("platinum crown with gems", "platinumCrownWithGems", 8.0f, 26000);
    }
}

