/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.items;

import java.awt.Image;
import java.io.Serializable;
import silmar.Sound;
import silmar.entities.LightSource;
import silmar.entities.MapEntity;
import silmar.entities.beings.player.Player;
import silmar.entities.items.Item;
import silmar.entities.items.ItemCondition;
import silmar.entities.terrains.Terrain;
import silmar.entities.terrains.TerrainFactory;
import silmar.entities.terrains.TerrainType;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapTileDistance;
import silmar.tiles.TileSize;
import silmar.util.ImageUtil;
import silmar.util.Random;

public class Items {

    public static class RingOfPowerStorage
    extends Item {
        public void onSuppliedMagicPoints(int amount) {
            if (Random.getInt(1, 15) <= amount) {
                this.doDegrade();
            }
        }
    }

    public static class PotionOfAttribute
    extends Potion {
    }

    public static class PotionOfPoison
    extends Potion {
    }

    public static class PotionOfHealing
    extends Potion {
    }

    public static class Potion
    extends Item
    implements Item.Usable {
        public void onUsed(Player user) {
            user.getMap().onSoundIssued(Sound.potionDrunk, user.getLocation());
            user.onUsedItem(this);
            this.doRemoveOne();
        }
    }

    public static class LandMine
    extends Item
    implements Item.Usable {
        public void onUsed(Player user) {
            Map map = user.getMap();
            MapPixelLocation location = user.getLocation();
            Terrain landMine = TerrainFactory.doCreateTerrain(TerrainType.landMine);
            map.doAddEntity((MapEntity)landMine, location);
            this.doRemoveOne();
        }
    }

    public static class Torch
    extends Item
    implements Item.Usable,
    LightSource {
        private boolean lit = false;
        private TurnsOfLightLeft turnsOfLightLeft = new TurnsOfLightLeft();
        public static final MapPixelDistance torchLightRadius = new MapPixelDistance(new MapTileDistance(9));
        private static Image litImage;
        private static int turnsOfLightPerCondition;

        public void onUsed(Player user) {
            user.onUsedItem(this);
            if (!this.lit) {
                this.lit = true;
                this.doIssueSound(Sound.torchLit);
            } else {
                this.doExtinguish();
            }
        }

        public MapPixelDistance getLightRadius() {
            return torchLightRadius;
        }

        public boolean isEmittingLight() {
            return this.lit;
        }

        public void doExtinguish() {
            this.lit = false;
            this.doIssueSound(Sound.torchGoesOut);
        }

        private void doIssueSound(Sound sound) {
            Map map = this.holder != null ? this.holder.getMap() : this.getMap();
            MapPixelLocation location = this.holder != null ? this.holder.getLocation() : this.getLocation();
            map.onSoundIssued(sound, location);
        }

        public void doAct() {
            this.onEndOfTurn();
        }

        public void onEndOfTurn() {
            if (this.lit) {
                this.turnsOfLightLeft.doRemoveOne();
            }
        }

        public void doSpoil() {
            if (this.lit) {
                this.doExtinguish();
            }
            this.condition.set(ItemCondition.destroyed, false);
        }

        public Image getImage() {
            return this.lit ? litImage : super.getImage();
        }

        static {
            Torch.torchLightRadius.distance += TileSize.tileSize.width / 2;
            litImage = ImageUtil.doLoadImage("items/litTorch");
            turnsOfLightPerCondition = 40;
        }

        private class TurnsOfLightLeft
        implements Serializable {
            private int turnsOfLightLeft = Torch.access$100();

            private TurnsOfLightLeft() {
            }

            public void set(int turns) {
                this.turnsOfLightLeft = turns;
                if (turns <= 0) {
                    if (Torch.this.getCondition().equals(ItemCondition.poor)) {
                        Torch.this.doIssueSound(Sound.torchGoesOut);
                    }
                    Torch.this.doDegrade(false);
                    this.turnsOfLightLeft = turnsOfLightPerCondition;
                }
            }

            public void doRemoveOne() {
                this.set(this.turnsOfLightLeft - 1);
            }
        }
    }
}

