/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.talkerBeings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import silmar.Names;
import silmar.entities.MapEntity;
import silmar.entities.beings.talkerBeings.TalkerBeingFactory;
import silmar.entities.types.EntityType;
import silmar.map.Map;
import silmar.map.MapPixelLocation;
import silmar.map.stocking.Stockable;
import silmar.tiles.Tile;

public final class TalkerBeingType
extends EntityType
implements Stockable,
Names {
    private String greeting;
    private int movementPoints;
    public static final List types = new ArrayList();
    public static final HashMap typesMap = new HashMap();
    public static TalkerBeingType topsideStorekeeper = new TalkerBeingType("storekeeper", "topsideStorekeeper", 0, 1, "\"Welcome to my little general store. My selection is limited and the prices are high, but that's because I'm having to risk my life just to sell here.  What would you like to purchase?\"");
    public static TalkerBeingType topsidePriest = new TalkerBeingType("priest", "topsidePriest", 0, 1, "\"I am the priest known as Ramulon. Years ago, Syrilboltus destroyed the town where my mission was based. I now aid any who would stand against him. I provide my services for cost of materials only. How may I help you, friend?\"");
    public static TalkerBeingType goldPorter = new TalkerBeingType("porter", "goldPorter", 0, 1, "This is your hireling who is responsible for arranging transport of the items and gold you give him back to your devastated homelands. \"Greetings! I hope your quest goes well. What shall I transport for you?\"");
    public static TalkerBeingType dwarvenConsort = new TalkerBeingType("consort", "dwarvenConsort", 0, 1, "\"I am Grundle, consort of King Thelbar. I am authorized by His Majesty to purchase items of value from you for possession by the kingdom.  What do you wish to sell?\"");
    public static TalkerBeingType topsideBlacksmith = new TalkerBeingType("blacksmith", "topsideBlacksmith", 0, 1, "This person appears to be a blacksmith. \"I lost my whole family to that fiend Syrilboltus...  If you're going after him, I'll gladly repair any normal weapons or armor you have, real cheap!\"");
    public static TalkerBeingType nightdwarf = new TalkerBeingType("nightdwarf", "nightdwarf", 0, 1, "This fellow is a nightdwarf. \"Pay me well, and I will fix your weapons and armor, even those that are magical!\"");
    public static TalkerBeingType demonicWizard = new TalkerBeingType("demonicWizard", "demonicWizard", 0, 1, "This creature appears to be a demonic wizard. \"For a fee, I can restore and recharge your noncombative magical items. Otherwise, leave me to my work!\"");
    public static TalkerBeingType sage = new TalkerBeingType("sage", "sage", 0, 1, "This gnarled old man is so frail that you wonder how he made the trip here. \"Through experience and magic I am able to identify most of the items that exist in these parts. Have you any you want me to look at?\"");
    public static TalkerBeingType alienBuyer = new TalkerBeingType("alienBuyer", "alienBuyer", 1, 1, "\"Greetings!  I am from the City of Gold on the Plane of Metal. I have traveled here to purchase an alien artifact to bring back to my world.  What one item will you sell to me?\"");
    public static TalkerBeingType medicalRobot = new TalkerBeingType("medicalRobot", "medicalRobot", 1, 1, "");

    public TalkerBeingType(String name, String imageName, int frequency, int movementPoints, String greeting) {
        super(name, imageName);
        this.frequency = frequency;
        this.movementPoints = movementPoints;
        this.greeting = greeting;
        this.doDetmSize();
        types.add(this);
        typesMap.put(name, this);
    }

    public boolean equals(TalkerBeingType type) {
        return type == this || type.name.equals(this.name);
    }

    public boolean isValidForMap(Map map) {
        boolean tech = map.getMotif().isTech();
        return !(this.equals(medicalRobot) ? !tech : tech);
    }

    public MapEntity doCreateStockInstance() {
        return TalkerBeingFactory.doCreateTalkerBeing(this);
    }

    protected boolean isPresenceLocationValid(Map map, MapPixelLocation location) {
        if (map.getFirstBeingAt(location) != null) {
            return false;
        }
        Tile tile = map.getTile(location);
        return tile.isPassible() && !tile.getBlocksLOS();
    }

    protected String getImagePath() {
        return "beings/";
    }

    public String getGreeting() {
        return this.greeting;
    }

    public int getMovementPoints() {
        return this.movementPoints;
    }
}

