/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.talkerBeings;

import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import silmar.entities.MapEntityUtil;
import silmar.entities.beings.Being;
import silmar.entities.beings.MovementType;
import silmar.entities.beings.attacks.PenetrationType;
import silmar.entities.beings.player.Player;
import silmar.entities.beings.talkerBeings.TalkerBeingType;
import silmar.entities.damage.Damage;
import silmar.entities.talkers.Talker;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.tiles.Tile;
import silmar.tiles.TileSize;
import silmar.util.Random;

public class TalkerBeing
extends Being
implements Talker {
    private final MapPixelLocation goalLocation = new MapPixelLocation();
    private boolean hasGoalLocation = false;
    private transient TalkerBeingType type;
    private String typeName;
    private boolean turnOver;
    private Tile movementTile;

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.typeName = this.type.getName();
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException {
        try {
            s.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.type = (TalkerBeingType)TalkerBeingType.typesMap.get(this.typeName);
    }

    public void onCreated(TalkerBeingType type) {
        this.type = type;
        this.maxHitPoints.set(1);
        this.setHitPoints(1);
    }

    public String getImageName() {
        String imageName = this.type.getImageName();
        return imageName != null ? "beings/" + imageName : null;
    }

    public String getGreeting() {
        return this.type.getGreeting();
    }

    public void onGreetingHeardByPlayer(Player player) {
    }

    public void onTalkedTo() {
    }

    public void doAct() {
        this.turnOver = false;
        this.movementSoundCounter = 0;
        this.setMovementPoints(this.getMaxMovementPoints());
        while (!this.turnOver) {
            MapPixelLocation current = this.location;
            if (!this.hasGoalLocation) {
                if (this.movementTile == null) {
                    this.movementTile = this.map.getTile(current);
                }
                int maxTries = 5;
                int maxTileDistance = 4;
                for (int i = 0; i < 5; ++i) {
                    this.goalLocation.setLocation(current.x + Random.getInt(-4, 4) * TileSize.tileSize.width, current.y + Random.getInt(-4, 4) * TileSize.tileSize.height);
                    if (this.goalLocation.equals(current) || !this.map.getTile(this.goalLocation).equals(this.movementTile)) continue;
                    this.hasGoalLocation = true;
                    break;
                }
                if (!this.hasGoalLocation) break;
            }
            if (!MapPixelLocationUtil.isDistanceAtMost(current, this.goalLocation, TileSize.halfTileDistance)) {
                MapEntityUtil.MoveTowardsGoalResult result = MapEntityUtil.doMoveTowardsGoal(this, this.goalLocation, this.getMovementPoints(), null);
                if (result.impass) {
                    this.hasGoalLocation = false;
                    break;
                }
                if (result.notEnoughMovementPoints) break;
                this.hasGoalLocation = false;
                continue;
            }
            this.hasGoalLocation = false;
        }
    }

    public void doEndTurn() {
        this.turnOver = true;
    }

    public int getPowerRating() {
        return 1;
    }

    protected final int getDefense(PenetrationType penetration) {
        return Integer.MAX_VALUE;
    }

    public final TalkerBeingType getType() {
        return this.type;
    }

    public int getMaxMovementPoints() {
        return this.type.getMovementPoints();
    }

    public Dimension getSize() {
        return this.type.getSize();
    }

    protected int getDefense(PenetrationType penetration, Being attacker) {
        return 0;
    }

    public MovementType getMovementType() {
        return MovementType.walking;
    }

    public void doTakeDamage(Damage damage) {
    }
}

