/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.player;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import silmar.client.gui.LocationSelection;
import silmar.entities.beings.player.PlayerClass;
import silmar.entities.beings.player.PlayerLevel;
import silmar.entities.items.types.ItemType;
import silmar.util.HtmlUtil;

public final class PlayerPower {
    private String name;
    private PlayerLevel level;
    private boolean activeUse;
    private int magicPointCost;
    private int clericalPointCost;
    private String info;
    private String tooltipText;
    public static List powers = new ArrayList();
    public static HashMap powersMap = new HashMap();
    public static PlayerPower combatProwess = new PlayerPower(PlayerLevel.fighter, "Combat Prowess", false, 0, "This grants an extra melee attack per turn.");
    public static PlayerPower unarmedCombatProwess = new PlayerPower(PlayerLevel.monk, "Unarmed Combat Prowess", false, 0, "This adds +1 to hit and +1 damage per 3 experience levels to attacks made using the hands.  It also grants an extra hand attack per turn.");
    public static PlayerPower unarmoredDefensiveProwess = new PlayerPower(PlayerLevel.monk, "Unarmored Defensive Prowess", false, 0, "This adds +1 per 2 experience levels to defense when not wearing armor.");
    public static PlayerPower archerySkill = new PlayerPower(PlayerLevel.archer, "Archery Skill", false, 0, "This adds +1 to hit and +1 damage per 5 experience levels to attacks made using a bow or crossbow.  It also grants an extra attack per turn with such weapons.");
    public static PlayerPower immunityToDisease = new PlayerPower(PlayerLevel.paladin, "Immunity to Disease", false, 0, "This grants absolute immunity to all diseases.");
    public static PlayerPower layHands = new PlayerPower(PlayerLevel.paladin, "Lay Hands", true, 0, "This lets you heal yourself for up to 1 hit point per experience level. You may only reuse this power once you have been damaged again for a non-trivial amount.");
    public static PlayerPower protectionAgainstEvil = new PlayerPower(PlayerLevel.paladin, "Protection Against Evil", false, 0, "This adds +2 to hit and +2 to defense while in melee combat with evil monsters.  (Note that many monsters are simply hungry or animated, rather than evil.)");
    public static PlayerPower repelLivingDeadPaladin = new PlayerPower(PlayerLevel.paladin, "Repel Living Dead", true, 0, "This wards off any living dead creature within sight that fails an avoidance check (modified by your level).  Costs 2 hit points per use.");
    public static PlayerPower immunityToPoison = new PlayerPower(PlayerLevel.superhero, "Immunity to Poison", false, 0, "This grants complete immunity to all poisons.");
    public static PlayerPower fireEyeBeams = new PlayerPower(PlayerLevel.superhero, "Fire Eye Beams", true, 0, "This attack form hits opponents based solely on your agility score.  Costs 2 hit points per use.");
    public static PlayerPower employSuperVision = new PlayerPower(PlayerLevel.superhero, "Employ Super Vision", true, 0, "This enables you to see through obstructions for an instant.  Costs 5 hit points per use.");
    public static PlayerPower immunityToRadiation = new PlayerPower(PlayerLevel.neonKnight, "Immunity to Radiation", false, 0, "This grants complete immunity to the effects of radiation.");
    public static PlayerPower emitRadWave = new PlayerPower(PlayerLevel.neonKnight, "Emit Rad Wave", true, 0, "This generates a massive wave of radiation that will kill most nearby monsters.  You must have at least half of your hit points left to use this, and such usage will leave you with 1 hit point remaining.  You also must first succeed at a +0 endurance check to use this.");
    public static final int repelLivingDeadCostForPaladin = 2;
    public static PlayerPower hunterSpeed = new PlayerPower(PlayerLevel.barbarian, "Hunter Speed", false, 0, "This improves your movement rate.");
    public static PlayerPower fastRecuperation = new PlayerPower(PlayerLevel.barbarian, "Fast Recuperation", false, 0, "This means you heal on your own at a perceptible rate.");
    public static PlayerPower detectTraps = new PlayerPower(PlayerLevel.thief, "Trap Detection", false, 0, "This gives a percentage chance (based on your intelligence and agility) to detect adjacent traps.");
    public static PlayerPower disarmTraps = new PlayerPower(PlayerLevel.thief, "Trap Disarming", false, 0, "This gives a percentage chance (based on your intelligence and agility) to disarm any trap you make contact with.");
    public static PlayerPower stealth = new PlayerPower(PlayerLevel.ninja, "Stealthy Movement", false, 0, "This keeps monsters from noticing you if you aren't wearing anything noisy.  Your chance of success in remaining unnoticed depends on both your intelligence and your agility.  The first attack on an unaware opponent causes double damage!");
    public static PlayerPower horns = new PlayerPower(PlayerLevel.minotaur, "Horns", false, 0, "These add additional damage to any melee attack which hits an opponent.");
    public static PlayerPower senseCreatures = new PlayerPower(PlayerLevel.minotaur, "Sense Creatures", true, 0, "This lets you sense if there are any creatures nearby.");
    public static PlayerPower senseSecretDoors = new PlayerPower(PlayerLevel.minotaur, "Sense Secret Doors", true, 0, "This gives you a +0 intelligence check to find any secret doors within sight.");
    public static PlayerPower immunityToConfusion = new PlayerPower(PlayerLevel.minotaur, "Immunity to Confusion", false, 0, "This grants complete immunity from the effects of confusion.");
    public static PlayerPower regeneration = new PlayerPower(PlayerLevel.troll, "Regeneration", false, 0, "This heals you at a fast rate.  However, it cannot bring you back from the dead.");
    public static PlayerPower nightVision = new PlayerPower(PlayerLevel.werewolf, "Night Vision", false, 0, "This lets you see in the dark without needing a torch.");
    public static PlayerPower claws = new PlayerPower(PlayerLevel.werewolf, "Claws", false, 0, "This means your hand attacks can do much greater base damage than normal hands.");
    public static PlayerPower invulnerabilityToLesserCreatures = new PlayerPower(PlayerLevel.werewolf, "Invulnerability to Lesser Creatures", false, 0, "This prevents the normal attacks of lesser creatures from damaging you.");
    public static PlayerPower throwBoulder = new PlayerPower(PlayerLevel.giant, "Throw Boulder", true, 0, "This hurls a boulder (if there is one at your current location) at an opponent if you make a -5 strength check.  Your agility affects the accuracy of your throw.  If the target monster is hit, it may make an avoidance check (modified by your level) to take half damage.");
    public static PlayerPower invulnerabilityToAverageCreatures = new PlayerPower(PlayerLevel.subvampire, "Invulnerability to Average Creatures", false, 0, "This prevents the normal attacks of average-power creatures from damaging you.");
    public static PlayerPower immunityToParalyzation = new PlayerPower(PlayerLevel.subvampire, "Immunity to Paralyzation", false, 0, "This prevents any attempt to paralyze you.");
    public static PlayerPower lifeDraining = new PlayerPower(PlayerLevel.subvampire, "Life Draining", false, 0, "This channels half the damage you cause with a hand attack into your own hit point total, if you make a +0 agility check.");
    public static PlayerPower spinWeb = new PlayerPower(PlayerLevel.mutatedSpider, "Spin Web", true, 0, "This leaves a web at your current location.  The webbing is strong enough to trap (or at least slow) many types of creatures.  You lose one hit point per web spun, due to the exertion involved.");
    public static PlayerPower teleportingTouch = new PlayerPower(PlayerLevel.pixie, "Teleportng Touch", false, 0, "This teleports away any monster you hit with a hand attack which fails an avoidance check, modified by your level.");
    public static PlayerPower leap = new PlayerPower(PlayerLevel.kangadillo, "Leap", true, 0, "This moves you directly to any visible location within a certain distance (which is determined by your strength).  How close you land to your target is affected by your agility.");
    public static PlayerPower toughExterior = new PlayerPower(PlayerLevel.kangadillo, "Tough Exterior", false, 0, "This reduces by half the damage you take from most attack forms.");
    public static PlayerPower disintegratingTouch = new PlayerPower(PlayerLevel.demon, "Disintegrating Touch", false, 0, "This disintegrates any monster you hit with a hand attack, if you make a +0 endurance check, and if the victim fails an avoidance check (modified by your level).");
    public static PlayerPower cyberneticAccuracy = new PlayerPower(PlayerLevel.cyborg, "Cybernetic Accuracy", false, 0, "When using ranged weapons, this adds +1 to hit and +1 damage per 4 intelligence you possess.");
    public static PlayerPower healWounds = new PlayerPower(PlayerLevel.cleric, "Heal Wounds", true, 2, "This heals a limited amount of hit points of damage.");
    public static PlayerPower curePoison = new PlayerPower(PlayerLevel.cleric, "Cure Poison", true, 4, "This cures one level of poisoning from the recipient.  Multiple uses might be required for complete cleansing.");
    public static PlayerPower repelLivingDeadCleric = new PlayerPower(PlayerLevel.cleric, "Repel Living Dead", true, 1, "This wards off any living dead creature within sight that fails an avoidance check (modified by your casting level).");
    public static PlayerPower cureDisease = new PlayerPower(PlayerLevel.cleric, "Cure Disease", true, 3, "This cures the recipient of one disease.");
    public static PlayerPower emitLightning = new PlayerPower(PlayerLevel.druid, "Emit Lightning", true, 3, "This emits a lightning bolt that causes damage according to your casting level.  Victims may make an avoidance check (modified by your casting level) to take half damage.");
    public static PlayerPower healFully = new PlayerPower(PlayerLevel.priest, "Heal Fully", true, 6, "This heals all of your lost hit points.");
    public static PlayerPower revealTraps = new PlayerPower(PlayerLevel.priest, "Reveal Traps", true, 2, "This automatically reveals all traps within sight.");
    public static PlayerPower placeVengefulSymbol = new PlayerPower(PlayerLevel.priest, "Place Vengeful Symbol", true, 1, "This places a symbol that does damage to evil creatures passing over it.  The amount of damage is affected by your casting level.");
    public static PlayerPower conjureDeathFog = new PlayerPower(PlayerLevel.deathCaster, "Conjure Death Fog", true, 5, "This creates a cloud of deadly vapors which damages monsters passing through it for an amount dependent on your casting level.  Victims may make an avoidance check (modified by your casting level) to take half damage.");
    public static PlayerPower teleportSelf = new PlayerPower(PlayerLevel.wizard, "Teleport Self", true, 2, "This transports you to the last location you memorized on a specified level.");
    public static PlayerPower memorizeLocation = new PlayerPower(PlayerLevel.wizard, "Memorize Location", true, 0, "This specifies your current location as the spot on this level where the Teleport Self power will take you.");
    public static PlayerPower hurlFireball = new PlayerPower(PlayerLevel.wizard, "Hurl Fireball", true, 3, "This hurls a fireball that causes both explosion and fire damage according to your casting level.  This spell can also damage or destroy any loose items within its blast radius.  You must make a successful +0 agility check to have the fireball explode exactly where you target it.  Victims may make an avoidance check (modified by your casting level) to take half damage.");
    public static PlayerPower findExit = new PlayerPower(PlayerLevel.wizard, "Find Exit", true, 2, "This gives you an idea of where the exit to the next level is.");
    public static PlayerPower transmuteGoldToBars = new PlayerPower(PlayerLevel.alchemist, "Transmute Gold to Bars", true, 3, "This converts each " + ItemType.goldBar.getPlacementValue() + " gold at and around your location (but not being held by you) into a gold bar, which weighs less (because the impurities are stripped out), and takes up less space.");
    public static PlayerPower transmuteBarsToGold = new PlayerPower(PlayerLevel.alchemist, "Transmute Bars to Gold", true, 3, "This converts each of your gold bars back into regular gold.");
    public static PlayerPower findTreasure = new PlayerPower(PlayerLevel.sorcerer, "Find Treasure", true, 1, "This gives an idea of where the nearest treasure is, which is of at least a certain value.");
    public static PlayerPower projectRetributiveShield = new PlayerPower(PlayerLevel.sorcerer, "Project Retributive Shield", true, 3, "This causes melee damage inflicted on you to be inflicted back on your attacker, as well.  The effect lasts for a duration that is dependent on your casting level.");
    public static PlayerPower freezeBeing = new PlayerPower(PlayerLevel.battlemage, "Freeze Monster", true, 5, "This will paralyze a monster if it fails an avoidance check (modified by your casting level).  The effect lasts for a duration that is dependent on your casting level.");
    public static PlayerPower quickenSelf = new PlayerPower(PlayerLevel.battlemage, "Quicken Self", true, 2, "This grants you a doubled movement rate and a doubled attack rate for a duration that is dependent on your casting level.  However, with each use you run the risk of a permanent loss of endurance, due to the exertion involved.");
    public static PlayerPower achieveBionicStrength = new PlayerPower(PlayerLevel.scientist, "Achieve Bionic Strength", true, 2, "This grants you +6 strength for a duration that is dependent on your casting level.");
    public static PlayerPower summonMeteorShower = new PlayerPower(PlayerLevel.scientist, "Summon Meteor Shower", true, 7, "This explodes a fiery meteor on each enemy within sight.  Damage per meteor is as per a fireball.");

    public static PlayerPower getPower(String name) {
        return (PlayerPower)powersMap.get(name);
    }

    public PlayerPower(PlayerLevel level, String name, boolean activeUse, int pointCost, String info) {
        this.level = level;
        this.name = name;
        this.activeUse = activeUse;
        this.info = info = HtmlUtil.doBreakText(info, 50);
        if (PlayerClass.magicUser.getContains(level)) {
            this.magicPointCost = pointCost;
        } else if (PlayerClass.cleric.getContains(level)) {
            this.clericalPointCost = pointCost;
        }
        powers.add(this);
        powersMap.put(name, this);
        this.tooltipText = "<B>" + name + "</B><br>" + info;
    }

    public boolean equals(PlayerPower power) {
        return power == this || power.name.equals(this.name);
    }

    public boolean isActiveUse() {
        return this.activeUse;
    }

    public int getClericalPointCost() {
        return this.clericalPointCost;
    }

    public String getInfo() {
        return this.info;
    }

    public PlayerLevel getLevel() {
        return this.level;
    }

    public int getMagicPointCost() {
        return this.magicPointCost;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMagicUserSpell() {
        return PlayerClass.magicUser.getContains(this.level);
    }

    public boolean isClericalSpell() {
        return PlayerClass.cleric.getContains(this.level);
    }

    public String toString() {
        return this.name;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public LocationSelection getLocationSelection() {
        LocationSelection selection = null;
        if (this.equals(fireEyeBeams)) {
            selection = new LocationSelection.FireEyeBeams();
        } else if (this.equals(leap)) {
            selection = new LocationSelection.Leap();
        } else if (this.equals(emitLightning)) {
            selection = new LocationSelection.EmitLightning();
        } else if (this.equals(conjureDeathFog)) {
            selection = new LocationSelection.ConjureDeathFog();
        } else if (this.equals(placeVengefulSymbol)) {
            selection = new LocationSelection.PlaceVengefulSymbol();
        } else if (this.equals(throwBoulder)) {
            selection = new LocationSelection.ThrowBoulder();
        } else if (this.equals(freezeBeing)) {
            selection = new LocationSelection.FreezeBeing();
        } else if (this.equals(hurlFireball)) {
            selection = new LocationSelection.HurlFireball();
        }
        return selection;
    }
}

