/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.player;

import silmar.entities.beings.player.Player;

public class ExperienceNeededForLevels {
    private static int maxNumLevels = 50;
    private static final int experienceNeededToGainFirstPlayerLevel = 1350;
    private static int[] experienceNeededForLevels;

    private static void doDetmExperienceNeededForLevels(int startingLevel) {
        int i;
        experienceNeededForLevels = new int[maxNumLevels];
        int[] amounts = experienceNeededForLevels;
        for (i = 1; i <= startingLevel; ++i) {
            amounts[i] = amounts[i - 1] + (int)(1350.0f * ((float)(i - 1) / (float)startingLevel));
        }
        for (i = startingLevel + 1; i < amounts.length; ++i) {
            amounts[i] = amounts[i - 1] + (i - startingLevel) * 1350;
        }
    }

    public static int getExperienceNeededForLevel(int level) {
        if (level >= maxNumLevels) {
            return Integer.MAX_VALUE;
        }
        return experienceNeededForLevels[level];
    }

    public static int getLevelForExperience(int experience) {
        for (int i = 0; i < maxNumLevels; ++i) {
            if (experience >= ExperienceNeededForLevels.getExperienceNeededForLevel(i)) continue;
            return i - 1;
        }
        return maxNumLevels;
    }

    static {
        ExperienceNeededForLevels.doDetmExperienceNeededForLevels(Player.getStartingLevel());
    }
}

