/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.monsters;

import java.awt.Dimension;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import silmar.Sound;
import silmar.entities.LightSource;
import silmar.entities.MapEntity;
import silmar.entities.MapEntityUtil;
import silmar.entities.beings.Being;
import silmar.entities.beings.BeingUtil;
import silmar.entities.beings.MovementType;
import silmar.entities.beings.monsters.Monster;
import silmar.entities.beings.monsters.MonsterAttack;
import silmar.entities.beings.monsters.MonsterFactory;
import silmar.entities.beings.monsters.MonsterType;
import silmar.entities.beings.monsters.MonsterUtil;
import silmar.entities.beings.player.Player;
import silmar.entities.beings.player.PlayerUtil;
import silmar.entities.beings.talkerBeings.TalkerBeingType;
import silmar.entities.damage.Damage;
import silmar.entities.damage.DamageForm;
import silmar.entities.damage.DamageUtil;
import silmar.entities.items.weapons.Weapon;
import silmar.entities.items.weapons.WeaponType;
import silmar.entities.terrains.Terrain;
import silmar.entities.terrains.TerrainFactory;
import silmar.entities.terrains.TerrainType;
import silmar.entities.terrains.Terrains;
import silmar.game.Game;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.MapTileDistance;
import silmar.map.effects.DeathFog;
import silmar.map.effects.DragonBreath;
import silmar.map.effects.ElectricityDischarge;
import silmar.map.effects.Fireball;
import silmar.map.effects.MassConfusion;
import silmar.map.effects.MeteorShower;
import silmar.map.effects.PoisonGas;
import silmar.map.effects.Poof;
import silmar.map.effects.PowerDischarge;
import silmar.map.effects.Radiation;
import silmar.map.effects.StunFlash;
import silmar.map.effects.Teleport;
import silmar.map.effects.VisualEffect;
import silmar.map.effects.WebShot;
import silmar.tiles.TileSize;
import silmar.util.ListUtil;
import silmar.util.Random;
import silmar.util.ThreadUtil;

public class Monsters {

    public static class Poltergeist
    extends Monster {
        public boolean isVisible() {
            return false;
        }
    }

    public static class Stalkin
    extends Monster {
        public boolean isVisible() {
            return false;
        }
    }

    public static class Mutivider
    extends Monster {
        public void onRationTheftWorked() {
            MonsterUtil.doCreateMonster(this.map, this.location, this.getType(), MonsterUtil.CreateMonsterReason.generation);
        }
    }

    public static class LivingDeadWizard
    extends Monster {
        private boolean greetedPlayers = false;
        private int firstTurnToAct = 0;

        public void doAct() {
            if (this.getType().equals(MonsterType.livingDeadWizard2)) {
                super.doAct();
                return;
            }
            if (this.firstTurnToAct == 0) {
                Game game = Game.getCurrentGame();
                this.firstTurnToAct = game.getTurn();
            }
            if (!this.greetedPlayers) {
                PlayerUtil.doSendMessageToPlayersInLOS(this.map, this.location, "Syrilboltus: \"Meddlesome adventurer...");
                PlayerUtil.doSendMessageToPlayersInLOS(this.map, this.location, "Your invasion into my sanctuary ends here!\"");
                this.greetedPlayers = true;
            }
            super.doAct();
        }

        protected void doDie(Damage damage) {
            if (this.getType().equals(MonsterType.livingDeadWizard2)) {
                super.doDie(damage);
                return;
            }
            Terrain throne = this.map.getTerrainOfType(TerrainType.throne);
            if (throne != null) {
                Terrain terrain = TerrainFactory.doCreateTerrain(TerrainType.downExit);
                MapPixelLocation throneLocation = throne.getLocation();
                this.map.doAddEntity((MapEntity)terrain, new MapPixelLocation(throneLocation.x + TileSize.tileSize.width, throneLocation.y));
            }
            String message = "Syrilboltus screams in rage, \"You will yet perish by my wrath!\"";
            PlayerUtil.doSendMessageToPlayersInLOS(this.map, this.location, message);
            ThreadUtil.doSleep(3000L);
            Map map = this.map;
            super.doDie(damage);
            Teleport.doTeleport(map, this.location, true, false);
            Teleport.doTeleport(map, this.location, false, false);
        }

        protected void doAffectDamage(Damage damage) {
            DamageUtil.doAffectForm(DamageForm.electricity, damage, 0.0f);
            DamageUtil.doAffectForm(DamageForm.deathFog, damage, 0.25f);
        }

        protected boolean doUsePreMovementPower(Player player) {
            Game game = Game.getCurrentGame();
            if (!(player.isConfused() || game.getTurn() != this.firstTurnToAct && Random.getInt(1, 5) != 1)) {
                MassConfusion.doConfusion(this.map, this.location, this.getPowerRating(), false);
                return true;
            }
            if (Random.getInt(1, 4) == 1 && MapPixelLocationUtil.getDistance((MapPixelLocation)this.location, (MapPixelLocation)player.getLocation()).distance >= 3 * TileSize.tileSize.width) {
                PowerDischarge.doDischarge(this.map, this.location);
                MeteorShower.doShower(this.map, this.location, false, this.getPowerRating() / 2);
                return true;
            }
            return false;
        }
    }

    public static class LivingDeadWizard2
    extends LivingDeadWizard {
        protected void doDie(Damage damage) {
            Map map = this.getMap();
            MapPixelLocation location = this.getLocation();
            PlayerUtil.doSendMessageToPlayersInLOS(map, location, "Syrilboltus screams, \"No... This cannot be!!!\"");
            int strength = 5;
            MapPixelLocation spot = new MapPixelLocation(location);
            int dx = TileSize.tileSize.width;
            int dy = TileSize.tileSize.height;
            spot.translate(-dx, -dy);
            Fireball.doFireball(map, null, spot, 5);
            spot.translate(2 * dx, 2 * dy);
            Fireball.doFireball(map, null, spot, 5);
            spot.translate(0, -2 * dy);
            Fireball.doFireball(map, null, spot, 5);
            spot.translate(-2 * dx, 2 * dy);
            Fireball.doFireball(map, null, location, 5);
            super.doDie(damage);
            ArrayList monsters = new ArrayList(map.getMonstersInLOS(location, null));
            while (!monsters.isEmpty()) {
                Monster monster = (Monster)ListUtil.doRemoveRandomElement(monsters);
                while (!monster.isDead()) {
                    Fireball.doFireball(map, null, monster.getLocation(), 5);
                }
            }
            ArrayList terrains = new ArrayList(map.getTerrainsInLOS(location, null));
            while (!terrains.isEmpty()) {
                Terrain terrain = (Terrain)ListUtil.doRemoveRandomElement(terrains);
                if (!terrain.isOfType(TerrainType.machinery2) && !terrain.isOfType(TerrainType.bones)) continue;
                MapPixelLocation terrainLocation = terrain.getLocation();
                map.doRemoveEntity(terrain);
                Fireball.doFireball(map, null, terrainLocation, 5);
            }
            ThreadUtil.doSleep(4000L);
            Sound.gameFinished.doPlay();
            ThreadUtil.doSleep(5000L);
            Game game = Game.getCurrentGame();
            List players = game.getPlayers();
            int numPlayers = players.size();
            for (int i = 0; i < numPlayers; ++i) {
                Player player = (Player)players.get(i);
                player.onGameFinished();
            }
            game.onFinished();
        }
    }

    public static class GammaVampire
    extends Vampire {
        protected boolean doUsePreMovementPower(Player player) {
            if (Random.getInt(1, 2) == 1) {
                Radiation.doRadiation(this.map, this.location);
            }
            return false;
        }
    }

    public static class Vampire
    extends Monster {
        private static final MapPixelDistance minDistanceToBecomeBat = new MapPixelDistance(MonsterType.vampire.getMovementPoints() * TileSize.tileSize.width * 2);
        private Bat bat = new Bat();

        public void onDrainStrikeWorked() {
            this.onHealedFully();
        }

        public void doAct() {
            if (this.getHitPoints() < this.getMaxHitPoints()) {
                this.doTakeHealing(3);
            }
            if (!this.bat.get()) {
                Player player = this.map.getNearestPlayer(this.location);
                if (player != null) {
                    if (!MapPixelLocationUtil.isDistanceAtMost(this.location, player.getLocation(), minDistanceToBecomeBat)) {
                        this.bat.set(true);
                    } else if (this.getHitPoints() <= this.getMaxHitPoints() / 4) {
                        this.bat.set(true);
                        this.fleeing.set(true);
                        this.fleeFromPlayer = player;
                    }
                }
            } else {
                Player player;
                if (this.fleeing.get() && this.getHitPoints() > this.getMaxHitPoints() / 2) {
                    this.fleeing.set(false);
                }
                if (!this.fleeing.get() && this.activated.get() && (player = this.map.getNearestPlayer(this.location)) != null && MapPixelLocationUtil.isDistanceAtMost(this.location, player.getLocation(), minDistanceToBecomeBat)) {
                    this.bat.set(false);
                }
            }
            super.doAct();
        }

        public String getImageName() {
            return this.bat.get() ? "monsters/" + MonsterType.bat.getImageName() : super.getImageName();
        }

        public int getMaxMovementPoints() {
            return this.bat.get() ? MonsterType.bat.getMovementPoints() : super.getMaxMovementPoints();
        }

        public MovementType getMovementType() {
            return this.bat.get() ? MonsterType.bat.getMovementType() : super.getMovementType();
        }

        public Dimension getSize() {
            return this.bat.get() ? MonsterType.bat.getSize() : super.getSize();
        }

        private class Bat
        implements Serializable {
            private boolean bat = false;

            private Bat() {
            }

            public boolean get() {
                return this.bat;
            }

            private void set(boolean value) {
                if (value == this.bat) {
                    return;
                }
                this.bat = value;
                Poof.doPoof(Vampire.this.map, Vampire.this.location, Vampire.this.getSize());
                Vampire.this.onImageToChange();
                Vampire.this.map.onEntityChangedAppearance(Vampire.this);
            }
        }
    }

    public static class Gremlin
    extends Monster {
        public void onItemSwiped() {
            Teleport.doTeleport(this.map, this.location, true, false);
            this.map.doRemoveEntity(this);
        }
    }

    public static class Munchkin
    extends Monster {
        public void onNoRationsLeft(Player player) {
            this.fleeFromPlayer = player;
            this.fleeing.set(true);
        }

        public void onItemSwiped() {
            Teleport.doTeleport(this.map, this.location, true, false);
            this.map.doRemoveEntity(this);
        }
    }

    public static class TransparentGelatinoid
    extends Monster {
        protected void doAffectDamage(Damage damage) {
            DamageUtil.doAffectForm(DamageForm.electricity, damage, 0.0f);
        }

        public boolean isVisible() {
            return false;
        }
    }

    public static class Slime
    extends Monster {
        public void onDamaged(Damage damage) {
            if (damage.weapon != null && !damage.weapon.getWeaponType().isRanged()) {
                damage.weapon.onStruckSlime();
            }
        }
    }

    public static class KillerTree
    extends Monster {
        protected void doAffectDamage(Damage damage) {
            DamageUtil.doAffectForm(DamageForm.fire, damage, 2.0f);
        }
    }

    public static class Mummy
    extends Monster {
        protected void doAffectDamage(Damage damage) {
            DamageUtil.doAffectAttacks(damage, 0.5f);
        }
    }

    public static class FerrousGolem
    extends Monster {
        public void onInDeathFog(int strength) {
        }

        public boolean isAffectedByFire() {
            return false;
        }

        protected void doAffectDamage(Damage damage) {
            this.doHealFromForm(DamageForm.fire, damage, 1.0f);
            if (!damage.form.equals(DamageForm.crushing)) {
                DamageUtil.doAffectNonAttacks(damage, 0.0f);
            }
        }

        protected boolean doUsePreMovementPower(Player player) {
            int interval = 7;
            Game game = Game.getCurrentGame();
            if ((game.getTurn() + this.map.getMonsters().indexOf(this)) % 7 == 0) {
                DeathFog.doFog(this.map, this.location, this.getPowerRating());
                return true;
            }
            return false;
        }

        public boolean isAffectedByDeathFog() {
            return false;
        }
    }

    public static class FloatingSpheroid
    extends Monster {
        protected void doDie(Damage damage) {
            Map map = this.getMap();
            MapPixelLocation location = this.getLocation();
            super.doDie(damage);
            Fireball.doFireball(map, null, location, 6);
        }
    }

    public static class DreadedPansy
    extends Monster {
        public void onDamaged(Damage damage) {
            if (this.getHitPoints() > 0) {
                BeingUtil.doTeleportRandomlyWithinMap(this, this.getMap());
            }
        }
    }

    public static class Visculoid
    extends Monster {
        public void onDamaged(Damage damage) {
            if (this.getHitPoints() >= 2 && !damage.form.equals(DamageForm.fire)) {
                this.doSplit();
            }
        }
    }

    public static class MirroredArmor
    extends Monster {
        public void onDamaged(Damage damage) {
            Player player;
            if (this.getHitPoints() > 0 && (player = this.map.getNearestPlayerInLOS(this.location)) != null) {
                MapPixelDistance distance = MapPixelLocationUtil.getDistance(this.location, player.getLocation());
                int maxDistance = 10 * TileSize.tileSize.width;
                ElectricityDischarge.doDischarge(this.map, this.location, player.getLocation(), this.getPowerRating(), Math.max(1, (int)((float)damage.amount * ((float)(maxDistance - distance.distance) / (float)maxDistance))));
            }
        }
    }

    public static class Maniac
    extends LightSourceMonster {
        public void onDamaged(Damage damage) {
            if (this.getHitPoints() > 0 && !this.getType().equals(MonsterType.maniacEnraged)) {
                this.setType(MonsterType.maniacEnraged);
                PlayerUtil.doSendMessageToPlayersInLOS(this.map, this.location, "enraged!");
            }
        }
    }

    public static class MoldySkeleton
    extends Monster {
        public void onDamaged(Damage damage) {
            PoisonGas.doGas(this.map, this.location, this.getPowerRating(), new MapTileDistance(2));
        }
    }

    public static class RedDragon
    extends Monster {
        protected void doAffectDamage(Damage damage) {
            DamageUtil.doAffectForm(DamageForm.fire, damage, 0.0f);
        }

        public boolean isAffectedByFire() {
            return false;
        }

        protected boolean doUsePreMovementPower(Player player) {
            MapTileDistance maxRange = new MapTileDistance(11);
            if (this.getHitPoints() >= this.getMaxHitPoints() / 4 && Random.getInt(1, 2) == 1 && MapPixelLocationUtil.isDistanceAtMost(this.location, player.getLocation(), new MapPixelDistance(maxRange))) {
                DragonBreath.doBreath(this.map, this.location, player.getLocation(), DamageForm.fire, maxRange, this.getPowerRating(), this.getHitPoints(), this);
                return true;
            }
            return false;
        }
    }

    public static class Atoman
    extends LightSourceMonster {
        public boolean isAffectedByFire() {
            return false;
        }

        protected void doAffectDamage(Damage damage) {
            DamageUtil.doAffectForm(DamageForm.fire, damage, 0.0f);
            Weapon weapon = damage.weapon;
            if (damage.amount > 0 && weapon != null && weapon.getType().isMetal()) {
                damage.amount = 0;
                Being foe = damage.foe;
                if (foe.isPlayer()) {
                    ((Player)foe).onMessage("The atoman appears to be unaffected by metal weapons.", Player.MessageType.status);
                }
            }
        }

        protected void onAttackHitPlayer(Player player, MonsterAttack attack, int hitBy) {
            MapPixelLocation location = player.getLocation();
            Terrain fire = TerrainFactory.doCreateTerrain(TerrainType.fire);
            this.map.doAddEntity((MapEntity)fire, location);
        }
    }

    public static class Dragonman
    extends Monster {
        protected void doAffectDamage(Damage damage) {
            DamageUtil.doAffectForm(DamageForm.fire, damage, 0.0f);
        }

        public boolean isAffectedByFire() {
            return false;
        }

        protected boolean doUsePreMovementPower(Player player) {
            MapTileDistance maxRange = new MapTileDistance(4);
            if (MapPixelLocationUtil.isDistanceAtMost(this.location, player.getLocation(), new MapPixelDistance(maxRange)) && Random.getInt(1, 5) <= 2) {
                DragonBreath.doBreath(this.map, this.location, player.getLocation(), DamageForm.fire, maxRange, this.getPowerRating(), this.getHitPoints(), this);
                return true;
            }
            return false;
        }
    }

    public static class Doppleganger
    extends Monster {
        private String imageName;

        public void doAct() {
            if (this.imageName == null) {
                List types = TalkerBeingType.types;
                int index = Random.getInt(0, types.size() - 1);
                this.imageName = "beings/" + ((TalkerBeingType)types.get(index)).getImageName();
                this.onImageToChange();
                this.getMap().onEntityChangedAppearance(this);
            }
            super.doAct();
        }

        public String getImageName() {
            return this.imageName != null ? this.imageName : super.getImageName();
        }
    }

    public static class Casket
    extends Monster {
        private int turnActivated;
        private boolean wasActivated = false;

        public void doAct() {
            if (!this.wasActivated && this.isActivated()) {
                Game game = Game.getCurrentGame();
                this.turnActivated = game.getTurn();
                this.wasActivated = true;
            }
            super.doAct();
        }

        protected boolean doUsePreMovementPower(Player player) {
            int turnsUntilGeneration = 5;
            Game game = Game.getCurrentGame();
            if (this.turnActivated != 0 && game.getTurn() - this.turnActivated >= 5) {
                MonsterUtil.doCreateMonster(this.map, this.location, MonsterType.killerCorpse, MonsterUtil.CreateMonsterReason.generation);
                this.map.doRemoveEntity(this);
                return true;
            }
            return false;
        }
    }

    public static class Hider
    extends Monster {
        private boolean visible = false;

        public void onDamaged(Damage damage) {
            this.doBecomeVisible();
            super.onDamaged(damage);
        }

        protected void onMadeAttack(MonsterAttack attack) {
            this.doBecomeVisible();
            super.onMadeAttack(attack);
        }

        protected void doBecomeVisible() {
            if (this.visible) {
                return;
            }
            this.visible = true;
            this.onImageToChange();
            this.getMap().onEntityChangedAppearance(this);
        }

        public String getImageName() {
            return this.visible ? super.getImageName() : null;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }

    public static class Troll
    extends Monster {
        public static final int regenerationRate = 3;

        public void doAct() {
            if (this.getHitPoints() < this.getMaxHitPoints()) {
                this.doTakeHealing(3);
            }
            super.doAct();
        }

        protected void doDie(Damage damage) {
            if (!damage.form.equals(DamageForm.fire) && !damage.form.equals(DamageForm.explosion)) {
                Terrains.TrollCarcass carcass = (Terrains.TrollCarcass)TerrainFactory.doCreateTerrain(TerrainType.trollCarcass);
                carcass.setTroll(this);
                this.map.doAddEntity((MapEntity)carcass, this.location);
            }
            super.doDie(damage);
        }
    }

    public static class Warlock
    extends LightSourceMonster {
        protected boolean doUsePreMovementPower(Player player) {
            if (MapPixelLocationUtil.isDistanceAtMost(this.location, player.getLocation(), new MapPixelDistance(4 * TileSize.tileSize.width))) {
                MapEntityUtil.doTeleportNearPlayers(this);
                return true;
            }
            if (this.getHitPoints() <= this.getMaxHitPoints() / 2) {
                this.doTakeHealing(this.getMaxHitPoints() - this.getHitPoints());
                return true;
            }
            return false;
        }
    }

    public static class Medusa
    extends Monster {
        protected boolean doUsePreMovementPower(Player player) {
            if (Random.getInt(1, 5) <= 2 && !player.isParalyzed()) {
                PowerDischarge.doDischarge(this.map, this.location);
                player.onMedusaGaze(this.getPowerRating());
                return true;
            }
            return false;
        }

        protected void doDie(Damage damage) {
            List players = this.map.getPlayers();
            int numPlayers = players.size();
            for (int i = 0; i < numPlayers; ++i) {
                Player player = (Player)players.get(i);
                player.onMedusaDeath();
            }
            super.doDie(damage);
        }
    }

    public static class Hulkster
    extends Monster {
        protected boolean doUsePreMovementPower(Player player) {
            if (!player.isConfused() && Random.getInt(1, 5) <= 2) {
                PowerDischarge.doDischarge(this.map, this.location);
                player.onHulksterGaze(this.getPowerRating());
                return true;
            }
            return false;
        }
    }

    public static class DarkKnight
    extends Monster {
        protected boolean doUsePreMovementPower(Player player) {
            if (Random.getInt(1, 5) == 1) {
                MapPixelLocation to = Fireball.getSkeweredTargetLocation(this.map, this.location, player.getLocation(), new MapPixelDistance(3 * TileSize.tileSize.width));
                Fireball.doFireball(this.map, this.location, to, 10);
                return true;
            }
            return false;
        }
    }

    public static class GiantAnt
    extends Monster {
        protected boolean doUsePreMovementPower(Player player) {
            if (Random.getInt(1, 4) == 1) {
                MonsterUtil.doCreateMonster(this.map, this.location, this.getType(), MonsterUtil.CreateMonsterReason.summoning);
                return true;
            }
            return false;
        }
    }

    public static class Grave
    extends Generator {
        protected MonsterType getGenerateType() {
            return MonsterType.giantZombie;
        }

        protected int getInterval() {
            return 5;
        }
    }

    public static class Bones
    extends Generator {
        protected MonsterType getGenerateType() {
            return MonsterType.moldySkeleton;
        }

        protected int getInterval() {
            return 3;
        }
    }

    public static abstract class Generator
    extends Monster {
        protected static final MapPixelDistance playerProximityForGeneration = new MapPixelDistance(25 * TileSize.tileSize.width);

        protected boolean doUsePreMovementPower(Player player) {
            if (player == null || !this.map.getCanSee(this.location, player.getLocation(), TileSize.tileSize.width, false, false, null, null)) {
                if (player == null && (player = this.map.getNearestPlayer(this.location)) == null) {
                    return true;
                }
                if (!this.map.getAdjacencyMap().getPathExists((MapPixelLocation)this.location, (MapPixelLocation)player.getLocation(), (MapPixelDistance)Generator.playerProximityForGeneration, (boolean)true).pathExists) {
                    this.activated.set(false);
                    return true;
                }
            }
            return MonsterUtil.doGenerateMonster(this.map, this.location, this.getGenerateType(), this.getInterval());
        }

        protected abstract MonsterType getGenerateType();

        protected abstract int getInterval();
    }

    public static class Vortex
    extends Generator {
        protected MonsterType getGenerateType() {
            return MonsterType.ghost;
        }

        protected int getInterval() {
            return 2;
        }
    }

    public static class GiantSpider
    extends Monster {
        protected boolean doUsePreMovementPower(Player player) {
            if (Random.getInt(1, 3) == 1 && !player.isStuckInWebs()) {
                MapPixelLocation playerLocation = player.getLocation();
                MapPixelDistance range = MapPixelLocationUtil.getDistance(this.location, playerLocation);
                if (range.distance <= TileSize.tileSize.width * 8) {
                    MapPixelDistance maxSkewer = range;
                    maxSkewer.distance /= 6;
                    MapPixelLocation to = Fireball.getSkeweredTargetLocation(this.map, this.location, playerLocation, maxSkewer);
                    WebShot.doShot(this.map, this.location, to, this);
                    return true;
                }
            }
            return false;
        }
    }

    public static class Grenadier
    extends LightSourceMonster {
        protected boolean doUsePreMovementPower(Player player) {
            MapPixelDistance minRange = new MapPixelDistance(2 * TileSize.tileSize.width);
            MapPixelDistance maxRange = new MapPixelDistance(5 * TileSize.tileSize.width);
            MapPixelDistance range = MapPixelLocationUtil.getDistance(this.location, player.getLocation());
            if (Random.getInt(1, 5) < 4 && range.distance >= minRange.distance && range.distance <= maxRange.distance) {
                Fireball.doFireball(this.map, this.location, player.getLocation(), 4);
                return true;
            }
            return false;
        }
    }

    public static class Cetharg
    extends Monster {
        protected boolean doUsePreMovementPower(Player player) {
            int strength = this.getPowerRating();
            if (player != null && !player.isParalyzed() && Random.getInt(1, 4) == 1 && MapPixelLocationUtil.isDistanceAtMost(this.location, player.getLocation(), new MapPixelDistance(strength * TileSize.tileSize.width))) {
                PowerDischarge.doDischarge(this.map, this.location);
                StunFlash.doFlash(this.map, this.location, strength, this);
                return true;
            }
            return false;
        }
    }

    public static class RobotGenerator
    extends Monster {
        protected boolean doUsePreMovementPower(Player player) {
            if (Game.getCurrentGame().getTurn() % 4 == 0) {
                this.map.onSoundIssued(Sound.robotGenerator, this.location, true);
                ThreadUtil.doSleep(1000L);
                MonsterUtil.doCreateMonster(this.map, this.location, Random.getBoolean() ? MonsterType.sentryborg : MonsterType.deathbot, MonsterUtil.CreateMonsterReason.generation);
                return true;
            }
            return false;
        }

        protected void doDie(Damage damage) {
            Map map = this.getMap();
            MapPixelLocation location = new MapPixelLocation(this.getLocation());
            super.doDie(damage);
            Monster wizard = MonsterFactory.doCreateMonster(MonsterType.livingDeadWizard2);
            MapPixelLocation wizardLocation = map.getNearbyPassibleRectangleLocation(location, wizard.getSize(), this.type.getMovementType(), new MapPixelDistance(3 * TileSize.tileSize.width));
            if (wizardLocation == null) {
                wizardLocation = location;
            }
            VisualEffect lastFrame = Teleport.doTeleport(map, wizardLocation, true, true);
            map.doAddEntity((MapEntity)wizard, wizardLocation);
            map.doRemoveEntity(lastFrame);
            Teleport.doTeleport(map, wizardLocation, false, false);
            String[] greeting = new String[]{"Syrilboltus towers above you and bellows", "\"You have destroyed my precious machine!", "This time you shall face my full might...", "And once I have dispensed with you,", "I will wreak my vengeance upon the lands", "and establish my rule, which will be without end!\""};
            for (int i = 0; i < greeting.length; ++i) {
                PlayerUtil.doSendMessageToPlayersInLOS(map, location, greeting[i]);
                ThreadUtil.doSleep(3000L);
            }
        }
    }

    public static class Blob
    extends Monster {
        protected void doAffectDamage(Damage damage) {
            damage.amount = 1;
        }

        public void onDamaged(Damage damage) {
            if (damage.foe != null && damage.weapon != null && !damage.weapon.isOfType(WeaponType.hand) && !damage.weapon.getWeaponType().isRanged()) {
                damage.foe.onStruckBlobWithWeapon(damage.weapon, this.getPowerRating() / 2);
            }
        }
    }

    public static class Assassin
    extends Hider {
        protected void onAttackHitPlayer(Player player, MonsterAttack attack, int hitBy) {
            if (!this.isVisible()) {
                int damage = Random.getInt(attack.getMinDamage() * 3, attack.getMaxDamage() * 3);
                player.onHitByAssassinationBlow(damage, DamageForm.pierce);
            }
            super.onAttackHitPlayer(player, attack, hitBy);
        }

        protected int getToHitModifier(Player player, MonsterAttack attack) {
            if (!this.isVisible()) {
                return 6;
            }
            return super.getToHitModifier(player, attack);
        }
    }

    public static class AcidDragon
    extends Monster {
        protected boolean doUsePreMovementPower(Player player) {
            MapTileDistance maxRange = new MapTileDistance(9);
            if (this.getHitPoints() >= this.getMaxHitPoints() / 4 && MapPixelLocationUtil.isDistanceAtMost(this.location, player.getLocation(), new MapPixelDistance(maxRange)) && Random.getInt(1, 5) <= 2) {
                DragonBreath.doBreath(this.map, this.location, player.getLocation(), DamageForm.acid, maxRange, this.getPowerRating(), this.getHitPoints(), this);
                return true;
            }
            return false;
        }
    }

    public static class LightSourceMonster
    extends Monster
    implements LightSource {
        public boolean isEmittingLight() {
            return true;
        }

        public MapPixelDistance getLightRadius() {
            return this.type.getLightRadius();
        }

        public boolean isLightSource() {
            return true;
        }
    }
}

