/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings.monsters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import silmar.Sound;
import silmar.entities.MapEntity;
import silmar.entities.beings.Alignment;
import silmar.entities.beings.MovementType;
import silmar.entities.beings.attacks.PenetrationType;
import silmar.entities.beings.monsters.MonsterAttack;
import silmar.entities.beings.monsters.MonsterFactory;
import silmar.entities.types.EntityType;
import silmar.map.Map;
import silmar.map.MapLevel;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapTileDistance;
import silmar.tiles.Tile;

public final class MonsterType
extends EntityType {
    private int powerRating;
    private Alignment alignment;
    private int experienceValue;
    private boolean stationary;
    private int movementPoints;
    private int[] defenses;
    private boolean livingDead;
    private MonsterAttack[] meleeAttacks;
    private MonsterAttack[] rangedAttacks;
    private int rangedAttackFrequency;
    private MapLevel[] validLevels;
    private MovementType movementType;
    private int weaponPlusNeededToHit;
    private int avoidanceModifier;
    private boolean lessVulnerableToEdgedWeapons;
    private boolean mustSeePlayerToUsePower = true;
    private Sound sound;
    private float soundFrequency;
    private MapPixelDistance lightRadius;
    public static final List types = new ArrayList();
    public static final HashMap typesMap = new HashMap();
    protected static MapLevel[] dungeon1Levels1 = new MapLevel[]{MapLevel.dungeonA1, MapLevel.dungeonA2};
    protected static MapLevel[] dungeon1Levels2 = new MapLevel[]{MapLevel.dungeonA2, MapLevel.swamp1};
    protected static MapLevel[] swampLevels1 = new MapLevel[]{MapLevel.swamp1, MapLevel.swamp2};
    protected static MapLevel[] swampLevels2 = new MapLevel[]{MapLevel.swamp2, MapLevel.city};
    protected static MapLevel[] cityLevels = new MapLevel[]{MapLevel.city, MapLevel.dungeonB1};
    protected static MapLevel[] dungeon2Levels1 = new MapLevel[]{MapLevel.dungeonB1, MapLevel.dungeonB2};
    protected static MapLevel[] dungeon2Levels2 = new MapLevel[]{MapLevel.dungeonB2, MapLevel.ruins};
    protected static MapLevel[] ruinsLevels = new MapLevel[]{MapLevel.ruins};
    protected static MapLevel[] baseLevels = new MapLevel[]{MapLevel.base, MapLevel.dungeonC};
    protected static MapLevel[] dungeon3Levels = new MapLevel[]{MapLevel.dungeonC, MapLevel.daveDungeon};
    protected static MapLevel[] daveDungeonLevels = new MapLevel[]{MapLevel.daveDungeon, MapLevel.moon};
    protected static MapLevel[] moonLevels = new MapLevel[]{MapLevel.moon};
    public static MonsterType giantRat = new MonsterType(5, "giant rat", "giantRat", 1, Alignment.evil, 1, 4, 3, 0, 0, false, new MonsterAttack[]{MonsterAttack.giantRatBite}, null, 0, dungeon1Levels1, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType bat = new MonsterType(5, "bat", "bat", 1, Alignment.neutral, 1, 8, 2, 2, 2, false, new MonsterAttack[]{MonsterAttack.batBite}, null, 0, dungeon1Levels1, MovementType.flyingNoHands, 0, 0, false, Sound.bat, 1.0f, false);
    public static MonsterType orc = new MonsterType(5, "orc", "orc", 1, Alignment.evil, 3, 3, 4, 0, 0, false, new MonsterAttack[]{MonsterAttack.orcSword}, new MonsterAttack[]{MonsterAttack.orcCrossbow}, 2, dungeon1Levels1, MovementType.walking, 0, 0, false, Sound.orc, 0.33f, false);
    public static MonsterType goblin = new MonsterType(5, "goblin", "goblin", 1, Alignment.evil, 2, 2, 4, 0, 0, false, new MonsterAttack[]{MonsterAttack.goblinSword}, null, 0, dungeon1Levels1, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType skeleton = new MonsterType(5, "skeleton", "skeleton", 1, Alignment.neutral, 2, 4, 3, 3, 3, true, new MonsterAttack[]{MonsterAttack.skeletonSword}, null, 0, dungeon1Levels1, MovementType.walking, 0, 0, true, null, 0.0f, false);
    public static MonsterType reptileMan = new MonsterType(5, "reptile man", "reptileMan", 2, Alignment.neutral, 7, 4, 5, 1, 0, false, new MonsterAttack[]{MonsterAttack.reptileManClaw, MonsterAttack.reptileManClaw, MonsterAttack.reptileManBite}, null, 0, dungeon1Levels2, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType floatingSpheroid = new MonsterType(3, "floating spheroid", "floatingSpheroid", 1, Alignment.neutral, 4, 1, 0, 0, 0, false, new MonsterAttack[]{MonsterAttack.floatingSpheroidBite}, null, 0, dungeon1Levels2, MovementType.flyingNoHands, 0, 0, false, Sound.floatingSpheroid, 1.0f, false);
    public static MonsterType zombie = new MonsterType(5, "zombie", "zombie", 2, Alignment.neutral, 4, 1, 2, 2, 2, true, new MonsterAttack[]{MonsterAttack.zombieRend}, null, 0, dungeon1Levels2, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType slime = new MonsterType(5, "slime", "slime", 2, Alignment.neutral, 8, 1, 1, 1, 1, false, new MonsterAttack[]{MonsterAttack.slimeOoze}, null, 0, dungeon1Levels2, MovementType.walkingNoHands, 0, 0, true, Sound.slime, 1.0f, false);
    public static MonsterType warlock = new MonsterType(5, "warlock", "warlock", 2, Alignment.evil, 8, 4, 3, 0, 0, false, new MonsterAttack[]{MonsterAttack.warlockDagger}, new MonsterAttack[]{MonsterAttack.warlockDarts, MonsterAttack.warlockDarts}, 10, dungeon1Levels2, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType munchkin = new MonsterType(5, "munchkin", "munchkin", 2, Alignment.neutral, 5, 3, 5, 5, 5, false, new MonsterAttack[]{MonsterAttack.munchkinGrab}, null, 0, dungeon1Levels2, MovementType.walking, 0, 0, false, Sound.gremlin, 0.33f, false);
    public static MonsterType cannibal = new MonsterType(5, "cannibal", "cannibal", 1, Alignment.evil, 7, 5, 1, 0, 0, false, new MonsterAttack[]{MonsterAttack.cannibalSpear}, new MonsterAttack[]{MonsterAttack.cannibalBlowgunDart}, 2, swampLevels1, MovementType.walking, 0, 0, false, Sound.cannibal, 0.33f, false);
    public static MonsterType livingDeadPirate = new MonsterType(5, "living dead pirate", "livingDeadPirate", 1, Alignment.evil, 10, 3, 6, 0, 0, true, new MonsterAttack[]{MonsterAttack.livingDeadPirateGrab, MonsterAttack.livingDeadPirateRake}, null, 0, swampLevels1, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType painkiller = new MonsterType(5, "painkiller", "painkiller", 1, Alignment.neutral, 5, 3, 0, 0, 0, false, new MonsterAttack[]{MonsterAttack.painkillerInjection}, null, 0, swampLevels1, MovementType.walkingNoHands, 0, 0, false, null, 0.0f, false);
    public static MonsterType giantAnt = new MonsterType(5, "giant ant", "giantAnt", 2, Alignment.neutral, 4, 4, 4, 2, 2, false, new MonsterAttack[]{MonsterAttack.giantAntBite}, null, 0, swampLevels1, MovementType.walkingNoHands, 0, 0, false, null, 0.0f, false);
    public static MonsterType dreadedPansy = new MonsterType(5, "dreaded pansy", "dreadedPansy", 6, Alignment.neutral, 40, 1, 2, 2, 2, false, null, new MonsterAttack[]{MonsterAttack.dreadedPansyNeedle, MonsterAttack.dreadedPansyNeedle}, 10, swampLevels1, MovementType.walkingNoHands, 0, 0, false, null, 0.0f, true);
    public static MonsterType poisonousSnake = new MonsterType(5, "poisonous snake", "poisonousSnake", 4, Alignment.neutral, 49, 5, 5, 2, 1, false, new MonsterAttack[]{MonsterAttack.poisonousSnakeFangs}, null, 0, swampLevels1, MovementType.walkingNoHands, 0, 0, false, null, 0.0f, false);
    public static MonsterType giantCentipede = new MonsterType(5, "giant centipede", "giantCentipede", 2, Alignment.neutral, 13, 3, 1, 0, 0, false, new MonsterAttack[]{MonsterAttack.giantCentipedeBite}, null, 0, swampLevels1, MovementType.walkingNoHands, 0, 0, false, null, 0.0f, false);
    public static MonsterType ogre = new MonsterType(5, "ogre", "ogre", 4, Alignment.evil, 19, 3, 5, 1, 0, false, new MonsterAttack[]{MonsterAttack.ogreFist}, null, 0, swampLevels2, MovementType.walking, 0, 0, false, Sound.ogre, 0.25f, false);
    public static MonsterType scumShamble = new MonsterType(5, "scum shamble", "scumShamble", 8, Alignment.neutral, 120, 2, 8, 8, 8, false, new MonsterAttack[]{MonsterAttack.scumShambleArm, MonsterAttack.scumShambleArm}, null, 0, swampLevels2, MovementType.walking, 0, 0, false, Sound.scumShamble, 1.0f, false);
    public static MonsterType giantWasp = new MonsterType(5, "giant wasp", "giantWasp", 4, Alignment.neutral, 23, 4, 6, 4, 4, false, new MonsterAttack[]{MonsterAttack.giantWaspBite, MonsterAttack.giantWaspSting}, null, 0, swampLevels2, MovementType.flyingNoHands, 0, 0, false, null, 0.0f, false);
    public static MonsterType weirdThing = new MonsterType(5, "weird thing", "weirdThing", 7, Alignment.neutral, 57, 5, 6, 6, 6, false, null, new MonsterAttack[]{MonsterAttack.weirdThingZap}, 10, swampLevels2, MovementType.walking, 0, 12, false, null, 0.0f, false);
    public static MonsterType killerTree = new MonsterType(3, "killer tree", "killerTree", 7, Alignment.evil, 100, 4, 10, 7, 4, false, new MonsterAttack[]{MonsterAttack.killerTreeLimb, MonsterAttack.killerTreeLimb}, null, 0, swampLevels2, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType giantSpider = new MonsterType(5, "giant spider", "giantSpider", 5, Alignment.evil, 45, 2, 6, 3, 1, false, new MonsterAttack[]{MonsterAttack.giantSpiderBite}, null, 0, swampLevels2, MovementType.walkingNoHands, 0, 0, false, null, 0.0f, false);
    public static MonsterType slimeChucker = new MonsterType(5, "slime chucker", "slimeChucker", 4, Alignment.evil, 40, 2, 1, 0, 0, false, null, new MonsterAttack[]{MonsterAttack.slimeChuckerSlime}, 10, swampLevels2, MovementType.walking, 0, 0, true, Sound.slimeChucker, 1.0f, false);
    public static MonsterType berzerker = new MonsterType(5, "berzerker", "berzerker", 1, Alignment.evil, 3, 5, 3, 0, 0, false, new MonsterAttack[]{MonsterAttack.berzerkerSword, MonsterAttack.berzerkerDagger}, null, 0, cityLevels, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType typhoidZombie = new MonsterType(5, "typhoid zombie", "typhoidZombie", 4, Alignment.evil, 25, 1, 2, 0, 0, true, new MonsterAttack[]{MonsterAttack.typhoidZombieRend}, null, 0, cityLevels, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType gremlin = new MonsterType(5, "gremlin", "gremlin", 2, Alignment.neutral, 10, 5, 8, 8, 8, false, new MonsterAttack[]{MonsterAttack.gremlinSwipe}, null, 0, cityLevels, MovementType.walking, 0, 0, false, Sound.gremlin, 0.33f, false);
    public static MonsterType cyclops = new MonsterType(5, "cyclops", "cyclops", 5, Alignment.evil, 40, 4, 3, 0, 0, false, new MonsterAttack[]{MonsterAttack.cyclopsClub}, null, 0, cityLevels, MovementType.walking, 0, 0, false, Sound.cyclops, 0.25f, false);
    public static MonsterType landShark = new MonsterType(5, "land shark", "landShark", 6, Alignment.neutral, 50, 4, 4, 0, 0, false, new MonsterAttack[]{MonsterAttack.landSharkBite}, null, 0, cityLevels, MovementType.walkingNoHands, 0, 0, false, null, 0.0f, false);
    public static MonsterType blob = new MonsterType(5, "blob", "blob", 5, Alignment.neutral, 100, 1, 0, 0, 0, false, new MonsterAttack[]{MonsterAttack.blobAcid}, null, 0, cityLevels, MovementType.walkingNoHands, 0, 0, false, Sound.blob, 1.0f, false);
    public static MonsterType rogue = new MonsterType(5, "rogue", "rogue", 4, Alignment.evil, 55, 4, 4, 0, 0, false, new MonsterAttack[]{MonsterAttack.rogueDagger}, null, 0, cityLevels, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType transparentGelatinoid = new MonsterType(5, "transparent gelatinoid", null, 4, Alignment.neutral, 23, 2, 2, 2, 2, false, new MonsterAttack[]{MonsterAttack.transparentGelatinoidAcid}, null, 0, dungeon2Levels1, MovementType.walkingNoHands, 0, 0, true, Sound.blob, 1.0f, false);
    public static MonsterType gargoyle = new MonsterType(5, "gargoyle", "gargoyle", 4, Alignment.evil, 28, 4, 5, 2, 1, false, new MonsterAttack[]{MonsterAttack.gargoyleClaw, MonsterAttack.gargoyleClaw, MonsterAttack.gargoyleBite, MonsterAttack.gargoyleTail}, null, 0, dungeon2Levels1, MovementType.flying, 1, 0, false, Sound.bat, 1.0f, false);
    public static MonsterType ruster = new MonsterType(5, "ruster", "ruster", 5, Alignment.neutral, 28, 6, 8, 5, 3, false, new MonsterAttack[]{MonsterAttack.rusterAntenna, MonsterAttack.rusterAntenna}, null, 0, dungeon2Levels1, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType preteg = new MonsterType(5, "preteg", "preteg", 6, Alignment.neutral, 43, 4, 7, 3, 2, false, new MonsterAttack[]{MonsterAttack.pretegClaw}, null, 0, dungeon2Levels1, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType ghoul = new MonsterType(5, "ghoul", "ghoul", 2, Alignment.evil, 25, 3, 4, 0, 0, true, new MonsterAttack[]{MonsterAttack.ghoulClaw, MonsterAttack.ghoulClaw, MonsterAttack.ghoulBite}, null, 0, dungeon2Levels1, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType doppleganger = new MonsterType(5, "doppleganger", null, 4, Alignment.neutral, 43, 4, 5, 0, 0, false, new MonsterAttack[]{MonsterAttack.dopplegangerFist}, null, 0, dungeon2Levels1, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType minotaur = new MonsterType(5, "minotaur", "minotaur", 6, Alignment.evil, 65, 4, 4, 0, 0, false, new MonsterAttack[]{MonsterAttack.minotaurFistHornCombo, MonsterAttack.minotaurFistHornCombo}, null, 0, dungeon2Levels2, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType medusa = new MonsterType(5, "medusa", "medusa", 6, Alignment.evil, 85, 3, 5, 0, 0, false, new MonsterAttack[]{MonsterAttack.medusaSnakes}, null, 0, dungeon2Levels2, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType troll = new MonsterType(5, "troll", "troll", 7, Alignment.evil, 70, 4, 6, 4, 2, false, new MonsterAttack[]{MonsterAttack.trollRake, MonsterAttack.trollBite}, null, 0, dungeon2Levels2, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType negadead = new MonsterType(5, "negadead", "negadead", 4, Alignment.evil, 65, 4, 5, 0, 0, true, new MonsterAttack[]{MonsterAttack.negadeadClaw}, null, 0, dungeon2Levels2, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType ghast = new MonsterType(5, "ghast", "ghast", 4, Alignment.evil, 35, 3, 6, 0, 0, true, new MonsterAttack[]{MonsterAttack.ghastClaw, MonsterAttack.ghastClaw, MonsterAttack.ghastBite}, null, 0, dungeon2Levels2, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType atoman = new MonsterType(5, "atoman", "atoman", 4, Alignment.neutral, 23, 3, 6, 6, 6, false, new MonsterAttack[]{MonsterAttack.atomanFist, MonsterAttack.atomanFist, MonsterAttack.atomanBite}, null, 0, dungeon2Levels2, MovementType.walking, 0, 0, false, Sound.atoman, 0.5f, false);
    public static MonsterType grave = new MonsterType(10, "grave", "grave", 7, Alignment.evil, 68, 1, 0, 0, 0, false, null, null, 0, ruinsLevels, MovementType.walking, 0, 0, true, null, 0.0f, true);
    public static MonsterType giantZombie = new MonsterType(0, "giant zombie", "giantZombie", 8, Alignment.evil, 50, 1, 2, 0, 0, true, new MonsterAttack[]{MonsterAttack.giantZombieBlow}, null, 0, ruinsLevels, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType bones = new MonsterType(10, "pile of bones", "bones", 9, Alignment.evil, 25, 1, 0, 0, 0, false, null, null, 0, ruinsLevels, MovementType.walking, 0, 0, true, null, 0.0f, true);
    public static MonsterType moldySkeleton = new MonsterType(0, "moldy skeleton", "moldySkeleton", 5, Alignment.evil, 30, 2, 4, 4, 4, true, new MonsterAttack[]{MonsterAttack.moldySkeletonRapier}, null, 0, ruinsLevels, MovementType.walking, 0, 0, true, null, 0.0f, false);
    public static MonsterType hydra = new MonsterType(1, "hydra", "hydra", 10, Alignment.neutral, 205, 3, 5, 3, 1, false, new MonsterAttack[]{MonsterAttack.hydraBite, MonsterAttack.hydraBite, MonsterAttack.hydraBite}, null, 0, ruinsLevels, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType vortex = new MonsterType(10, "magical vortex", "vortex", 5, Alignment.evil, 75, 1, 8, 8, 8, false, null, null, 0, ruinsLevels, MovementType.walking, 1, 0, false, null, 0.0f, true);
    public static MonsterType ghost = new MonsterType(0, "ghost", "ghost", 2, Alignment.evil, 20, 3, 10, 10, 10, true, new MonsterAttack[]{MonsterAttack.ghostTouch}, null, 0, ruinsLevels, MovementType.ethereal, 1, 0, false, Sound.ghost, 0.5f, false);
    public static MonsterType casket = new MonsterType(10, "casket", "casket", 7, Alignment.evil, 100, 1, 0, 0, 0, false, null, null, 0, ruinsLevels, MovementType.walking, 0, 0, false, null, 0.0f, true);
    public static MonsterType killerCorpse = new MonsterType(0, "killer corpse", "killerCorpse", 12, Alignment.evil, 475, 2, 4, 0, 0, true, new MonsterAttack[]{MonsterAttack.killerCorpseTouch, MonsterAttack.killerCorpseTouch}, null, 0, ruinsLevels, MovementType.walking, 2, 0, false, Sound.killerCorpse, 0.33f, false);
    public static MonsterType grenadier = new MonsterType(5, "grenadier", "grenadier", 2, Alignment.evil, 60, 4, 3, 3, 1, false, null, new MonsterAttack[]{MonsterAttack.grenadierPistol, MonsterAttack.grenadierPistol, MonsterAttack.grenadierPistol}, 10, baseLevels, MovementType.walking, 0, 0, false, Sound.mercenary, 0.2f, false);
    public static MonsterType maniac = new MonsterType(5, "maniac", "maniac", 2, Alignment.evil, 50, 2, 1, 0, 0, false, new MonsterAttack[]{MonsterAttack.maniacKnife}, null, 0, baseLevels, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType maniacEnraged = new MonsterType(0, "enraged maniac", "maniac", 2, Alignment.evil, 50, 8, 1, 0, 0, false, new MonsterAttack[]{MonsterAttack.maniacKnife, MonsterAttack.maniacKnife, MonsterAttack.maniacKnife, MonsterAttack.maniacKnife}, null, 0, null, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType mercenary = new MonsterType(5, "mercenary", "mercenary", 3, Alignment.evil, 70, 4, 6, 6, 1, false, null, new MonsterAttack[]{MonsterAttack.mercenaryAssaultRifle, MonsterAttack.mercenaryAssaultRifle, MonsterAttack.mercenaryAssaultRifle, MonsterAttack.mercenaryAssaultRifle}, 10, baseLevels, MovementType.walking, 0, 0, false, Sound.mercenary, 0.33f, false);
    public static MonsterType assassin = new MonsterType(5, "assassin", "assassin", 6, Alignment.evil, 40, 4, 3, 0, 0, false, new MonsterAttack[]{MonsterAttack.assassinSword}, null, 0, baseLevels, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType sentryborg = new MonsterType(5, "sentryborg", "sentryborg", 6, Alignment.evil, 80, 4, 7, 7, 7, false, new MonsterAttack[]{MonsterAttack.sentryborgPincer}, new MonsterAttack[]{MonsterAttack.sentryborgStunRay}, 4, baseLevels, MovementType.walking, 1, 0, false, Sound.sentryborg, 0.5f, false);
    public static MonsterType mutivider = new MonsterType(5, "mutivider", "mutivider", 3, Alignment.neutral, 20, 4, 5, 5, 5, false, new MonsterAttack[]{MonsterAttack.mutividerRazorSwipe}, null, 0, baseLevels, MovementType.walking, 0, 0, false, Sound.mutivider, 0.33f, false);
    public static MonsterType mutatedRat = new MonsterType(5, "mutated rat", "mutatedRat", 4, Alignment.neutral, 40, 3, 3, 0, 0, false, new MonsterAttack[]{MonsterAttack.mutatedRatBite}, null, 0, baseLevels, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType redDragon = new MonsterType(1, "young red dragon", "redDragon", 9, Alignment.evil, 300, 3, 11, 9, 7, false, new MonsterAttack[]{MonsterAttack.redDragonClaw, MonsterAttack.redDragonClaw, MonsterAttack.redDragonBite}, null, 0, dungeon3Levels, MovementType.walking, 0, 3, false, Sound.redDragon, 1.0f, false);
    public static MonsterType mummy = new MonsterType(5, "mummy", "mummy", 6, Alignment.evil, 120, 2, 7, 4, 0, true, new MonsterAttack[]{MonsterAttack.mummyArm}, null, 0, dungeon3Levels, MovementType.walking, 1, 0, false, null, 0.0f, false);
    public static MonsterType hulkster = new MonsterType(5, "hulkster", "hulkster", 9, Alignment.evil, 180, 2, 8, 5, 2, false, new MonsterAttack[]{MonsterAttack.hulksterClaw, MonsterAttack.hulksterClaw, MonsterAttack.hulksterMandibles}, null, 0, dungeon3Levels, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType earthElemental = new MonsterType(5, "earth elemental", "earthElemental", 8, Alignment.neutral, 335, 2, 8, 8, 8, false, new MonsterAttack[]{MonsterAttack.earthElementalFist, MonsterAttack.earthElementalFist}, null, 0, dungeon3Levels, MovementType.earthing, 2, 0, false, Sound.earthElemental, 1.0f, false);
    public static MonsterType stalkin = new MonsterType(5, "stalkin", null, 8, Alignment.neutral, 145, 4, 9, 9, 9, false, new MonsterAttack[]{MonsterAttack.stalkinFist}, null, 0, dungeon3Levels, MovementType.walking, 0, 4, false, null, 0.0f, false);
    public static MonsterType vampire = new MonsterType(5, "vampire", "vampire", 8, Alignment.evil, 430, 4, 9, 6, 3, true, new MonsterAttack[]{MonsterAttack.vampireDrainStrike}, null, 0, dungeon3Levels, MovementType.walking, 1, 0, false, null, 0.0f, false);
    public static MonsterType giantWorm = new MonsterType(3, "giant worm", "giantWorm", 12, Alignment.neutral, 500, 2, 4, 2, 1, false, new MonsterAttack[]{MonsterAttack.giantWormBite}, null, 0, dungeon3Levels, MovementType.walking, 0, 0, false, Sound.giantWorm, 1.0f, false);
    public static MonsterType livingDeadWizard = new MonsterType(0, "Syrilboltus", "livingDeadWizard", 16, Alignment.evil, 1400, 2, 10, 7, 4, true, new MonsterAttack[]{MonsterAttack.livingDeadWizardTouch}, null, 0, null, MovementType.walking, 1, 0, false, Sound.livingDeadWizard, 0.4f, false);
    public static MonsterType acidDragon = new MonsterType(1, "acid dragon", "acidDragon", 10, Alignment.evil, 300, 3, 7, 5, 3, false, new MonsterAttack[]{MonsterAttack.acidDragonClaw, MonsterAttack.acidDragonClaw, MonsterAttack.acidDragonBite}, null, 0, daveDungeonLevels, MovementType.walking, 0, 0, false, Sound.acidDragon, 0.33f, false);
    public static MonsterType darkKnight = new MonsterType(5, "dark knight", "darkKnight", 9, Alignment.evil, 450, 4, 10, 3, 3, true, new MonsterAttack[]{MonsterAttack.darkKnightSword, MonsterAttack.darkKnightSword}, null, 0, daveDungeonLevels, MovementType.walking, 0, 10, false, Sound.killerCorpse, 0.33f, false);
    public static MonsterType warpDemon = new MonsterType(4, "warp demon", "warpDemon", 8, Alignment.evil, 350, 4, 10, 7, 4, false, new MonsterAttack[]{MonsterAttack.warpDemonArm, MonsterAttack.warpDemonArm, MonsterAttack.warpDemonArm, MonsterAttack.warpDemonArm, MonsterAttack.warpDemonArm}, null, 0, daveDungeonLevels, MovementType.walking, 2, 12, false, Sound.warpDemon, 1.0f, false);
    public static MonsterType visculoid = new MonsterType(5, "visculoid", "visculoid", 10, Alignment.neutral, 275, 2, 4, 0, 0, false, new MonsterAttack[]{MonsterAttack.visculoidTouch}, null, 0, daveDungeonLevels, MovementType.walkingNoHands, 0, 0, true, Sound.slime, 1.0f, false);
    public static MonsterType ferrousGolem = new MonsterType(2, "ferrous golem", "ferrousGolem", 18, Alignment.neutral, 1400, 2, 7, 7, 7, false, new MonsterAttack[]{MonsterAttack.ferrousGolemSword}, null, 0, daveDungeonLevels, MovementType.walking, 3, 0, false, Sound.ferrousGolem, 1.0f, false);
    public static MonsterType mirroredArmor = new MonsterType(5, "mirrored armor", "mirroredArmor", 14, Alignment.neutral, 700, 3, 10, 1, 1, false, new MonsterAttack[]{MonsterAttack.mirroredArmorRam}, null, 0, daveDungeonLevels, MovementType.walking, 2, 0, false, Sound.mirroredArmor, 1.0f, false);
    public static MonsterType guardianSword = new MonsterType(5, "guardian sword", "guardianSword", 9, Alignment.neutral, 350, 4, 12, 10, 8, false, new MonsterAttack[]{MonsterAttack.guardianSwordSlash}, null, 0, daveDungeonLevels, MovementType.walking, 3, 0, false, Sound.guardianSword, 1.0f, false);
    public static MonsterType gammaVampire = new MonsterType(10, "gamma vampire", "gammaVampire", 10, Alignment.evil, 500, 4, 9, 6, 3, true, new MonsterAttack[]{MonsterAttack.vampireDrainStrike}, null, 0, moonLevels, MovementType.walking, 1, 8, false, null, 0.0f, false);
    public static MonsterType dragonman = new MonsterType(10, "dragonman", "dragonMan", 8, Alignment.evil, 200, 4, 8, 6, 4, false, new MonsterAttack[]{MonsterAttack.dragonmanBite}, null, 0, moonLevels, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType cetharg = new MonsterType(10, "cetharg", "cetharg", 12, Alignment.evil, 400, 3, 11, 11, 11, false, new MonsterAttack[]{MonsterAttack.cethargFist}, null, 0, moonLevels, MovementType.walking, 1, 0, false, Sound.cetharg, 0.5f, false);
    public static MonsterType mutatedWarrior = new MonsterType(10, "mutated warrior", "mutatedWarrior", 8, Alignment.evil, 270, 4, 8, 8, 8, false, new MonsterAttack[]{MonsterAttack.mutatedWarriorSabre, MonsterAttack.mutatedWarriorDagger, MonsterAttack.mutatedWarriorSabre, MonsterAttack.mutatedWarriorDagger}, new MonsterAttack[]{MonsterAttack.mutatedWarriorPistol, MonsterAttack.mutatedWarriorPistol, MonsterAttack.mutatedWarriorPistol, MonsterAttack.mutatedWarriorPistol, MonsterAttack.mutatedWarriorPistol, MonsterAttack.mutatedWarriorPistol}, 4, moonLevels, MovementType.walking, 0, 0, false, null, 0.0f, false);
    public static MonsterType deathbot = new MonsterType(5, "deathbot", "deathbot", 16, Alignment.evil, 1200, 6, 13, 13, 13, false, new MonsterAttack[]{MonsterAttack.deathbotGrasp}, new MonsterAttack[]{MonsterAttack.deathbotRay}, 5, moonLevels, MovementType.walking, 2, 0, false, Sound.deathbot, 1.0f, false);
    public static MonsterType poltergeist = new MonsterType(10, "poltergeist", null, 8, Alignment.evil, 1000, 4, 12, 12, 12, true, new MonsterAttack[]{MonsterAttack.poltergeistTouch}, null, 0, moonLevels, MovementType.ethereal, 2, 0, false, Sound.ghost, 0.33f, false);
    public static MonsterType robotGenerator = new MonsterType(0, "robot generator", "robotGenerator", 16, Alignment.evil, 2000, 1, 7, 7, 7, false, null, null, 0, null, MovementType.walking, 2, 0, false, null, 0.0f, true);
    public static MonsterType livingDeadWizard2 = new MonsterType(0, "neo-Syrilboltus", "livingDeadWizard2", 20, Alignment.evil, 2000, 5, 15, 15, 15, true, null, new MonsterAttack[]{MonsterAttack.livingDeadWizard2VortexBeam, MonsterAttack.livingDeadWizard2VortexBeam}, 8, null, MovementType.walking, 3, 0, false, Sound.livingDeadWizard2, 0.5f, false);

    public MonsterType(int frequency, String name, String imageName, int powerRating, Alignment alignment, int experienceValue, int movementPoints, int defenseNormal, int defenseFirearm, int defenseLaser, boolean livingDead, MonsterAttack[] meleeAttacks, MonsterAttack[] rangedAttacks, int rangedAttackFrequency, MapLevel[] validLevels, MovementType movementType, int weaponPlusNeededToHit, int avoidanceBonus, boolean lessVulnerableToEdgedWeapons, Sound sound, float getSoundFrequency, boolean stationary) {
        super(name, imageName);
        this.frequency = frequency;
        this.powerRating = powerRating;
        this.alignment = alignment;
        this.experienceValue = experienceValue;
        this.movementPoints = movementPoints;
        this.defenses = new int[3];
        this.defenses[PenetrationType.normal.getRank()] = defenseNormal;
        this.defenses[PenetrationType.firearm.getRank()] = defenseFirearm;
        this.defenses[PenetrationType.laser.getRank()] = defenseLaser;
        this.livingDead = livingDead;
        this.meleeAttacks = meleeAttacks;
        this.rangedAttacks = rangedAttacks;
        this.rangedAttackFrequency = rangedAttackFrequency;
        this.validLevels = validLevels;
        this.movementType = movementType;
        this.weaponPlusNeededToHit = weaponPlusNeededToHit;
        this.avoidanceModifier = avoidanceBonus;
        this.lessVulnerableToEdgedWeapons = lessVulnerableToEdgedWeapons;
        this.sound = sound;
        this.soundFrequency = getSoundFrequency;
        this.stationary = stationary;
        this.doDetmSize();
        types.add(this);
        typesMap.put(name, this);
    }

    public boolean equals(MonsterType type) {
        return type == this || type.name.equals(this.name);
    }

    protected boolean isPresenceLocationValid(Map map, MapPixelLocation location) {
        if (map.getFirstBeingAt(location) != null) {
            return false;
        }
        Tile tile = map.getTile(location);
        return tile.isPassible() && !tile.getBlocksLOS();
    }

    public MapEntity doCreateStockInstance() {
        return MonsterFactory.doCreateMonster(this);
    }

    public boolean isValidForMap(Map map) {
        if (this.validLevels == null) {
            return false;
        }
        for (int i = 0; i < this.validLevels.length; ++i) {
            if (!map.getLevel().equals(this.validLevels[i])) continue;
            return true;
        }
        return false;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public int getAvoidanceModifier() {
        return this.avoidanceModifier;
    }

    public int[] getDefenses() {
        return this.defenses;
    }

    public int getExperienceValue() {
        return this.experienceValue;
    }

    public boolean isLessVulnerableToEdgedWeapons() {
        return this.lessVulnerableToEdgedWeapons;
    }

    public boolean isLivingDead() {
        return this.livingDead;
    }

    public MonsterAttack[] getMeleeAttacks() {
        return this.meleeAttacks;
    }

    public MovementType getMovementType() {
        return this.movementType;
    }

    public int getMovementPoints() {
        return this.movementPoints;
    }

    public int getPowerRating() {
        return this.powerRating;
    }

    public int getRangedAttackFrequency() {
        return this.rangedAttackFrequency;
    }

    public MonsterAttack[] getRangedAttacks() {
        return this.rangedAttacks;
    }

    public Sound getSound() {
        return this.sound;
    }

    public MapLevel[] getValidLevels() {
        return this.validLevels;
    }

    public int getWeaponPlusNeededToHit() {
        return this.weaponPlusNeededToHit;
    }

    protected String getImagePath() {
        return "monsters/";
    }

    public boolean isStationary() {
        return this.stationary;
    }

    public boolean getMustSeePlayerToUsePower() {
        return this.mustSeePlayerToUsePower;
    }

    public MapPixelDistance getLightRadius() {
        return this.lightRadius;
    }

    public float getSoundFrequency() {
        return this.soundFrequency;
    }

    static {
        MonsterType.robotGenerator.mustSeePlayerToUsePower = false;
        MonsterType.bones.mustSeePlayerToUsePower = false;
        MonsterType.vortex.mustSeePlayerToUsePower = false;
        MonsterType.grave.mustSeePlayerToUsePower = false;
        MonsterType.casket.mustSeePlayerToUsePower = false;
        MonsterType.cetharg.mustSeePlayerToUsePower = false;
        MonsterType.warlock.lightRadius = new MapPixelDistance(new MapTileDistance(6));
        MonsterType.cannibal.lightRadius = new MapPixelDistance(new MapTileDistance(4));
        MonsterType.berzerker.lightRadius = new MapPixelDistance(new MapTileDistance(6));
        MonsterType.atoman.lightRadius = new MapPixelDistance(new MapTileDistance(2));
        MonsterType.rogue.lightRadius = new MapPixelDistance(new MapTileDistance(6));
        MonsterType.grenadier.lightRadius = new MapPixelDistance(new MapTileDistance(6));
        MonsterType.maniac.lightRadius = new MapPixelDistance(new MapTileDistance(6));
        MonsterType.maniacEnraged.lightRadius = new MapPixelDistance(new MapTileDistance(6));
        MonsterType.mercenary.lightRadius = new MapPixelDistance(new MapTileDistance(6));
    }
}

