/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities.beings;

import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import silmar.Sound;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.entities.beings.MovementType;
import silmar.entities.beings.player.Player;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.effects.PowerDischarge;
import silmar.map.effects.Teleport;
import silmar.map.effects.VisualEffect;
import silmar.tiles.TileSize;
import silmar.util.FloatPoint;
import silmar.util.PointUtil;
import silmar.util.Random;
import silmar.util.ThreadUtil;

public class BeingUtil
implements TileSize {
    public static void doTeleportRandomlyWithinMap(Being being, Map map) {
        MapPixelLocation location = map.getRandomPassibleRectangleLocation(being.getSize());
        if (location == null) {
            return;
        }
        VisualEffect lastFrame = Teleport.doTeleport(map, being.getLocation(), true, true);
        map.doMoveEntity(being, location);
        map.doRemoveEntity(lastFrame);
        Teleport.doTeleport(map, location, false, false);
        if (being instanceof Player) {
            ((Player)being).onTeleported();
        }
    }

    public static void doKnockBeingBack(Being being, Point knockerLocation, int damage, int power) {
        int stepSize = 4;
        MapPixelDistance knockbackDistance = new MapPixelDistance(being.getBaseKnockbackDistance());
        knockbackDistance.distance += power * TileSize.tileSize.width;
        if (knockbackDistance.distance < 1) {
            return;
        }
        MapPixelLocation location = new MapPixelLocation(being.getLocation());
        FloatPoint direction = PointUtil.getUnitVector(knockerLocation, location);
        Map map = being.getMap();
        int numSteps = knockbackDistance.distance / 4;
        for (int i = 0; i < numSteps && !being.isDead(); ++i) {
            location.x = (int)((float)location.x + direction.x * 4.0f);
            location.y = (int)((float)location.y + direction.y * 4.0f);
            Dimension beingSize = being.getSize();
            if (!map.isRectanglePassible((MapPixelLocation)location, (Dimension)beingSize, (MovementType)MovementType.walking, (boolean)true, (MapEntity)being, null, (boolean)false).passible) {
                being.onInKnockBackCollision(damage);
                boolean shouldBreak = true;
                Being closest = null;
                MapPixelDistance closestDistance = null;
                List beings = map.getEntitiesInRectangle(location, beingSize, map.getBeings(), null, being, null, null);
                int numBeings = beings.size();
                for (int j = 0; j < numBeings; ++j) {
                    Being test = (Being)beings.get(j);
                    if (test == being) continue;
                    MapPixelDistance distanceToTest = MapPixelLocationUtil.getDistance(test.getLocation(), location);
                    if (closestDistance != null && distanceToTest.distance >= closestDistance.distance) continue;
                    closest = test;
                    closestDistance = distanceToTest;
                }
                if (closest != null) {
                    closest.onInKnockBackCollision(damage);
                    if (closest.isDead() && map.isRectanglePassible((MapPixelLocation)location, (Dimension)beingSize, (MovementType)MovementType.walking, (boolean)true, (MapEntity)being, null, (boolean)false).passible) {
                        shouldBreak = false;
                    }
                }
                if (shouldBreak) break;
            }
            map.doMoveEntity(being, location);
            ThreadUtil.doSleep(0L, 10);
        }
    }

    public static boolean doLeap(Being being, MapPixelLocation to, int strength, int agility) {
        Map map = being.getMap();
        MapPixelLocation from = being.getLocation();
        Dimension beingSize = being.getSize();
        if (!map.isRectanglePassible((MapPixelLocation)to, (Dimension)beingSize, (MovementType)MovementType.walking, (boolean)true, null, null, (boolean)false).passible || !map.getCanSee(from, to, TileSize.tileSize.width, false, false, null, null)) {
            return false;
        }
        MapPixelDistance maxRange = new MapPixelDistance(strength / 2 * TileSize.tileSize.width);
        MapPixelDistance distance = MapPixelLocationUtil.getDistance(from, to);
        if (distance.distance > maxRange.distance) {
            if (being.isPlayer()) {
                ((Player)being).onMessage("You cannot leap that far");
            }
            return false;
        }
        int roll = Random.getInt(1, 20) + distance.distance / TileSize.tileSize.width / 2;
        int missedBy = roll - agility;
        if (missedBy > 0) {
            MapPixelLocation adjusted;
            MapPixelDistance maxError = new MapPixelDistance(Math.min(distance.distance / 2, missedBy / 2 * TileSize.tileSize.width));
            while ((adjusted = map.getRandomPassibleRectangleLocationInRange(to, being.getSize(), maxError, 50, being.getMovementType(), true)) != null && !map.getCanSee(from, adjusted, TileSize.tileSize.width, false, false, null, null)) {
            }
            if (adjusted != null) {
                to = adjusted;
            }
        }
        PowerDischarge.doDischarge(being);
        map.onSoundIssued(Sound.leap, from);
        map.doMoveEntity(being, to);
        return true;
    }
}

