/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.entities.beings.MovementType;
import silmar.entities.beings.player.Player;
import silmar.entities.terrains.Terrain;
import silmar.map.Map;
import silmar.map.MapPixelDistance;
import silmar.map.MapPixelLocation;
import silmar.map.MapPixelLocationUtil;
import silmar.map.effects.Teleport;
import silmar.tiles.Tile;
import silmar.tiles.TileSize;
import silmar.util.FloatPoint;
import silmar.util.PointUtil;
import silmar.util.ThreadUtil;

public class MapEntityUtil
implements TileSize {
    private static List doMoveTowardsGoal_terrainsOn = new ArrayList();
    private static List doMoveTowardsGoal_terrains = new ArrayList();
    private static MoveTowardsGoalResult doMoveTowardsGoal_result = new MoveTowardsGoalResult();
    private static MapPixelLocation doMoveTowardsGoal_location = new MapPixelLocation();
    private static FloatPoint doMoveTowardsGoal_direction = new FloatPoint();
    private static MapPixelDistance doMoveTowardsGoal_distance = new MapPixelDistance();
    private static FloatPoint doMoveTowardsGoal_current = new FloatPoint();
    private static MapPixelLocation doMoveTowardsGoal_roundedCurrent = new MapPixelLocation();
    private static MapPixelLocation doMoveTowardsGoal_oldLocation = new MapPixelLocation();
    private static FloatPoint doMoveTowardsGoal_save = new FloatPoint();
    private static List doMoveTowardsGoal_Players = new ArrayList();
    public static final int pixelsPerMove = 4;

    public static MoveTowardsGoalResult doMoveTowardsGoal(MapEntity entity, MapPixelLocation goal, float movementPoints, MoveTowardsGoalListener listener) {
        MoveTowardsGoalResult result = doMoveTowardsGoal_result;
        result.doInit();
        if (goal.equals(entity.getLocation())) {
            result.impass = false;
            result.movementPointsLeft = movementPoints;
            result.notEnoughMovementPoints = false;
            return result;
        }
        Map map = entity.getMap();
        MapPixelLocation location = doMoveTowardsGoal_location;
        location.setLocation(entity.getLocation());
        FloatPoint direction = PointUtil.getUnitVector(location, goal, doMoveTowardsGoal_direction);
        direction.x *= 4.0f;
        direction.y *= 4.0f;
        float numMoves = (float)MapPixelLocationUtil.getDistance((MapPixelLocation)location, (MapPixelLocation)goal, (MapPixelDistance)MapEntityUtil.doMoveTowardsGoal_distance).distance / 4.0f;
        float tileFractionPerMove = 4.0f / (float)TileSize.tileSize.width;
        List terrainsOn = doMoveTowardsGoal_terrainsOn;
        map.getEntitiesInRectangle(location, entity.getSize(), map.getTerrains(), null, null, null, terrainsOn);
        FloatPoint current = doMoveTowardsGoal_current;
        current.setLocation(location.x, location.y);
        MapPixelLocation roundedCurrent = doMoveTowardsGoal_roundedCurrent;
        Dimension testRectSize = entity.getSize();
        MapPixelLocation oldLocation = doMoveTowardsGoal_oldLocation;
        oldLocation.setLocation(location);
        MovementType movementType = entity.getMovementType();
        FloatPoint save = doMoveTowardsGoal_save;
        int numIterations = (int)(Math.floor(numMoves) + (double)(numMoves != (float)((int)numMoves) ? 1 : 0));
        float movementPointsUsed = 0.0f;
        long lastTime = System.currentTimeMillis();
        for (int i = 0; i < numIterations; ++i) {
            save.setLocation(current);
            float fraction = numMoves - (float)i;
            if ((double)fraction > 0.0 && (double)fraction < 1.0) {
                current.x += direction.x * fraction;
                current.y += direction.y * fraction;
            } else {
                current.x += direction.x;
                current.y += direction.y;
            }
            roundedCurrent.setLocation(Math.round(current.x), Math.round(current.y));
            float fractionOfStepTaken = 1.0f;
            if (!map.isRectanglePassible((MapPixelLocation)roundedCurrent, (Dimension)testRectSize, (MovementType)movementType, (boolean)true, (MapEntity)entity, null, (boolean)false).passible) {
                boolean canContinue = false;
                if (entity.isPlayer() && numMoves - (float)i >= 1.0f) {
                    current.setLocation(save);
                    current.y += direction.y;
                    roundedCurrent.setLocation(Math.round(current.x), Math.round(current.y));
                    if ((double)Math.abs(direction.y) >= 0.1 && map.isRectanglePassible((MapPixelLocation)roundedCurrent, (Dimension)testRectSize, (MovementType)movementType, (boolean)true, (MapEntity)entity, null, (boolean)false).passible) {
                        canContinue = true;
                        fractionOfStepTaken = direction.y / (direction.x + direction.y);
                    } else {
                        current.setLocation(save);
                        current.x += direction.x;
                        roundedCurrent.setLocation(Math.round(current.x), Math.round(current.y));
                        if ((double)Math.abs(direction.x) >= 0.1 && map.isRectanglePassible((MapPixelLocation)roundedCurrent, (Dimension)testRectSize, (MovementType)movementType, (boolean)true, (MapEntity)entity, null, (boolean)false).passible) {
                            canContinue = true;
                            fractionOfStepTaken = direction.x / (direction.x + direction.y);
                        }
                    }
                }
                if (!canContinue) {
                    result.impass = true;
                    break;
                }
            }
            boolean tileChanged = roundedCurrent.x / TileSize.tileSize.width != location.x / TileSize.tileSize.width || roundedCurrent.y / TileSize.tileSize.height != location.y / TileSize.tileSize.height;
            location.setLocation(roundedCurrent.x, roundedCurrent.y);
            map.doMoveEntity(entity, location);
            entity.doCheckForMovementSound();
            boolean stop = false;
            boolean lastMove = false;
            if (tileChanged) {
                boolean bl = lastMove = (float)i == numMoves - 1.0f;
                if (listener != null && !listener.onMovedOntoNewTile(map.getTile(location)) && !lastMove) {
                    stop = true;
                }
            }
            if ((movementPointsUsed += (float)map.getMovementCost(location) * tileFractionPerMove * fractionOfStepTaken) >= movementPoints && !lastMove) {
                result.notEnoughMovementPoints = true;
                stop = true;
            }
            List terrains = doMoveTowardsGoal_terrains;
            map.getEntitiesInRectangle(location, entity.getSize(), map.getTerrains(), null, null, null, terrains);
            int numTerrains = terrains.size();
            for (int j = 0; j < numTerrains; ++j) {
                Terrain terrain = (Terrain)terrains.get(j);
                if (terrainsOn.contains(terrain)) continue;
                terrainsOn.add(terrain);
                if (entity.isBeing() && terrain.onBeingArrival((Being)entity)) {
                    stop = true;
                }
                if (listener == null || listener.onAtTerrain(terrain)) continue;
                stop = true;
            }
            int numTerrainsOn = terrainsOn.size();
            for (int j = 0; j < numTerrainsOn; ++j) {
                Terrain terrain = (Terrain)terrainsOn.get(j);
                if (terrains.contains(terrain)) continue;
                terrainsOn.remove(j--);
                --numTerrainsOn;
            }
            if (listener != null && !listener.getShouldContinue(oldLocation)) {
                stop = true;
            }
            oldLocation.setLocation(location);
            boolean isPlayer = entity.isPlayer();
            if (isPlayer || !map.getPlayersInLOS(location, doMoveTowardsGoal_Players).isEmpty()) {
                int minimumStepTime;
                long newTime = System.currentTimeMillis();
                long delta = newTime - lastTime;
                lastTime = newTime;
                int n = minimumStepTime = isPlayer ? 25 : 15;
                if (delta < (long)minimumStepTime) {
                    ThreadUtil.doSleep((long)minimumStepTime - delta);
                }
            }
            if (stop) break;
        }
        result.movementPointsLeft = movementPoints - movementPointsUsed;
        return result;
    }

    public static void doTeleportNearPlayers(MapEntity entity) {
        MapPixelLocation test;
        Map map = entity.getMap();
        MapPixelLocation location = entity.getLocation();
        MapPixelDistance maxDistance = new MapPixelDistance(10 * TileSize.tileSize.width);
        MapPixelDistance minDistanceToPlayer = new MapPixelDistance(6 * TileSize.tileSize.width);
        for (int i = 0; i < 30 && (test = map.getRandomPassibleRectangleLocationInRange(location, entity.getSize(), maxDistance, 50, entity.getMovementType(), true)) != null; ++i) {
            Player player = map.getNearestPlayerInLOS(test);
            if (player != null && MapPixelLocationUtil.isDistanceAtMost(test, player.getLocation(), minDistanceToPlayer)) continue;
            Teleport.doTeleport(map, location, true, false);
            map.doMoveEntity(entity, test);
            Teleport.doTeleport(map, test, false, false);
            break;
        }
    }

    public static interface MoveTowardsGoalListener {
        public boolean onMovedOntoNewTile(Tile var1);

        public boolean onAtTerrain(Terrain var1);

        public boolean getShouldContinue(MapPixelLocation var1);
    }

    public static class MoveTowardsGoalResult {
        public boolean impass;
        public boolean notEnoughMovementPoints;
        public float movementPointsLeft;

        public MoveTowardsGoalResult() {
            this.doInit();
        }

        public void doInit() {
            this.impass = false;
            this.notEnoughMovementPoints = false;
            this.movementPointsLeft = 0.0f;
        }
    }
}

