/*
 * Decompiled with CFR 0.152.
 */
package silmar.entities;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Serializable;
import silmar.Images;
import silmar.Sound;
import silmar.entities.beings.MovementType;
import silmar.map.Map;
import silmar.map.MapPixelLocation;
import silmar.map.MapTileLocation;
import silmar.tiles.TileSize;
import silmar.tiles.TileSizeUtil;
import silmar.util.RectangleUtil;

public abstract class MapEntity
implements Serializable,
TileSize {
    static final long serialVersionUID = 4680769021145295914L;
    protected Map map;
    protected final MapPixelLocation location = new MapPixelLocation();
    protected final Bounds bounds = new Bounds();
    protected transient int movementSoundCounter = 0;
    protected int movementSoundInterval = 0;
    private transient Image image;

    public void doAct() {
    }

    public final Map getMap() {
        return this.map;
    }

    public boolean isLightSource() {
        return false;
    }

    public abstract Dimension getSize();

    public boolean getContains(MapPixelLocation location) {
        return this.bounds.get().contains(location);
    }

    public final MapPixelLocation getLocation() {
        return this.location;
    }

    public void setLocation(MapPixelLocation location) {
        this.location.setLocation(location);
        this.bounds.doUpdate();
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public boolean isNextTo(MapEntity entity) {
        if (this.map != entity.getMap()) {
            return false;
        }
        Rectangle bounds = this.bounds.get();
        Rectangle entityBounds = entity.getBounds();
        Rectangle union = bounds.union(entityBounds);
        return union.width <= bounds.width + entityBounds.width + 6 && union.height <= bounds.height + entityBounds.height + 6;
    }

    public boolean isNextToLocation(MapTileLocation tileLocation) {
        MapPixelLocation tileCenter = TileSizeUtil.getPixelLocation(tileLocation);
        return this.isNextToLocation(tileCenter);
    }

    public boolean isNextToLocation(MapPixelLocation location) {
        Rectangle enlarged = RectangleUtil.getEnlargedVersion(this.getBounds(), 2.75f);
        return enlarged.contains(location);
    }

    public Image getImage() {
        String imageName;
        if (this.image == null && (imageName = this.getImageName()) != null) {
            this.image = Images.getImage(imageName);
        }
        return this.image;
    }

    protected abstract String getImageName();

    public Rectangle getBounds() {
        return this.bounds.get();
    }

    public Rectangle getImpassibleBounds() {
        return this.getBounds();
    }

    public MovementType getMovementType() {
        return MovementType.walkingNoHands;
    }

    public void onImageToChange() {
        this.image = null;
    }

    public Sound getMovementSound() {
        return this.getMovementType().isQuiet() ? null : Sound.movement;
    }

    protected void onBoundsChanged() {
    }

    public boolean getShouldDrawOnTop() {
        return false;
    }

    public void onTurnOver() {
    }

    public boolean isBeing() {
        return false;
    }

    public boolean isPlayer() {
        return false;
    }

    public boolean isMonster() {
        return false;
    }

    public boolean isTerrain() {
        return false;
    }

    public boolean isItem() {
        return false;
    }

    public boolean isTrap() {
        return false;
    }

    public boolean isVisualEffect() {
        return false;
    }

    public boolean isVisible() {
        return true;
    }

    public void doCheckForMovementSound() {
        Sound sound;
        if (this.movementSoundCounter == 0 && (sound = this.getMovementSound()) != null) {
            this.map.onSoundIssued(sound, this.location, !this.isPlayer());
        }
        if (this.movementSoundInterval == 0) {
            this.movementSoundInterval = (this.isPlayer() ? 3 : 4) * TileSize.tileSize.width / 4;
        }
        this.movementSoundCounter = this.movementSoundCounter >= this.movementSoundInterval - 1 ? 0 : this.movementSoundCounter + 1;
    }

    protected class Bounds
    implements Serializable {
        private Rectangle bounds = new Rectangle();

        protected Bounds() {
        }

        public Rectangle get() {
            return this.bounds;
        }

        public void doUpdate() {
            Dimension size = MapEntity.this.getSize();
            this.bounds.setLocation(MapEntity.this.location.x - size.width / 2, MapEntity.this.location.y - size.height / 2);
            this.bounds.setSize(MapEntity.this.getSize());
            MapEntity.this.onBoundsChanged();
        }
    }
}

