/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import silmar.gui.widgets.Button;
import silmar.gui.widgets.TextArea;
import silmar.util.ThreadUtil;
import silmar.util.WindowUtil;

public class StoryDialog
extends JDialog {
    private static final String story = "...And so, it came to be that upon his passing, the evil archmage Syrilboltus did not truly die, but instead the foulness of his soul sustained his being into a state of living death, and his power grew only greater and more twisted. From the barren plains of Silmar surrounding his tower came disturbing reports that he was bending the forces of time and space to his will, and fashioning some great magical construct with which to assert his rule over the lands. Such rumors finally distressed King Thelbar so much that he formed an army and led an assault on the remote structure. Though the tower was leveled in the onslaught, Syrilboltus escaped into what the dwarves soon realized was his infamous creation, a massive labyrinthine expanse underneath the tower inhabited by an amazing variety of creatures both familiar and alien, all under some sort of spell to cooperate in defending him.  So entangled and imbued with magic were the dungeons that the dwarven sages sternly warned the king against any charge into their bowels. Accepting their advice, the king pronounced victory and dispersed his army, leaving the true threat largely undisturbed to this day.\n\nUndisturbed, except for the likes of adventurers such as yourself, who have heard the stories about great wealth from across time and space being sucked into the labryinths, waiting to be plucked from their powerful grasp.  The area has garnered enough attention that humble structures have sprung up near the tower ruins, housing a few brave souls willing to aid those who would dare enter the depths. But no one seems to survive more than a few scavenging trips.\n\nYou have come from a very poor village that needs funds to sustain its war-torn existence. You know that you must acquire wealth from the dungeons for your brethren to survive.\n\nThe depths await...";
    private static final String gameFinishedMessage = "And so, the evil presence of Syrilboltus was rid forever from the land of Silmar. And with his passing, the labyrinths beneath the tower began to slowly dissipate back to the existences from which they were summoned.  In time they vanished completely, and those who arrived later in search of riches found only a ladder leading down into solid dirt, and the little structures of the suppliers who were to aid them abandoned and collapsing.  King Thelbar used the sudden demise of Syrilboltus to justify his belief that there was no further threat to his kingdom once the tower was razed, and the dwarven people hold him in high regard for his foresight to this day.\n\nMore importantly, though, your humble village was able to escape the hard times it was facing, thanks in large part to the treasure with which you filled its coffers. Your fellow villagers were able to rebuild their war-torn society and go on to prosper, being well-fed and well-defended for a long time to come.\n\nCongratuations!  You have succeeded where many others have failed, and you will be known as a hero for generations hence!\n\nTake care, and thanks for playing!";

    public StoryDialog(Frame parent, boolean gameFinished) {
        super(parent, "Silmar");
        this.setSize(400, 240);
        this.setResizable(false);
        this.setModal(true);
        WindowUtil.doCenterWindow(this);
        this.setDefaultCloseOperation(0);
        Container pane = this.getContentPane();
        pane.setBackground(Color.black);
        pane.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 1));
        pane.add((Component)panel, "Center");
        final TextArea storyArea = new TextArea("\n\n\n\n\n\n\n" + (gameFinished ? gameFinishedMessage : story) + "\n\n\n\n\n\n\n");
        final JScrollPane scrollPane = new JScrollPane(storyArea);
        scrollPane.setBorder(new EtchedBorder(Color.white, Color.lightGray));
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(21);
        scrollPane.setOpaque(false);
        panel.add(scrollPane);
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        Button button = new Button(" Ok ");
        panel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StoryDialog.this.setVisible(false);
            }
        });
        new Thread(){

            public void run() {
                while (!StoryDialog.this.isVisible()) {
                    ThreadUtil.doSleep(100L);
                }
                int topY = 0;
                int topYMax = storyArea.getPreferredSize().height - scrollPane.getHeight();
                while (topY < topYMax && StoryDialog.this.isVisible()) {
                    JViewport view = scrollPane.getViewport();
                    view.setViewPosition(new Point(0, topY));
                    ThreadUtil.doSleep(70L);
                    ++topY;
                }
            }
        }.start();
    }
}

