/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import silmar.entities.beings.attacks.PenetrationType;
import silmar.entities.beings.player.Player;
import silmar.game.Game;
import silmar.gui.Fonts;
import silmar.gui.widgets.Label;
import silmar.map.MapLevel;
import silmar.util.HtmlUtil;

public final class PlayerVitalStatsDisplay
extends JPanel {
    private Player player;
    private JLabel hitPointsLabel;
    private JLabel statusLabel;
    private JLabel magicPointsLabel;
    private JLabel clericalPointsLabel;
    private Label defenseLabel;
    private JLabel goldLabel;
    private JLabel levelLabel;
    private JLabel encumbranceLabel;
    private JLabel movementRateLabel;
    private final String encumbranceLabelText = "encumbr.:";
    private final String defenseLabelTooltip1 = "How hard it is to hit you in combat.";
    private final String defenseLabelTooltip2 = "How hard it is to hit you in combat. The second number applies to firearm penetration-level attacks.";
    private final String defenseLabelTooltip3 = "How hard it is to hit you in combat. The second number applies to firearm penetration-level attacks. The third number applies to laser penetration-level attacks.";

    public PlayerVitalStatsDisplay(Player player) {
        this.player = player;
        this.setLayout(new BoxLayout(this, 1));
        this.setOpaque(false);
        this.levelLabel = this.doAddLabel("level:", "Your experience level. Affects how well you hit in combat, and your maximum hit points.");
        this.hitPointsLabel = this.doAddLabel("hit pts.:", "How much damage you can take before dying.", true);
        this.statusLabel = this.doAddLabel("status:", "Your general welfare, ignoring your hit points.");
        this.statusLabel.setFont(new Font("dialog", 1, 11));
        this.magicPointsLabel = this.doAddLabel("magic pts.:", "How many points you have for casting magic-user spells.", true);
        this.clericalPointsLabel = this.doAddLabel("clerical pts.:", "How many points you have for casting clerical spells.", true);
        this.defenseLabel = this.doAddLabel("defense:", "How hard it is to hit you in combat.");
        this.goldLabel = this.doAddLabel("gold:", "The amount of gold coins you possess.");
        this.encumbranceLabel = this.doAddLabel("encumbr.:", "(Encumbrance:) How much your currently held possessions are encumbering you.  Affects your movement rate.", true);
        this.movementRateLabel = this.doAddLabel("move:", "How many squares you can move per game turn.");
    }

    private Label doAddLabel(String text, String tooltip) {
        return this.doAddLabel(text, tooltip, false);
    }

    private Label doAddLabel(String text, String tooltip, boolean addCurrentMaximum) {
        String currentMaximum = "<br><I>(Current / Maximum)</I>";
        tooltip = HtmlUtil.doBreakText(tooltip, 30) + (addCurrentMaximum ? "<br><I>(Current / Maximum)</I>" : "");
        Box box = Box.createHorizontalBox();
        this.add(box);
        AttributeLabel label = new AttributeLabel(text);
        box.add(label);
        label.getHasTooltipImpl().setTooltipText(tooltip, 0);
        if (!text.equals("encumbr.:")) {
            box.add(Box.createRigidArea(new Dimension(20, 0)));
        }
        box.add(Box.createHorizontalGlue());
        ValueLabel label2 = new ValueLabel();
        box.add(label2);
        label2.getHasTooltipImpl().setTooltipText(tooltip, 0);
        return label2;
    }

    public void onAttributeValueChanged() {
        this.hitPointsLabel.setText("" + this.player.getHitPoints() + " / " + this.player.getMaxHitPoints());
        this.levelLabel.setText("" + this.player.getLevel().get());
        this.goldLabel.setText("" + this.player.getGold());
        this.magicPointsLabel.setText("" + this.player.getMagicPoints().get() + " / " + this.player.getMaxMagicPoints().get());
        this.clericalPointsLabel.setText("" + this.player.getClericalPoints().get() + " / " + this.player.getMaxClericalPoints().get());
        this.encumbranceLabel.setText("" + this.player.getEncumbrance().get() + " / " + this.player.getMaxEncumbrance().get());
        this.movementRateLabel.setText("" + this.player.getMaxMovementPoints());
        this.doUpdateStatusLabel();
        this.doUpdateDefenseLabel();
        this.repaint();
    }

    private void doUpdateStatusLabel() {
        Color color = Color.white;
        String text = "normal";
        if (this.player.isParalyzed()) {
            color = Color.cyan;
            text = "paralyzed";
        } else if (this.player.isQuickened()) {
            color = Color.yellow;
            text = "quickened";
        } else if (this.player.isConfused()) {
            color = Color.blue;
            text = "confused";
        } else if (this.player.isPoisoned()) {
            color = Color.green;
            text = "poisoned";
        } else if (this.player.isDiseased()) {
            color = new Color(152, 185, 53);
            text = "diseased";
        }
        this.statusLabel.setForeground(color);
        this.statusLabel.setText(text);
    }

    private void doUpdateDefenseLabel() {
        boolean reachedLasers;
        boolean reachedFirearms;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.player.getDefense(PenetrationType.normal, null));
        Game game = Game.getCurrentGame();
        int maxLevel = game.getFurthestLevelReachedByPlayer(this.player);
        boolean bl = reachedFirearms = maxLevel >= MapLevel.cityEnd.getIndex();
        if (reachedFirearms) {
            buffer.append(" / F");
            buffer.append(this.player.getDefense(PenetrationType.firearm, null));
        }
        boolean bl2 = reachedLasers = maxLevel >= MapLevel.moon.getIndex();
        if (reachedLasers) {
            buffer.append(" / L");
            buffer.append(this.player.getDefense(PenetrationType.laser, null));
        }
        this.defenseLabel.setText(buffer.toString());
        this.defenseLabel.getHasTooltipImpl().setTooltipText(reachedLasers ? "How hard it is to hit you in combat. The second number applies to firearm penetration-level attacks. The third number applies to laser penetration-level attacks." : (reachedFirearms ? "How hard it is to hit you in combat. The second number applies to firearm penetration-level attacks." : "How hard it is to hit you in combat."), 30);
    }

    protected static class ValueLabel
    extends Label {
        public ValueLabel() {
            super("0", Fonts.small);
            this.setHorizontalAlignment(4);
        }

        public float getAlignmentX() {
            return 1.0f;
        }
    }

    protected static class AttributeLabel
    extends Label {
        public AttributeLabel(String text) {
            super(text, Fonts.small);
            this.setHorizontalAlignment(2);
        }

        public float getAlignmentX() {
            return 0.0f;
        }
    }
}

