/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import silmar.Debug;
import silmar.Images;
import silmar.client.Client;
import silmar.client.CommandsThread;
import silmar.client.MapView;
import silmar.client.gui.HandsItemsDisplay;
import silmar.client.gui.LocationSelection;
import silmar.client.gui.PlayerVitalStatsDisplay;
import silmar.client.gui.WindowArrangement;
import silmar.entities.MapEntity;
import silmar.entities.beings.Being;
import silmar.entities.beings.monsters.Monster;
import silmar.entities.beings.monsters.MonsterFactory;
import silmar.entities.beings.monsters.MonsterType;
import silmar.entities.beings.player.ExperienceNeededForLevels;
import silmar.entities.beings.player.Player;
import silmar.entities.beings.talkerBeings.TalkerBeing;
import silmar.entities.items.Item;
import silmar.entities.items.ItemFactory;
import silmar.entities.items.types.ItemType;
import silmar.entities.items.weapons.Weapon;
import silmar.entities.talkers.Talker;
import silmar.entities.terrains.Terrain;
import silmar.game.Game;
import silmar.gui.Fonts;
import silmar.gui.dialogs.InputIntDialog;
import silmar.gui.dialogs.OkCancelDialog;
import silmar.gui.widgets.Button;
import silmar.gui.widgets.Label;
import silmar.map.Map;
import silmar.map.MapPixelLocation;
import silmar.tiles.Tile;
import silmar.tiles.TileSize;
import silmar.util.ImageUtil;
import silmar.util.ThreadUtil;
import silmar.util.WindowUtil;

public final class PlayFrame
extends JFrame
implements TileSize {
    private Client client;
    private Button itemsButton;
    private Button powersButton;
    private Button attributesButton;
    private Button gameButton;
    private Button passButton;
    private Button homeViewButton;
    private Button previousHandsConfigButton;
    private Button useHandsConfigButton;
    private Button setHandsConfigButton;
    private LocationSelection locationSelection;
    private HandsItemsDisplay handsItemsDisplay;
    private MapView mapView;
    private PlayerVitalStatsDisplay playerVitalStatsDisplay;
    private JLabel statusLine;
    private JPopupMenu gamePopup;
    private Cursor crosshairsCursor;

    public PlayFrame(final Client client) {
        super("Silmar");
        this.client = client;
        Player player = client.getPlayer();
        final Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        Color backgroundColor = client.getBackgroundColor();
        pane.setBackground(backgroundColor);
        this.setIconImage(Images.iconImage);
        this.setSize(628, 500);
        WindowUtil.doCenterWindow(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent event) {
                pane.repaint();
            }

            public void windowClosing(WindowEvent event) {
                PlayFrame.this.onClosing(event);
            }
        });
        this.setDefaultCloseOperation(0);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        pane.add((Component)panel, "Center");
        this.mapView = new MapView();
        panel.add((Component)this.mapView, "Center");
        this.mapView.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isConsumed() || !PlayFrame.this.mapView.isEnabled()) {
                    return;
                }
                MapPixelLocation location = PlayFrame.this.mapView.getMapLocationAtPoint(e.getPoint());
                if (location != null) {
                    CommandsThread.getInstance().doAddCommand(new CommandsThread.Command(this, location, e){
                        private final /* synthetic */ MapPixelLocation val$location;
                        private final /* synthetic */ MouseEvent val$e;
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$location = val$location;
                            this.val$e = val$e;
                        }

                        public void doExecute() {
                            PlayFrame.access$200(2.access$100(this.this$1), this.val$location, this.val$e.isPopupTrigger(), this.val$e.isShiftDown());
                        }
                    });
                }
            }

            static /* synthetic */ PlayFrame access$100(2 x0) {
                return x0.PlayFrame.this;
            }
        });
        this.statusLine = new Label("  ", Fonts.medium);
        this.statusLine.setBorder(new MatteBorder(2, 0, 0, 0, Color.lightGray));
        panel.add((Component)this.statusLine, "South");
        panel = new JPanel();
        panel.setBackground(backgroundColor);
        panel.setBorder(new MatteBorder(0, 5, 0, 0, Color.lightGray));
        panel.setLayout(new BoxLayout(panel, 1));
        pane.add((Component)panel, "East");
        Label label = new Label(player.getName(), Fonts.medium);
        panel.add(label);
        this.playerVitalStatsDisplay = new PlayerVitalStatsDisplay(player);
        panel.add(this.playerVitalStatsDisplay);
        panel.add(Box.createRigidArea(new Dimension(0, 20)));
        Button button = this.itemsButton = new Button(" Items ");
        button.setAlignmentX(0.5f);
        panel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PlayFrame.this.isEnabled()) {
                    return;
                }
                if (PlayFrame.this.locationSelection == null) {
                    client.doShowItems();
                }
            }
        });
        this.setTooltip(button, "Displays your equipped items and inventory.");
        panel.add(Box.createRigidArea(new Dimension(0, 3)));
        button = this.powersButton = new Button(" Powers ");
        button.setAlignmentX(0.5f);
        panel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PlayFrame.this.isEnabled()) {
                    return;
                }
                if (PlayFrame.this.locationSelection == null) {
                    client.doShowPowers();
                }
            }
        });
        this.setTooltip(button, "Displays the active- and passive-use powers you possess.");
        panel.add(Box.createRigidArea(new Dimension(0, 3)));
        button = this.attributesButton = new Button(" Attributes ");
        button.setAlignmentX(0.5f);
        panel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PlayFrame.this.isEnabled()) {
                    return;
                }
                if (PlayFrame.this.locationSelection == null) {
                    client.doShowAttributes();
                }
            }
        });
        this.setTooltip(button, "Displays your attribute scores.");
        panel.add(Box.createRigidArea(new Dimension(0, 3)));
        button = this.passButton = new Button(" Pass ");
        button.setAlignmentX(0.5f);
        panel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PlayFrame.this.isEnabled()) {
                    return;
                }
                if (PlayFrame.this.locationSelection == null) {
                    client.getPlayer().doEndTurn();
                }
            }
        });
        this.setTooltip(button, "Manually ends your current game turn.");
        panel.add(Box.createRigidArea(new Dimension(0, 3)));
        button = this.homeViewButton = new Button(" Home view ");
        button.setAlignmentX(0.5f);
        panel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlayFrame.this.mapView.doHomeViewpoint();
            }
        });
        this.setTooltip(button, "Homes the view on you.");
        panel.add(Box.createRigidArea(new Dimension(0, 3)));
        final Button gameMenuButton = button = (this.gameButton = new Button(" Game "));
        button.setAlignmentX(0.5f);
        panel.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!PlayFrame.this.isEnabled()) {
                    return;
                }
                if (PlayFrame.this.locationSelection == null) {
                    PlayFrame.this.gamePopup.show(gameMenuButton, 0, 0);
                }
            }
        });
        this.setTooltip(button, "Displays a menu of game-related commands.");
        panel.add(Box.createRigidArea(new Dimension(0, 3)));
        if (Debug.isOn()) {
            button = new Button(" Debug ");
            button.setAlignmentX(0.5f);
            panel.add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CommandsThread.getInstance().doAddCommand(new CommandsThread.Command(this){
                        private final /* synthetic */ 10 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void doExecute() {
                            Player player = 10.access$500(this.this$1).getPlayer();
                            player.onExperienceGained(ExperienceNeededForLevels.getExperienceNeededForLevel(player.getLevel().get() + 1) - ExperienceNeededForLevels.getExperienceNeededForLevel(player.getLevel().get()));
                            MapPixelLocation location = new MapPixelLocation(player.getLocation());
                            location.x -= TileSize.tileSize.width;
                            Item item = ItemFactory.doCreateItem(ItemType.necklaceOfOgreStrength);
                        }
                    });
                }

                static /* synthetic */ Client access$500(10 x0) {
                    return x0.client;
                }
            });
            panel.add(Box.createRigidArea(new Dimension(0, 3)));
            button = new Button(" Debug 2 ");
            button.setAlignmentX(0.5f);
            panel.add(button);
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CommandsThread.getInstance().doAddCommand(new CommandsThread.Command(this){
                        private final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void doExecute() {
                            Player player = 12.access$600(this.this$1).getPlayer();
                            MapPixelLocation location = new MapPixelLocation(player.getLocation());
                            location.x += 2 * TileSize.tileSize.width;
                            Item item = ItemFactory.doCreateItem(ItemType.potionOfPoison);
                            player.getMap().doAddEntity((MapEntity)MonsterFactory.doCreateMonster(MonsterType.acidDragon), location);
                        }
                    });
                }

                static /* synthetic */ Client access$600(12 x0) {
                    return x0.client;
                }
            });
        }
        panel.add(Box.createRigidArea(new Dimension(0, 20)));
        label = new Label("hands:", Fonts.small);
        label.setAlignmentX(0.5f);
        panel.add(label);
        panel.add(Box.createRigidArea(new Dimension(0, 1)));
        this.handsItemsDisplay = new HandsItemsDisplay(player);
        this.handsItemsDisplay.setAlignmentX(0.5f);
        panel.add(this.handsItemsDisplay);
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        label = new Label("hands configs:", Fonts.small);
        label.setAlignmentX(0.5f);
        panel.add(label);
        panel.add(Box.createRigidArea(new Dimension(0, 1)));
        JPanel panel2 = new JPanel();
        panel2.setBackground(backgroundColor);
        panel2.setLayout(new BoxLayout(panel2, 0));
        panel.add(panel2);
        button = this.previousHandsConfigButton = new Button(" Prev ");
        button.setAlignmentX(0.5f);
        panel2.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                client.getPlayer().doUsePreviousHandsConfig();
            }
        });
        this.setTooltip(button, "Employs the previously-selected hands configuration.");
        panel2.add(Box.createRigidArea(new Dimension(3, 0)));
        String useLabel = "Use";
        String setLabel = "Set";
        button = this.useHandsConfigButton = new Button(" Use ");
        button.setAlignmentX(0.5f);
        panel2.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                client.doSelectHandsConfig();
            }
        });
        this.setTooltip(button, "Lets you select what items you have in your hands from the configurations you have specified using <I>Set</I>.");
        panel2.add(Box.createRigidArea(new Dimension(3, 0)));
        button = this.setHandsConfigButton = new Button(" Set ");
        button.setAlignmentX(0.5f);
        panel2.add(button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                client.doSelectHandsConfigToSet();
            }
        });
        this.setTooltip(button, "Lets you specify the items currently in your hands as a configuration which you may quickly reassume later by clicking <I>Use</I>.");
        panel.add(Box.createRigidArea(new Dimension(0, 3)));
        panel.add(Box.createVerticalGlue());
        this.doBuildGamePopup();
        Toolkit kit = Toolkit.getDefaultToolkit();
        this.crosshairsCursor = kit.createCustomCursor(ImageUtil.doLoadImage("crosshairsCursor"), new Point(15, 15), "");
        Rectangle bounds = WindowArrangement.getInstance().playFrameBounds;
        if (bounds != null) {
            this.setBounds(bounds);
        }
    }

    private void setTooltip(Button button, String text) {
        button.getHasTooltipImpl().setTooltipText(text, 25);
    }

    private void doBuildGamePopup() {
        this.gamePopup = new JPopupMenu();
        PopupItem item = new PopupItem("Help");
        this.gamePopup.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlayFrame.this.client.doDisplayHelp();
            }
        });
    }

    public void onClosing(WindowEvent event) {
        if (!this.client.getPlayer().isDead() && OkCancelDialog.doShow(this, "Quit, and lose all changes since the last save point?")) {
            return;
        }
        this.client.getServer().onClientQuit();
        this.setVisible(false);
        Game.getCurrentGame().onStopping();
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            WindowArrangement arrangement = WindowArrangement.getInstance();
            arrangement.playFrameBounds = this.getBounds();
        }
        super.setVisible(visible);
    }

    private void onMapClicked(MapPixelLocation location, boolean rightClick, boolean shiftClick) {
        if (!this.mapView.isEnabled()) {
            return;
        }
        Player player = this.client.getPlayer();
        if (player.isParalyzed()) {
            return;
        }
        Map map = player.getMap();
        boolean locationVisible = map.getCanSee(player.getLocation(), location, TileSize.tileSize.width, true, false, null, null);
        LocationSelection selection = this.locationSelection;
        if (selection != null && !selection.isNearbyOnly()) {
            if (!locationVisible) {
                return;
            }
            this.mapView.doUseNormalCursor();
            this.doClearStatusLine();
            this.locationSelection = null;
            selection.onSelection(location, player);
            return;
        }
        if (selection != null && selection.isNearbyOnly()) {
            Monster monster = map.getFirstMonsterAt(location);
            if (!(player.isNextToLocation(location) || monster != null && player.isNextTo(monster))) {
                this.doDisplayStatusMessage("Location is too far away.", 2000);
                return;
            }
            this.mapView.doUseNormalCursor();
            this.doClearStatusLine();
            this.locationSelection = null;
            selection.onSelection(location, player);
            return;
        }
        Being being = map.getFirstBeingAt(location);
        Weapon weapon = player.getWeapon();
        if (being instanceof Monster) {
            if (weapon != null && weapon.getWeaponType().isRanged()) {
                if (!locationVisible) {
                    return;
                }
                new LocationSelection.RangedAttack().onSelection(location, player);
                return;
            }
            if (player.isNextTo(being)) {
                new LocationSelection.MeleeAttack().onSelection(location, player);
                return;
            }
        }
        if (shiftClick && weapon != null && weapon.getWeaponType().isRanged()) {
            new LocationSelection.RangedAttack().onSelection(location, player);
            return;
        }
        if (being != null && being != player && player.isNextTo(being) && being instanceof Talker) {
            this.client.onNearbyTalkerBeingClicked((TalkerBeing)being);
            return;
        }
        Item item = map.getFirstItemAt(location);
        if (item != null && player.isNextTo(item)) {
            int quantity = item.getQuantity();
            if (quantity > 1) {
                InputIntDialog.Result result = InputIntDialog.doShow(this, "Get how many of this item (" + item.getType().getPluralName() + ")?", 1, quantity, quantity);
                if (result.cancelled) {
                    return;
                }
                quantity = result.valueEntered;
            }
            player.doGetItem(item, quantity);
            return;
        }
        Terrain terrain = map.getFirstTerrainAt(location);
        if (terrain != null && player.isNextTo(terrain) && this.client.onNearbyTerrainClicked(terrain)) {
            return;
        }
        Tile tile = map.getTile(location);
        if (tile.isOpenDoor() && player.isNextToLocation(location) && !tile.equals(map.getTile(player.getLocation()))) {
            player.doShutDoor(location);
            if (map.getTile(location).isDoor()) {
                return;
            }
        }
        player.doMove(location);
    }

    public void doDisplayStatusMessage(String message) {
        this.doDisplayStatusMessage(message, 0);
    }

    public void doDisplayStatusMessage(final String message, final int duration) {
        this.statusLine.setText(message);
        if (duration > 0) {
            new Thread(){

                public void run() {
                    ThreadUtil.doSleep(duration);
                    if (PlayFrame.this.statusLine.getText().equals(message)) {
                        PlayFrame.this.doClearStatusLine();
                    }
                }
            }.start();
        }
    }

    public void doClearStatusLine() {
        this.statusLine.setText("  ");
    }

    public Client getClient() {
        return this.client;
    }

    public void setLocationSelection(LocationSelection selection) {
        this.locationSelection = selection;
        if (selection != null) {
            this.mapView.doUseCursor(this.crosshairsCursor);
        }
    }

    public MapView getMapView() {
        return this.mapView;
    }

    public PlayerVitalStatsDisplay getPlayerVitalStatsDisplay() {
        return this.playerVitalStatsDisplay;
    }

    public HandsItemsDisplay getHandsItemsDisplay() {
        return this.handsItemsDisplay;
    }

    public void setUIEnabled(final boolean enable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PlayFrame.this.mapView.setEnabled(enable);
                PlayFrame.this.itemsButton.setEnabled(enable);
                PlayFrame.this.powersButton.setEnabled(enable);
                PlayFrame.this.attributesButton.setEnabled(enable);
                PlayFrame.this.gameButton.setEnabled(enable);
                PlayFrame.this.passButton.setEnabled(enable);
                PlayFrame.this.homeViewButton.setEnabled(enable);
                PlayFrame.this.previousHandsConfigButton.setEnabled(enable);
                PlayFrame.this.useHandsConfigButton.setEnabled(enable);
                PlayFrame.this.setHandsConfigButton.setEnabled(enable);
            }
        });
    }

    static /* synthetic */ void access$200(PlayFrame x0, MapPixelLocation x1, boolean x2, boolean x3) {
        x0.onMapClicked(x1, x2, x3);
    }

    private class PopupItem
    extends JMenuItem {
        public PopupItem(String text) {
            super(text);
            this.setFont(new Font("Serif", 0, 12));
            this.setForeground(Color.black);
            this.setBackground(new Color(253, 209, 128));
        }
    }
}

