/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import silmar.client.gui.ItemDisplay;
import silmar.entities.beings.talkerBeings.TalkerBeings;
import silmar.entities.items.Item;
import silmar.entities.items.ItemCondition;
import silmar.entities.items.ItemValueContext;
import silmar.entities.items.types.ItemType;
import silmar.entities.talkers.ItemFixer;
import silmar.entities.talkers.ItemSeller;
import silmar.events.Event;
import silmar.events.Listener;
import silmar.util.HtmlUtil;

public class ItemDisplayListener
implements Listener {
    private ItemValueContext itemValueContext;
    private ItemSeller seller;
    private TalkerBeings.Buyer buyer;
    private TalkerBeings.ItemIdentifier identifier;
    private ItemFixer fixer;

    public ItemDisplayListener(ItemValueContext itemValueContext) {
        this.itemValueContext = itemValueContext;
    }

    public void onEvent(Event event) {
        if (event.isOfType(ItemDisplay.ItemClicked.itemClicked)) {
            this.onItemClicked((ItemDisplay.ItemClicked)event);
        } else if (event.isOfType(ItemDisplay.CanAppendToTooltip.canAppendToTooltip)) {
            this.onCanAppendToTooltip((ItemDisplay.CanAppendToTooltip)event);
        }
    }

    private void onItemClicked(ItemDisplay.ItemClicked event) {
        Item item = event.item;
        if ((this.itemValueContext.equals(ItemValueContext.sell) || this.itemValueContext.equals(ItemValueContext.experience)) && (item.getType().isCursed() || !item.isIdentified())) {
            return;
        }
        if (this.itemValueContext.equals(ItemValueContext.repair) && (item.getType().isGroupable() || item.getCondition().equals(ItemCondition.excellent) || !this.fixer.getCanFixItem(item))) {
            return;
        }
        if (this.itemValueContext.equals(ItemValueContext.sell) && item.getType().equals(ItemType.gold)) {
            return;
        }
        if (this.itemValueContext.equals(ItemValueContext.identify) && item.isIdentified()) {
            return;
        }
        this.onItemClickedAndValidated(event);
    }

    protected void onItemClickedAndValidated(ItemDisplay.ItemClicked event) {
    }

    public void onCanAppendToTooltip(ItemDisplay.CanAppendToTooltip event) {
        String refusalText = null;
        Item item = event.item;
        ItemValueContext context = this.itemValueContext;
        if (context.equals(ItemValueContext.sell) || context.equals(ItemValueContext.experience)) {
            if (!item.isIdentified()) {
                refusalText = "unidentified";
            } else if (item.getType().isCursed()) {
                refusalText = "cursed";
            }
        }
        if (context.equals(ItemValueContext.repair)) {
            if (item.getType().isGroupable() || item.getCondition().equals(ItemCondition.excellent)) {
                refusalText = "undamaged";
            } else if (!this.fixer.getCanFixItem(item)) {
                refusalText = "outside of expertise";
            }
        }
        if (context.equals(ItemValueContext.identify) && item.isIdentified()) {
            refusalText = "identified";
        }
        StringBuffer text = event.text;
        if (refusalText != null) {
            HtmlUtil.doBreak(text);
            text.append("<b><i>Cannot choose: ");
            text.append(refusalText);
            text.append("</i></b>");
            return;
        }
        if (item.getType().equals(ItemType.gold) && !context.equals(ItemValueContext.experience)) {
            return;
        }
        if (context == null) {
            return;
        }
        String valueName = context == ItemValueContext.experience ? "experience value" : (context == ItemValueContext.sell ? "offered" : "price");
        HtmlUtil.doBreak(text);
        text.append(valueName);
        int value = item.getValue(context);
        if (context == ItemValueContext.buy) {
            value = this.seller.getAdjustedItemPrice(item, value);
        } else if (context == ItemValueContext.sell) {
            value = this.buyer.getAdjustedItemOffering(item, value);
        } else if (context == ItemValueContext.identify) {
            value = this.identifier.getAdjustedItemPrice(item, value);
        } else if (context == ItemValueContext.repair) {
            value = this.fixer.getAdjustedItemPrice(item, value);
        }
        text.append(": <b><font style='font-family:sans-serif;font-size:16'>");
        text.append(value);
        text.append("</font></b>");
        if (context != ItemValueContext.experience) {
            text.append(" gold");
        }
    }

    public void setBuyer(TalkerBeings.Buyer buyer) {
        this.buyer = buyer;
    }

    public void setFixer(ItemFixer fixer) {
        this.fixer = fixer;
    }

    public void setIdentifier(TalkerBeings.ItemIdentifier identifier) {
        this.identifier = identifier;
    }

    public void setSeller(ItemSeller seller) {
        this.seller = seller;
    }
}

