/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.JPanel;
import silmar.entities.beings.player.PlayerAttribute;
import silmar.entities.items.Item;
import silmar.entities.items.ItemCondition;
import silmar.entities.items.ItemValueContext;
import silmar.events.Event;
import silmar.events.EventType;
import silmar.events.Listener;
import silmar.events.Reporter;
import silmar.gui.tooltips.HasTooltip;
import silmar.gui.tooltips.HasTooltipImpl;
import silmar.tiles.TileSize;
import silmar.util.HtmlUtil;

public final class ItemDisplay
extends JPanel
implements TileSize,
HasTooltip {
    private Item item;
    private Reporter reporter = new Reporter();
    private static Font itemQuantityFont = new Font("SansSerif", 1, 12);
    private NumberFormat format;
    private boolean reportNoItemClicks = false;
    private HasTooltipImpl hasTooltipImpl = new HasTooltipImpl(this);

    public ItemDisplay() {
        this.setOpaque(false);
        this.setBackground(Color.black);
        this.format = NumberFormat.getInstance();
        this.format.setMaximumFractionDigits(1);
        this.addMouseListener(new MouseAdapter(){
            private boolean rightClick = false;

            public void mouseEntered(MouseEvent e) {
                ItemDisplay.this.doUpdateTooltip();
            }

            public void mousePressed(MouseEvent e) {
                this.rightClick = e.isPopupTrigger();
            }

            public void mouseReleased(MouseEvent e) {
                this.rightClick |= e.isPopupTrigger();
            }

            public void mouseClicked(MouseEvent e) {
                if (ItemDisplay.this.item == null && !ItemDisplay.this.reportNoItemClicks) {
                    return;
                }
                ItemDisplay.this.reporter.doReport(new ItemClicked(ItemDisplay.this, ItemDisplay.this.item, this.rightClick, e.isShiftDown()));
            }
        });
    }

    public Dimension getMaximumSize() {
        return TileSize.tileSize;
    }

    public Dimension getMinimumSize() {
        return TileSize.tileSize;
    }

    public Dimension getPreferredSize() {
        return TileSize.tileSize;
    }

    public void setItem(Item item) {
        this.item = item;
        this.doUpdateTooltip();
        this.repaint();
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        if (this.item != null) {
            this.doDrawItem(g, size.width / 2, size.height / 2);
        }
        super.paint(g);
    }

    public void doUpdateTooltip() {
        StringBuffer text = new StringBuffer();
        if (this.item != null) {
            this.doAppendItemTooltipText(text);
            this.reporter.doReport(new CanAppendToTooltip(this.item, text));
        }
        this.hasTooltipImpl.setTooltipText(text.toString(), 0);
    }

    public void doAddListener(Listener listener) {
        this.reporter.doAddListener(listener);
    }

    public void doDrawItem(Graphics g, int x, int y) {
        g.setColor(this.item.getType().isGroupable() ? Color.black : this.item.getCondition().getColor());
        Dimension size = this.getSize();
        g.fillRect(x - size.width / 2, y - size.height / 2, size.width, size.height);
        Image image = this.item.getImage();
        g.drawImage(image, x - image.getWidth(null) / 2, y - image.getHeight(null) / 2, null);
        int quantity = this.item.getQuantity();
        if (quantity > 1) {
            String text = Integer.toString(quantity);
            g.setColor(Color.white);
            g.setFont(itemQuantityFont);
            g.drawString(text, x + size.width / 2 - 1 - g.getFontMetrics(itemQuantityFont).stringWidth(text), y + size.height / 2 - 1);
        }
    }

    public void doAppendItemTooltipText(StringBuffer text) {
        this.doAppendItemTooltipText(text, null);
    }

    public void doAppendItemTooltipText(StringBuffer text, ItemValueContext valueContext) {
        text.append("<i>");
        text.append(this.item.getName());
        text.append("</i>");
        if (!this.item.getType().isGroupable()) {
            HtmlUtil.doBreak(text);
            ItemCondition condition = this.item.getCondition();
            Color color = condition.getColor();
            text.append("condition: <b><font color='#");
            text.append(HtmlUtil.getHexString(color));
            text.append("'>");
            text.append(condition.getName());
            text.append("</font></b>");
        }
        HtmlUtil.doBreak(text);
        text.append("encumbrance: <b>");
        text.append(this.format.format(this.item.getEncumbrance()));
        text.append("</b>");
        String info = this.item.getInfo();
        if (info != null) {
            HtmlUtil.doBreak(text);
            text.append(HtmlUtil.doBreakText(info, 45));
        }
        int numAttributes = PlayerAttribute.attributes.size();
        for (int i = 0; i < numAttributes; ++i) {
            PlayerAttribute attribute = PlayerAttribute.getAttribute(i);
            int requirement = this.item.getType().getAttributeRequirement(attribute);
            if (requirement <= 1) continue;
            HtmlUtil.doBreak(text);
            text.append(attribute.getName() + " required: " + requirement);
        }
    }

    public void setReportNoItemClicks(boolean reportNoItemClicks) {
        this.reportNoItemClicks = reportNoItemClicks;
    }

    public HasTooltipImpl getHasTooltipImpl() {
        return this.hasTooltipImpl;
    }

    public static class CanAppendToTooltip
    extends Event {
        public Item item;
        public StringBuffer text;
        public static final EventType canAppendToTooltip = new EventType();

        public CanAppendToTooltip(Item item, StringBuffer text) {
            this.item = item;
            this.text = text;
        }

        public EventType getType() {
            return canAppendToTooltip;
        }
    }

    public static class ItemClicked
    extends Event {
        public ItemDisplay source;
        public Item item;
        public boolean rightClick;
        public boolean shiftClick;
        public static final EventType itemClicked = new EventType();

        public ItemClicked(ItemDisplay source, Item item, boolean rightClick, boolean shiftClick) {
            this.item = item;
            this.rightClick = rightClick;
            this.shiftClick = shiftClick;
            this.source = source;
        }

        public EventType getType() {
            return itemClicked;
        }
    }
}

