/*
 * Decompiled with CFR 0.152.
 */
package silmar.client.gui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import silmar.client.gui.ItemDisplay;
import silmar.entities.beings.player.Player;
import silmar.events.Event;
import silmar.events.EventType;
import silmar.events.Listener;
import silmar.events.Reporter;

public final class HandsConfigsDisplay
extends JPanel {
    private Player player;
    private Reporter reporter = new Reporter();
    private ConfigPanel[] configPanels;

    public HandsConfigsDisplay(Player player) {
        this.player = player;
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        int numConfigs = player.getHandsConfigs().length;
        this.configPanels = new ConfigPanel[numConfigs];
        for (int i = 0; i < numConfigs; ++i) {
            ConfigPanel panel = this.configPanels[i] = new ConfigPanel(i);
            this.add(panel);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
        }
        this.onConfigChanged();
    }

    public void doAddListener(Listener listener) {
        this.reporter.doAddListener(listener);
    }

    public void onConfigChanged() {
        for (int i = 0; i < this.configPanels.length; ++i) {
            this.configPanels[i].onItemsChanged();
        }
        this.repaint();
    }

    public void doUpdateItems() {
        for (int i = 0; i < this.configPanels.length; ++i) {
            this.configPanels[i].doUpdateItems();
        }
    }

    static /* synthetic */ Reporter access$100(HandsConfigsDisplay x0) {
        return x0.reporter;
    }

    public static class ConfigSelected
    extends Event {
        int configIndex;
        public static final EventType configSelected = new EventType();

        public ConfigSelected(int configIndex) {
            this.configIndex = configIndex;
        }

        public EventType getType() {
            return configSelected;
        }
    }

    private class ConfigPanel
    extends JPanel {
        private ItemDisplay leftDisplay;
        private ItemDisplay rightDisplay;
        private int configIndex;

        public ConfigPanel(int configIndex) {
            this.configIndex = configIndex;
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createRigidArea(new Dimension(1, 0)));
            this.leftDisplay = new ItemDisplay();
            this.leftDisplay.setReportNoItemClicks(true);
            this.leftDisplay.setBorder(new LineBorder(Color.white, 1));
            this.add(this.leftDisplay);
            Listener listener = new Listener(this, configIndex){
                private final /* synthetic */ int val$configIndex;
                private final /* synthetic */ ConfigPanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$configIndex = val$configIndex;
                }

                public void onEvent(Event event) {
                    if (event.isOfType(ItemDisplay.ItemClicked.itemClicked)) {
                        HandsConfigsDisplay.access$100(ConfigPanel.access$000(this.this$1)).doReport(new ConfigSelected(this.val$configIndex));
                    }
                }
            };
            this.leftDisplay.doAddListener(listener);
            this.add(Box.createRigidArea(new Dimension(1, 0)));
            this.rightDisplay = new ItemDisplay();
            this.rightDisplay.setReportNoItemClicks(true);
            this.rightDisplay.setBorder(new LineBorder(Color.white, 1));
            this.add(this.rightDisplay);
            this.rightDisplay.doAddListener(listener);
        }

        public void onItemsChanged() {
            Player.HandsConfig config = HandsConfigsDisplay.this.player.getHandsConfigs()[this.configIndex];
            this.leftDisplay.setItem(config.leftItem);
            this.rightDisplay.setItem(config.rightItem);
        }

        public void doUpdateItems() {
            this.leftDisplay.repaint();
            this.rightDisplay.repaint();
        }

        static /* synthetic */ HandsConfigsDisplay access$000(ConfigPanel x0) {
            return x0.HandsConfigsDisplay.this;
        }
    }
}

