/*
 * Decompiled with CFR 0.152.
 */
package silmar.client;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import silmar.tiles.TileSize;

public class Sound
implements TileSize {
    private String fileName;
    private boolean activatesMonsters;
    private int range;
    private List clips = new ArrayList();
    private static final int defaultRange = 10;
    public static Sound damage = new Sound("damage");
    public static Sound meleeAttack = new Sound("meleeAttack");
    public static Sound oldProjectile = new Sound("oldProjectile");
    public static Sound bullet = new Sound("bullet", 25);
    public static Sound laserCell = new Sound("laserCell");
    public static Sound web = new Sound("web");
    public static Sound fireballWhoosh = new Sound("fireballWhoosh", 20);
    public static Sound electricity = new Sound("electricity");
    public static Sound deathRay = new Sound("deathRay");
    public static Sound vortexBeam = new Sound("vortexBeam", 20);
    public static Sound grunt = new Sound("grunt");
    public static Sound curePoison = new Sound("curePoison");
    public static Sound cureDisease = new Sound("cureDisease");
    public static Sound miss = new Sound("miss");
    public static Sound disintegration = new Sound("disintegration");
    public static Sound fireballBlast = new Sound("fireballBlast", 30);
    public static Sound heal = new Sound("heal");
    public static Sound laser = new Sound("laser");
    public static Sound lightning = new Sound("lightning", 20);
    public static Sound livingDeadRepel = new Sound("livingDeadRepelled");
    public static Sound markLocations = new Sound("markLocations");
    public static Sound flash = new Sound("flash");
    public static Sound powerCircle = new Sound("powerCircle");
    public static Sound radWave = new Sound("radWave", 25);
    public static Sound teleportIn = new Sound("teleportIn");
    public static Sound teleportOut = new Sound("teleportOut");
    public static Sound dragonBreathed = new Sound("dragonBreathed", 25);
    public static Sound wallsClosing = new Sound("wallsClosing", 20, false);
    public static Sound wallsOpening = new Sound("wallsOpening", false);
    public static Sound waterAppears = new Sound("waterAppears", false);
    public static Sound waterDisappears = new Sound("waterDisappears", false);
    public static Sound doorAppears = new Sound("doorAppears");
    public static Sound deathFog = new Sound("deathFog");
    public static Sound vengefulSymbol = new Sound("vengefulSymbol");
    public static Sound landMinePlaced = new Sound("landMinePlaced");
    public static Sound trollBackToLife = new Sound("trollBackToLife");
    public static Sound machineBreaks = new Sound("machineBreaks");
    public static Sound monsterGenerated = new Sound("monsterGenerated", false);
    public static Sound exitAppears = new Sound("exitAppears");
    public static Sound playerDead = new Sound("playerDead");
    public static Sound atMap = new Sound("mapLoaded", false);
    public static Sound loadingLevel = new Sound("loadingLevel", false);
    public static Sound levelLost = new Sound("levelLost");
    public static Sound itemAdded = new Sound("itemAdded", false);
    public static Sound itemRemoved = new Sound("itemRemoved", false);
    public static Sound itemDamaged = new Sound("itemDamaged");
    public static Sound itemRepaired = new Sound("itemRepaired");
    public static Sound movement = new Sound("movement", 6);
    public static Sound trapSprung = new Sound("trapSprung", 15);
    public static Sound trapDetected = new Sound("trapDetected", false);
    public static Sound torchLit;
    public static Sound fire;
    public static Sound torchGoesOut;
    public static Sound itemLost;
    public static Sound superVision;
    public static Sound gremlin;
    public static Sound ghost;
    public static Sound killerCorpse;
    public static Sound guardianSword;
    public static Sound slime;
    public static Sound blob;
    public static Sound sentryborg;
    public static Sound cetharg;
    public static Sound mercenary;
    public static Sound deathbot;
    public static Sound mutivider;
    public static Sound scumShamble;
    public static Sound ogre;
    public static Sound bat;
    public static Sound slimeChucker;
    public static Sound floatingSpheroid;
    public static Sound confused;
    public static Sound title;
    public static Sound alarm;
    public static Sound gameFinished;
    public static Sound bionicStrength;
    public static Sound senseCreatures;
    public static Sound medicalRobot;
    public static Sound doorOpens;
    public static Sound doorCloses;
    public static Sound poof;
    public static Sound playerSaid;
    public static Sound ferrousGolem;
    public static Sound chestOpens;
    public static Sound itemBought;
    public static Sound itemSold;
    public static Sound itemDonated;
    public static Sound inWeb;
    public static Sound leap;
    public static Sound potionDrunk;
    public static Sound retributiveShieldProjection;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    private Sound(String fileName) {
        this(fileName, 10);
    }

    private Sound(String fileName, int range) {
        this(fileName, range, true);
    }

    private Sound(String fileName, boolean activatesMonsters) {
        this(fileName, 10, activatesMonsters);
    }

    private Sound(String fileName, int range, boolean activatesMonsters) {
        this.fileName = fileName;
        this.range = range;
        this.activatesMonsters = activatesMonsters;
    }

    public void doPlay() {
        this.doPlay(0);
    }

    public void doPlay(int distance) {
        Line clip = null;
        int i = 0;
        while (i < this.clips.size()) {
            ClipWrapper test = (ClipWrapper)this.clips.get(i);
            if (!test.playing) {
                clip = test.clip;
                test.playing = true;
                break;
            }
            ++i;
        }
        if (clip == null) {
            AudioInputStream stream;
            File file = new File("sounds/" + this.fileName + ".wav");
            try {
                stream = AudioSystem.getAudioInputStream(file);
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            DataLine.Info info = null;
            AudioFormat format = stream.getFormat();
            info = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = Sound.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, format);
            try {
                clip = (Clip)AudioSystem.getLine(info);
                clip.open(stream);
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            final ClipWrapper wrapper = new ClipWrapper((Clip)clip);
            clip.addLineListener(new LineListener(){

                public void update(LineEvent event) {
                    if (event.getType().equals(LineEvent.Type.STOP)) {
                        wrapper.playing = false;
                        wrapper.clip.stop();
                        wrapper.clip.setFramePosition(0);
                    }
                }
            });
            this.clips.add(wrapper);
        }
        Control[] controls = clip.getControls();
        int i2 = 0;
        while (i2 < controls.length) {
            Control control = controls[i2];
            if (control.getType().equals(FloatControl.Type.VOLUME)) {
                FloatControl volumeControl = (FloatControl)control;
                float min = volumeControl.getMinimum();
                float max = volumeControl.getMaximum();
                volumeControl.setValue(min + (1.0f - (float)distance / (float)(this.range * TileSize.tileSize.width)) * (max - min));
            }
            ++i2;
        }
        clip.start();
    }

    public boolean getActivatesMonsters() {
        return this.activatesMonsters;
    }

    public int getRange() {
        return this.range;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fire = torchLit = new Sound("torchLit");
        torchGoesOut = new Sound("torchGoesOut", false);
        itemLost = new Sound("itemLost", false);
        superVision = new Sound("superVision", false);
        gremlin = new Sound("gremlin", false);
        ghost = new Sound("ghost", false);
        killerCorpse = new Sound("killerCorpse", false);
        guardianSword = new Sound("guardianSword", false);
        slime = new Sound("slime", false);
        blob = new Sound("blob", false);
        sentryborg = new Sound("sentryborg", false);
        cetharg = new Sound("cetharg", false);
        mercenary = new Sound("mercenary", false);
        deathbot = new Sound("deathbot", false);
        mutivider = new Sound("mutivider", false);
        scumShamble = new Sound("scumShamble", false);
        ogre = new Sound("ogre", false);
        bat = new Sound("bat", false);
        slimeChucker = new Sound("slimeChucker", false);
        floatingSpheroid = new Sound("floatingSpheroid", false);
        confused = new Sound("confused", false);
        title = new Sound("title", false);
        alarm = new Sound("alarm", 20);
        gameFinished = new Sound("gameFinished");
        bionicStrength = new Sound("bionicStrength", false);
        senseCreatures = new Sound("senseCreatures", false);
        medicalRobot = new Sound("medicalRobot", false);
        doorOpens = new Sound("doorOpens");
        doorCloses = new Sound("doorCloses");
        poof = new Sound("poof");
        playerSaid = new Sound("playerSaid");
        ferrousGolem = new Sound("ferrousGolem", false);
        chestOpens = new Sound("chestOpens");
        itemBought = itemRemoved;
        itemSold = new Sound("itemSold");
        itemDonated = new Sound("itemDonated");
        inWeb = new Sound("inWeb");
        leap = new Sound("leap");
        potionDrunk = new Sound("potionDrunk");
        retributiveShieldProjection = new Sound("retributiveShieldProjection");
    }

    private class ClipWrapper {
        public boolean playing = false;
        public Clip clip;

        public ClipWrapper(Clip clip) {
            this.clip = clip;
        }
    }
}

