// MAGFORM.CPP (Visual C++ 1.00) -- Runs Magic Formula files with C64 emulators

#if MASTER
  #ifndef NDEBUG
    #error Set the Build Options to RELEASE!
  #endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int uint;
typedef unsigned long dword;
typedef enum {FALSE, TRUE} flag;

byte abData[] = {
  0xA9,0x55,0xCD,0xFF,0xDF,0xF0,0x05,0xCD,0xFF,0xDF,0xD0,0x31,0xA2,0xAA,0xEC,
  0xFF,0xDF,0xD0,0x2A,0xCD,0xFF,0xDF,0xD0,0x25,0xEC,0xFF,0xDF,0xD0,0x20,0xA0,
  0x26,0xB9,0xB5,0x10,0x99,0xC8,0x0A,0x88,0x10,0xF7,0xA0,0x09,0xB9,0xDC,0x10,
  0x99,0x36,0x0B,0x88,0x10,0xF7,0xA0,0x12,0xA9,0xEA,0x99,0xBB,0x08,0x88,0x10,
  0xFA,0x4C,0x0D,0x08,0x8E,0x0F,0x02,0xA6,0x01,0xA9,0x37,0x85,0x01,0x20,0x13,
  0xEE,0x86,0x01,0xA2,0x00,0x60,0xA9,0x37,0x85,0x01,0x20,0xEF,0xED,0xA9,0x08,
  0x20,0x0C,0xED,0xA9,0xE0,0x20,0xB9,0xED,0x20,0xFE,0xED,0x78,0x60,0x20,0x11,
  0x02,0xEA,0xEA,0xEA,0xEA,0xEA,0xEA,0xEA
};

int main(int iArg, char** ppcArg) {
  #ifdef DEBUG
    _bdos(0x0D, 0, 0);
  #endif
  #if GERMAN
    printf("\
MAGFORM schaltet den Schnellader aus, wenn ein mit Magic Formel gefreeztes\n\
Programm innerhalb eines C64-Emulators gestartet wird. (Magic-Formel-Dateien\n\
sehen aus wie die von Isepic, also mit einem '-' am Anfang des zweiten Files.)\n");
  #else
    printf("\
MAGFORM disables the fast loader when the Magic Formel snapshot is run under a\n\
C64 emulator. Those snapshots come as two separate files where the 2nd file is\n\
preceeded by a '-'. They look like the files generated by an ISEPIC cartridge.\n");
  #endif
  if (iArg != 2) {
    #if GERMAN
      fprintf(stderr, "Aufruf: magform <Datei>.P00\n");
    #else
      fprintf(stderr, "Usage: magform <1st file>.P00\n");
    #endif
    return 1;
  }
  int hFile = _open(ppcArg[1], _O_BINARY | _O_RDWR);
  if (hFile == -1) {
    perror(ppcArg[1]);
    return 1;
  }
  if (_filelength(hFile) != 2192) {
    #if GERMAN
      fprintf(stderr, "%s: Datei ist nicht 2192 Bytes gro\n", ppcArg[1]);
    #else
      fprintf(stderr, "%s: file size is not 2192 bytes\n", ppcArg[1]);
    #endif
    return 1;
  }
  char ac[4];
  _lseek(hFile, 33, SEEK_SET);
  if (_read(hFile, ac, 4) != 4) {
    perror(ppcArg[1]);
    return 1;
  }
  if (memcmp(ac, "2061", 4)) {
    #if GERMAN
      fprintf(stderr, "%s: Die Zeichenkette \"2061\" steht nicht an Offset 33\n", ppcArg[1]);
    #else
      fprintf(stderr, "%s: the string \"2061\" is not on offset 33\n", ppcArg[1]);
    #endif
    return 1;
  }
  _lseek(hFile, 33, SEEK_SET);
  if (_write(hFile, "4213", 4) != 4) {
    perror(ppcArg[1]);
    return 1;
  }
  _lseek(hFile, 2192, SEEK_SET);
  if (_write(hFile, abData, sizeof abData) != sizeof abData) {
    perror(ppcArg[1]);
    return 1;
  }
  if (_close(hFile) == -1) {
    perror(ppcArg[1]);
    return 1;
  }
  #if GERMAN
    printf("Sie knnen das Spiel jetzt auf einem C64-Emulator ausfhren.\n");
  #else
    printf("The game can now be run under an emulator.\n");
  #endif
  #ifdef DEBUG
    printf("\nPress any key to continue...");
    _bdos(0x0C, 0, 0x07);
    printf("\r%79c", '\r');
  #endif
  return 0;
}
