/*
 * Decompiled with CFR 0.152.
 */
package patpack.stack;

import java.awt.Graphics;
import java.util.ArrayList;
import patpack.card.Card;
import patpack.card.CardBase;
import patpack.card.CardMark;
import patpack.game.CardGame;
import patpack.stack.CardDrag;

public abstract class CardStack {
    public static final int SELECTNONE = -1;
    public static final int SELECTBASE = -2;
    public static final int SELECTDECK = -3;
    public static final int FINISH_NONE = 1;
    public static final int FINISH_13 = 2;
    public static final int FINISH_0_OR_9 = 3;
    public static final int FINISH_52 = 4;
    public static final int FINISH_ANY = 5;
    public static final int FINISH_1 = 6;
    public static final int FINISH_FACE_UP = 7;
    public static final int FINISH_LINEUP = 8;
    public static final int FINISH_SCORPION = 9;
    public static final int FINISH_PILESORT = 10;
    protected int finishTest = 1;
    protected CardGame game = null;
    protected int x = 0;
    protected int y = 0;
    protected char baseType = (char)32;
    protected CardBase cardBase = null;
    protected ArrayList stack = new ArrayList();
    protected int numFaceDown = 0;
    protected CardMark mark = null;
    protected int dragColorCheck = 0;
    protected int dragValueCheck = 0;
    protected int dropEmptyCheck = 0;
    protected CardStack prevStack = null;
    protected int dropPrevCheck = 0;
    protected int dropNum = 0;
    protected boolean dropOnlyFromDeck = false;
    protected int maxSize = -1;
    protected boolean isDeck = false;
    protected boolean autoDeal = false;
    protected boolean autoDrop = false;

    public void init(CardGame game, int x, int y, char baseType) {
        this.game = game;
        this.x = x;
        this.y = y;
        this.baseType = (char)32;
        this.cardBase = new CardBase(game, baseType);
    }

    public char getBaseType() {
        return this.baseType;
    }

    public void move(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setFaceDown(int num) {
        this.numFaceDown = num;
    }

    public int numFaceDown() {
        return this.numFaceDown;
    }

    public void setMark(char markType) {
        this.mark = markType == ' ' ? null : new CardMark(this.game, markType);
    }

    public boolean isMarked() {
        return this.mark != null;
    }

    public void setIsDeck(boolean isDeck) {
        this.isDeck = isDeck;
    }

    public boolean isDeck() {
        return this.isDeck;
    }

    public void setDragCheck(int colorCheck, int valueCheck, int emptyCheck) {
        this.dragColorCheck = colorCheck;
        this.dragValueCheck = valueCheck;
        this.dropEmptyCheck = emptyCheck;
    }

    public int getDragColorCheck() {
        return this.dragColorCheck;
    }

    public int getDragValueCheck() {
        return this.dragValueCheck;
    }

    public int getDropEmptyCheck() {
        return this.dropEmptyCheck;
    }

    public void setDropOnlyFromDeck(boolean dropOnlyFromDeck) {
        this.dropOnlyFromDeck = dropOnlyFromDeck;
    }

    public void setDropNum(int dropNum) {
        this.dropNum = dropNum;
    }

    public int dropNum() {
        return this.dropNum;
    }

    public void setAutoDeal(boolean autoDeal) {
        this.autoDeal = autoDeal;
    }

    public boolean autoDeal() {
        return this.autoDeal;
    }

    public void setAutoDrop(boolean autoDrop) {
        this.autoDrop = autoDrop;
    }

    public boolean autoDrop() {
        return this.autoDrop;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getSize() {
        return this.stack.size();
    }

    public void setFinishTest(int finishTest) {
        this.finishTest = finishTest;
    }

    public void setPrevStack(CardStack s, int prevCheck) {
        this.prevStack = s;
        this.dropPrevCheck = prevCheck;
    }

    public CardStack getPrevStack() {
        return this.prevStack;
    }

    public int getDropPrevCheck() {
        return this.dropPrevCheck;
    }

    public boolean isFinished() {
        switch (this.finishTest) {
            case 2: {
                return this.getSize() == 13;
            }
            case 3: {
                return this.getSize() == 0 || this.getSize() == 9;
            }
            case 4: {
                return this.getSize() == 52;
            }
            case 5: {
                return true;
            }
            case 6: {
                return this.getSize() == 1;
            }
            case 7: {
                return this.numFaceDown == 0;
            }
            case 8: {
                if (this.getSize() <= 0) {
                    return this.dropNum == 0;
                }
                if (this.getCard(0).getValue() != this.dropNum) {
                    return false;
                }
                if (this.prevStack == null) {
                    return true;
                }
                if (this.prevStack.getSize() <= 0) {
                    return false;
                }
                return this.getCard(0).getSuit() == this.prevStack.getCard(0).getSuit();
            }
            case 9: {
                if (this.getSize() <= 0) {
                    return true;
                }
                if (this.getSize() != 13) {
                    return false;
                }
                int i = 0;
                while (i < 13) {
                    Card c = this.getCard(i);
                    if (c.getValue() != 13 - i) {
                        return false;
                    }
                    if (c.getSuit() != this.getCard(0).getSuit()) {
                        return false;
                    }
                    ++i;
                }
            }
            case 10: {
                if (this.getSize() <= 0) {
                    return true;
                }
                if (this.getSize() != 4) {
                    return false;
                }
                int i = 0;
                while (i < 4) {
                    Card c = this.getCard(i);
                    if (c.getValue() != this.getCard(0).getValue()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return this.stack.size() == 0;
    }

    public Card getCard(int cardPos) {
        if (cardPos < 0 || cardPos >= this.stack.size()) {
            return null;
        }
        return (Card)this.stack.get(cardPos);
    }

    public void add(Card c) {
        this.stack.add(c);
    }

    public void add(int cardPos, Card c) {
        this.stack.add(cardPos, c);
    }

    public void add(int cardPos, CardStack s) {
        int size = this.stack.size();
        if (cardPos < 0 || cardPos > size) {
            cardPos = size;
        }
        int i = 0;
        while (i < s.getSize()) {
            this.stack.add(cardPos + i, s.getCard(i));
            ++i;
        }
    }

    public Card removeCard(int cardPos) {
        if (cardPos < 0 || cardPos >= this.stack.size()) {
            return null;
        }
        return (Card)this.stack.remove(cardPos);
    }

    public abstract int select(int var1, int var2);

    public abstract CardStack take(int var1);

    public abstract boolean turn(int var1);

    public abstract boolean drop(int var1, CardDrag var2, boolean var3);

    public abstract void draw(Graphics var1);
}

