/*
 * Decompiled with CFR 0.152.
 */
package patpack.stack;

import java.awt.Graphics;
import patpack.card.Card;
import patpack.stack.CardDrag;
import patpack.stack.CardStack;

public class CardPile
extends CardStack {
    public int select(int sx, int sy) {
        int dx = sx - this.x;
        int dy = sy - this.y;
        int size = this.stack.size();
        if (size <= 0) {
            if (dx >= 0 && dx < 71 && dy >= 0 && dy < 96) {
                return -2;
            }
            return -1;
        }
        int offset = (size - 1) / 4 * 2;
        if (offset > 6) {
            offset = 6;
        }
        if (dx < offset || dx >= offset + 71) {
            return -1;
        }
        if (dy < offset || dy >= offset + 96) {
            return -1;
        }
        return size - 1;
    }

    public CardStack take(int cardPos) {
        if (cardPos < 0) {
            return null;
        }
        int size = this.stack.size();
        if (this.numFaceDown >= size) {
            return null;
        }
        if (!this.takeOkay(cardPos)) {
            return null;
        }
        CardPile newStack = new CardPile();
        int offset = (size - 1) / 4 * 2;
        if (offset > 6) {
            offset = 6;
        }
        int newX = this.x + offset;
        int newY = this.y + offset;
        newStack.init(this.game, newX, newY, ' ');
        int i = cardPos;
        while (i < size) {
            newStack.add(this.getCard(cardPos));
            this.stack.remove(cardPos);
            ++i;
        }
        return newStack;
    }

    public boolean turn(int cardPos) {
        if (cardPos < 0) {
            return false;
        }
        int size = this.stack.size();
        if (this.numFaceDown < size) {
            return false;
        }
        if (cardPos != size - 1) {
            return false;
        }
        this.numFaceDown = cardPos;
        return true;
    }

    public boolean drop(int cardPos, CardDrag drag, boolean cheat) {
        if (!this.dropOkay(cardPos, drag) && !cheat) {
            return false;
        }
        this.add(cardPos + 1, drag.getDrag());
        return true;
    }

    protected boolean takeOkay(int cardPos) {
        if (this.autoDrop()) {
            return false;
        }
        int size = this.stack.size();
        if (cardPos < 0 || cardPos >= size) {
            return false;
        }
        if (cardPos < this.numFaceDown) {
            return false;
        }
        return cardPos == size - 1;
    }

    protected boolean dropOkay(int cardPos, CardDrag drag) {
        CardStack s = drag.getSrc();
        if (s.getX() == this.x && s.getY() == this.y) {
            return false;
        }
        if (this.dropOnlyFromDeck && !s.isDeck()) {
            return false;
        }
        if (this.dropPrevCheck == 6 && this.prevStack.getSize() > 0 && s.dropNum() > 0 && s.dropNum != this.dropNum()) {
            return false;
        }
        s = drag.getDrag();
        int size = this.stack.size();
        if (this.maxSize >= 0 && s.getSize() + size > this.maxSize) {
            return false;
        }
        if ((size <= 0 || cardPos != size - 1) && cardPos != -2) {
            return false;
        }
        if (s.getSize() != 1) {
            return false;
        }
        Card c = s.getCard(0);
        if (size > 0) {
            return CardDrag.dragMatch(this, this.getCard(cardPos), c);
        }
        return CardDrag.dropEmptyMatch(this, c);
    }

    public void draw(Graphics g) {
        int size = this.stack.size();
        if (size <= 0) {
            this.cardBase.draw(g, this.x, this.y);
            return;
        }
        int x = this.x;
        int y = this.y;
        int i = 3;
        while (i < size - 1 && i <= 11) {
            this.getCard(i).draw(g, x, y, i < this.numFaceDown);
            x += 2;
            y += 2;
            i += 4;
        }
        this.getCard(size - 1).draw(g, x, y, size - 1 < this.numFaceDown);
        if (this.mark != null) {
            this.mark.draw(g, x, y);
        }
    }
}

