/*
 * Decompiled with CFR 0.152.
 */
package patpack.scores;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import patpack.dice.Dice;
import patpack.scores.SingleScore;

public class SquLineScores
extends AbstractTableModel {
    static final int NUM_COLS = 3;
    static final int NUM_ROWS = 9;
    static final String[] COL_NAMES = new String[]{"Game Turn", "Count", "Score"};
    static final String[] ROW_NAMES = new String[]{"Row 1", "Row 2", "Row 3", "Column 1", "Column 2", "Column 3", "Diag. Up", "Diag. Down", "TOTAL"};
    SingleScore[] counts = new SingleScore[9];
    SingleScore[] scores = new SingleScore[9];

    public SquLineScores() {
        this.resetScores();
    }

    public void resetScores() {
        int i = 0;
        while (i < 9) {
            this.counts[i] = new SingleScore();
            this.scores[i] = new SingleScore();
            ++i;
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return 9;
    }

    public String getColumnName(int col) {
        return COL_NAMES[col];
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return ROW_NAMES[row];
            }
            case 1: {
                return this.counts[row];
            }
        }
        return this.scores[row];
    }

    public Class getColumnClass(int col) {
        return this.getValueAt(0, col).getClass();
    }

    public int getTotal() {
        return this.scores[8].getValue();
    }

    public int calc(ArrayList diceArray) {
        int tot = 0;
        int i = 0;
        while (i < 3) {
            tot += this.calcEntry(diceArray, i, i * 3 + 1, 1);
            ++i;
        }
        int i2 = 0;
        while (i2 < 3) {
            tot += this.calcEntry(diceArray, i2 + 3, i2 + 1, 3);
            ++i2;
        }
        tot += this.calcEntry(diceArray, 6, 3, 2);
        this.scores[8].setValue(tot += this.calcEntry(diceArray, 7, 1, 4));
        this.fireTableDataChanged();
        return tot;
    }

    private int calcEntry(ArrayList diceArray, int row, int first, int inc) {
        int cnt = 0;
        int i = 0;
        while (i < 3) {
            Dice dice = (Dice)diceArray.get(first + inc * i);
            cnt += dice.getValue();
            ++i;
        }
        this.counts[row].setValue(cnt);
        int sc = 10;
        cnt = Math.abs(cnt - 15);
        while (cnt-- > 0 && sc > 0) {
            sc /= 2;
        }
        this.scores[row].setValue(sc);
        return sc;
    }
}

