/*
 * Decompiled with CFR 0.152.
 */
package patpack.scores;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import patpack.card.Card;
import patpack.scores.SingleScore;
import patpack.stack.CardStack;

public class PokerScores
extends AbstractTableModel {
    static final int NUM_COLS = 2;
    static final int NUM_ROWS = 11;
    static final String[] COL_NAMES = new String[]{"Row / Column", "Score"};
    String[] names = new String[11];
    SingleScore[] scores = new SingleScore[11];

    public PokerScores() {
        int i = 0;
        while (i < 5) {
            this.names[i] = "Row " + (i + 1);
            ++i;
        }
        int i2 = 5;
        while (i2 < 10) {
            this.names[i2] = "Column " + (i2 - 4);
            ++i2;
        }
        this.names[10] = "TOTAL";
        this.resetScores();
    }

    public void resetScores() {
        int i = 0;
        while (i < 11) {
            this.scores[i] = new SingleScore();
            ++i;
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return 11;
    }

    public String getColumnName(int col) {
        return COL_NAMES[col];
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.names[row];
        }
        return this.scores[row];
    }

    public Class getColumnClass(int col) {
        return this.getValueAt(0, col).getClass();
    }

    public int calc(ArrayList cardStacks) {
        int tot = 0;
        int i = 0;
        while (i < 5) {
            int sc = this.calcEntry(cardStacks, i * 5 + 1, 1);
            this.scores[i].setValue(sc);
            tot += sc;
            ++i;
        }
        int i2 = 0;
        while (i2 < 5) {
            int sc = this.calcEntry(cardStacks, i2 + 1, 5);
            this.scores[i2 + 5].setValue(sc);
            tot += sc;
            ++i2;
        }
        this.scores[10].setValue(tot);
        this.fireTableDataChanged();
        return tot;
    }

    private int calcEntry(ArrayList cardStacks, int first, int inc) {
        boolean isSeq;
        boolean hasAce = false;
        int minVal = 14;
        int maxVal = 0;
        boolean sameSuit = true;
        int numPairs = 0;
        int i = 0;
        while (i < 5) {
            CardStack s = (CardStack)cardStacks.get(first + inc * i);
            if (s.getSize() > 0) {
                Card c = s.getCard(0);
                int val = c.getValue();
                if (val == 1) {
                    hasAce = true;
                } else {
                    if (val > maxVal) {
                        maxVal = val;
                    }
                    if (val < minVal) {
                        minVal = val;
                    }
                }
                int j = i + 1;
                while (j < 5) {
                    CardStack sj = (CardStack)cardStacks.get(first + inc * j);
                    if (sj.getSize() > 0) {
                        Card cj = sj.getCard(0);
                        if (cj.getValue() == val) {
                            ++numPairs;
                        }
                        if (cj.getSuit() != c.getSuit()) {
                            sameSuit = false;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (minVal == 2 && hasAce) {
            minVal = 1;
        }
        if (maxVal == 13 && hasAce) {
            maxVal = 14;
        }
        boolean bl = isSeq = numPairs == 0 && maxVal - minVal == 4;
        if (sameSuit && isSeq && maxVal == 14) {
            return 100;
        }
        if (sameSuit && isSeq) {
            return 75;
        }
        if (numPairs >= 6) {
            return 50;
        }
        if (numPairs >= 4) {
            return 25;
        }
        if (sameSuit) {
            return 20;
        }
        if (isSeq) {
            return 15;
        }
        if (numPairs >= 3) {
            return 10;
        }
        if (numPairs >= 2) {
            return 5;
        }
        if (numPairs >= 1) {
            return 2;
        }
        return 0;
    }
}

