/*
 * Decompiled with CFR 0.152.
 */
package patpack.scores;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import patpack.dice.Dice;
import patpack.scores.SingleScore;

public class PigsScores
extends AbstractTableModel {
    static final int NUM_COLS = 2;
    static final int NUM_ROWS = 17;
    static final String[] COL_NAMES = new String[]{"Game Turn", "Score"};
    String[] names = new String[17];
    SingleScore[] scores;

    public PigsScores() {
        int i = 0;
        while (i < 16) {
            this.names[i] = "Turn " + (i + 1);
            ++i;
        }
        this.names[16] = "TOTAL";
        this.scores = new SingleScore[17];
        this.resetScores();
    }

    public void resetScores() {
        int i = 0;
        while (i < 17) {
            this.scores[i] = new SingleScore();
            if (i < 16) {
                this.scores[i].setTemp(true);
            }
            ++i;
        }
        this.updateTotal();
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return 17;
    }

    public String getColumnName(int col) {
        return COL_NAMES[col];
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.names[row];
        }
        return this.scores[row];
    }

    public Class getColumnClass(int col) {
        return this.getValueAt(0, col).getClass();
    }

    public boolean allDone() {
        int i = 0;
        while (i < 17) {
            if (this.scores[i].isTemp()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getTotal() {
        return this.scores[16].getValue();
    }

    public boolean selectScore(int row) {
        if (row >= 17) {
            return false;
        }
        SingleScore sc = this.scores[row];
        if (!sc.isSet() || !sc.isTemp()) {
            return false;
        }
        sc.setTemp(false);
        this.updateTotal();
        this.fireTableDataChanged();
        return true;
    }

    private void updateTotal() {
        int total = 0;
        int i = 0;
        while (i < 16) {
            if (!this.scores[i].isTemp()) {
                total += this.scores[i].getValue();
            }
            ++i;
        }
        this.scores[16].setValue(total);
    }

    public void calc(ArrayList diceArray) {
        Dice dice1 = (Dice)diceArray.get(1);
        Dice dice2 = (Dice)diceArray.get(2);
        int val1 = dice1.getValue();
        int val2 = dice2.getValue();
        int points = 0;
        boolean pig = false;
        if (val1 == val2) {
            points = val1 == 1 ? 25 : 4 * val1;
        } else if (val1 == 1 || val2 == 1) {
            pig = true;
        }
        int i = 0;
        while (i < 16) {
            if (this.scores[i].isTemp()) {
                if (pig) {
                    this.scores[i].setTemp(false);
                    this.scores[i].setValue(0);
                    break;
                }
                this.scores[i].setValue(points += this.scores[i].getValue());
                break;
            }
            ++i;
        }
        this.fireTableDataChanged();
    }
}

