/*
 * Decompiled with CFR 0.152.
 */
package patpack.game;

import patpack.game.CardGame;
import patpack.scores.PohtzeeScores;
import patpack.stack.CardDeck;
import patpack.stack.CardPile;
import patpack.stack.CardSpread;
import patpack.stack.CardStack;

public class Pohtzee
extends CardGame {
    private PohtzeeScores scores = null;
    private int numDeals = 0;

    protected void initScores() {
        this.scores = new PohtzeeScores();
        this.patpack.getScores().init(this.scores);
    }

    public void start() {
        super.start();
        CardPile pile = new CardPile();
        pile.init(this, 240, 48, 'd');
        pile.setAutoDrop(true);
        this.cardStacks.add(pile);
        int i = 0;
        while (i < 5) {
            CardSpread spread = new CardSpread();
            int x = 100 + 87 * i;
            int y = 200;
            spread.init(this, x, y, 'd');
            spread.setAutoDrop(true);
            spread.setDropNum(1);
            this.cardStacks.add(spread);
            ++i;
        }
        this.initDealStack();
        this.scores.resetScores();
    }

    private void initDealStack() {
        CardPile pile = (CardPile)this.cardStacks.get(0);
        while (pile.getSize() > 0) {
            pile.removeCard(0);
        }
        pile.setMark(' ');
        this.numDeals = 0;
        CardDeck deck = new CardDeck();
        deck.init(this, 0, 0, ' ');
        deck.initDeck(11, 0, 0);
        deck.deal(24, pile);
        pile.setFaceDown(24);
        int i = 1;
        while (i <= 5) {
            CardStack s = (CardStack)this.cardStacks.get(i);
            if (s.getSize() > 0) {
                s.removeCard(0);
            }
            s.setMark(' ');
            ++i;
        }
    }

    public boolean stackMark(CardStack stack) {
        if (stack.dropNum() != 1) {
            this.stackDeal(stack);
            return true;
        }
        if (stack.getSize() <= 0 || stack.isMarked()) {
            stack.setMark(' ');
        } else {
            stack.setMark('m');
        }
        return true;
    }

    private void stackDeal(CardStack stack) {
        if (stack.isMarked()) {
            return;
        }
        boolean hasDealt = false;
        int i = 1;
        while (i <= 5) {
            CardStack s = (CardStack)this.cardStacks.get(i);
            if (s.getSize() > 0 && !s.isMarked()) {
                s.removeCard(0);
            }
            if (s.getSize() <= 0) {
                s.add(stack.removeCard(0));
                hasDealt = true;
            }
            ++i;
        }
        this.scores.calc(this.cardStacks);
        if (hasDealt) {
            ++this.numDeals;
        }
        if (this.numDeals >= 3) {
            stack.setMark('x');
        }
    }

    public void selectScore(int row) {
        if (!this.scores.selectScore(row)) {
            return;
        }
        this.initDealStack();
        this.table.repaint();
        this.updateStatus();
    }

    public void updateStatus() {
        if (this.isFinished() || this.isFailed()) {
            return;
        }
        if (this.scores.allDone()) {
            int total = this.scores.getTotal();
            if (total >= 700) {
                this.setFinished();
            } else {
                this.setFailed("You failed to get 700 or more points");
            }
        }
        super.updateStatus();
    }
}

