/*
 * Decompiled with CFR 0.152.
 */
package patpack.card;

import java.awt.Graphics;
import javax.swing.ImageIcon;
import patpack.game.CardGame;

public class Card {
    public static final int CARDWIDTH = 71;
    public static final int CARDHEIGHT = 96;
    public static final char CLUB = 'c';
    public static final char DIAMOND = 'd';
    public static final char HEART = 'h';
    public static final char SPADE = 's';
    public static final char JOKER = 'j';
    public static final int BLACK = 1;
    public static final int RED = 2;
    public static final char[] SUITS = new char[]{'c', 'd', 'h', 's'};
    private CardGame game = null;
    private char suit = (char)99;
    private int value = 1;
    private ImageIcon icon = null;

    public Card(CardGame game, char suit, int value) {
        this.game = game;
        this.suit = suit;
        this.value = value;
    }

    public char getSuit() {
        return this.suit;
    }

    public int getValue() {
        return this.value;
    }

    public int getColor() {
        if (this.suit == 'd' || this.suit == 'h') {
            return 2;
        }
        if (this.suit == 'j') {
            return this.value;
        }
        return 1;
    }

    public void draw(Graphics g, int x, int y, boolean faceDown) {
        if (faceDown) {
            this.game.getCardBack().draw(g, x, y);
            return;
        }
        if (this.icon == null) {
            this.icon = this.game.loadIcon("cards/" + this.suit + "/" + this.value + ".gif");
        }
        this.icon.paintIcon(this.game.getTable(), g, x, y);
    }
}

