/*
 * Decompiled with CFR 0.152.
 */
package patpack.applet;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import patpack.applet.ChoosePane;
import patpack.applet.DialogMgr;
import patpack.applet.HelpPane;
import patpack.applet.MenuBar;
import patpack.applet.Scores;
import patpack.applet.Table;
import patpack.game.CardGame;
import patpack.game.Game;
import patpack.game.GameFactory;

public class PatPack
extends JApplet {
    public static final String NO_GAME = "none";
    private MenuBar menu = null;
    private JPanel mainPane = null;
    private CardLayout mainLayout = null;
    private ChoosePane choose = null;
    private JPanel playArea = null;
    private Table table = null;
    private Scores scores = null;
    private HelpPane help = null;
    private DialogMgr dialogMgr = null;
    private Game game = null;
    private String tableColor = "#008000";
    private String gameName = "none";
    private int cardBack = 1;

    public String getAppletInfo() {
        return "Patience Pack 6.1\n\nCopyright 2002 \u00a9 Maurice Abraham\n\nCollection of different patience and solitaire games.";
    }

    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.menu = new MenuBar(this);
        this.setJMenuBar(this.menu);
        this.mainLayout = new CardLayout();
        this.mainPane = new JPanel(this.mainLayout);
        this.getContentPane().add(this.mainPane);
        this.choose = new ChoosePane(this);
        this.mainPane.add((Component)new JScrollPane(this.choose), "choose");
        this.playArea = new JPanel(new BorderLayout());
        this.scores = new Scores(this);
        this.scores.setColor(this.tableColor);
        this.table = new Table(this);
        this.table.setColor(this.tableColor);
        this.playArea.add(this.table);
        this.mainPane.add((Component)this.playArea, "play");
        this.help = new HelpPane(this);
        this.mainPane.add((Component)this.help, "help");
        this.mainLayout.show(this.mainPane, "choose");
        this.menu.enableGame(false);
        this.menu.enableHelp(false);
        this.menu.enableUndo(false);
        this.dialogMgr = new DialogMgr(this);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
        this.gameName = NO_GAME;
        if (this.game != null) {
            this.game.destroy();
        }
        this.game = null;
    }

    public void menuAction(String action) {
        if (action.equals("undo")) {
            this.game.undo();
            return;
        }
        if (action.equals("newgame")) {
            this.newGame(this.gameName);
            return;
        }
        if (action.equals("restart")) {
            this.restartGame();
            return;
        }
        if (action.equals("another")) {
            this.gameName = NO_GAME;
            if (this.game != null) {
                this.game.destroy();
            }
            this.game = null;
            this.mainLayout.show(this.mainPane, "choose");
            this.getGlassPane().setVisible(false);
            this.menu.enableGame(false);
            this.menu.enableHelp(false);
            this.menu.enableUndo(false);
            return;
        }
        if (action.startsWith("back")) {
            this.cardBack = Integer.parseInt(action.substring(4), 10);
            if (this.game instanceof CardGame) {
                ((CardGame)this.game).setCardBack(this.cardBack);
            }
            return;
        }
        if (action.startsWith("color")) {
            this.tableColor = "#" + action.substring(5);
            this.table.setColor(this.tableColor);
            this.scores.setColor(this.tableColor);
            return;
        }
        if (action.equals("overview")) {
            this.showHelp("overview");
            return;
        }
        if (action.equals("help")) {
            this.showHelp(this.gameName);
            return;
        }
        if (action.equals("more")) {
            this.showHelp("more");
            return;
        }
        if (action.equals("about")) {
            this.showHelp("about");
            return;
        }
    }

    public void newGame(String gameName) {
        this.gameName = gameName;
        if (this.game != null) {
            this.game.destroy();
        }
        this.game = GameFactory.newGame(this.gameName);
        this.game.setTable(this, this.table);
        if (this.game instanceof CardGame) {
            ((CardGame)this.game).setCardBack(this.cardBack);
        }
        this.mainLayout.show(this.mainPane, "play");
        this.getGlassPane().setVisible(false);
        this.game.start();
        this.menu.enableGame(true);
        this.menu.enableHelp(true);
    }

    public void restartGame() {
        if (this.gameName.equals(NO_GAME)) {
            return;
        }
        this.mainLayout.show(this.mainPane, "play");
        this.getGlassPane().setVisible(false);
        this.game.start();
        this.menu.enableGame(true);
        this.menu.enableHelp(true);
    }

    public void resumeGame() {
        if (this.gameName.equals(NO_GAME)) {
            this.mainLayout.show(this.mainPane, "choose");
            return;
        }
        this.mainLayout.show(this.mainPane, "play");
        this.getGlassPane().setVisible(false);
        this.menu.enableGame(true);
        this.menu.enableHelp(true);
    }

    public void showHelp(String name) {
        this.mainLayout.show(this.mainPane, "help");
        this.getGlassPane().setVisible(false);
        this.menu.enableGame(false);
        this.help.showHelp(name);
    }

    public void showDialog(String msg, int msgType) {
        this.dialogMgr.showDialog(msg, msgType);
    }

    public Game getGame() {
        return this.game;
    }

    public JPanel getPlayArea() {
        return this.playArea;
    }

    public Scores getScores() {
        return this.scores;
    }

    public ImageIcon loadIcon(String path) {
        try {
            String urlStr = "jar:" + this.getCodeBase() + "patpack.jar!/" + path;
            URL url = new URL(urlStr);
            return new ImageIcon(url);
        }
        catch (Exception e) {
            System.out.println("Error " + e.toString());
            return null;
        }
    }

    public void enableUndo(boolean enable) {
        this.menu.enableUndo(enable);
    }
}

