/*
 * Decompiled with CFR 0.152.
 */
package patpack.applet;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import patpack.applet.PatPack;

public class HelpPane
extends JPanel
implements ActionListener {
    public static final int HELP_OVERVIEW = 1;
    public static final int HELP_GAME = 2;
    public static final int HELP_ABOUT = 3;
    private PatPack patpack = null;
    private CardLayout viewLayout = null;
    private JPanel viewPane = null;
    private JTextPane helpText = null;
    private Timer loadTimer = null;

    public HelpPane(PatPack patpack) {
        this.patpack = patpack;
        this.setLayout(new BorderLayout());
        this.viewLayout = new CardLayout();
        this.viewPane = new JPanel(this.viewLayout);
        JLabel loading = new JLabel("Loading Help ...", 0);
        this.viewPane.add((Component)loading, "loading");
        this.helpText = new JTextPane();
        this.helpText.setEditable(false);
        this.helpText.addHyperlinkListener(new FollowLink());
        this.viewPane.add((Component)new JScrollPane(this.helpText), "help");
        this.add(this.viewPane);
        this.viewLayout.show(this.viewPane, "loading");
        JPanel bottom = new JPanel();
        JButton btn = new JButton("Click here to return to game");
        btn.setActionCommand("close");
        btn.addActionListener(this);
        bottom.add(btn);
        this.add((Component)bottom, "South");
    }

    public void setHelpPage(String name) {
        try {
            String urlStr = this.patpack.getCodeBase() + "help/" + name.toLowerCase() + ".html";
            URL url = new URL(urlStr);
            this.helpText.setPage(url);
        }
        catch (Exception e) {
            System.out.println("Error " + e.toString());
            this.helpText.setText("Failed to load " + name + " help!");
        }
        this.viewLayout.show(this.viewPane, "help");
    }

    public void showHelp(String name) {
        this.viewLayout.show(this.viewPane, "loading");
        HelpLoader help = new HelpLoader();
        help.init(this, name);
        this.loadTimer = new Timer(100, help);
        this.loadTimer.setRepeats(false);
        this.loadTimer.start();
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("close")) {
            this.patpack.resumeGame();
        }
    }

    class HelpLoader
    implements ActionListener {
        private HelpPane help = null;
        private String name = null;

        HelpLoader() {
        }

        public void init(HelpPane help, String name) {
            this.help = help;
            this.name = name;
        }

        public void actionPerformed(ActionEvent evt) {
            this.help.loadTimer.stop();
            this.help.loadTimer = null;
            this.help.setHelpPage(this.name);
        }
    }

    class FollowLink
    implements HyperlinkListener {
        FollowLink() {
        }

        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            try {
                JEditorPane pane = (JEditorPane)e.getSource();
                pane.setPage(e.getURL());
            }
            catch (Exception ex) {
                System.out.println("Error " + ex.toString());
            }
        }
    }
}

