/*
 * Decompiled with CFR 0.152.
 */
package impChess;

import impChess.character;
import impChess.empire;
import impChess.gameBoard;
import impChess.gameSquare;
import impChess.prison;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class impChess
extends JPanel
implements ActionListener,
MouseListener,
MouseMotionListener {
    protected static final boolean PRODUCTION = true;
    protected static final Color[] empireColor = new Color[]{Color.white, new Color(200, 170, 213), new Color(246, 235, 20)};
    protected static final Color[] keepColor = new Color[]{Color.black, new Color(234, 194, 0), new Color(184, 0, 239)};
    protected static final Color[] boardColor = new Color[]{Color.black, new Color(200, 170, 213), new Color(246, 235, 20)};
    protected static final Color[] actionColor = new Color[]{Color.magenta, new Color(6, 149, 250), new Color(88, 85, 219), new Color(0, 255, 0), Color.red};
    protected static final String[] empireName = new String[]{"none", "Gold", "Purple"};
    protected static final int[] empireObjective = new int[]{0, 14, 1};
    protected static final int GOLDEMPIRE = 1;
    protected static final int PURPLEEMPIRE = 2;
    protected static final int UNAFFECTED = -1;
    protected static final int OVERSQUARE = 0;
    protected static final int SELECTEDSQUARE = 1;
    protected static final int TARGETSQUARE = 2;
    protected static final int MOVESQUARE = 3;
    protected static final int CAPTURESQUARE = 4;
    protected static final Color GOLD = new Color(233, 194, 57);
    protected static final Color DARKGOLD = new Color(246, 235, 20);
    protected static final Color PURPLE = new Color(160, 18, 195);
    protected static final Color DARKPURPLE = new Color(200, 170, 213);
    protected static final Dimension BOARDSQUARE = new Dimension(32, 32);
    protected static final BorderLayout BORDERNONE = new BorderLayout(0, 0);
    protected static final int SQUARESIZE = 30;
    protected static final int BOARDSIZE = 14;
    protected static final int PRISONWIDTH = 50;
    protected static final int MAXDOMINATED = 104;
    protected ResourceBundle resBundle = ResourceBundle.getBundle("impChess", Locale.getDefault());
    public static JFrame mainFrame;
    protected JTextArea textArea1;
    JPanel mainPanel;
    protected gameBoard GameBoard;
    protected Toolkit impToolkit = Toolkit.getDefaultToolkit();
    protected Image impImage;
    protected Image impImage2;
    protected Image _image;
    protected Image _image2;
    protected BufferedImage bufImage;
    protected MediaTracker mediaTracker;
    protected empire[] Empire = new empire[3];
    protected prison[] Prison = new prison[3];
    protected String Orientation = "Gold";
    protected gameSquare lastOver = null;
    protected gameSquare lastSelected = null;
    protected gameSquare selectedSquare = null;
    protected gameSquare targetSquare = null;
    protected gameSquare[] dominatedSquares = new gameSquare[104];
    protected int[] squareAction = new int[104];
    protected character overCharacter = null;
    protected character selectedCharacter = null;
    protected gameSquare[] lastMoveSquares = null;
    protected gameSquare[] lastCaptureSquares = null;
    protected gameSquare[] allAvailableSquares = null;
    gameSquare fromSquare = null;
    gameSquare toSquare = null;
    boolean moveInitiated = false;
    boolean moveCompleted = false;
    boolean moveSubmitted = false;
    boolean turnCompleted = false;
    String moveLog = "";
    protected boolean gameOver = false;
    protected int winner = 0;
    protected static final JMenuBar mainMenuBar;
    protected JMenu fileMenu;
    protected JMenuItem miNew;
    protected JMenuItem miOpen;
    protected JMenuItem miClose;
    protected JMenuItem miSave;
    protected JMenuItem miSaveAs;
    protected JMenu editMenu;
    protected JMenuItem miUndo;
    protected JMenuItem miFlip;
    protected JMenu optionsMenu;
    protected JMenu optionLevel;
    protected JMenu optionRules;
    protected JCheckBoxMenuItem miNovice;
    protected JCheckBoxMenuItem miAdvanced;
    protected JCheckBoxMenuItem miClubhouse;
    protected JCheckBoxMenuItem miTournament;
    protected JMenu helpMenu;
    protected JMenuItem miPlaying;
    protected JMenuItem miRules;
    protected JMenuItem miInternet;
    protected JMenuItem miAbout;
    static /* synthetic */ Class class$impChess$impChess;

    public impChess() {
        this.createMenus();
        this.setPreferredSize(new Dimension(640, 540));
        this.mediaTracker = new MediaTracker(this);
        this.GameBoard = new gameBoard(14, this);
        this.Empire[1] = new empire(1, this);
        this.Empire[2] = new empire(2, this);
        for (int i = 1; i < 3; ++i) {
            this.Prison[i] = new prison(this, i, ResourceBundle.getBundle("impChess").getString("PrisonName"));
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public boolean getProduction() {
        return true;
    }

    public empire getEmpire(int n) {
        return this.Empire[n];
    }

    public Color getEmpireColor(int n) {
        if (n >= empireColor.length) {
            return empireColor[0];
        }
        return empireColor[n];
    }

    public Color getBoardColor(int n) {
        if (n >= boardColor.length) {
            return boardColor[0];
        }
        return boardColor[n];
    }

    public Color getKeepColor(int n) {
        if (n >= keepColor.length) {
            return keepColor[0];
        }
        return keepColor[n];
    }

    public String getEmpireName(int n) {
        if (n >= empireName.length) {
            return empireName[0];
        }
        return empireName[n];
    }

    public int getLeft() {
        return 0;
    }

    public int getRight() {
        if (this.getWidth() <= 0) {
            return 640;
        }
        return this.getWidth();
    }

    public int getTop() {
        return 0;
    }

    public int getBottom() {
        if (this.getHeight() <= 0) {
            return 450;
        }
        return this.getHeight();
    }

    public int getAdjustedLeft() {
        return 52;
    }

    public int getAdjustedRight() {
        return this.getRight() - 50 - 4;
    }

    public int getAdjustedTop() {
        return 2;
    }

    public int getAdjustedBottom() {
        return this.getBottom() - 2;
    }

    public int getPrisonWidth() {
        return 50;
    }

    public String getOrientation() {
        return this.Orientation;
    }

    public void flipOrientation() {
        this.Orientation = this.Orientation == "Gold" ? "Purple" : "Gold";
    }

    private void capture() {
        boolean bl;
        character character2 = this.targetSquare.getCharacter();
        if (character2.getRank() == 1 && !(bl = this.succeed(3 - this.playerUp()))) {
            this.gameOver = true;
            this.winner = this.playerUp();
            mainFrame.setTitle("Victory is Achieved");
        }
        this.targetSquare.getCharacter().capture();
        this.targetSquare.removeCharacter();
        if (character2.getRank() == 5 || this.selectedSquare.getCharacter().getRank() == 5) {
            this.selectedSquare.getCharacter().capture();
        } else {
            this.targetSquare.setCharacter(this.selectedCharacter);
            this.selectedCharacter.setPosition(this.targetSquare.getRow(), this.targetSquare.getCol());
        }
    }

    private boolean succeed(int n) {
        boolean bl = false;
        character character2 = this.Empire[n].getCharacter(3, true, false);
        if (character2 != null) {
            bl = character2.promote(1);
        }
        return bl;
    }

    private boolean reviveWaters() {
        boolean bl = false;
        character character2 = this.targetSquare.getCharacter();
        if (character2 != null && character2.getRank() == 4 && this.targetSquare.getRow() == empireObjective[this.playerUp()] && this.selectedSquare.getRow() != empireObjective[this.playerUp()]) {
            System.out.println("Reviving Waters.");
            Dialog dialog = new Dialog(mainFrame, "Reviving Waters", true);
            bl = true;
        }
        return bl;
    }

    private boolean promoteWarrior() {
        boolean bl = false;
        character character2 = this.targetSquare.getCharacter();
        if (character2 != null && character2.getRank() == 11 && this.targetSquare.getRow() == empireObjective[this.playerUp()] && this.selectedSquare.getRow() != empireObjective[this.playerUp()]) {
            System.out.println("Promoting Warrior.");
            bl = true;
        }
        return bl;
    }

    private void makeMove() {
        if (this.selectedCharacter == null) {
            this.selectedCharacter = this.selectedSquare.getCharacter();
        }
        if (this.targetSquare.isOccupied()) {
            this.capture();
        } else {
            this.targetSquare.setCharacter(this.selectedCharacter);
            this.selectedCharacter.setPosition(this.targetSquare.getRow(), this.targetSquare.getCol());
        }
        this.selectedSquare.removeCharacter();
        if (this.targetSquare.isOccupied()) {
            if (!this.targetSquare.getCharacter().isCaptured()) {
                this.targetSquare.getCharacter().warriorMoved();
            }
            this.reviveWaters();
            this.promoteWarrior();
        }
    }

    public int playerUp() {
        int n = 0;
        for (int i = 0; i < empireName.length; ++i) {
            if (empireName[i] != this.Orientation) continue;
            n = i;
            break;
        }
        return n;
    }

    public MediaTracker getMediaTracker() {
        return this.mediaTracker;
    }

    public gameBoard getGameBoard() {
        return this.GameBoard;
    }

    private gameSquare[] tagAllAvailable(gameSquare[] gameSquareArray, gameSquare[] gameSquareArray2) {
        int n;
        int n2 = gameSquareArray.length + gameSquareArray2.length;
        gameSquare[] gameSquareArray3 = new gameSquare[n2];
        for (n = 0; n < gameSquareArray.length; ++n) {
            gameSquareArray3[n] = gameSquareArray[n];
        }
        for (n = 0; n < gameSquareArray2.length; ++n) {
            gameSquareArray3[gameSquareArray.length + n] = gameSquareArray2[n];
        }
        return gameSquareArray3;
    }

    private boolean isDominatedSquare(gameSquare gameSquare2) {
        boolean bl = false;
        if (gameSquare2 != null) {
            for (int i = 0; i < this.allAvailableSquares.length; ++i) {
                if (this.allAvailableSquares[i] == null || this.allAvailableSquares[i] != gameSquare2) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void clearActogram() {
        int n;
        if (this.lastMoveSquares != null) {
            for (n = 0; n < this.lastMoveSquares.length; ++n) {
                if (this.lastMoveSquares[n] == null) continue;
                this.lastMoveSquares[n].resetColor();
            }
        }
        if (this.lastCaptureSquares != null) {
            for (n = 0; n < this.lastCaptureSquares.length; ++n) {
                if (this.lastCaptureSquares[n] == null) continue;
                this.lastCaptureSquares[n].resetColor();
            }
        }
    }

    public void showActogram(gameSquare gameSquare2) {
        this.clearActogram();
        if (gameSquare2.isOccupied()) {
            gameSquare[] gameSquareArray = gameSquare2.getCharacter().movePoints();
            this.GameBoard.highlight(gameSquareArray, actionColor[3]);
            this.lastMoveSquares = gameSquareArray;
            gameSquare[] gameSquareArray2 = gameSquare2.getCharacter().strikePoints();
            this.GameBoard.highlight(gameSquareArray2, actionColor[4]);
            this.lastCaptureSquares = gameSquareArray2;
        }
        this.repaint();
    }

    private static void createAndShowGUI() {
        Serializable serializable = (class$impChess$impChess == null ? (class$impChess$impChess = impChess.class$("impChess.impChess")) : class$impChess$impChess).getResource("/chars/ic.gif");
        Image image = Toolkit.getDefaultToolkit().getImage((URL)serializable);
        JFrame.setDefaultLookAndFeelDecorated(true);
        mainFrame = new JFrame(ResourceBundle.getBundle("impChess").getString("GameTitle") + " " + ResourceBundle.getBundle("impChess").getString("GameVersion"));
        mainFrame.setDefaultCloseOperation(3);
        serializable = new impChess();
        ((JComponent)serializable).setOpaque(true);
        mainFrame.setContentPane((Container)serializable);
        mainFrame.pack();
        mainFrame.setVisible(true);
        mainFrame.setIconImage(image);
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paint(graphics2D);
        for (int i = 1; i < 3; ++i) {
            this.Prison[i].paint(graphics2D);
        }
        this.GameBoard.paint(graphics2D);
    }

    public void createMenus() {
        this.createFileMenu();
        this.createOptionsMenu();
        this.createHelpMenu();
        mainFrame.setJMenuBar(mainMenuBar);
    }

    public void createFileMenu() {
        this.fileMenu = new JMenu(this.resBundle.getString("fileMenu"));
        this.fileMenu.setMnemonic('f');
        this.miNew = new JMenuItem(this.resBundle.getString("newGame"));
        this.miNew.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.fileMenu.add(this.miNew).setEnabled(true);
        this.miNew.addActionListener(this);
        mainMenuBar.add(this.fileMenu);
    }

    public void createEditMenu() {
    }

    public void createOptionsMenu() {
        this.optionsMenu = new JMenu(this.resBundle.getString("optionsMenu"));
        this.optionsMenu.setMnemonic('o');
        this.optionLevel = new JMenu(this.resBundle.getString("optionLevel"));
        this.optionLevel.setMnemonic('l');
        this.optionRules = new JMenu(this.resBundle.getString("optionRules"));
        this.optionRules.setMnemonic('r');
        this.optionsMenu.add(this.optionLevel);
        this.optionsMenu.add(this.optionRules);
        this.miNovice = new JCheckBoxMenuItem(this.resBundle.getString("menuNovice"));
        this.miAdvanced = new JCheckBoxMenuItem(this.resBundle.getString("menuAdvanced"));
        this.miClubhouse = new JCheckBoxMenuItem(this.resBundle.getString("menuClubhouse"));
        this.miTournament = new JCheckBoxMenuItem(this.resBundle.getString("menuTournament"));
        this.miNovice.setSelected(true);
        this.miClubhouse.setSelected(true);
        this.optionLevel.add(this.miNovice);
        this.optionLevel.add(this.miAdvanced);
        this.optionRules.add(this.miClubhouse);
        this.optionRules.add(this.miTournament);
        mainMenuBar.add(this.optionsMenu);
    }

    public void createHelpMenu() {
        this.helpMenu = new JMenu(this.resBundle.getString("helpMenu"));
        this.helpMenu.setMnemonic('h');
        this.miInternet = new JMenuItem(this.resBundle.getString("toInternet"));
        this.miInternet.setAccelerator(KeyStroke.getKeyStroke(123, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.helpMenu.add(this.miInternet).setEnabled(true);
        this.miInternet.addActionListener(this);
        this.miAbout = new JMenuItem(this.resBundle.getString("About"));
        this.miAbout.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.helpMenu.add(this.miAbout).setEnabled(true);
        this.miAbout.addActionListener(this);
        mainMenuBar.add(this.helpMenu);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                impChess.createAndShowGUI();
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Dimension dimension = new Dimension(mouseEvent.getX(), mouseEvent.getY());
        gameSquare gameSquare2 = this.GameBoard.inGameSquare(dimension);
        if (gameSquare2 != null) {
            if (!this.moveInitiated) {
                if (this.lastSelected != gameSquare2) {
                    if (this.lastSelected != null) {
                        this.lastSelected.resetColor();
                    }
                    this.lastSelected = gameSquare2;
                }
                if (gameSquare2.isEmpire(this.Orientation)) {
                    this.moveInitiated = true;
                    gameSquare2.changeColor(actionColor[1]);
                    this.selectedSquare = gameSquare2;
                    this.selectedCharacter = gameSquare2.getCharacter();
                    System.out.println("Character selected is " + this.selectedCharacter.getName() + ":" + gameSquare2.getSquareName(this.Orientation) + " - ");
                    this.allAvailableSquares = this.tagAllAvailable(this.lastMoveSquares, this.lastCaptureSquares);
                }
            } else if (!this.moveCompleted) {
                if (gameSquare2 == this.lastSelected) {
                    this.moveInitiated = false;
                    this.lastSelected = null;
                    this.selectedSquare = null;
                    this.selectedCharacter = null;
                    this.mouseMoved(mouseEvent);
                } else {
                    for (int i = 0; i < this.allAvailableSquares.length; ++i) {
                        if (gameSquare2 != this.allAvailableSquares[i]) continue;
                        this.clearActogram();
                        gameSquare2.changeColor(actionColor[2]);
                        this.targetSquare = gameSquare2;
                        this.moveCompleted = true;
                    }
                }
            } else if (gameSquare2 == this.lastSelected) {
                this.moveInitiated = false;
                this.moveCompleted = false;
                this.lastSelected = null;
                this.selectedSquare = null;
                this.selectedCharacter = null;
                this.targetSquare = null;
                this.mouseMoved(mouseEvent);
            }
        } else if (this.moveInitiated && this.moveCompleted && this.Prison[this.playerUp()].inStandard(dimension)) {
            this.makeMove();
            this.clearActogram();
            this.selectedSquare.resetColor();
            this.targetSquare.resetColor();
            this.moveInitiated = false;
            this.moveCompleted = false;
            this.lastSelected = null;
            this.selectedSquare = null;
            this.selectedCharacter = null;
            this.targetSquare = null;
            this.turnCompleted = true;
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Dimension dimension;
        gameSquare gameSquare2;
        if (this.turnCompleted) {
            this.turnCompleted = false;
            this.flipOrientation();
        }
        if ((gameSquare2 = this.GameBoard.inGameSquare(dimension = new Dimension(mouseEvent.getX(), mouseEvent.getY()))) != null) {
            if (!this.moveInitiated) {
                if (this.lastOver != gameSquare2) {
                    if (this.lastOver != null) {
                        this.lastOver.resetColor();
                        this.clearActogram();
                    }
                    this.lastOver = gameSquare2;
                }
                if (gameSquare2.isEmpire(this.Orientation)) {
                    gameSquare2.changeColor(actionColor[0]);
                    this.overCharacter = gameSquare2.getCharacter();
                    this.showActogram(gameSquare2);
                }
            } else if (!this.moveCompleted) {
                // empty if block
            }
        }
        this.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        mainMenuBar = new JMenuBar();
    }
}

